/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.legacy.aws.com.amazonaws.services.elasticloadbalancingv2.model.transform;

import com.dataiku.dss.legacy.aws.com.amazonaws.DefaultRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.Request;
import com.dataiku.dss.legacy.aws.com.amazonaws.SdkClientException;
import com.dataiku.dss.legacy.aws.com.amazonaws.http.HttpMethodName;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.elasticloadbalancingv2.model.DescribeListenersRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.transform.Marshaller;
import com.dataiku.dss.legacy.aws.com.amazonaws.util.StringUtils;
import java.util.List;

public class DescribeListenersRequestMarshaller
implements Marshaller<Request<DescribeListenersRequest>, DescribeListenersRequest> {
    @Override
    public Request<DescribeListenersRequest> marshall(DescribeListenersRequest describeListenersRequest) {
        if (describeListenersRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeListenersRequest> request = new DefaultRequest<DescribeListenersRequest>(describeListenersRequest, "AmazonElasticLoadBalancing");
        request.addParameter("Action", "DescribeListeners");
        request.addParameter("Version", "2015-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeListenersRequest.getLoadBalancerArn() != null) {
            request.addParameter("LoadBalancerArn", StringUtils.fromString(describeListenersRequest.getLoadBalancerArn()));
        }
        if (describeListenersRequest.getListenerArns() != null) {
            List<String> listenerArnsList = describeListenersRequest.getListenerArns();
            if (listenerArnsList.isEmpty()) {
                request.addParameter("ListenerArns", "");
            } else {
                int listenerArnsListIndex = 1;
                for (String listenerArnsListValue : listenerArnsList) {
                    if (listenerArnsListValue != null) {
                        request.addParameter("ListenerArns.member." + listenerArnsListIndex, StringUtils.fromString(listenerArnsListValue));
                    }
                    ++listenerArnsListIndex;
                }
            }
        }
        if (describeListenersRequest.getMarker() != null) {
            request.addParameter("Marker", StringUtils.fromString(describeListenersRequest.getMarker()));
        }
        if (describeListenersRequest.getPageSize() != null) {
            request.addParameter("PageSize", StringUtils.fromInteger(describeListenersRequest.getPageSize()));
        }
        return request;
    }
}

