/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.jdbc42.internal.apache.thrift;

import com.databricks.client.jdbc42.internal.apache.thrift.AsyncProcessFunction;
import com.databricks.client.jdbc42.internal.apache.thrift.TApplicationException;
import com.databricks.client.jdbc42.internal.apache.thrift.TAsyncProcessor;
import com.databricks.client.jdbc42.internal.apache.thrift.TBase;
import com.databricks.client.jdbc42.internal.apache.thrift.TException;
import com.databricks.client.jdbc42.internal.apache.thrift.TProcessor;
import com.databricks.client.jdbc42.internal.apache.thrift.async.AsyncMethodCallback;
import com.databricks.client.jdbc42.internal.apache.thrift.protocol.TMessage;
import com.databricks.client.jdbc42.internal.apache.thrift.protocol.TProtocol;
import com.databricks.client.jdbc42.internal.apache.thrift.protocol.TProtocolException;
import com.databricks.client.jdbc42.internal.apache.thrift.protocol.TProtocolUtil;
import com.databricks.client.jdbc42.internal.apache.thrift.server.AbstractNonblockingServer;
import com.databricks.client.jdbc42.internal.slf4j.Logger;
import com.databricks.client.jdbc42.internal.slf4j.LoggerFactory;
import java.util.Collections;
import java.util.Map;

public class TBaseAsyncProcessor<I>
implements TAsyncProcessor,
TProcessor {
    protected final Logger LOGGER = LoggerFactory.getLogger(this.getClass().getName());
    final I iface;
    final Map<String, AsyncProcessFunction<I, ? extends TBase, ?>> processMap;

    public TBaseAsyncProcessor(I iface, Map<String, AsyncProcessFunction<I, ? extends TBase, ?>> processMap) {
        this.iface = iface;
        this.processMap = processMap;
    }

    public Map<String, AsyncProcessFunction<I, ? extends TBase, ?>> getProcessMapView() {
        return Collections.unmodifiableMap(this.processMap);
    }

    @Override
    public void process(AbstractNonblockingServer.AsyncFrameBuffer fb) throws TException {
        TProtocol in = fb.getInputProtocol();
        TProtocol out = fb.getOutputProtocol();
        TMessage msg = in.readMessageBegin();
        AsyncProcessFunction<I, TBase, ?> fn = this.processMap.get(msg.name);
        if (fn == null) {
            TProtocolUtil.skip(in, (byte)12);
            in.readMessageEnd();
            TApplicationException x = new TApplicationException(1, "Invalid method name: '" + msg.name + "'");
            this.LOGGER.debug("Invalid method name", x);
            if (msg.type == 1) {
                out.writeMessageBegin(new TMessage(msg.name, 3, msg.seqid));
                x.write(out);
                out.writeMessageEnd();
                out.getTransport().flush();
            }
            fb.responseReady();
            return;
        }
        TBase args = fn.getEmptyArgsInstance();
        try {
            args.read(in);
        }
        catch (TProtocolException e) {
            in.readMessageEnd();
            TApplicationException x = new TApplicationException(7, e.getMessage());
            this.LOGGER.debug("Could not retrieve function arguments", x);
            if (!fn.isOneway()) {
                out.writeMessageBegin(new TMessage(msg.name, 3, msg.seqid));
                x.write(out);
                out.writeMessageEnd();
                out.getTransport().flush();
            }
            fb.responseReady();
            return;
        }
        in.readMessageEnd();
        if (fn.isOneway()) {
            fb.responseReady();
        }
        AsyncMethodCallback<?> resultHandler = fn.getResultHandler(fb, msg.seqid);
        try {
            fn.start(this.iface, args, resultHandler);
        }
        catch (Exception e) {
            this.LOGGER.debug("Exception handling function", e);
            resultHandler.onError(e);
        }
    }

    @Override
    public void process(TProtocol in, TProtocol out) throws TException {
    }
}

