/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.jdbc42.internal.nimbusjose.crypto.factories;

import com.databricks.client.jdbc42.internal.nimbusjose.JOSEException;
import com.databricks.client.jdbc42.internal.nimbusjose.JWSAlgorithm;
import com.databricks.client.jdbc42.internal.nimbusjose.JWSSigner;
import com.databricks.client.jdbc42.internal.nimbusjose.crypto.ECDSASigner;
import com.databricks.client.jdbc42.internal.nimbusjose.crypto.Ed25519Signer;
import com.databricks.client.jdbc42.internal.nimbusjose.crypto.MACSigner;
import com.databricks.client.jdbc42.internal.nimbusjose.crypto.RSASSASigner;
import com.databricks.client.jdbc42.internal.nimbusjose.crypto.impl.BaseJWSProvider;
import com.databricks.client.jdbc42.internal.nimbusjose.jca.JCAContext;
import com.databricks.client.jdbc42.internal.nimbusjose.jwk.ECKey;
import com.databricks.client.jdbc42.internal.nimbusjose.jwk.JWK;
import com.databricks.client.jdbc42.internal.nimbusjose.jwk.JWKException;
import com.databricks.client.jdbc42.internal.nimbusjose.jwk.KeyUse;
import com.databricks.client.jdbc42.internal.nimbusjose.jwk.OctetKeyPair;
import com.databricks.client.jdbc42.internal.nimbusjose.jwk.OctetSequenceKey;
import com.databricks.client.jdbc42.internal.nimbusjose.jwk.RSAKey;
import com.databricks.client.jdbc42.internal.nimbusjose.produce.JWSSignerFactory;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;

public class DefaultJWSSignerFactory
implements JWSSignerFactory {
    private final JCAContext jcaContext = new JCAContext();
    public static final Set<JWSAlgorithm> SUPPORTED_ALGORITHMS;

    @Override
    public Set<JWSAlgorithm> supportedJWSAlgorithms() {
        return SUPPORTED_ALGORITHMS;
    }

    @Override
    public JCAContext getJCAContext() {
        return this.jcaContext;
    }

    @Override
    public JWSSigner createJWSSigner(JWK key) throws JOSEException {
        BaseJWSProvider signer;
        if (!key.isPrivate()) {
            throw JWKException.expectedPrivate();
        }
        if (key.getKeyUse() != null && !KeyUse.SIGNATURE.equals(key.getKeyUse())) {
            throw new JWKException("The JWK use must be sig (signature) or unspecified");
        }
        if (key instanceof OctetSequenceKey) {
            signer = new MACSigner((OctetSequenceKey)key);
        } else if (key instanceof RSAKey) {
            signer = new RSASSASigner((RSAKey)key);
        } else if (key instanceof ECKey) {
            signer = new ECDSASigner((ECKey)key);
        } else if (key instanceof OctetKeyPair) {
            signer = new Ed25519Signer((OctetKeyPair)key);
        } else {
            throw new JOSEException("Unsupported JWK type: " + key);
        }
        ((JCAContext)signer.getJCAContext()).setSecureRandom(this.jcaContext.getSecureRandom());
        ((JCAContext)signer.getJCAContext()).setProvider(this.jcaContext.getProvider());
        return signer;
    }

    @Override
    public JWSSigner createJWSSigner(JWK key, JWSAlgorithm alg) throws JOSEException {
        BaseJWSProvider signer;
        if (!key.isPrivate()) {
            throw JWKException.expectedPrivate();
        }
        if (key.getKeyUse() != null && !KeyUse.SIGNATURE.equals(key.getKeyUse())) {
            throw new JWKException("The JWK use must be sig (signature) or unspecified");
        }
        if (MACSigner.SUPPORTED_ALGORITHMS.contains(alg)) {
            if (!(key instanceof OctetSequenceKey)) {
                throw JWKException.expectedClass(OctetSequenceKey.class);
            }
            signer = new MACSigner((OctetSequenceKey)key);
        } else if (RSASSASigner.SUPPORTED_ALGORITHMS.contains(alg)) {
            if (!(key instanceof RSAKey)) {
                throw JWKException.expectedClass(RSAKey.class);
            }
            signer = new RSASSASigner((RSAKey)key);
        } else if (ECDSASigner.SUPPORTED_ALGORITHMS.contains(alg)) {
            if (!(key instanceof ECKey)) {
                throw JWKException.expectedClass(ECKey.class);
            }
            signer = new ECDSASigner((ECKey)key);
        } else if (Ed25519Signer.SUPPORTED_ALGORITHMS.contains(alg)) {
            if (!(key instanceof OctetKeyPair)) {
                throw JWKException.expectedClass(OctetKeyPair.class);
            }
            signer = new Ed25519Signer((OctetKeyPair)key);
        } else {
            throw new JOSEException("Unsupported JWS algorithm: " + alg);
        }
        ((JCAContext)signer.getJCAContext()).setSecureRandom(this.jcaContext.getSecureRandom());
        ((JCAContext)signer.getJCAContext()).setProvider(this.jcaContext.getProvider());
        return signer;
    }

    static {
        LinkedHashSet algs = new LinkedHashSet();
        algs.addAll(MACSigner.SUPPORTED_ALGORITHMS);
        algs.addAll(RSASSASigner.SUPPORTED_ALGORITHMS);
        algs.addAll(ECDSASigner.SUPPORTED_ALGORITHMS);
        algs.addAll(Ed25519Signer.SUPPORTED_ALGORITHMS);
        SUPPORTED_ALGORITHMS = Collections.unmodifiableSet(algs);
    }
}

