/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.jdbc42.internal.nimbusjose.jwk.source;

import com.databricks.client.jdbc42.internal.nimbusjose.KeySourceException;
import com.databricks.client.jdbc42.internal.nimbusjose.jwk.JWKSet;
import com.databricks.client.jdbc42.internal.nimbusjose.jwk.source.AbstractJWKSetSourceEvent;
import com.databricks.client.jdbc42.internal.nimbusjose.jwk.source.JWKSetCacheRefreshEvaluator;
import com.databricks.client.jdbc42.internal.nimbusjose.jwk.source.JWKSetSource;
import com.databricks.client.jdbc42.internal.nimbusjose.jwk.source.JWKSetSourceWrapper;
import com.databricks.client.jdbc42.internal.nimbusjose.jwk.source.JWKSetUnavailableException;
import com.databricks.client.jdbc42.internal.nimbusjose.proc.SecurityContext;
import com.databricks.client.jdbc42.internal.nimbusjose.util.events.EventListener;
import java.util.Objects;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class RetryingJWKSetSource<C extends SecurityContext>
extends JWKSetSourceWrapper<C> {
    private final EventListener<RetryingJWKSetSource<C>, C> eventListener;

    public RetryingJWKSetSource(JWKSetSource<C> source, EventListener<RetryingJWKSetSource<C>, C> eventListener) {
        super(source);
        this.eventListener = eventListener;
    }

    @Override
    public JWKSet getJWKSet(JWKSetCacheRefreshEvaluator refreshEvaluator, long currentTime, C context) throws KeySourceException {
        try {
            return this.getSource().getJWKSet(refreshEvaluator, currentTime, context);
        }
        catch (JWKSetUnavailableException e) {
            if (this.eventListener != null) {
                this.eventListener.notify(new RetrialEvent(this, e, (SecurityContext)context, null));
            }
            return this.getSource().getJWKSet(refreshEvaluator, currentTime, context);
        }
    }

    public static class RetrialEvent<C extends SecurityContext>
    extends AbstractJWKSetSourceEvent<RetryingJWKSetSource<C>, C> {
        private final Exception exception;

        private RetrialEvent(RetryingJWKSetSource<C> source, Exception exception, C securityContext) {
            super(source, securityContext);
            Objects.requireNonNull(exception);
            this.exception = exception;
        }

        public Exception getException() {
            return this.exception;
        }

        /* synthetic */ RetrialEvent(RetryingJWKSetSource x0, Exception x1, SecurityContext x2, 1 x3) {
            this(x0, x1, x2);
        }
    }
}

