/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.docgen.extractor;

import com.dataiku.dip.analysis.docgen.extractor.ModelExtractor;
import com.dataiku.dip.analysis.docgen.helpers.TimeSeriesUtil;
import com.dataiku.dip.analysis.model.ModelDetailsBase;
import com.dataiku.dip.analysis.model.prediction.TimeseriesForecastingModelDetails;
import com.dataiku.dip.analysis.model.prediction.TimestepParams;
import com.jayway.jsonpath.DocumentContext;
import java.io.IOException;

public class TimeseriesForecastHorizonExtractor
implements ModelExtractor<String> {
    @Override
    public String extract(DocumentContext documentContext, ModelDetailsBase model) throws IOException {
        if (!(model instanceof TimeseriesForecastingModelDetails)) {
            throw new IOException(String.format("Extractor '%s' does not support model details of type '%s'", this.getClass().getSimpleName(), model.getClass().getSimpleName()));
        }
        TimeseriesForecastingModelDetails timeseriesModelDetails = (TimeseriesForecastingModelDetails)model;
        long numTimeUnits = timeseriesModelDetails.coreParams.timestepParams.numberOfTimeunits;
        long predictionLength = timeseriesModelDetails.coreParams.predictionLength;
        TimestepParams.Timeunit timeunit = timeseriesModelDetails.coreParams.timestepParams.timeunit;
        return TimeSeriesUtil.prettyTimeStep(numTimeUnits * predictionLength, timeunit);
    }
}

