/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.docgen.extractor;

import com.dataiku.dip.analysis.docgen.extractor.ModelExtractor;
import com.dataiku.dip.analysis.docgen.extractor.WeightingStrategyMethodExtractor;
import com.dataiku.dip.analysis.model.ModelDetailsBase;
import com.dataiku.dip.analysis.model.prediction.ClassicalPredictionModelDetails;
import com.dataiku.dip.analysis.model.prediction.ResolvedClassicalPredictionCoreParams;
import com.jayway.jsonpath.DocumentContext;
import java.io.IOException;

public class WeightingStrategyVariableExtractor
implements ModelExtractor<String> {
    @Override
    public String extract(DocumentContext documentContext, ModelDetailsBase model) throws IOException {
        if (model instanceof ClassicalPredictionModelDetails) {
            ResolvedClassicalPredictionCoreParams coreParams = ((ClassicalPredictionModelDetails)model).coreParams;
            if (coreParams.weight == null || coreParams.weight.weightMethod == null) {
                return "No weighting strategy";
            }
            for (WeightingStrategyMethodExtractor.WeightMethodName weightMethodName : WeightingStrategyMethodExtractor.WeightMethodName.values()) {
                if (!weightMethodName.name().equals(coreParams.weight.weightMethod.name())) continue;
                if (!WeightingStrategyMethodExtractor.WeightMethodName.SAMPLE_WEIGHT.equals((Object)weightMethodName) && !WeightingStrategyMethodExtractor.WeightMethodName.CLASS_AND_SAMPLE_WEIGHT.equals((Object)weightMethodName)) break;
                return coreParams.weight.sampleWeightVariable != null ? coreParams.weight.sampleWeightVariable : "No weighting strategy variable";
            }
            return "No weighting strategy variable";
        }
        throw new IOException("Unable to retrieve preprocessing params for model " + model.fullModelId + " : The class " + String.valueOf(model.getClass()) + " is not supported.");
    }
}

