/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.ml.distributed.workers;

import com.dataiku.dip.analysis.ml.distributed.workers.WorkerInfos;
import com.dataiku.dip.analysis.ml.distributed.workers.WorkerPool;
import com.dataiku.dip.analysis.ml.distributed.workers.WorkerStatus;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.io.SimplePythonKernel;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.utils.DKULogger;
import java.io.IOException;

public class Worker
implements AutoCloseable {
    public final String workerType;
    private final SimplePythonKernel pythonKernel;
    private final String id;
    private WorkerInfos workerInfos = new WorkerInfos(WorkerStatus.PENDING, null, null, null);
    private boolean started = false;
    private boolean closed;
    private final AuthCtx authCtx;
    public static final DKULogger logger = DKULogger.getLogger((String)"com.dataiku.dip.analysis.ml.distributed.workers");

    public Worker(String workerId, WorkerPool workerPool, SimplePythonKernel pythonKernel) throws IOException {
        this.id = workerPool.workerPoolId + "." + workerId;
        this.authCtx = workerPool.authCtx;
        this.pythonKernel = pythonKernel;
        this.workerType = pythonKernel.getType() + " worker";
    }

    public String getId() {
        return this.id;
    }

    public void start() throws IOException, InterruptedException, CodedException {
        if (this.started) {
            throw new IllegalStateException(this.workerType + " " + this.id + " already started");
        }
        this.started = true;
        this.pythonKernel.start();
        this.workerInfos = (WorkerInfos)this.pythonKernel.getLink().receiveJsonResponse(WorkerInfos.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Worker worker = this;
        synchronized (worker) {
            if (this.closed) {
                return;
            }
            this.closed = true;
        }
        this.workerInfos = new WorkerInfos(WorkerStatus.DEAD, null, null, null);
        logger.info((Object)("Closing " + this.workerType + " python kernel " + this.pythonKernel.getId()));
        try {
            this.pythonKernel.close();
        }
        catch (IOException e) {
            logger.error((Object)("Could not close " + this.workerType + " python kernel"), (Throwable)e);
        }
    }

    public WorkerInfos getWorkerInfos() {
        return this.workerInfos;
    }

    public AuthCtx getAuthCtx() {
        return this.authCtx;
    }
}

