/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.ml.prediction;

import com.dataiku.common.server.APIError;
import com.dataiku.common.server.SerializedError;
import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.ProxySettings;
import com.dataiku.dip.analysis.coreservices.AnalysisMLContainerKernel;
import com.dataiku.dip.analysis.coreservices.AnalysisMLKernel;
import com.dataiku.dip.analysis.coreservices.IAnalysisMLKernel;
import com.dataiku.dip.analysis.ml.FullModelId;
import com.dataiku.dip.analysis.ml.ModelLikeId;
import com.dataiku.dip.analysis.ml.prediction.PredictionPostComputationHandler;
import com.dataiku.dip.code.CodeEnvModel;
import com.dataiku.dip.code.CodeEnvResolutionService;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.containers.exec.ContainerExecRuntimeConfig;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.externalinfras.ExternalInfrasUtils;
import com.dataiku.dip.externalml.mlflow.MLFlowModelVersionInfo;
import com.dataiku.dip.io.PortRangeParams;
import com.dataiku.dip.io.SingleCommandKernelLink;
import com.dataiku.dip.io.SocketBlockLinkException;
import com.dataiku.dip.kernels.IDSSKernelBase;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.rpc.EncryptedRPC;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.JSON;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import org.apache.log4j.Logger;

public abstract class PythonPostComputationHandler
extends PredictionPostComputationHandler {
    protected final AuthCtx authCtx;
    protected final ModelLikeId mle;
    protected final PredictionPostComputationHandler.PostComputationCommand computationCommand;
    protected final JsonObject computationParameters;
    protected IAnalysisMLKernel kernel;
    protected boolean runsInContainer = false;
    private static Logger logger = Logger.getLogger((String)"dku.analysis.ml.prediction.posttraining");

    public PythonPostComputationHandler(AuthCtx authCtx, String jobId, ModelLikeId mle, PredictionPostComputationHandler.PostComputationCommand computationCommand, JsonObject computationParameters) {
        this.authCtx = authCtx;
        this.jobId = jobId;
        this.mle = mle;
        this.computationCommand = computationCommand;
        this.computationParameters = computationParameters;
    }

    protected abstract Map<String, Object> prepareParams() throws IOException;

    protected void createOutputFolder() throws IOException {
        File fileOutputFolder = this.mle.getPostOperationsFolder();
        if (!fileOutputFolder.isDirectory()) {
            DKUFileUtils.mkdirs((File)fileOutputFolder);
        }
    }

    @Override
    protected void abort() {
        if (this.kernel != null) {
            this.kernel.killNoWaitNoException(true);
        }
    }

    protected abstract String envName();

    protected abstract ContainerExecRuntimeConfig getContainerConfig() throws IOException, DKUSecurityException;

    protected abstract void init() throws IOException, DKUSecurityException;

    public void postCompute() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void compute() throws Exception {
        block38: {
            this.init();
            PortRangeParams dssPortRange = ApplicationConfigurator.getPortRangeParams();
            String envName = this.envName();
            ContainerExecRuntimeConfig containerConfig = this.getContainerConfig();
            this.runsInContainer = containerConfig != null;
            SingleCommandKernelLink link = new SingleCommandKernelLink(SecretKeyGenerator.generate((int)16), dssPortRange, this.runsInContainer ? EncryptedRPC.getSSLContext() : null);
            CodeEnvResolutionService codeEnvResolutionService = (CodeEnvResolutionService)SpringUtils.getBean(CodeEnvResolutionService.class);
            codeEnvResolutionService.checkEnvExists(CodeEnvModel.EnvLang.PYTHON, envName);
            this.kernel = !this.runsInContainer ? new AnalysisMLKernel(link, null, this.mle.getProjectKey(), envName, this.authCtx, this.mle.getMainFolder()) : new AnalysisMLContainerKernel(link, null, this.mle.getProjectKey(), envName, this.authCtx, this.getExecutionDirForContainerExec(), this.getContextDirForContainerExec(), containerConfig, "doctor-post-computation-");
            Exception error = null;
            try {
                MLFlowModelVersionInfo mim;
                DSSConnection connection;
                ProxySettings proxySettings;
                this.createOutputFolder();
                Map<String, Object> params = this.prepareParams();
                if (null != this.mle.getUnderlyingModel() && this.mle.getUnderlyingModel().isExternalMLflowModelVersion() && !this.runsInContainer && (proxySettings = ExternalInfrasUtils.getProxy(connection = ExternalInfrasUtils.getAndCheckConnection(this.authCtx, (mim = this.mle.getUnderlyingModel().getMLflowImportedModelMetadata()).getProxyModelConnection()))).hasProxy()) {
                    params.put("_PROXY_MODELS_PROXY", proxySettings.getAsString());
                }
                this.kernel.start();
                try {
                    link.executeAsync((Object)new AnalysisMLKernel.ComputeRequest(this.computationCommand.toCmd(), JSON.pretty(params)), null, String.class, "Failed to run post training computation").call();
                }
                catch (SocketBlockLinkException e) {
                    throw this.kernel.maybeRethrowAsProcessDied((IOException)((Object)e.withLogTail((IDSSKernelBase)this.kernel)));
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                logger.error((Object)"Post training computation failed", (Throwable)e);
                error = e;
            }
            catch (Exception e) {
                logger.warn((Object)"Post training computation failed", (Throwable)e);
                error = e;
            }
            finally {
                try {
                    if (!this.kernel.isAborted()) {
                        if (error == null) {
                            try {
                                this.kernel.waitForResults();
                                this.postCompute();
                            }
                            catch (TimeoutException e) {
                                error = e;
                            }
                        } else {
                            SerializedError serializedError = this.kernel.waitForError();
                            if (serializedError != null) {
                                error = new APIError.SerializedErrorException(serializedError);
                            }
                        }
                    }
                    this.kernel.cleanup();
                    this.kernel.killWithoutMercy();
                }
                catch (Exception e) {
                    logger.error((Object)"Failure while destroying post training computation kernel", (Throwable)e);
                }
                try {
                    link.close();
                }
                catch (Exception e) {
                    logger.error((Object)"Failure while closing link to kernel", (Throwable)e);
                }
                this.kernel = null;
                if (error == null) break block38;
                throw error;
            }
        }
    }

    protected abstract File getContextDirForContainerExec() throws IOException;

    protected abstract File getExecutionDirForContainerExec() throws IOException;

    protected abstract FullModelId.Type getFMIType() throws IOException;
}

