/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.model.prediction;

import com.dataiku.dip.analysis.model.core.ModelCustomEvaluationMetric;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class MetricParams {
    private List<ModelCustomEvaluationMetric> customMetrics = new ArrayList<ModelCustomEvaluationMetric>();
    public EvaluationMetric evaluationMetric;
    public ClassAveragingMethod classAveragingMethod = ClassAveragingMethod.MACRO;
    public String customEvaluationMetricName;
    public ThresholdOptimizationMetric thresholdOptimizationMetric;
    public CostMatrixWeights costMatrixWeights = new CostMatrixWeights();
    public double liftPoint = 0.4;
    public double netUpliftPoint = 0.5;
    public CausalWeighting causalWeighting = CausalWeighting.NO_WEIGHTING;

    public MetricParams() {
    }

    public MetricParams(List<ModelCustomEvaluationMetric> customMetrics) {
        this.customMetrics = customMetrics;
    }

    public List<ModelCustomEvaluationMetric> getCustomMetrics() {
        if (this.customMetrics != null) {
            return this.customMetrics;
        }
        return new ArrayList<ModelCustomEvaluationMetric>();
    }

    public Set<String> getCustomMetricNames() {
        if (this.customMetrics != null) {
            return this.customMetrics.stream().map(x -> x.name).collect(Collectors.toSet());
        }
        return new HashSet<String>();
    }

    public ModelCustomEvaluationMetric getCustomMetric(String name) {
        Optional<ModelCustomEvaluationMetric> customMetricOpt = this.customMetrics.stream().filter(m -> m.name.equals(name)).findFirst();
        if (customMetricOpt.isPresent()) {
            return customMetricOpt.get();
        }
        throw new NoSuchElementException("Custom metric " + name + " not found");
    }

    public ModelCustomEvaluationMetric getCustomEvaluationMetric() {
        return this.getCustomMetric(this.customEvaluationMetricName);
    }

    public static enum ClassAveragingMethod {
        WEIGHTED,
        MACRO;

    }

    public static class CostMatrixWeights {
        public double tpGain = 1.0;
        public double tnGain = 0.0;
        public double fpGain = -0.3;
        public double fnGain = 0.0;
    }

    public static enum CausalWeighting {
        NO_WEIGHTING,
        INVERSE_PROPENSITY;

    }

    public static enum ThresholdOptimizationMetric {
        ACCURACY,
        F1,
        COST_MATRIX;

    }

    public static enum EvaluationMetric {
        ACCURACY,
        RECALL,
        PRECISION,
        F1,
        COST_MATRIX,
        CUMULATIVE_LIFT,
        LOG_LOSS(OptimalValueCriteria.LOWER_IS_BETTER),
        ROC_AUC,
        CALIBRATION_LOSS(OptimalValueCriteria.LOWER_IS_BETTER),
        AVERAGE_PRECISION,
        EVS,
        MAPE(OptimalValueCriteria.LOWER_IS_BETTER),
        MAE(OptimalValueCriteria.LOWER_IS_BETTER),
        MSE(OptimalValueCriteria.LOWER_IS_BETTER),
        RMSE(OptimalValueCriteria.LOWER_IS_BETTER),
        RMSLE(OptimalValueCriteria.LOWER_IS_BETTER),
        R2,
        MASE(OptimalValueCriteria.LOWER_IS_BETTER),
        MEAN_ABSOLUTE_QUANTILE_LOSS(OptimalValueCriteria.LOWER_IS_BETTER),
        MEAN_WEIGHTED_QUANTILE_LOSS(OptimalValueCriteria.LOWER_IS_BETTER),
        MSIS(OptimalValueCriteria.LOWER_IS_BETTER),
        ND(OptimalValueCriteria.LOWER_IS_BETTER),
        SMAPE(OptimalValueCriteria.LOWER_IS_BETTER),
        AUUC,
        QINI,
        NET_UPLIFT,
        CUSTOM;

        private final OptimalValueCriteria isLowerIsBetter;

        private EvaluationMetric(OptimalValueCriteria isLowerIsBetter) {
            this.isLowerIsBetter = isLowerIsBetter;
        }

        private EvaluationMetric() {
            this.isLowerIsBetter = OptimalValueCriteria.GREATER_IS_BETTER;
        }

        public boolean isLowerIsBetter() {
            return this.isLowerIsBetter == OptimalValueCriteria.LOWER_IS_BETTER;
        }
    }

    public static enum OptimalValueCriteria {
        LOWER_IS_BETTER,
        GREATER_IS_BETTER,
        UNDEFINED;

    }
}

