/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.analysis.model.prediction.algorithms.python;

import com.dataiku.dip.analysis.model.ModelTrainInfo;
import com.dataiku.dip.analysis.model.core.WorkSet;
import com.dataiku.dip.analysis.model.prediction.CategoricalHyperparameterDimension;
import com.dataiku.dip.analysis.model.prediction.PostTrainPredictionModelingParams;
import com.dataiku.dip.analysis.model.prediction.PreTrainPredictionModelingParams;
import com.dataiku.dip.analysis.model.prediction.PredictionMLTask;
import com.dataiku.dip.analysis.model.prediction.PredictionModelingParams;
import com.dataiku.dip.analysis.model.prediction.PredictionParameterChecks;
import com.dataiku.dip.analysis.model.prediction.algorithms.python.PyMemoryAlgorithmMeta;
import java.util.Collections;
import java.util.List;

public class GluonTSMXNetSimpleFeedForwardMeta
extends PyMemoryAlgorithmMeta {
    @Override
    public String generateName(PreTrainPredictionModelingParams rpmp) {
        return "Simple Feed Forward - MXNet";
    }

    @Override
    public ModelTrainInfo.PreSearchDescription generatePreTrainDescription(PreTrainPredictionModelingParams rpmp) {
        PredictionModelingParams.GluonTSMXNetSimpleFeedForwardSpace space = rpmp.gluonts_simple_feed_forward_timeseries_grid;
        ModelTrainInfo.PreSearchDescription description = new ModelTrainInfo.PreSearchDescription(rpmp).withGridLength(this.getSearchSize(rpmp.grid_search_params, space)).withMVParam("Learning rate", space.learning_rate).withMVParam("Output distribution", space.distr_output).withMVParam("Batch normalization", space.batch_normalization).withMVParam("Mean scaling", space.mean_scaling).withSVParam("Hidden layer sizes", space.num_hidden_dimensions);
        if (!space.full_context) {
            description = description.withMVParam("Context length", space.context_length);
        }
        return description;
    }

    @Override
    public ModelTrainInfo.PostSearchDescription generatePostTrainDescription(ModelTrainInfo.PreSearchDescription descBefore, PreTrainPredictionModelingParams before, PostTrainPredictionModelingParams after) {
        PredictionModelingParams.GluonTSMXNetSimpleFeedForwardSpace space = before.gluonts_simple_feed_forward_timeseries_grid;
        PostTrainPredictionModelingParams.GluonTSMXNetSimpleFeedForwardParams params = after.gluonts_simple_feedforward_timeseries_params;
        ModelTrainInfo.PostSearchDescription description = new ModelTrainInfo.PostSearchDescription().withSVParam("Learning rate", params.learning_rate).withSVParam("Output distribution", params.distr_output).withSVParam("Batch normalization", params.batch_normalization).withSVParam("Mean scaling", params.mean_scaling).withSVParam("Hidden layer sizes", params.num_hidden_dimensions).withSVParam("Epochs", params.epochs);
        if (!space.full_context) {
            description = description.withSVParam("Context length", params.context_length);
        }
        return description;
    }

    @Override
    public void validateParameters(PredictionModelingParams pmp, PredictionMLTask.TabularPredictionMLTask task, PredictionParameterChecks checks) {
        PredictionModelingParams.GluonTSMXNetSimpleFeedForwardSpace space = pmp.gluonts_simple_feed_forward_timeseries;
        if (space == null || !space.enabled) {
            return;
        }
        checks.checkPositive(space.distr_output.getLength(), "At least one output distribution must be selected (Simple Feed Forward)");
        checks.checkPositive(space.batch_normalization.getLength(), "At least one batch normalization option must be selected (Simple Feed Forward)");
        checks.checkPositive(space.mean_scaling.getLength(), "At least one mean scaling option must be selected (Simple Feed Forward)");
        checks.checkNumericalDimension(space.learning_rate, "Learning rate (Simple Feed Forward)");
        if (!space.full_context) {
            checks.checkNumericalDimension(space.context_length, "Context length (Simple Feed Forward)");
        }
    }

    @Override
    public List<WorkSet.ModelingSet> expandModeling(PredictionModelingParams pmp, PredictionMLTask.TabularPredictionMLTask task, int gsFolds) {
        PredictionModelingParams.GluonTSMXNetSimpleFeedForwardSpace space = pmp.gluonts_simple_feed_forward_timeseries;
        if (space == null || !space.enabled) {
            return Collections.emptyList();
        }
        PreTrainPredictionModelingParams preTrainParams = new PreTrainPredictionModelingParams(PreTrainPredictionModelingParams.Algorithm.GLUONTS_SIMPLE_FEEDFORWARD, pmp);
        preTrainParams.gluonts_simple_feed_forward_timeseries_grid = space;
        preTrainParams.gridLength = this.getSearchSize(preTrainParams.grid_search_params, space);
        WorkSet.ModelingSet modelingSet = new WorkSet.ModelingSet(preTrainParams);
        if (preTrainParams.gridLength > 1) {
            modelingSet.estimatedTrains = preTrainParams.gridLength * gsFolds + 1;
        }
        return Collections.singletonList(modelingSet);
    }

    @Override
    public PreTrainPredictionModelingParams regridifyToPreTrain(PostTrainPredictionModelingParams optimized, PreTrainPredictionModelingParams usedToTrain) {
        PostTrainPredictionModelingParams.GluonTSMXNetSimpleFeedForwardParams optimizedParameters = optimized.gluonts_simple_feedforward_timeseries_params;
        PreTrainPredictionModelingParams preTrainParams = this.getCopyWithGridStrategy(usedToTrain);
        PredictionModelingParams.GluonTSMXNetSimpleFeedForwardSpace space = preTrainParams.gluonts_simple_feed_forward_timeseries_grid;
        if (!preTrainParams.gluonts_simple_feed_forward_timeseries_grid.full_context) {
            space.context_length.setToSingleValueGrid(optimizedParameters.context_length);
        }
        space.learning_rate.setToSingleValueGrid(optimizedParameters.learning_rate);
        space.distr_output = CategoricalHyperparameterDimension.create(optimizedParameters.distr_output, "StudentTOutput", "GaussianOutput", "NegativeBinomialOutput");
        space.batch_normalization = CategoricalHyperparameterDimension.create(optimizedParameters.batch_normalization, "true", "false");
        space.mean_scaling = CategoricalHyperparameterDimension.create(optimizedParameters.mean_scaling, "true", "false");
        return preTrainParams;
    }

    @Override
    public void regridifyToMLTask(PredictionModelingParams target, PostTrainPredictionModelingParams optimized, PreTrainPredictionModelingParams usedToTrain) {
        PreTrainPredictionModelingParams preTrainParams = this.regridifyToPreTrain(optimized, usedToTrain);
        target.gluonts_simple_feed_forward_timeseries = preTrainParams.gluonts_simple_feed_forward_timeseries_grid;
        target.gluonts_simple_feed_forward_timeseries.enabled = true;
    }

    @Override
    public void refreshMLTask(PredictionModelingParams target, PreTrainPredictionModelingParams usedToTrain) {
        target.gluonts_simple_feed_forward_timeseries = usedToTrain.gluonts_simple_feed_forward_timeseries_grid;
        target.gluonts_simple_feed_forward_timeseries.enabled = true;
    }

    @Override
    public boolean hasProbabilities(PreTrainPredictionModelingParams rpmp) {
        return true;
    }

    @Override
    protected int getGridLength(PredictionModelingParams.HyperparametersSpace space) {
        PredictionModelingParams.GluonTSMXNetSimpleFeedForwardSpace gluonTSMXNetSimpleFeedForwardSpace = (PredictionModelingParams.GluonTSMXNetSimpleFeedForwardSpace)space;
        int gridLength = gluonTSMXNetSimpleFeedForwardSpace.batch_normalization.getLength() * gluonTSMXNetSimpleFeedForwardSpace.distr_output.getLength() * gluonTSMXNetSimpleFeedForwardSpace.mean_scaling.getLength() * gluonTSMXNetSimpleFeedForwardSpace.learning_rate.getLength();
        if (!gluonTSMXNetSimpleFeedForwardSpace.full_context) {
            gridLength *= gluonTSMXNetSimpleFeedForwardSpace.context_length.getLength();
        }
        return gridLength;
    }
}

