/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.apideployer.datamodel.actual.sagemaker;

import com.dataiku.dip.apideployer.datamodel.actual.sagemaker.SageMakerResource;
import com.dataiku.dip.apideployer.datamodel.config.SageMakerAPIDeployment;
import com.dataiku.dip.apideployer.datamodel.config.SageMakerAPIDeploymentInfra;
import com.dataiku.dip.apideployer.deployments.SageMakerDeploymentConfigManager;
import com.dataiku.dip.externalinfras.sagemaker.SageMakerUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.variables.VariablesContext;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.core.exception.SdkException;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.sagemaker.SageMakerClient;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.sagemaker.model.CreateEndpointRequest;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.sagemaker.model.DescribeEndpointResponse;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.sagemaker.model.EndpointStatus;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.sagemaker.model.PendingProductionVariantSummary;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.sagemaker.model.ProductionVariant;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.sagemaker.model.ProductionVariantSummary;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.sagemaker.model.Tag;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.sagemaker.model.UpdateEndpointRequest;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;

public class SageMakerEndpoint
extends SageMakerResource<DescribeEndpointResponse> {
    public boolean isDescriptionTransient;
    public String status = "UNKNOWN";
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.deployer.deployment.actual.sagemaker.resource-summary");

    public boolean isCreatingOrUpdating() {
        return EndpointStatus.CREATING.toString().equals(this.status) || EndpointStatus.UPDATING.toString().equals(this.status);
    }

    public boolean hasFailed() {
        return EndpointStatus.FAILED.toString().equals(this.status);
    }

    public String getVariantName() {
        String variantName = "";
        if (this.resourceDescription.isPresent() && !this.isDescriptionTransient && !this.hasFailed()) {
            variantName = this.isCreatingOrUpdating() ? ((DescribeEndpointResponse)this.resourceDescription.get()).pendingDeploymentSummary().productionVariants().stream().findFirst().map(PendingProductionVariantSummary::variantName).orElse("") : ((DescribeEndpointResponse)this.resourceDescription.get()).productionVariants().stream().findFirst().map(ProductionVariantSummary::variantName).orElse("");
        }
        return variantName;
    }

    public String getEndpointConfigName() {
        String endpointConfigName = "";
        if (this.resourceDescription.isPresent() && !this.isDescriptionTransient) {
            endpointConfigName = this.isCreatingOrUpdating() ? ((DescribeEndpointResponse)this.resourceDescription.get()).pendingDeploymentSummary().endpointConfigName() : ((DescribeEndpointResponse)this.resourceDescription.get()).endpointConfigName();
        }
        return endpointConfigName;
    }

    public UpdateEndpointRequest createUpdateEndpointRequest() {
        UpdateEndpointRequest.Builder updateEndpointRequest = UpdateEndpointRequest.builder();
        this.resourceDescription.ifPresent(endpointDescription -> updateEndpointRequest.endpointName(this.name).endpointConfigName(endpointDescription.endpointConfigName()).retainAllVariantProperties(Boolean.valueOf(false)).retainDeploymentConfig(Boolean.valueOf(false)).deploymentConfig(endpointDescription.lastDeploymentConfig()));
        return (UpdateEndpointRequest)updateEndpointRequest.build();
    }

    public CreateEndpointRequest createCreateEndpointRequest() {
        CreateEndpointRequest.Builder createEndpointRequest = CreateEndpointRequest.builder();
        this.resourceDescription.ifPresent(endpointDescription -> createEndpointRequest.endpointName(this.name).endpointConfigName(endpointDescription.endpointConfigName()).deploymentConfig(endpointDescription.lastDeploymentConfig()).tags(this.getSageMakerTags()));
        return (CreateEndpointRequest)createEndpointRequest.build();
    }

    public static class SageMakerEndpointBuilder {
        private SageMakerEndpointBuilder() {
        }

        public static SageMakerEndpoint buildFromRemoteConfig_NT(SageMakerClient sageMakerClient, String endpointName) {
            SageMakerEndpoint sageMakerEndpoint = new SageMakerEndpoint();
            sageMakerEndpoint.name = endpointName;
            sageMakerEndpoint.resourceShouldExist = StringUtils.isNotBlank((String)endpointName);
            if (sageMakerEndpoint.resourceShouldExist) {
                try {
                    Optional<DescribeEndpointResponse> deployedEndpointDescription;
                    sageMakerEndpoint.resourceDescription = deployedEndpointDescription = SageMakerUtils.retrieveCheckEndpointDescription_NT(sageMakerClient, endpointName);
                    if (deployedEndpointDescription.isPresent()) {
                        boolean isCreatingOrUpdating;
                        String endpointStatus = deployedEndpointDescription.get().endpointStatus().toString();
                        sageMakerEndpoint.tags = SageMakerUtils.listTags_NT(sageMakerClient, deployedEndpointDescription.get().endpointArn()).stream().collect(Collectors.toMap(Tag::key, Tag::value));
                        sageMakerEndpoint.status = endpointStatus;
                        boolean bl = isCreatingOrUpdating = EndpointStatus.CREATING.toString().equals(sageMakerEndpoint.status) || EndpointStatus.UPDATING.toString().equals(sageMakerEndpoint.status);
                        if (isCreatingOrUpdating && Objects.isNull(deployedEndpointDescription.get().pendingDeploymentSummary())) {
                            logger.warnV("Unable to retrieve all the information for SageMaker endpoint %s.", new Object[]{sageMakerEndpoint.name});
                            sageMakerEndpoint.isDescriptionTransient = true;
                        }
                    } else {
                        logger.infoV("Endpoint '%s' is not present in SageMaker. Updating the deployment should create it.", new Object[]{endpointName});
                    }
                }
                catch (SdkException e) {
                    logger.errorV("Error while retrieving SageMaker Endpoint %s.", new Object[]{endpointName});
                    throw e;
                }
            }
            return sageMakerEndpoint;
        }

        public static SageMakerEndpoint buildFromLocalConfig(SageMakerAPIDeployment deployment, SageMakerAPIDeploymentInfra infra, VariablesContext vc, String resourceName, String endpointConfigName, String modelName) {
            SageMakerDeploymentConfigManager deploymentConfigManager = new SageMakerDeploymentConfigManager(deployment, infra, vc);
            SageMakerEndpoint sageMakerEndpoint = new SageMakerEndpoint();
            sageMakerEndpoint.name = resourceName;
            sageMakerEndpoint.isRemote = false;
            sageMakerEndpoint.tags = deploymentConfigManager.prepareTags();
            ProductionVariant productionVariant = deploymentConfigManager.getProductionVariant(modelName);
            ProductionVariantSummary productionVariantSummary = (ProductionVariantSummary)ProductionVariantSummary.builder().variantName(productionVariant.variantName()).currentInstanceCount(productionVariant.initialInstanceCount()).currentWeight(productionVariant.initialVariantWeight()).currentServerlessConfig(productionVariant.serverlessConfig()).build();
            DescribeEndpointResponse endpointResult = (DescribeEndpointResponse)DescribeEndpointResponse.builder().endpointName(sageMakerEndpoint.name).endpointConfigName(endpointConfigName).lastDeploymentConfig(deploymentConfigManager.getDeploymentConfig()).productionVariants(new ProductionVariantSummary[]{productionVariantSummary}).build();
            sageMakerEndpoint.resourceDescription = Optional.of(endpointResult);
            return sageMakerEndpoint;
        }
    }
}

