/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.apideployer.monitoring;

import com.dataiku.dip.apideployer.monitoring.MetricType;
import com.dataiku.dip.apideployer.monitoring.MonitoringMetric;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;

public class SystemMetric
implements MonitoringMetric<Type> {
    @Nonnull
    private final Type type;
    private double value;

    public SystemMetric(@Nonnull Type type, double value) {
        this.type = type;
        this.value = value;
    }

    @Override
    @Nonnull
    public Type getType() {
        return this.type;
    }

    @Override
    public double getValue() {
        return this.value;
    }

    @Override
    public void setValue(double value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SystemMetric that = (SystemMetric)o;
        return Double.compare(this.getValue(), that.getValue()) == 0 && this.getType() == that.getType();
    }

    public int hashCode() {
        int result = this.getType().hashCode();
        result = 31 * result + Double.hashCode(this.getValue());
        return result;
    }

    public static enum Type implements MetricType
    {
        CPU_USAGE_ABSOLUTE_IN_MILLICORES("cpuUsageAbsoluteMillis"),
        CPU_USAGE_RELATIVE("cpuUsageRelative"),
        CPU_CAPACITY_IN_MILLICORES("cpuCapacityMillis"),
        MEMORY_USAGE_ABSOLUTE_IN_MEGABYTES("memoryUsageAbsoluteMB"),
        MEMORY_USAGE_RELATIVE("memoryUsageRelative"),
        MEMORY_CAPACITY_IN_MEGABYTES("memoryCapacityMB"),
        NODE_COUNT("nodeCount"),
        POD_COUNT("podCount");

        private final String rrdFieldName;
        static final Map<String, Type> byRrdFieldName;

        private Type(String rrdFieldName) {
            this.rrdFieldName = rrdFieldName;
        }

        @Override
        public String getRrdFieldName() {
            return this.rrdFieldName;
        }

        static {
            byRrdFieldName = new HashMap<String, Type>();
            for (Type mt : Type.values()) {
                byRrdFieldName.put(mt.getRrdFieldName(), mt);
            }
        }
    }

    public static class TimeAndMetrics {
        public long timestampInSeconds;
        @Nonnull
        public Map<Type, SystemMetric> systemMetricsByType;

        public TimeAndMetrics(long timestampInSeconds) {
            this.timestampInSeconds = timestampInSeconds;
            this.systemMetricsByType = new EnumMap<Type, SystemMetric>(Type.class);
        }

        public TimeAndMetrics(long timestampInSeconds, @Nonnull Map<Type, SystemMetric> systemMetricsByType) {
            this.timestampInSeconds = timestampInSeconds;
            this.systemMetricsByType = systemMetricsByType;
        }

        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TimeAndMetrics that = (TimeAndMetrics)o;
            return this.timestampInSeconds == that.timestampInSeconds && this.systemMetricsByType.equals(that.systemMetricsByType);
        }

        public int hashCode() {
            int result = Long.hashCode(this.timestampInSeconds);
            result = 31 * result + this.systemMetricsByType.hashCode();
            return result;
        }
    }

    public static class TimeAndMetricsForDeployment {
        @Nonnull
        public String deploymentId;
        @Nonnull
        public TimeAndMetrics timeAndMetrics;

        public TimeAndMetricsForDeployment(@Nonnull String deploymentId, @Nonnull TimeAndMetrics timeAndMetrics) {
            this.deploymentId = deploymentId;
            this.timeAndMetrics = timeAndMetrics;
        }

        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TimeAndMetricsForDeployment that = (TimeAndMetricsForDeployment)o;
            return this.deploymentId.equals(that.deploymentId) && this.timeAndMetrics.equals(that.timeAndMetrics);
        }

        public int hashCode() {
            int result = this.deploymentId.hashCode();
            result = 31 * result + this.timeAndMetrics.hashCode();
            return result;
        }
    }

    public static class TimeAndMetricsByDeployment
    extends HashMap<String, TimeAndMetricsForDeployment> {

        public static class None
        extends TimeAndMetricsByDeployment {
        }
    }
}

