/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.cli.internalcmd;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.cli.CLICommand;
import com.dataiku.dip.cli.CLISetup;
import com.dataiku.dip.cli.DKU;
import com.dataiku.dip.connections.SQLBaseConnectionService;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.dao.impl.FilesBasedProjectVersionTagsDAO;
import com.dataiku.dip.db.DSSDBConnection;
import com.dataiku.dip.db.DSSDBConnectionsManagementService;
import com.dataiku.dip.discussions.Discussion;
import com.dataiku.dip.discussions.DiscussionsInternalDB;
import com.dataiku.dip.logging.MainLoggingConfigurator;
import com.dataiku.dip.scheduler.scenarios.ScenarioRunContext;
import com.dataiku.dip.security.model.NoopCredentialsService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.DKUTransactionService;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.PubSubService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.timelines.ProjectTimelineInternalDB;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.variables.BackendVariablesService;
import com.dataiku.dip.wikis.ArticlesCacheService;
import com.dataiku.dip.wikis.FilesBasedArticlesDAO;
import java.util.List;
import org.apache.commons.cli.Options;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;

public class V6000MigrationCommand
extends CLICommand {
    private static DKULogger logger = DKULogger.getLogger((String)"dku.cli.migration.wiki-articles");

    @Override
    public String usageString() {
        return "__migrate_v6000";
    }

    @Override
    public String description() {
        return "Upgrade Wiki articles timeline to use numeric IDs instead of names";
    }

    @Override
    public Options opts() {
        Options options = new Options();
        DKU.addGlobalOptions(options);
        return options;
    }

    @Override
    public int execute(String[] args) throws Exception {
        this.parseAndMiniSetup(args, this.usageString(), true);
        AnnotationConfigApplicationContext appContext = new AnnotationConfigApplicationContext();
        appContext.register(new Class[]{SpringUtils.class});
        appContext.register(new Class[]{NoopCredentialsService.class});
        appContext.register(new Class[]{DKUTransactionService.class});
        appContext.register(new Class[]{GeneralSettingsDAO.class});
        appContext.register(new Class[]{ScenarioRunContext.class});
        appContext.register(new Class[]{BackendVariablesService.class});
        appContext.register(new Class[]{DSSDBConnectionsManagementService.class});
        appContext.register(new Class[]{FilesBasedProjectVersionTagsDAO.class, ArticlesCacheService.class, FilesBasedArticlesDAO.class, PubSubService.class});
        appContext.register(new Class[]{DiscussionsInternalDB.class});
        appContext.register(new Class[]{SQLBaseConnectionService.class});
        appContext.refresh();
        ApplicationConfigurator.setProcessType((MainLoggingConfigurator.ProcessType)MainLoggingConfigurator.ProcessType.DKU);
        logger.info((Object)"Migrating Wiki article IDs to numeric in timeline");
        List<String> projectKeys = CLISetup.listProjectKeys();
        for (String projectKey : projectKeys) {
            logger.debug((Object)("Migrating Wiki article IDs for project " + projectKey));
            try {
                ProjectTimelineInternalDB internalDB = new ProjectTimelineInternalDB(projectKey);
                DSSDBConnection dssdbConnection = internalDB.acquireConnection();
                try {
                    internalDB.behavior.migrateArticlesToNumericIds(dssdbConnection);
                }
                finally {
                    if (dssdbConnection == null) continue;
                    dssdbConnection.close();
                }
            }
            catch (Throwable t) {
                logger.info((Object)("Failed for project " + projectKey + ", ignoring: " + ExceptionUtils.getMessageWithCauses((Throwable)t)));
            }
        }
        logger.info((Object)"Done migrating Wiki article IDs to numeric in timeline");
        this.migrateDiscussionReferenceToArticleFromNamesToIds();
        appContext.close();
        return 0;
    }

    public void migrateDiscussionReferenceToArticleFromNamesToIds() throws Exception {
        logger.debug((Object)"Migrating Wiki article IDs to numeric in discussion DB");
        ArticlesCacheService articlesCacheService = (ArticlesCacheService)SpringUtils.getBean(ArticlesCacheService.class);
        DiscussionsInternalDB internalDB = (DiscussionsInternalDB)SpringUtils.getBean(DiscussionsInternalDB.class);
        TransactionService transactionService = (TransactionService)SpringUtils.getBean(TransactionService.class);
        List<Discussion> discussions = internalDB.getAllDiscussionsNoReplies();
        for (Discussion discussion : discussions) {
            String id;
            if (discussion.objectType != ITaggingService.TaggableType.ARTICLE) continue;
            try (Transaction t = transactionService.beginRead();){
                id = articlesCacheService.getIdFromName(discussion.projectKey, discussion.objectId);
            }
            if (StringUtils.isBlank((CharSequence)id)) {
                logger.warn((Object)("Unable to find new ID for article: " + discussion.projectKey + "." + discussion.objectId));
                continue;
            }
            discussion.objectId = id;
            internalDB.saveDiscussion(discussion, false);
        }
        logger.debug((Object)"Done migrating Wiki article IDs to numeric in discussion DB");
    }
}

