/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.cluster;

import com.dataiku.dip.cluster.Cluster;
import com.dataiku.dip.cluster.ClusterHandler;
import com.dataiku.dip.cluster.ClusterMeta;
import com.dataiku.dip.cluster.ClusterParams;
import com.dataiku.dip.cluster.ContainerOverrideMask;
import com.dataiku.dip.cluster.ContainerSettings;
import com.dataiku.dip.cluster.HadoopOverrideMask;
import com.dataiku.dip.cluster.HadoopSettings;
import com.dataiku.dip.cluster.HiveOverrideMask;
import com.dataiku.dip.cluster.HiveSettings;
import com.dataiku.dip.cluster.ImpalaOverrideMask;
import com.dataiku.dip.cluster.ImpalaSettings;
import com.dataiku.dip.cluster.LoadedPythonPluginCluster;
import com.dataiku.dip.cluster.PythonClusterKernel;
import com.dataiku.dip.cluster.PythonPluginClustersService;
import com.dataiku.dip.cluster.SparkOverrideMask;
import com.dataiku.dip.cluster.SparkSettings;
import com.dataiku.dip.custom.IElementLoadedDesc;
import com.dataiku.dip.custom.IPluginifiedMeta;
import com.dataiku.dip.kernels.DSSKernelBase;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.tickets.APITicketService;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.SmartLogTail;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import javax.annotation.Nullable;
import org.springframework.beans.factory.annotation.Autowired;

public class PythonPluginClusterHandler
implements ClusterHandler {
    @Autowired
    private APITicketService apiTicketService;
    @Autowired
    private PythonPluginClustersService pythonPluginClustersService;
    private final Cluster cluster;
    private final PythonPluginClusterParams params;
    private final LoadedPythonPluginCluster desc;
    private final String pluginId;
    private final AuthCtx authCtx;
    private final String projectKey;
    private DSSKernelBase runningKernel;
    private static DKULogger logger = DKULogger.getLogger((String)"dip.cluster.plugin");

    public PythonPluginClusterHandler(AuthCtx authCtx, @Nullable String projectKey, Cluster cluster, String pluginId, LoadedPythonPluginCluster desc, PythonPluginClusterParams params) {
        this.authCtx = authCtx;
        this.projectKey = projectKey;
        this.cluster = cluster;
        this.pluginId = pluginId;
        this.desc = desc;
        this.params = params;
    }

    @Override
    public Cluster getCluster() {
        return this.cluster;
    }

    public SmartLogTail getLogTail() {
        DSSKernelBase kernel = this.runningKernel;
        if (kernel != null) {
            return kernel.getLogTail();
        }
        return null;
    }

    @Override
    public void start() throws Exception {
        this.cluster.state = Cluster.ClusterState.STARTING;
        try {
            PythonClusterKernel.ClusterStartResponse started = this.run("start", PythonClusterKernel.ClusterStartResponse.class, "Failed to start cluster");
            this.cluster.state = Cluster.ClusterState.RUNNING;
            this.cluster.data = started.data;
            this.cluster.overrideHadoopSettings = HadoopOverrideMask.fromJsonObject(started.hadoopSettings);
            this.cluster.overrideHiveSettings = HiveOverrideMask.fromJsonObject(started.hiveSettings);
            this.cluster.overrideImpalaSettings = ImpalaOverrideMask.fromJsonObject(started.impalaSettings);
            this.cluster.overrideSparkSettings = SparkOverrideMask.fromJsonObject(started.sparkSettings);
            this.cluster.overrideContainerSettings = ContainerOverrideMask.fromJsonObject(started.containerSettings);
            this.cluster.hadoopSettings = (HadoopSettings)JSON.parse((JsonElement)started.hadoopSettings, HadoopSettings.class);
            this.cluster.hiveSettings = (HiveSettings)JSON.parse((JsonElement)started.hiveSettings, HiveSettings.class);
            this.cluster.impalaSettings = (ImpalaSettings)JSON.parse((JsonElement)started.impalaSettings, ImpalaSettings.class);
            this.cluster.sparkSettings = (SparkSettings)JSON.parse((JsonElement)started.sparkSettings, SparkSettings.class);
            this.cluster.containerSettings = (ContainerSettings)JSON.parse((JsonElement)started.containerSettings, ContainerSettings.class);
            if (this.cluster.hadoopSettings == null) {
                this.cluster.hadoopSettings = new HadoopSettings();
            }
            if (this.cluster.hiveSettings == null) {
                this.cluster.hiveSettings = new HiveSettings();
            }
            if (this.cluster.impalaSettings == null) {
                this.cluster.impalaSettings = new ImpalaSettings();
            }
            if (this.cluster.sparkSettings == null) {
                this.cluster.sparkSettings = new SparkSettings();
            }
            if (this.cluster.containerSettings == null) {
                this.cluster.containerSettings = new ContainerSettings();
            }
        }
        catch (Exception e) {
            this.cluster.state = Cluster.ClusterState.NONE;
            throw e;
        }
    }

    @Override
    public void stop() throws Exception {
        Cluster.ClusterState oldState = this.cluster.state;
        try {
            this.cluster.state = Cluster.ClusterState.STOPPING;
            PythonClusterKernel.ClusterResponse stopped = this.run("stop", PythonClusterKernel.ClusterResponse.class, "Failed to stop cluster");
            if (!stopped.ok) {
                throw new Exception("Stopping the cluster failed. Check the logs.");
            }
            this.cluster.state = Cluster.ClusterState.NONE;
        }
        catch (Exception e) {
            this.cluster.state = oldState;
            throw e;
        }
    }

    /*
     * Exception decompiling
     */
    private <T> T run(String command, Class<T> clazz, String exceptionIfNullMessage) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static class PythonPluginClusterParams
    implements ClusterParams {
        public JsonObject config = new JsonObject();
    }

    public static class PythonPluginClusterMeta
    implements ClusterMeta,
    IPluginifiedMeta {
        private final LoadedPythonPluginCluster desc;
        private final String pluginId;

        public PythonPluginClusterMeta(String pluginId, LoadedPythonPluginCluster desc, PythonPluginClustersService pythonPluginClustersService) {
            this.pluginId = pluginId;
            this.desc = desc;
        }

        public LoadedPythonPluginCluster getDesc() {
            return this.desc;
        }

        @Override
        public Class<? extends ClusterParams> paramsClass() {
            return PythonPluginClusterParams.class;
        }

        @Override
        public String getType() {
            return this.desc.clusterType;
        }

        @Override
        public ClusterHandler buildHandler(AuthCtx authCtx, @Nullable String projectKey, Cluster cluster) {
            return new PythonPluginClusterHandler(authCtx, projectKey, cluster, this.pluginId, this.desc, cluster.getParamsAs(PythonPluginClusterParams.class));
        }

        @Override
        public Cluster prepareForSaveFromUser(Cluster cluster, Cluster existing) {
            cluster.type = existing.type;
            cluster.data = existing.data;
            cluster.state = existing.state;
            return cluster;
        }

        @Override
        public IElementLoadedDesc getLoadedDesc() {
            return this.desc;
        }
    }
}

