/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.code;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.code.AbstractNodeCodeEnvsAccessService;
import com.dataiku.dip.code.CodeEnvCodes;
import com.dataiku.dip.code.CodeEnvModel;
import com.dataiku.dip.code.CodeEnvUtilsBase;
import com.dataiku.dip.code.StandardPythonInterpreter;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.exceptions.CodedIOException;
import com.dataiku.dip.transactions.TransactionProvider;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.git.DSSTransactionProviderSettings;
import com.dataiku.dip.transactions.ifaces.IsolationLevel;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ExceptionUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.springframework.stereotype.Service;

@Service
public class DesignNodeCodeEnvsAccessService
extends AbstractNodeCodeEnvsAccessService {
    private File descRootDir = ApplicationConfigurator.getFile((String[])new String[]{"code-envs", "desc"});
    private TransactionProvider descTransactionProvider;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.code.envs");

    @PostConstruct
    public void setupGit() throws IOException {
        logger.debug((Object)"Init code envs service");
        DKUFileUtils.mkdirs((File)this.descRootDir);
        this.descTransactionProvider = new TransactionProvider(this.descRootDir, (TransactionProvider.TransactionProviderSettings)new DSSTransactionProviderSettings(false, true, true, true));
        logger.debug((Object)"Done init code envs service");
    }

    public TransactionProvider getTransactionProvider() {
        return this.descTransactionProvider;
    }

    public List<CodeEnvModel.CodeEnvListItem> listCodeEnvs() throws IOException {
        ArrayList<CodeEnvModel.CodeEnvListItem> ret = new ArrayList<CodeEnvModel.CodeEnvListItem>();
        try (Transaction t = this.descTransactionProvider.retrieveOrBeginRead();){
            RelFile rDescDir;
            RelFile pyDescDir = new RelFile(new String[]{CodeEnvModel.EnvLang.PYTHON.getFolderName()});
            if (t.isDirectory(pyDescDir)) {
                for (RelFile envDir : t.listFiles(pyDescDir)) {
                    String envName = null;
                    try {
                        envName = envDir.getLeafName();
                        RelFile descFile = new RelFile(envDir, new String[]{"desc.json"});
                        if (!t.isFile(descFile)) continue;
                        CodeEnvModel.PythonEnvDesc desc = (CodeEnvModel.PythonEnvDesc)t.readObjectUnsafe(descFile, CodeEnvModel.PythonEnvDesc.class);
                        ret.add(CodeEnvUtilsBase.getListItemFromDesc(desc, envName));
                    }
                    catch (Exception e) {
                        if (envName != null) {
                            logger.warnV("Skipping python code env '%s', could not parse desc file: %s", new Object[]{envName, ExceptionUtils.getMessageWithCauses((Throwable)e)});
                            continue;
                        }
                        logger.warnV("Skipping unknown python code env, could not parse desc file: %s", new Object[]{ExceptionUtils.getMessageWithCauses((Throwable)e)});
                    }
                }
            }
            if (t.isDirectory(rDescDir = new RelFile(new String[]{CodeEnvModel.EnvLang.R.getFolderName()}))) {
                for (RelFile envDir : t.listFiles(rDescDir)) {
                    String envName = null;
                    try {
                        envName = envDir.getLeafName();
                        RelFile descFile = new RelFile(envDir, new String[]{"desc.json"});
                        if (!t.isFile(descFile)) continue;
                        CodeEnvModel.REnvDesc desc = (CodeEnvModel.REnvDesc)t.readObjectUnsafe(descFile, CodeEnvModel.REnvDesc.class);
                        ret.add(CodeEnvUtilsBase.getListItemFromDesc(desc, CodeEnvModel.EnvLang.R, envName));
                    }
                    catch (Exception e) {
                        if (envName != null) {
                            logger.warnV("Skipping R code env '%s', could not parse desc file: %s", new Object[]{envName, ExceptionUtils.getMessageWithCauses((Throwable)e)});
                            continue;
                        }
                        logger.warnV("Skipping R unknown code env, could not parse desc file: %s", new Object[]{ExceptionUtils.getMessageWithCauses((Throwable)e)});
                    }
                }
            }
        }
        return ret;
    }

    public Set<String> listDesignCodeEnvAndInternalCodeEnvNames(CodeEnvModel.EnvLang envLang) throws IOException {
        return this.listCodeEnvs().stream().filter(codeEnvListItem -> codeEnvListItem.envLang == envLang && codeEnvListItem.deploymentMode != CodeEnvModel.CodeEnvDeploymentMode.PLUGIN_MANAGED && codeEnvListItem.deploymentMode != CodeEnvModel.CodeEnvDeploymentMode.PLUGIN_NON_MANAGED).map(codeEnvListItem -> codeEnvListItem.envName).collect(Collectors.toSet());
    }

    public CodeEnvModel.AbstractEnvDesc getEnvDesc(CodeEnvModel.EnvLang envLang, String envName) throws IOException {
        try (Transaction t = this.descTransactionProvider.retrieveOrBeginRead();){
            RelFile descFile = new RelFile(new String[]{envLang.getFolderName(), envName, "desc.json"});
            if (!t.exists(descFile)) {
                CodeEnvModel.AbstractEnvDesc abstractEnvDesc = null;
                return abstractEnvDesc;
            }
            CodeEnvModel.AbstractEnvDesc abstractEnvDesc = (CodeEnvModel.AbstractEnvDesc)t.readObjectUnsafe(descFile, envLang.getDescClazz());
            return abstractEnvDesc;
        }
    }

    @Override
    public boolean doesEnvExist(CodeEnvModel.EnvLang envLang, String envName) throws IOException {
        try (Transaction t = this.descTransactionProvider.retrieveOrBeginRead(IsolationLevel.YOLO);){
            RelFile descFile = new RelFile(new String[]{envLang.getFolderName(), envName, "desc.json"});
            boolean bl = t.isFile(descFile);
            return bl;
        }
    }

    public void checkDesignEnvExists(CodeEnvModel.EnvLang envLang, String envName) throws IOException {
        if (!this.listDesignCodeEnvAndInternalCodeEnvNames(envLang).contains(envName)) {
            throw new CodedIOException((InfoMessage.MessageCode)CodeEnvCodes.ERR_CODEENV_MISSING_ENV, envLang.name() + " env " + envName + " doesn't exist");
        }
    }

    public StandardPythonInterpreter getPythonInterpreter(CodeEnvModel.PythonEnvDesc desc) {
        return CodeEnvUtilsBase.getPythonInterpreter(desc);
    }
}

