/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.codestudio.blocks;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.DKUApp;
import com.dataiku.dip.code.AutomationNodeCodeEnvsAccessService;
import com.dataiku.dip.code.AutomationNodeCodeEnvsService;
import com.dataiku.dip.code.AutomationNodeManagedEnvUtils;
import com.dataiku.dip.code.CodeEnvModel;
import com.dataiku.dip.code.CodeEnvPackageSystems;
import com.dataiku.dip.code.DesignNodeCodeEnvsService;
import com.dataiku.dip.codestudio.CodeStudioMeta;
import com.dataiku.dip.codestudio.blocks.CodeStudioBlock;
import com.dataiku.dip.codestudio.blocks.CodeStudioBlockMeta;
import com.dataiku.dip.codestudio.blocks.CodeStudioBlockParams;
import com.dataiku.dip.codestudio.template.CodeStudioTemplate;
import com.dataiku.dip.containers.exec.ContainerExecDockerFilePreparer;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.projects.importexport.model.ProjectRemappingSettings;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.variables.VariablesContext;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.stereotype.Component;

@Component
public class AddCodeEnvCodeStudioBlockMeta
implements CodeStudioBlockMeta {
    private static Logger logger = Logger.getLogger((String)"dip.codestudio.addcodeenv");

    @Override
    public String getType() {
        return "add_codeenv";
    }

    @Override
    public void newTemplateInitialization(CodeStudioBlock block) {
    }

    @Override
    public Class<? extends CodeStudioBlockParams> blockParamsClass() {
        return AddCodeEnvCodeStudioBlockParams.class;
    }

    @Override
    public CodeStudioBlock.CodeStudioBlockType getBlockType() {
        CodeStudioBlock.CodeStudioBlockType ret = new CodeStudioBlock.CodeStudioBlockType();
        ret.type = this.getType();
        ret.label = "Add Code Environment";
        ret.description = "Add a Code environment to the Code Studio at build time";
        ret.icon = "icon-dku-code";
        ret.isAdvanced = false;
        ret.uiDisplayPriority = 500;
        return ret;
    }

    @Override
    public CodeStudioMeta.ImageBuildSpec apply(AuthCtx authCtx, CodeStudioBlock block, CodeStudioMeta.ImageBuildSpec buildSpec, CodeStudioMeta.ImageBuildEnv buildEnv, CodeStudioTemplate template) throws IOException {
        Object envDirName;
        AddCodeEnvCodeStudioBlockParams params = block.getParamsAs(AddCodeEnvCodeStudioBlockParams.class);
        Object dockerfile = buildSpec.dockerfile;
        if (StringUtils.isBlank((String)dockerfile)) {
            throw ErrorContext.ice((String)("Code environment block " + params.envName + " must come after Base DSS image."));
        }
        File buildDir = new File(buildEnv.buildDir);
        if (!buildDir.exists()) {
            DKUFileUtils.mkdirs((File)buildDir);
        }
        if (StringUtils.isBlank((String)(envDirName = params.envDir))) {
            envDirName = params.envName.replaceAll("[^a-zA-Z0-9-_]", "_");
            logger.info((Object)("Using default location for code env : " + (String)envDirName));
        }
        String[] envPath = ((String)envDirName).split("/");
        File envDir = DKUFileUtils.getWithin((File)new File("."), (String[])envPath);
        envDirName = envDir.toString();
        switch (params.envLang) {
            case PYTHON: {
                envDirName = "python-code-envs/" + (String)envDirName;
                break;
            }
            case R: {
                envDirName = "r-code-envs/" + (String)envDirName;
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported lang " + String.valueOf((Object)params.envLang));
            }
        }
        ContainerExecDockerFilePreparer preparer = switch (ApplicationConfigurator.getNodeType()) {
            case ApplicationConfigurator.DSSNodeType.AUTOMATION -> this.getAutomationDockerFilePreparer(params, buildDir, (String)envDirName);
            case ApplicationConfigurator.DSSNodeType.DESIGN -> this.getDesignDockerFilePreparer(params, buildDir, (String)envDirName);
            default -> throw new Error("unreachable");
        };
        String dockerFileFragment = switch (params.envLang) {
            case CodeEnvModel.EnvLang.PYTHON -> preparer.preparePythonDockerFileFragment(buildDir);
            case CodeEnvModel.EnvLang.R -> preparer.prepareRDockerFileFragment(buildDir);
            default -> throw new UnsupportedOperationException("Unsupported lang " + String.valueOf((Object)params.envLang));
        };
        String uid = DKUApp.getParams().getParam("dku.container.dataiku.uid", "500");
        dockerfile = (String)dockerfile + "\n\n##### ADD CODE ENV " + params.envName + " #####";
        dockerfile = (String)dockerfile + "\nUSER root\nWORKDIR /opt/dataiku\n";
        dockerfile = (String)dockerfile + "\n\n" + dockerFileFragment;
        dockerfile = (String)dockerfile + "\n\nRUN chown -R dataiku:root " + (String)envDirName;
        dockerfile = (String)dockerfile + "\n\nUSER " + uid;
        buildSpec.dockerfile = dockerfile = (String)dockerfile + "\nWORKDIR /home/dataiku\n";
        return buildSpec;
    }

    private ContainerExecDockerFilePreparer getAutomationDockerFilePreparer(AddCodeEnvCodeStudioBlockParams params, File buildDir, String envDirName) throws IOException {
        CodeEnvModel.CodeEnvDeploymentMode mode;
        AutomationNodeCodeEnvsService automationNodeCodeEnvsService = (AutomationNodeCodeEnvsService)SpringUtils.getBean(AutomationNodeCodeEnvsService.class);
        try {
            CodeEnvModel.AutomationEnvRootDef envRootDef = automationNodeCodeEnvsService.getEnvRootDef(params.envLang, params.envName);
            mode = envRootDef.deploymentMode;
        }
        catch (Exception ex) {
            throw new Error(String.format("Failed to get code env details for '%s' (%s): %s", new Object[]{params.envName, params.envLang, ExceptionUtils.getMessageWithCauses((Throwable)ex)}));
        }
        String envVersion = params.versionId;
        File codeEnvFolder = switch (mode) {
            case CodeEnvModel.CodeEnvDeploymentMode.AUTOMATION_VERSIONED -> {
                if ("Latest".equals(envVersion)) {
                    try {
                        CodeEnvModel.AutomationUIEnv<?> uiEnv = automationNodeCodeEnvsService.getEnvForUI(params.envLang, params.envName, false);
                        envVersion = this.getLatestVersionedEnvId(uiEnv);
                    }
                    catch (Exception ex) {
                        throw new Error(String.format("Failed to get code env details for '%s' (%s): %s", new Object[]{params.envName, params.envLang, ExceptionUtils.getMessageWithCauses((Throwable)ex)}));
                    }
                }
                yield AutomationNodeManagedEnvUtils.getEnvVersionDir(params.envLang, params.envName, envVersion);
            }
            case CodeEnvModel.CodeEnvDeploymentMode.AUTOMATION_SINGLE, CodeEnvModel.CodeEnvDeploymentMode.PLUGIN_MANAGED -> AutomationNodeCodeEnvsAccessService.getEnvRootDir(params.envLang, params.envName);
            case CodeEnvModel.CodeEnvDeploymentMode.DSS_INTERNAL, CodeEnvModel.CodeEnvDeploymentMode.EXTERNAL_CONDA_NAMED, CodeEnvModel.CodeEnvDeploymentMode.PLUGIN_NON_MANAGED, CodeEnvModel.CodeEnvDeploymentMode.AUTOMATION_NON_MANAGED_PATH -> throw new UnsupportedOperationException("Unsupported Deployment mode " + String.valueOf((Object)mode));
            default -> throw new Error("unreachable");
        };
        CodeEnvModel.AbstractEnvDesc envDesc = AutomationNodeManagedEnvUtils.getEnvDesc(codeEnvFolder, params.envLang.getDescClazz());
        File codeEnvDescFolder = new File(codeEnvFolder, "desc");
        CodeEnvModel.EnvSpecData<CodeEnvModel.AbstractEnvDesc> envSpecData = automationNodeCodeEnvsService.getEnvSpecData(codeEnvDescFolder, envDesc, params.envLang);
        ContainerExecDockerFilePreparer preparer = new ContainerExecDockerFilePreparer(envDesc, CodeEnvPackageSystems.getCodeEnvSettings(envDesc), envSpecData, params.envName, envVersion, envDirName);
        if (params.envLang == CodeEnvModel.EnvLang.PYTHON) {
            automationNodeCodeEnvsService.copyPythonResources((CodeEnvModel.PythonEnvDesc)envDesc, params.envLang, params.envName, envVersion, preparer, buildDir);
        }
        return preparer;
    }

    private ContainerExecDockerFilePreparer getDesignDockerFilePreparer(AddCodeEnvCodeStudioBlockParams params, File buildDir, String envDirName) throws IOException {
        DesignNodeCodeEnvsService designNodeEnvsService = (DesignNodeCodeEnvsService)SpringUtils.getBean(DesignNodeCodeEnvsService.class);
        CodeEnvModel.AbstractEnvDesc envDesc = designNodeEnvsService.getEnvDesc(params.envLang, params.envName);
        ContainerExecDockerFilePreparer preparer = new ContainerExecDockerFilePreparer(envDesc, CodeEnvPackageSystems.getCodeEnvSettings(envDesc), switch (envDesc.deploymentMode) {
            case CodeEnvModel.CodeEnvDeploymentMode.PLUGIN_MANAGED, CodeEnvModel.CodeEnvDeploymentMode.DESIGN_MANAGED -> designNodeEnvsService.getEnvSpecData(params.envLang, params.envName);
            case CodeEnvModel.CodeEnvDeploymentMode.DSS_INTERNAL, CodeEnvModel.CodeEnvDeploymentMode.EXTERNAL_CONDA_NAMED, CodeEnvModel.CodeEnvDeploymentMode.PLUGIN_NON_MANAGED, CodeEnvModel.CodeEnvDeploymentMode.DESIGN_NON_MANAGED -> throw new UnsupportedOperationException("Unsupported Deployment mode " + String.valueOf((Object)envDesc.deploymentMode));
            default -> throw new Error("unreachable");
        }, params.envName, null, envDirName);
        if (params.envLang == CodeEnvModel.EnvLang.PYTHON) {
            designNodeEnvsService.copyPythonResources((CodeEnvModel.PythonEnvDesc)envDesc, params.envLang, params.envName, preparer, buildDir);
        }
        return preparer;
    }

    private String getLatestVersionedEnvId(CodeEnvModel.AutomationUIEnv<?> uiEnv) {
        if (uiEnv.versions.isEmpty()) {
            throw new IllegalArgumentException("No version defined in code env " + uiEnv.envName);
        }
        return ((CodeEnvModel.AbstractAutomationUIEnvVersion)uiEnv.versions.get((int)(uiEnv.versions.size() - 1))).versionId;
    }

    @Override
    public CodeStudioMeta.CodeStudioLaunchSpec apply(AuthCtx authCtx, CodeStudioBlock block, CodeStudioMeta.CodeStudioLaunchSpec launchSpec, CodeStudioMeta.CodeStudioLaunchEnv launchEnv) {
        return launchSpec;
    }

    @Override
    public CodeStudioMeta.TemplateExportSpec exportBlock(AuthCtx authCtx, CodeStudioBlock block, CodeStudioMeta.TemplateExportSpec exportSpec) {
        AddCodeEnvCodeStudioBlockParams params = block.getParamsAs(AddCodeEnvCodeStudioBlockParams.class);
        CodeEnvModel.UsedCodeEnvRef codeEnv = new CodeEnvModel.UsedCodeEnvRef(params.envLang, params.envName);
        if (!exportSpec.usedCodeEnvRefs.contains(codeEnv)) {
            exportSpec.usedCodeEnvRefs.add(codeEnv);
        }
        return exportSpec;
    }

    @Override
    public CodeStudioBlock importBlock(AuthCtx authCtx, CodeStudioBlock srcBlock, CodeStudioMeta.TemplateExportSpec exportSpec, CodeStudioMeta.TemplateImportSpec importSpec) {
        CodeStudioBlock block = (CodeStudioBlock)JSON.deepCopy((Object)srcBlock);
        AddCodeEnvCodeStudioBlockParams params = block.getParamsAs(AddCodeEnvCodeStudioBlockParams.class);
        ProjectRemappingSettings.CodeEnvRemapping remapping = importSpec.codeEnvs.stream().filter(e -> StringUtils.equals((String)e.source, (String)params.envName)).findFirst().orElse(null);
        if (remapping != null) {
            params.envName = remapping.target;
        }
        return block;
    }

    @Override
    public CodeStudioMeta.CreationSpec apply(AuthCtx authCtx, CodeStudioBlock block, CodeStudioMeta.CreationSpec creationSpec, CodeStudioMeta.CreationEnv creationEnv) throws IOException, DKUSecurityException {
        return creationSpec;
    }

    @Override
    public List<CodeEnvModel.CodeEnvUsage> collectUsages(CodeStudioBlock block, CodeStudioTemplate template) {
        ArrayList usages = Lists.newArrayList();
        AddCodeEnvCodeStudioBlockParams params = block.getParamsAs(AddCodeEnvCodeStudioBlockParams.class);
        if (StringUtils.isNotBlank((String)params.envName)) {
            usages.add(new CodeEnvModel.CodeEnvUsage(params.envLang, params.envName, CodeEnvModel.EnvUsage.CODE_STUDIO_TEMPLATE, "__DKU_ANY_PROJECT__", template.id));
        }
        return usages;
    }

    public static class AddCodeEnvCodeStudioBlockParams
    implements CodeStudioBlockParams {
        public String envName;
        public CodeEnvModel.EnvLang envLang;
        @Nullable
        public String envDir;
        public String versionId = "Latest";

        @Override
        public void checkValid(VariablesContext templateVariablesContext) throws Exception {
            if (this.envLang == null || StringUtils.isBlank((String)this.envName)) {
                throw ErrorContext.ice((String)"A code env must be selected");
            }
        }
    }
}

