/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.codestudio.template;

import com.dataiku.dip.codestudio.CodeStudioRegistry;
import com.dataiku.dip.codestudio.template.CodeStudioTemplateParams;
import com.dataiku.dip.coremodel.VersionTag;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.security.model.PublicUser;
import com.dataiku.dip.utils.JSON;
import com.google.common.collect.Lists;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class CodeStudioTemplate {
    @JSON.FileTransient
    public String id;
    public String type;
    public String label;
    public List<String> tags = Lists.newArrayList();
    public VersionTag versionTag;
    public VersionTag creationTag;
    public String description;
    public String shortDesc;
    public String icon;
    public boolean isEditor;
    public boolean reattachOnRestart;
    public String owner;
    public PermissionItem defaultPermission = new PermissionItem();
    public List<PermissionItem> permissions = new ArrayList<PermissionItem>();
    public String defaultContainerConf;
    public boolean allowContainerConfOverride = true;
    public boolean allContainerConfs = false;
    public List<String> containerConfs = new ArrayList<String>();
    public boolean inheritGlobalCodeEnvsExtraSettings = true;
    public GeneralSettingsDAO.GlobalCodeEnvsExtraSettings codeEnvsExtraSettings = new GeneralSettingsDAO.GlobalCodeEnvsExtraSettings();
    public CodeStudioTemplateParams params;
    private static Logger logger = Logger.getLogger((String)"dip.codestudio.template");

    public CodeStudioTemplate() {
    }

    public CodeStudioTemplate(CodeStudioTemplate other) {
        this.id = other.id;
        this.type = other.type;
        this.label = other.getLabel();
        this.shortDesc = other.shortDesc;
        this.description = other.description;
        this.icon = other.icon;
        this.isEditor = other.isEditor;
        this.reattachOnRestart = other.reattachOnRestart;
        this.owner = other.owner;
        this.tags = Lists.newArrayList(other.tags);
        this.creationTag = (VersionTag)JSON.deepCopy((Object)other.creationTag);
        this.versionTag = (VersionTag)JSON.deepCopy((Object)other.versionTag);
        this.params = (CodeStudioTemplateParams)JSON.deepCopy((Object)other.params);
    }

    public String getLabel() {
        return this.label != null ? this.label : "";
    }

    public <T extends CodeStudioTemplateParams> T getParamsAs(Class<T> clazz) {
        try {
            return (T)(this.params == null ? (CodeStudioTemplateParams)clazz.newInstance() : (CodeStudioTemplateParams)clazz.cast(this.params));
        }
        catch (IllegalAccessException | InstantiationException e) {
            logger.warn((Object)"Unable to create empty params object", (Throwable)e);
            return null;
        }
    }

    public static void registerAdapter() {
        JSON.registerAdapter(CodeStudioTemplate.class, (json, type, ctx) -> {
            JsonElement jsonParams;
            JsonElement jsonCodeEnvsExtraSettings;
            JsonElement jsonInheritGlobalCodeEnvsExtraSettings;
            JsonElement jsonDefaultContainerConf;
            JsonElement jsonAllowContainerConfOverride;
            JsonElement jsonContainerConfs;
            JsonElement jsonAllContainerConfs;
            JsonElement jsonVersionTag;
            JsonElement jsonCreationTag;
            JsonElement jsonTags;
            JsonElement jsonReattachOnRestart;
            JsonElement jsonIsEditor;
            JsonElement jsonIcon;
            JsonElement jsonShortDesc;
            JsonElement jsonDescription;
            JsonElement jsonPermissions;
            JsonElement jsonDefaultPermission;
            JsonElement jsonOwner;
            JsonElement jsonType;
            JsonElement jsonLabel;
            JsonObject jsonObj = json.getAsJsonObject();
            CodeStudioTemplate codeStudioTemplate = new CodeStudioTemplate();
            JsonElement jsonId = jsonObj.get("id");
            if (jsonId != null && !jsonId.isJsonNull()) {
                codeStudioTemplate.id = jsonId.getAsString();
            }
            if ((jsonLabel = jsonObj.get("label")) != null && !jsonLabel.isJsonNull()) {
                codeStudioTemplate.label = jsonLabel.getAsString();
            }
            if ((jsonType = jsonObj.get("type")) != null && !jsonType.isJsonNull()) {
                codeStudioTemplate.type = jsonType.getAsString();
            }
            if ((jsonOwner = jsonObj.get("owner")) != null && !jsonOwner.isJsonNull()) {
                codeStudioTemplate.owner = jsonOwner.getAsString();
            }
            if ((jsonDefaultPermission = jsonObj.get("defaultPermission")) != null && !jsonDefaultPermission.isJsonNull()) {
                codeStudioTemplate.defaultPermission = (PermissionItem)ctx.deserialize(jsonDefaultPermission, PermissionItem.class);
            }
            if ((jsonPermissions = jsonObj.get("permissions")) != null && !jsonPermissions.isJsonNull()) {
                codeStudioTemplate.permissions = (List)ctx.deserialize(jsonPermissions, new TypeToken<List<PermissionItem>>(){}.getType());
            }
            if ((jsonDescription = jsonObj.get("description")) != null && !jsonDescription.isJsonNull()) {
                codeStudioTemplate.description = jsonDescription.getAsString();
            }
            if ((jsonShortDesc = jsonObj.get("shortDesc")) != null && !jsonShortDesc.isJsonNull()) {
                codeStudioTemplate.shortDesc = jsonShortDesc.getAsString();
            }
            if ((jsonIcon = jsonObj.get("icon")) != null && !jsonIcon.isJsonNull()) {
                codeStudioTemplate.icon = jsonIcon.getAsString();
            }
            if ((jsonIsEditor = jsonObj.get("isEditor")) != null && !jsonIsEditor.isJsonNull()) {
                codeStudioTemplate.isEditor = jsonIsEditor.getAsBoolean();
            }
            if ((jsonReattachOnRestart = jsonObj.get("reattachOnRestart")) != null && !jsonReattachOnRestart.isJsonNull()) {
                codeStudioTemplate.reattachOnRestart = jsonReattachOnRestart.getAsBoolean();
            }
            if ((jsonTags = jsonObj.get("tags")) != null && !jsonTags.isJsonNull()) {
                codeStudioTemplate.tags = (List)ctx.deserialize(jsonTags, new TypeToken<List<String>>(){}.getType());
            }
            if ((jsonCreationTag = jsonObj.get("creationTag")) != null && !jsonCreationTag.isJsonNull()) {
                codeStudioTemplate.creationTag = (VersionTag)ctx.deserialize(jsonCreationTag, VersionTag.class);
            }
            if ((jsonVersionTag = jsonObj.get("versionTag")) != null && !jsonVersionTag.isJsonNull()) {
                codeStudioTemplate.versionTag = (VersionTag)ctx.deserialize(jsonVersionTag, VersionTag.class);
            }
            if ((jsonAllContainerConfs = jsonObj.get("allContainerConfs")) != null && !jsonAllContainerConfs.isJsonNull()) {
                codeStudioTemplate.allContainerConfs = jsonAllContainerConfs.getAsBoolean();
            }
            if ((jsonContainerConfs = jsonObj.get("containerConfs")) != null && !jsonContainerConfs.isJsonNull()) {
                codeStudioTemplate.containerConfs = (List)ctx.deserialize(jsonContainerConfs, new TypeToken<List<String>>(){}.getType());
            }
            if ((jsonAllowContainerConfOverride = jsonObj.get("allowContainerConfOverride")) != null && !jsonAllowContainerConfOverride.isJsonNull()) {
                codeStudioTemplate.allowContainerConfOverride = jsonAllowContainerConfOverride.getAsBoolean();
            }
            if ((jsonDefaultContainerConf = jsonObj.get("defaultContainerConf")) != null && !jsonDefaultContainerConf.isJsonNull()) {
                codeStudioTemplate.defaultContainerConf = jsonDefaultContainerConf.getAsString();
            }
            if ((jsonInheritGlobalCodeEnvsExtraSettings = jsonObj.get("inheritGlobalCodeEnvsExtraSettings")) != null && !jsonInheritGlobalCodeEnvsExtraSettings.isJsonNull()) {
                codeStudioTemplate.inheritGlobalCodeEnvsExtraSettings = jsonInheritGlobalCodeEnvsExtraSettings.getAsBoolean();
            }
            if ((jsonCodeEnvsExtraSettings = jsonObj.get("codeEnvsExtraSettings")) != null && !jsonCodeEnvsExtraSettings.isJsonNull()) {
                codeStudioTemplate.codeEnvsExtraSettings = (GeneralSettingsDAO.GlobalCodeEnvsExtraSettings)ctx.deserialize(jsonCodeEnvsExtraSettings, GeneralSettingsDAO.GlobalCodeEnvsExtraSettings.class);
            }
            if ((jsonParams = jsonObj.get("params")) != null && !jsonParams.isJsonNull() && codeStudioTemplate.type != null) {
                if (CodeStudioRegistry.hasMeta(codeStudioTemplate.type)) {
                    codeStudioTemplate.params = (CodeStudioTemplateParams)ctx.deserialize(jsonParams, CodeStudioRegistry.getMeta(codeStudioTemplate.type).templateParamsClass());
                } else {
                    logger.error((Object)("Can't deserialize params for type " + codeStudioTemplate.type));
                }
            }
            return codeStudioTemplate;
        });
    }

    public String makeParamsHash() {
        return DigestUtils.md5Hex((String)(this.params == null ? "" : JSON.json((Object)this.params)));
    }

    public static class PermissionItem {
        public String group;
        public boolean use;
        public boolean update;

        public PermissionItem() {
        }

        public PermissionItem(PermissionItem key) {
            this.group = key.group;
            this.update = key.update;
            this.use = key.use;
        }

        public PermissionItem deepCopy() {
            return new PermissionItem(this);
        }
    }

    public static class FilteredListItems {
        public List<ListItem> items = new ArrayList<ListItem>();
        public int filteredOut;
        public int notAccessible;
    }

    public static class ListItem {
        public String type;
        public final String id;
        public final String label;
        public final String owner;
        public final List<String> tags;
        public String shortDesc;
        public String icon;
        public PublicUser lastModifiedBy;
        public long lastModifiedOn;
        public PublicUser createdBy;
        public long createdOn;
        public CodeStudioTemplateType desc;
        public long lastBuilt;
        public List<String> buildFor = Lists.newArrayList();
        public String defaultConf;

        public ListItem(CodeStudioTemplate object) {
            this.type = object.type;
            this.id = object.id;
            this.owner = object.owner;
            this.label = StringUtils.defaultIfBlank((String)object.getLabel(), (String)"Untitled");
            this.tags = object.tags;
            this.shortDesc = object.shortDesc;
            this.icon = object.icon;
        }
    }

    public static class CodeStudioTemplateType {
        public String type;
        public String label;
        public String description;
    }
}

