/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.connections;

import com.dataiku.dip.connections.AzureConnection;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.services.ConnectionsTestService;

public class AzureMLConnection
extends AzureConnection {
    public static final String OAUTH_USER_IMPERSONATION_PER_USER_SCOPE = "https://management.azure.com/user_impersonation offline_access";
    public static final String DEFAULT_OAUTH_SCOPE = "https://management.azure.com/.default";
    public static final String AZURE_ML_CONNECTION_TYPE = "AzureML";

    public AzureMLConnection() {
        this.allowWrite = false;
        this.allowManagedDatasets = false;
        this.allowManagedFolders = false;
    }

    @Override
    public String getType() {
        return AZURE_ML_CONNECTION_TYPE;
    }

    @Override
    public String getDefaultAuthScope() {
        return DEFAULT_OAUTH_SCOPE;
    }

    @Override
    public String getDefaultAuthUserImpersonationScope() {
        return OAUTH_USER_IMPERSONATION_PER_USER_SCOPE;
    }

    @Override
    public boolean isADataStoringConnection() {
        return false;
    }

    @Override
    public ConnectionsTestService.ConnectionTestResult testConnection(AuthCtx authCtx, ConnectionsTestService connectionsTestService) throws Exception {
        return connectionsTestService.testAzureML_NT(authCtx, this);
    }
}

