/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.connections;

import com.dataiku.dip.CodedRuntimeException;
import com.dataiku.dip.DSSTempUtils;
import com.dataiku.dip.connections.GoogleCredentialsBuilder;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.server.connections.ConnectionCodes;
import com.dataiku.dip.util.HTTPClientUtils;
import com.dataiku.dip.utils.PerfUtils;
import com.dataiku.dss.shadelib.com.google.common.base.Objects;
import com.dataiku.dss.shadelib.com.google.common.cache.Cache;
import com.dataiku.dss.shadelib.com.google.common.cache.CacheBuilder;
import com.dataiku.dss.shadelib.com.google.common.io.FileWriteMode;
import com.dataiku.dss.shadelib.com.google.common.io.Files;
import com.dataiku.dss.shadelib.org.apache.http.HttpEntity;
import com.dataiku.dss.shadelib.org.apache.http.HttpResponse;
import com.dataiku.dss.shadelib.org.apache.http.client.methods.CloseableHttpResponse;
import com.dataiku.dss.shadelib.org.apache.http.client.methods.HttpGet;
import com.dataiku.dss.shadelib.org.apache.http.client.methods.HttpUriRequest;
import com.dataiku.dss.shadelib.org.apache.http.impl.client.DefaultHttpClient;
import com.dataiku.dss.shadelib.org.apache.http.util.EntityUtils;
import com.dataiku.dss.shadelibgcp.com.google.api.client.auth.oauth2.TokenResponse;
import com.dataiku.dss.shadelibgcp.com.google.api.client.googleapis.auth.oauth2.GoogleCredential;
import com.dataiku.dss.shadelibgcp.com.google.api.client.googleapis.auth.oauth2.OAuth2Utils;
import com.dataiku.dss.shadelibgcp.com.google.api.client.http.HttpTransport;
import com.dataiku.dss.shadelibgcp.com.google.auth.oauth2.AccessToken;
import com.dataiku.dss.shadelibgcp.com.google.auth.oauth2.GoogleCredentials;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Date;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;

public class GoogleCredentialCache {
    private static final Cache<PrivateKey, PrivateKeyInfo> cachedKeys = CacheBuilder.newBuilder().maximumSize(50L).build();
    @VisibleForTesting
    static GoogleCredentialsBuilder credentialsBuilder = new GoogleCredentialsBuilder();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RawTokenResponse getTokenFromMetadataServer() throws IOException {
        DefaultHttpClient client = new DefaultHttpClient();
        client.addRequestInterceptor(PerfUtils.MARK_HTTP_REQUEST_INTERCEPTOR);
        try {
            RawTokenResponse rawTokenResponse;
            HttpGet get = new HttpGet(OAuth2Utils.getMetadataServerUrl() + "/computeMetadata/v1/instance/service-accounts/default/token");
            get.setHeader("Metadata-Flavor", "Google");
            CloseableHttpResponse resp = client.execute((HttpUriRequest)get);
            try {
                rawTokenResponse = (RawTokenResponse)HTTPClientUtils.handleJSONResp((HttpResponse)resp, RawTokenResponse.class, HTTPClientUtils::handleAPIError);
            }
            catch (Throwable throwable) {
                EntityUtils.consume((HttpEntity)resp.getEntity());
                throw throwable;
            }
            EntityUtils.consume((HttpEntity)resp.getEntity());
            return rawTokenResponse;
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    public static PrivateKeyInfo getPrivateKey(String keyPath, String serviceAccountEmail, boolean useADC) {
        PrivateKey key = new PrivateKey(keyPath, serviceAccountEmail, useADC);
        PrivateKeyInfoBuilder keyInfoBuilder = new PrivateKeyInfoBuilder(key);
        try {
            PrivateKeyInfo privateKeyInfo = (PrivateKeyInfo)cachedKeys.get((Object)key, (Callable)keyInfoBuilder);
            if (!privateKeyInfo.isValid()) {
                cachedKeys.invalidate((Object)key);
                privateKeyInfo = (PrivateKeyInfo)cachedKeys.get((Object)key, (Callable)keyInfoBuilder);
            }
            return privateKeyInfo;
        }
        catch (ExecutionException e) {
            return keyInfoBuilder.call();
        }
    }

    private GoogleCredentialCache() {
    }

    public static class RawTokenResponse {
        public String access_token;
        public String refresh_token;
        public long expires_in;
        public String token_type;

        public TokenResponse toTokenResponse() {
            return new TokenResponse().setAccessToken(this.access_token).setRefreshToken(this.refresh_token).setTokenType(this.token_type).setExpiresInSeconds(Long.valueOf(this.expires_in));
        }

        public AccessToken toAccessToken() {
            long expiresAtMilliseconds = System.currentTimeMillis() + this.expires_in * 1000L;
            return new AccessToken(this.access_token, new Date(expiresAtMilliseconds));
        }
    }

    private static class PrivateKey {
        public final String keyPath;
        public final String serviceAccountEmail;
        private final boolean useADC;

        public PrivateKey(String keyPath, String serviceAccountEmail, boolean useADC) {
            this.keyPath = keyPath;
            this.serviceAccountEmail = serviceAccountEmail;
            this.useADC = useADC;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PrivateKey that = (PrivateKey)o;
            return Objects.equal((Object)this.keyPath, (Object)that.keyPath) && Objects.equal((Object)this.serviceAccountEmail, (Object)that.serviceAccountEmail) && Objects.equal((Object)this.useADC, (Object)that.useADC);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.keyPath, this.serviceAccountEmail, this.useADC});
        }
    }

    private static class PrivateKeyInfoBuilder
    implements Callable<PrivateKeyInfo> {
        private final PrivateKey privateKey;

        private PrivateKeyInfoBuilder(PrivateKey privateKey) {
            this.privateKey = privateKey;
        }

        @Override
        public PrivateKeyInfo call() {
            return new PrivateKeyInfo(this.privateKey.keyPath, this.privateKey.serviceAccountEmail, this.privateKey.useADC);
        }
    }

    public static class PrivateKeyInfo {
        public final String paramsKeyPath;
        public final String paramsServiceAccountEmail;
        public final boolean useADC;
        private Long keyFileLastModified;
        private String keyFilePath;
        private GoogleCredential credential;
        private GoogleCredentials credentials;

        public PrivateKeyInfo(String paramsKeyPath, String paramsServiceAccountEmail, boolean useADC) {
            this.paramsKeyPath = paramsKeyPath;
            this.paramsServiceAccountEmail = paramsServiceAccountEmail;
            this.useADC = useADC;
        }

        public synchronized GoogleCredential getCredential(HttpTransport httpTransport) {
            if (this.credential == null) {
                this.credential = credentialsBuilder.buildOldGoogleCredential(httpTransport, this.paramsKeyPath, this.paramsServiceAccountEmail, this.useADC);
            }
            return this.credential;
        }

        public synchronized GoogleCredentials getCredentials(HttpTransport httpTransport) {
            if (this.credentials == null) {
                this.credentials = credentialsBuilder.buildNewGoogleCredentials(httpTransport, this.paramsKeyPath, this.paramsServiceAccountEmail, this.useADC);
            }
            return this.credentials;
        }

        public synchronized String getKeyFile() {
            if (this.keyFileLastModified == null) {
                this.initializeKeyFile();
            }
            return this.keyFilePath;
        }

        @VisibleForTesting
        synchronized long getKeyFileLastModified() {
            if (this.keyFileLastModified == null) {
                this.initializeKeyFile();
            }
            return this.keyFileLastModified;
        }

        @VisibleForTesting
        boolean isValid() {
            return this.keyFilePath == null || PrivateKeyInfo.lastModified(new File(this.keyFilePath)) == this.keyFileLastModified;
        }

        private void initializeKeyFile() {
            if (this.useADC) {
                this.keyFilePath = null;
                this.keyFileLastModified = 0L;
            } else if (GoogleCredentialsBuilder.isJson(this.paramsKeyPath)) {
                File keyFile = PrivateKeyInfo.getAsFile(this.paramsKeyPath);
                this.keyFilePath = keyFile.getAbsolutePath();
                this.keyFileLastModified = PrivateKeyInfo.lastModified(keyFile);
            } else {
                this.keyFilePath = this.paramsKeyPath;
                File keyFile = new File(this.keyFilePath);
                this.keyFileLastModified = PrivateKeyInfo.lastModified(keyFile);
            }
        }

        private static File getAsFile(String keyPath) {
            File tempFile;
            try {
                String uniqueId = UUID.randomUUID().toString().replaceAll("-", "");
                tempFile = DSSTempUtils.getTempFileWithSpecificName((String)"gcloud", (String)uniqueId, (String)"json");
                tempFile.deleteOnExit();
                Files.asCharSink((File)tempFile, (Charset)Charsets.UTF_8, (FileWriteMode[])new FileWriteMode[0]).write((CharSequence)keyPath);
            }
            catch (IOException e) {
                throw new CodedRuntimeException((InfoMessage.MessageCode)ConnectionCodes.ERR_CONNECTION_INVALID_CONFIG, "Unable to store the secret key onto disk to pass it to the BigQuery JDBC driver.", (Throwable)e);
            }
            return tempFile;
        }

        private static long lastModified(File keyFile) {
            return keyFile.exists() ? keyFile.lastModified() : 0L;
        }
    }
}

