/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.containers.exec;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.analysis.model.MLTask;
import com.dataiku.dip.cluster.ClusterSelector;
import com.dataiku.dip.cluster.ContainerSettings;
import com.dataiku.dip.containers.exec.ContainerExecRuntimeConfig;
import com.dataiku.dip.containers.exec.ContainerExecSelection;
import com.dataiku.dip.containers.exec.WorkloadType;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.recipes.common.RecipeEngineStatus;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.controllers.NotFoundException;
import com.dataiku.dip.server.services.ProjectsDAO;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.StringUtils;
import java.io.IOException;
import javax.annotation.Nullable;

public class ContainerExecConfigSelector {
    private final ProjectsDAO projectsDAO = (ProjectsDAO)SpringUtils.getBean(ProjectsDAO.class);
    private final GeneralSettingsDAO gsDAO = (GeneralSettingsDAO)SpringUtils.getBean(GeneralSettingsDAO.class);

    public ContainerExecRuntimeConfig selectForML_autoTXN(AuthCtx authCtx, String projectKey, ContainerExecSelection local, MLTask.BackendType backendType) throws IOException, DKUSecurityException {
        if (backendType == null || backendType.isPythonBased()) {
            return this.select_autoTXN(authCtx, projectKey, local);
        }
        return null;
    }

    public String getProjectEnvDefault_autoTXN(String projectKey, WorkloadType workloadType) throws IOException {
        ContainerExecSelection local = new ContainerExecSelection();
        local.containerMode = ContainerExecSelection.ContainerExecMode.INHERIT;
        return this.selectName_autoTXN(projectKey, local, workloadType);
    }

    public ContainerExecRuntimeConfig selectForRecipeStatus_autoTXN(AuthCtx authCtx, String projectKey, ContainerExecSelection local, RecipeEngineStatus engineStatus) throws IOException, DKUSecurityException {
        if (!(engineStatus == null || "DSS".equals(engineStatus.type) && "MEMORY".equals(engineStatus.variant))) {
            return null;
        }
        return this.select_autoTXN(authCtx, projectKey, local);
    }

    public String selectNameForCodeStudio_autoTXN(AuthCtx authCtx, String projectKey, String templateConf, boolean canOverride) throws IOException {
        String selected = null;
        if (org.apache.commons.lang.StringUtils.isNotBlank((String)templateConf) && !canOverride) {
            selected = templateConf;
        } else {
            ContainerExecSelection project = this.getProjectContainerSelection_autoTXN(projectKey, WorkloadType.USER_CODE);
            switch (project.containerMode) {
                case NONE: 
                case INHERIT: {
                    selected = org.apache.commons.lang.StringUtils.defaultIfBlank((String)templateConf, (String)this.gsDAO.getUnsafeAutoTXN().containerSettings.defaultExecutionConfig);
                    break;
                }
                case EXPLICIT_CONTAINER: {
                    selected = project.containerConf;
                }
            }
        }
        return selected;
    }

    public ContainerExecRuntimeConfig selectForCodeStudio_autoTXN(AuthCtx authCtx, String projectKey, String templateConf, boolean canOverride) throws IOException, DKUSecurityException {
        ContainerExecRuntimeConfig ret;
        String selected = this.selectNameForCodeStudio_autoTXN(authCtx, projectKey, templateConf, canOverride);
        ContainerExecRuntimeConfig containerExecRuntimeConfig = ret = org.apache.commons.lang.StringUtils.isBlank((String)selected) ? null : this.getByName_autoTXN(authCtx, projectKey, selected);
        if (ret != null) {
            ((DSSAuthCtx)authCtx).failIfCantUseContainerConf(ret);
        }
        if (ret != null && !ret.supportsWorkloadType(WorkloadType.USER_CODE)) {
            throw new ContainerConfigurationWorkloadTypeException(ret.name, WorkloadType.USER_CODE);
        }
        return ret;
    }

    public String selectName_autoTXN(@Nullable String projectKey, ContainerExecSelection local, WorkloadType workloadType) throws IOException {
        if (local == null) {
            local = new ContainerExecSelection();
        }
        String selected = null;
        switch (local.containerMode) {
            case NONE: {
                selected = null;
                break;
            }
            case EXPLICIT_CONTAINER: {
                selected = local.containerConf;
                break;
            }
            case INHERIT: {
                if (org.apache.commons.lang.StringUtils.isNotBlank((String)projectKey)) {
                    ContainerExecSelection project = this.getProjectContainerSelection_autoTXN(projectKey, workloadType);
                    switch (project.containerMode) {
                        case INHERIT: {
                            selected = this.getGlobalDefaultConfigName(workloadType);
                            break;
                        }
                        case NONE: {
                            selected = null;
                            break;
                        }
                        case EXPLICIT_CONTAINER: {
                            selected = project.containerConf;
                        }
                    }
                    break;
                }
                selected = this.getGlobalDefaultConfigName(workloadType);
            }
        }
        return selected;
    }

    @Nullable
    private String getGlobalDefaultConfigName(WorkloadType workloadType) throws IOException {
        ContainerSettings containerSettings = this.gsDAO.getUnsafeAutoTXN().containerSettings;
        String defaultConf = workloadType == WorkloadType.VISUAL_RECIPES ? containerSettings.defaultExecutionConfigForVisualRecipesWorkloads : containerSettings.defaultExecutionConfig;
        String ret = StringUtils.nullIfBlank((String)defaultConf);
        return ret;
    }

    public ContainerExecRuntimeConfig select_autoTXN(AuthCtx authCtx, String projectKey, ContainerExecSelection local) throws IOException, DKUSecurityException {
        return this.select_autoTXN(authCtx, projectKey, local, WorkloadType.USER_CODE);
    }

    public ContainerExecRuntimeConfig select_autoTXN_visualRecipesWorkloads(AuthCtx authCtx, String projectKey, ContainerExecSelection local) throws IOException, DKUSecurityException {
        if (!ApplicationConfigurator.getGeneralSettingsUnsafeAutoTXN().containerSettings.cdeEnabled) {
            return null;
        }
        return this.select_autoTXN(authCtx, projectKey, local, WorkloadType.VISUAL_RECIPES);
    }

    private ContainerExecRuntimeConfig select_autoTXN(AuthCtx authCtx, String projectKey, ContainerExecSelection local, WorkloadType workloadType) throws IOException, DKUSecurityException {
        ContainerExecRuntimeConfig ret;
        assert (workloadType != null);
        String selected = this.selectName_autoTXN(projectKey, local, workloadType);
        ContainerExecRuntimeConfig containerExecRuntimeConfig = ret = selected == null ? null : this.getByName_autoTXN(authCtx, projectKey, selected);
        if (ret != null) {
            ((DSSAuthCtx)authCtx).failIfCantUseContainerConf(ret);
        }
        if (ret != null && !ret.supportsWorkloadType(workloadType)) {
            throw new ContainerConfigurationWorkloadTypeException(ret.name, workloadType);
        }
        return ret;
    }

    public String selectConfName_autoTXN(AuthCtx authCtx, String projectKey, ContainerExecSelection local) throws IOException, DKUSecurityException {
        ContainerExecRuntimeConfig config = this.select_autoTXN(authCtx, projectKey, local);
        if (config == null) {
            return null;
        }
        return config.name;
    }

    private ContainerExecRuntimeConfig getByName_autoTXN(AuthCtx authCtx, String projectKey, String name) throws IOException, DKUSecurityException {
        if (name == null) {
            throw new NotFoundException("Container configuration was requested but none was specified");
        }
        return new ClusterSelector().selectForProject(authCtx, projectKey).getContainerSettings().getByName(name);
    }

    private ContainerExecSelection getProjectContainerSelection_autoTXN(String projectKey, WorkloadType workloadType) throws IOException {
        try (Transaction t = ((TransactionService)SpringUtils.getBean(TransactionService.class)).retrieveOrBeginRead();){
            ContainerExecSelection containerExecSelection = workloadType == WorkloadType.VISUAL_RECIPES ? this.projectsDAO.getMandatory((String)projectKey).settings.containerForVisualRecipesWorkloads : this.projectsDAO.getMandatory((String)projectKey).settings.container;
            return containerExecSelection;
        }
    }

    public static class ContainerConfigurationWorkloadTypeException
    extends DKUSecurityException {
        public ContainerConfigurationWorkloadTypeException(String name, WorkloadType workloadType) {
            super("Cannot use config " + name + " for " + String.valueOf((Object)workloadType) + " workloads");
        }
    }
}

