/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.coremodel;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class ConditionalOutput
implements Serializable {
    private static final long serialVersionUID = 1L;
    public String name;
    public String defaultOutput;
    public List<Rule> rules = new ArrayList<Rule>();
    public String input;

    public String apply(double input) {
        for (Rule r : this.rules) {
            if (!r.operation.matches(input, r.operand)) continue;
            return r.output;
        }
        return this.defaultOutput;
    }

    public boolean equals(Object o) {
        return o != null && o instanceof ConditionalOutput && ((ConditionalOutput)o).name.equals(this.name);
    }

    public int hashCode() {
        return this.name == null ? 0 : this.name.hashCode();
    }

    public static class Rule
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public ComparisonOperation operation;
        public double operand;
        public String output;
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum ComparisonOperation implements Serializable
    {
        LT{

            @Override
            public boolean matches(double input, double operand) {
                return input < operand;
            }
        }
        ,
        LE{

            @Override
            public boolean matches(double input, double operand) {
                return input <= operand;
            }
        }
        ,
        GT{

            @Override
            public boolean matches(double input, double operand) {
                return input > operand;
            }
        }
        ,
        GE{

            @Override
            public boolean matches(double input, double operand) {
                return input >= operand;
            }
        };


        public abstract boolean matches(double var1, double var3);
    }
}

