/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datadirectories;

import com.dataiku.dip.datadirectories.DataDirectoriesFootprintHierarchy;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.NotImplementedException;
import com.dataiku.dip.utils.PathUtils;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import org.apache.commons.lang.StringUtils;

public class DataDirectoriesFootprintListingWalker
implements DataDirectoriesFootprintHierarchy.Walker {
    private static Pattern LINE_FORMAT = Pattern.compile("^\\s*[^\\s]+\\s+[^\\s]+\\s+([^\\s]+)\\s+[^\\s]+\\s+([^\\s]+)\\s+[^\\s]+\\s+([^\\s]+)\\s+([^\\s]+\\s+[^\\s]+\\s+[^\\s]+)\\s+(.*)$");
    private static Pattern PERMISSIONDENIED_FORMAT = Pattern.compile("^find: .(.*).: Permission denied$");
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.directories-footprint.fake-walker");
    private final File listing;
    private final String textual;
    private final String datadirRoot;
    private final String actualDatadirRoot;

    public DataDirectoriesFootprintListingWalker(File listing, String datadirRoot, String actualDatadirRoot) {
        this.listing = listing;
        this.textual = null;
        this.datadirRoot = datadirRoot;
        this.actualDatadirRoot = actualDatadirRoot;
    }

    public DataDirectoriesFootprintListingWalker(String textual, String datadirRoot, String actualDatadirRoot) {
        this.listing = null;
        this.textual = textual;
        this.datadirRoot = datadirRoot;
        this.actualDatadirRoot = actualDatadirRoot;
    }

    private InputStream openListing() throws IOException {
        if (this.textual != null) {
            return new ByteArrayInputStream(this.textual.getBytes(StandardCharsets.UTF_8));
        }
        if (this.listing.getName().endsWith(".gz")) {
            return new GZIPInputStream(new FileInputStream(this.listing));
        }
        if (this.listing.getName().endsWith(".txt")) {
            return new FileInputStream(this.listing);
        }
        throw new IOException("Unexpected listing name " + this.listing.getName() + ". Must be .txt or .gz");
    }

    @Override
    public void walk(Path startingPoint, FileVisitor<Path> dog) {
        String datadirRootLNT = PathUtils.makeLeadingNoTrailing((String)this.datadirRoot);
        String realDatadirRoot = PathUtils.makeLeadingNoTrailing((String)this.actualDatadirRoot);
        String startingPointLNT = PathUtils.makeLeadingNoTrailing((String)startingPoint.toString());
        String lastName = null;
        Boolean lastIsFolder = null;
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(this.openListing()));){
            WalkState state = new WalkState();
            String line = reader.readLine();
            while (line != null) {
                if (!StringUtils.isBlank((String)line) && !line.startsWith(">")) {
                    Matcher matcher = LINE_FORMAT.matcher(line);
                    Matcher errMatcher = PERMISSIONDENIED_FORMAT.matcher(line);
                    if (matcher.matches()) {
                        String perms = matcher.group(1);
                        String user = matcher.group(2);
                        String size = matcher.group(3);
                        String name = matcher.group(5);
                        if (!name.startsWith(datadirRootLNT)) {
                            logger.warn((Object)("Line outside datadir root: " + line));
                        } else {
                            try {
                                long sizeB = Long.parseLong(size);
                                boolean isFolder = perms.startsWith("d");
                                lastName = name;
                                lastIsFolder = isFolder;
                                String fakeName = realDatadirRoot + name.substring(datadirRootLNT.length());
                                if (fakeName.startsWith(startingPointLNT)) {
                                    this.handle(dog, state, fakeName, sizeB, isFolder, false);
                                }
                            }
                            catch (Exception e) {
                                logger.warn((Object)("Broken listing line: " + line), (Throwable)e);
                            }
                        }
                    } else if (errMatcher.matches()) {
                        String name = errMatcher.group(1);
                        if (!name.startsWith(datadirRootLNT)) {
                            logger.warn((Object)("Line outside datadir root: " + line));
                        } else {
                            try {
                                boolean isFolder = name.endsWith("/") || name.equals(lastName) && lastIsFolder != false;
                                String fakeName = PathUtils.makeLeadingNoTrailing((String)(realDatadirRoot + name.substring(datadirRootLNT.length())));
                                if (fakeName.startsWith(startingPointLNT)) {
                                    this.handle(dog, state, fakeName, 0L, isFolder, true);
                                }
                            }
                            catch (Exception e) {
                                logger.warn((Object)("Broken listing line: " + line), (Throwable)e);
                            }
                        }
                    } else {
                        logger.warn((Object)("Unable to tokenize: " + line));
                    }
                }
                line = reader.readLine();
            }
            while (!state.current.empty()) {
                Path popped;
                Path top = state.current.peek();
                if (state.skip == null) {
                    dog.postVisitDirectory(top, null);
                }
                if ((popped = state.current.pop()) != state.skip) continue;
                state.skip = null;
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to iterate the listing", e);
        }
    }

    private void handle(FileVisitor<Path> dog, WalkState state, String fakeName, long sizeB, boolean isFolder, boolean hasError) throws IOException {
        Path top;
        Path fakePath = new File(fakeName).toPath();
        FakeAttributes fakeAttrs = new FakeAttributes(sizeB, isFolder);
        while (!state.current.empty() && !fakePath.startsWith(top = state.current.peek())) {
            Path popped;
            if (state.skip == null) {
                dog.postVisitDirectory(top, null);
            }
            if ((popped = state.current.pop()) != state.skip) continue;
            state.skip = null;
        }
        if (state.skip != null && fakePath.startsWith(state.skip)) {
            return;
        }
        if (isFolder) {
            FileVisitResult action = dog.preVisitDirectory(fakePath, fakeAttrs);
            if (action == FileVisitResult.SKIP_SUBTREE) {
                state.skip = fakePath;
            }
            state.current.push(fakePath);
        } else if (hasError) {
            dog.visitFileFailed(fakePath, new IOException("there was an error"));
        } else {
            dog.visitFile(fakePath, fakeAttrs);
        }
    }

    private class WalkState {
        Stack<Path> current = new Stack();
        Path skip = null;

        private WalkState() {
        }
    }

    private class FakeAttributes
    implements BasicFileAttributes {
        private final long size;
        private final boolean isFolder;

        FakeAttributes(long size, boolean isFolder) {
            this.size = size;
            this.isFolder = isFolder;
        }

        @Override
        public FileTime lastModifiedTime() {
            throw new NotImplementedException();
        }

        @Override
        public FileTime lastAccessTime() {
            throw new NotImplementedException();
        }

        @Override
        public FileTime creationTime() {
            throw new NotImplementedException();
        }

        @Override
        public boolean isRegularFile() {
            return !this.isFolder;
        }

        @Override
        public boolean isDirectory() {
            return this.isFolder;
        }

        @Override
        public boolean isSymbolicLink() {
            return false;
        }

        @Override
        public boolean isOther() {
            return false;
        }

        @Override
        public long size() {
            return this.isFolder ? 0L : this.size;
        }

        @Override
        public Object fileKey() {
            throw new NotImplementedException();
        }
    }
}

