/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow;

import com.dataiku.dip.DSSMetrics;
import com.dataiku.dip.SmartObjectRef;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.coremodel.Zone;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dao.RecipesDAO;
import com.dataiku.dip.dao.ZonesDAO;
import com.dataiku.dip.dataflow.FlowGraph;
import com.dataiku.dip.dataflow.FlowZone;
import com.dataiku.dip.dataflow.ProjectFlowGraph;
import com.dataiku.dip.dataflow.graph.FlowComputable;
import com.dataiku.dip.dataflow.graph.FlowDataset;
import com.dataiku.dip.dataflow.graph.FlowImplicitRecipe;
import com.dataiku.dip.dataflow.graph.FlowManagedFolder;
import com.dataiku.dip.dataflow.graph.FlowModelEvaluationStore;
import com.dataiku.dip.dataflow.graph.FlowRecipe;
import com.dataiku.dip.dataflow.graph.FlowRunnable;
import com.dataiku.dip.dataflow.graph.FlowSavedModel;
import com.dataiku.dip.dataflow.graph.FlowStreamingEndpoint;
import com.dataiku.dip.dataflow.graph.FlowZoneNode;
import com.dataiku.dip.dataflow.graph.GraphNode;
import com.dataiku.dip.labeling.LabelingTask;
import com.dataiku.dip.labeling.LabelingTasksDAO;
import com.dataiku.dip.partitioning.PartitioningScheme;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dss.shadelib.com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FlowGraphService {
    @Autowired
    private DatasetsDAO datasetsDAO;
    @Autowired
    private ZonesDAO zonesDAO;
    private final Map<String, CacheValue<ProjectFlowGraph>> projectCachesSafe = new HashMap<String, CacheValue<ProjectFlowGraph>>();
    private final Map<String, CacheValue<ProjectFlowGraph>> projectCachesUnsafe = new HashMap<String, CacheValue<ProjectFlowGraph>>();
    private CacheValue<FlowGraph> globalCacheSafe;
    private CacheValue<FlowGraph> globalCacheUnsafe;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.flow");

    public synchronized void invalidateCache() {
        logger.info((Object)"Invalidate Flow memory cache");
        this.globalCacheSafe = null;
        this.globalCacheUnsafe = null;
        this.projectCachesSafe.clear();
        this.projectCachesUnsafe.clear();
    }

    public synchronized void invalidateCache(String projectKey) {
        logger.info((Object)("Invalidate Flow memory cache for " + projectKey));
        this.projectCachesSafe.remove(this.buildCacheKey(projectKey, true));
        this.projectCachesSafe.remove(this.buildCacheKey(projectKey, false));
        this.projectCachesUnsafe.remove(this.buildCacheKey(projectKey, true));
        this.projectCachesUnsafe.remove(this.buildCacheKey(projectKey, false));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FlowGraph getGlobalGraph(boolean iKnowIShouldGenerallyNotBeCallingThisMethodBecauseItIsSlowAndIHaveDiscussedIt) throws IOException {
        if (!iKnowIShouldGenerallyNotBeCallingThisMethodBecauseItIsSlowAndIHaveDiscussedIt) {
            throw new Error("you know nothing");
        }
        try (DSSMetrics.TimeCtx timeCtx = DSSMetrics.timeCtx((String)"dku.services.flowGraph.getGlobal");){
            FlowGraphService flowGraphService = this;
            synchronized (flowGraphService) {
                block21: {
                    if (this.globalCacheSafe == null || this.globalCacheSafe.graph == null) break block21;
                    DSSMetrics.registry().meter("dku.services.flowGraph.getGlobal.cacheHit").mark();
                    Object g = this.globalCacheSafe.graph;
                    return g;
                }
                CacheValue cacheValue = new CacheValue();
                this.globalCacheSafe = cacheValue;
            }
            DSSMetrics.registry().meter("dku.services.flowGraph.getGlobal.cacheMiss").mark();
            FlowGraph graph = this.newFlowGraph();
            try (DSSMetrics.TimeCtx timeCtx2 = DSSMetrics.timeCtx((String)"dku.services.flowGraph.getGlobal.compute");){
                graph.buildGlobal();
            }
            Object object = this;
            synchronized (object) {
                cacheValue.graph = graph;
            }
            object = graph;
            return object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FlowGraph getGlobalGraphUnsafe(boolean iKnowIShouldGenerallyNotBeCallingThisMethodBecauseItIsSlowAndIHaveDiscussedIt) throws IOException {
        if (!iKnowIShouldGenerallyNotBeCallingThisMethodBecauseItIsSlowAndIHaveDiscussedIt) {
            throw new Error("you know nothing");
        }
        try (DSSMetrics.TimeCtx timeCtx = DSSMetrics.timeCtx((String)"dku.services.flowGraph.getGlobalUnsafe");){
            FlowGraphService flowGraphService = this;
            synchronized (flowGraphService) {
                block21: {
                    if (this.globalCacheUnsafe == null || this.globalCacheUnsafe.graph == null) break block21;
                    DSSMetrics.registry().meter("dku.services.flowGraph.getGlobalUnsafe.cacheHit").mark();
                    Object g = this.globalCacheUnsafe.graph;
                    return g;
                }
                CacheValue cacheValue = new CacheValue();
                this.globalCacheUnsafe = cacheValue;
            }
            DSSMetrics.registry().meter("dku.services.flowGraph.getGlobalUnsafe.cacheMiss").mark();
            FlowGraph graph = this.newFlowGraph();
            try (DSSMetrics.TimeCtx timeCtx2 = DSSMetrics.timeCtx((String)"dku.services.flowGraph.getGlobalUnsafe.compute");){
                graph.buildGlobalUnsafe();
            }
            Object object = this;
            synchronized (object) {
                cacheValue.graph = graph;
            }
            object = graph;
            return object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public ProjectFlowGraph getProjectGraph(String projectKey, boolean drawZones) throws IOException {
        timeCtx = DSSMetrics.timeCtx((String)"dku.services.flowGraph.getProject");
        try {
            block36: {
                block34: {
                    timeCtx2 = DSSMetrics.timeCtx((String)("dku.services.flowGraph.getProject." + projectKey));
                    cacheKey = this.buildCacheKey(projectKey, drawZones);
                    var7_9 = this;
                    synchronized (var7_9) {
                        cacheValue = this.projectCachesSafe.computeIfAbsent(cacheKey, (Function<String, CacheValue>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$getProjectGraph$0(java.lang.String ), (Ljava/lang/String;)Lcom/dataiku/dip/dataflow/FlowGraphService$CacheValue;)());
                        if (cacheValue.graph == null) ** break block33
                        DSSMetrics.registry().meter("dku.services.flowGraph.getProject.cacheHit").mark();
                        DSSMetrics.registry().meter("dku.services.flowGraph.getProject." + projectKey + ".cacheHit").mark();
                        var8_12 = (ProjectFlowGraph)cacheValue.graph;
                        // MONITOREXIT @DISABLED, blocks:[0, 1, 2, 14] lbl14 : MonitorExitStatement: MONITOREXIT : var7_9
                        if (timeCtx2 == null) break block34;
                    }
                    timeCtx2.close();
                }
                return var8_12;
                {
                    // MONITOREXIT @DISABLED, blocks:[0, 4, 5, 14] lbl20 : MonitorExitStatement: MONITOREXIT : var7_9
                    {
                        catch (Throwable var9_14) {
                            throw var9_14;
                        }
                    }
                    FlowGraphService.logger.info((Object)("Computing flow graph for " + projectKey));
                    DSSMetrics.registry().meter("dku.services.flowGraph.getProject.cacheMiss").mark();
                    DSSMetrics.registry().meter("dku.services.flowGraph.getProject." + projectKey + ".cacheMiss").mark();
                    graph = this.newProjectFlowGraph();
                    timeCtx3 = DSSMetrics.timeCtx((String)"dku.services.flowGraph.getProject.compute");
                    try {
                        timeCtx4 = DSSMetrics.timeCtx((String)("dku.services.flowGraph.getProject." + projectKey + ".compute"));
                        try {
                            graph.buildForProject(projectKey, false, drawZones);
                        }
                        finally {
                            if (timeCtx4 != null) {
                                timeCtx4.close();
                            }
                        }
                    }
                    finally {
                        if (timeCtx3 != null) {
                            timeCtx3.close();
                        }
                    }
                    var8_13 = this;
                    synchronized (var8_13) {
                        cacheValue.graph = graph;
                    }
                    var8_13 = graph;
                    if (timeCtx2 == null) break block36;
                }
                timeCtx2.close();
            }
            return var8_13;
            {
                catch (Throwable var5_7) {
                    if (timeCtx2 != null) {
                        try {
                            timeCtx2.close();
                        }
                        catch (Throwable var6_11) {
                            var5_7.addSuppressed(var6_11);
                        }
                    }
                    throw var5_7;
                }
            }
        }
        finally {
            if (timeCtx != null) {
                timeCtx.close();
            }
        }
    }

    public ProjectFlowGraph getProjectGraphUnsafe(String projectKey) throws IOException {
        return this.getProjectGraphUnsafe(projectKey, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public ProjectFlowGraph getProjectGraphUnsafe(String projectKey, boolean drawZones) throws IOException {
        timeCtx = DSSMetrics.timeCtx((String)"dku.services.flowGraph.getProjectUnsafe");
        try {
            block36: {
                block34: {
                    timeCtx2 = DSSMetrics.timeCtx((String)("dku.services.flowGraph.getProjectUnsafe." + projectKey));
                    cacheKey = this.buildCacheKey(projectKey, drawZones);
                    var7_9 = this;
                    synchronized (var7_9) {
                        cacheValue = this.projectCachesUnsafe.computeIfAbsent(cacheKey, (Function<String, CacheValue>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$getProjectGraphUnsafe$1(java.lang.String ), (Ljava/lang/String;)Lcom/dataiku/dip/dataflow/FlowGraphService$CacheValue;)());
                        if (cacheValue.graph == null) ** break block33
                        DSSMetrics.registry().meter("dku.services.flowGraph.getProjectUnsafe.cacheHit").mark();
                        DSSMetrics.registry().meter("dku.services.flowGraph.getProjectUnsafe." + projectKey + ".cacheHit").mark();
                        var8_12 = (ProjectFlowGraph)cacheValue.graph;
                        // MONITOREXIT @DISABLED, blocks:[0, 1, 2, 14] lbl14 : MonitorExitStatement: MONITOREXIT : var7_9
                        if (timeCtx2 == null) break block34;
                    }
                    timeCtx2.close();
                }
                return var8_12;
                {
                    // MONITOREXIT @DISABLED, blocks:[0, 4, 5, 14] lbl20 : MonitorExitStatement: MONITOREXIT : var7_9
                    {
                        catch (Throwable var9_14) {
                            throw var9_14;
                        }
                    }
                    FlowGraphService.logger.info((Object)("Computing flow graph for " + projectKey + " (unsafe)"));
                    DSSMetrics.registry().meter("dku.services.flowGraph.getProjectUnsafe.cacheMiss").mark();
                    DSSMetrics.registry().meter("dku.services.flowGraph.getProjectUnsafe." + projectKey + ".cacheMiss").mark();
                    graph = this.newProjectFlowGraph();
                    timeCtx3 = DSSMetrics.timeCtx((String)"dku.services.flowGraph.getProjectUnsafe.compute");
                    try {
                        timeCtx4 = DSSMetrics.timeCtx((String)("dku.services.flowGraph.getProjectUnsafe." + projectKey + ".compute"));
                        try {
                            graph.buildForProjectUnsafe(projectKey, false, drawZones);
                        }
                        finally {
                            if (timeCtx4 != null) {
                                timeCtx4.close();
                            }
                        }
                    }
                    finally {
                        if (timeCtx3 != null) {
                            timeCtx3.close();
                        }
                    }
                    var8_13 = this;
                    synchronized (var8_13) {
                        cacheValue.graph = graph;
                    }
                    var8_13 = graph;
                    if (timeCtx2 == null) break block36;
                }
                timeCtx2.close();
            }
            return var8_13;
            {
                catch (Throwable var5_7) {
                    if (timeCtx2 != null) {
                        try {
                            timeCtx2.close();
                        }
                        catch (Throwable var6_11) {
                            var5_7.addSuppressed(var6_11);
                        }
                    }
                    throw var5_7;
                }
            }
        }
        finally {
            if (timeCtx != null) {
                timeCtx.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FlowGraph getCachedProjectGraph(String projectKey, boolean drawZones) {
        String key = this.buildCacheKey(projectKey, drawZones);
        FlowGraphService flowGraphService = this;
        synchronized (flowGraphService) {
            CacheValue<ProjectFlowGraph> cacheValue = this.projectCachesSafe.get(key);
            return cacheValue != null ? (FlowGraph)cacheValue.graph : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    FlowGraph getCachedProjectGraphUnsafe(String projectKey, boolean drawZones) {
        String key = this.buildCacheKey(projectKey, drawZones);
        FlowGraphService flowGraphService = this;
        synchronized (flowGraphService) {
            CacheValue<ProjectFlowGraph> cacheValue = this.projectCachesUnsafe.get(key);
            return cacheValue != null ? (FlowGraph)cacheValue.graph : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    FlowGraph getCachedGlobalGraphUnsafe() {
        FlowGraphService flowGraphService = this;
        synchronized (flowGraphService) {
            return this.globalCacheUnsafe != null ? (FlowGraph)this.globalCacheSafe.graph : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    FlowGraph getCachedGlobalGraphSafe() {
        FlowGraphService flowGraphService = this;
        synchronized (flowGraphService) {
            return this.globalCacheSafe != null ? (FlowGraph)this.globalCacheSafe.graph : null;
        }
    }

    ProjectFlowGraph newProjectFlowGraph() {
        return new ProjectFlowGraph();
    }

    FlowGraph newFlowGraph() {
        return new FlowGraph();
    }

    private String buildCacheKey(String projectKey, boolean drawZones) {
        return projectKey + (drawZones ? "" : "-withoutZone");
    }

    public ProjectFlowGraph getProjectGraphWithOrphans(String projectKey) throws IOException {
        logger.info((Object)("Computing flow graph with orphans for " + projectKey));
        ProjectFlowGraph graph = this.newProjectFlowGraph();
        graph.buildForProject(projectKey, true, true);
        return graph;
    }

    public ProjectFlowGraph getProjectGraphWithOrphansUnsafe(String projectKey, boolean drawZones) throws IOException {
        logger.info((Object)("Computing flow graph with orphans (unsafe) for " + projectKey));
        ProjectFlowGraph graph = this.newProjectFlowGraph();
        graph.buildForProjectUnsafe(projectKey, true, drawZones);
        return graph;
    }

    public Collection<FlowComputable> getDownstream(String projectKey) throws IOException {
        ArrayList<FlowComputable> results = new ArrayList<FlowComputable>();
        ProjectFlowGraph graph = this.getProjectGraph(projectKey, true);
        for (FlowComputable computable : graph.listComputables()) {
            if (!computable.getSuccessors().isEmpty()) continue;
            results.add(computable);
        }
        return results;
    }

    public Collection<FlowComputable> getDownstreamFromComputable(String projectKey, String computableSmartName) throws IOException {
        AnyLoc loc = AnyLoc.resolveSmart(projectKey, computableSmartName);
        ProjectFlowGraph graph = this.getProjectGraph(projectKey, true);
        FlowComputable computable = graph.getComputable(loc.getFullName());
        return this.getDownstreamRecursive(Collections.singletonList(computable), new HashSet<GraphNode>(), graph);
    }

    public Collection<FlowComputable> getDownstreamFromRunnable(String projectKey, String runnableName) throws IOException {
        AnyLoc loc = AnyLoc.resolveSmart(projectKey, runnableName);
        ProjectFlowGraph graph = this.getProjectGraph(projectKey, true);
        FlowRunnable runnable = graph.getRunnable(loc.getFullName());
        return this.getDownstreamRecursive(Collections.singletonList(runnable), new HashSet<GraphNode>(), graph);
    }

    /*
     * WARNING - void declaration
     */
    public Collection<FlowComputable> getFinalComputablesOfFlow(String projectKey, @Nullable String zoneId) throws IOException {
        logger.infoV("Getting final computables of project=%s zone=%s", new Object[]{projectKey, zoneId});
        ArrayList<FlowComputable> results = new ArrayList<FlowComputable>();
        ProjectFlowGraph graph = this.getProjectGraph(projectKey, zoneId != null);
        HashMap<AnyLoc, Zone> zonesMap = new HashMap<AnyLoc, Zone>();
        List zones = this.zonesDAO.listUnsafe(projectKey);
        for (Zone zone : zones) {
            for (SmartObjectRef objectRef : zone.getItems()) {
                zonesMap.put(AnyLoc.resolveFull(objectRef.getFullId(projectKey)), zone);
            }
        }
        for (FlowComputable computable : graph.listComputables()) {
            boolean noSuccessorIsInFlow;
            if (!computable.canBeBuilt()) continue;
            AnyLoc computableLoc = AnyLoc.resolveFull(computable.getFullId());
            if (zoneId != null) {
                Zone computableZone = (Zone)zonesMap.get(computableLoc);
                String computableZoneId = computableZone != null ? computableZone.getId() : Zone.DEFAULT_ZONE.getId();
                logger.traceV("Considering computable %s in zone %s", new Object[]{computable.getFullId(), computableZoneId});
                if (!computableZoneId.equals(zoneId)) {
                    continue;
                }
            } else {
                logger.traceV("Considering computable %s", new Object[]{computable.getFullId()});
            }
            if (zoneId != null) {
                if (!computable.getSuccessors().isEmpty()) {
                    logger.traceV("Checking its successors", new Object[0]);
                }
                noSuccessorIsInFlow = true;
                for (GraphNode graphNode : computable.getSuccessors()) {
                    void var12_14;
                    AnyLoc successorLoc;
                    Zone successorZone;
                    if (graphNode instanceof FlowImplicitRecipe) {
                        FlowImplicitRecipe implicitRecipe = (FlowImplicitRecipe)graphNode;
                        FlowComputable flowComputable = implicitRecipe.getSuccessor();
                    }
                    String successorZoneId = (successorZone = (Zone)zonesMap.get(successorLoc = AnyLoc.resolveFull(var12_14.getFullId()))) != null ? successorZone.getId() : Zone.DEFAULT_ZONE.getId();
                    logger.traceV("Successor %s is in zone %s - vs searched zone %s", new Object[]{var12_14.getFullId(), successorZoneId, zoneId});
                    if (!successorZoneId.equals(zoneId)) continue;
                    noSuccessorIsInFlow = false;
                    break;
                }
            } else {
                noSuccessorIsInFlow = computable.getSuccessors().isEmpty();
            }
            logger.traceV("noSuccessorIsInFlow=%s", new Object[]{noSuccessorIsInFlow});
            if (!noSuccessorIsInFlow) continue;
            results.add(computable);
        }
        logger.infoV("Final computables of project=%s zone=%s: %s", new Object[]{projectKey, zoneId, results.stream().map(GraphNode::getFullId).collect(Collectors.joining(","))});
        return results;
    }

    public List<FlowZoneNode> getFlowZoneNodes(String projectKey, Map<AnyLoc, Zone> zonesMap) throws IOException {
        String currentZoneId;
        HashMap<String, FlowZoneNode> flowZoneGraph = new HashMap<String, FlowZoneNode>();
        HashMap predecessors = new HashMap();
        HashMap successors = new HashMap();
        ProjectFlowGraph projectGraph = this.getProjectGraph(projectKey, true);
        for (FlowZone zone : projectGraph.getFlowZones()) {
            currentZoneId = zone.getZone().getId();
            predecessors.put(currentZoneId, new HashSet());
            successors.put(currentZoneId, new HashSet());
            flowZoneGraph.put(currentZoneId, new FlowZoneNode(zone.getZone()));
        }
        for (FlowZone zone : projectGraph.getFlowZones()) {
            currentZoneId = zone.getZone().getId();
            for (FlowComputable computable : zone.listComputables()) {
                AnyLoc computableLoc = AnyLoc.resolveFull(computable.getFullId());
                Zone computableZone = zonesMap.get(computableLoc);
                String computableZoneId = computableZone != null ? computableZone.getId() : Zone.DEFAULT_ZONE.getId();
                if (computableZoneId.equals(currentZoneId)) continue;
                ((Set)predecessors.get(currentZoneId)).add((FlowZoneNode)flowZoneGraph.get(computableZoneId));
                ((Set)successors.get(computableZoneId)).add((FlowZoneNode)flowZoneGraph.get(currentZoneId));
            }
        }
        for (FlowZoneNode zoneNode : flowZoneGraph.values()) {
            String zoneId = zoneNode.getFullId();
            zoneNode.clearPredecessors();
            ((Set)predecessors.get(zoneId)).forEach(p -> zoneNode.addPredecessor(p, null));
            zoneNode.clearSuccessors();
            ((Set)successors.get(zoneId)).forEach(s -> zoneNode.addSuccessor((GraphNode)s, null));
        }
        return Lists.newArrayList(flowZoneGraph.values());
    }

    public List<FlowRunnable> getInitialRunnablesOfFlow(String projectKey, @Nullable String zoneId, Map<AnyLoc, Zone> zonesMap) throws IOException {
        logger.infoV("Getting initial runnables of project=%s zone=%s", new Object[]{projectKey, zoneId});
        ArrayList<FlowRunnable> results = new ArrayList<FlowRunnable>();
        ProjectFlowGraph graph = this.getProjectGraph(projectKey, zoneId != null);
        for (FlowRunnable runnable : graph.listRunnables()) {
            AnyLoc runnableLoc = AnyLoc.resolveFull(runnable.getFullId());
            if (zoneId != null) {
                Zone runnableZone = zonesMap.get(runnableLoc);
                String runnableZoneId = runnableZone != null ? runnableZone.getId() : Zone.DEFAULT_ZONE.getId();
                logger.debugV("Considering runnable %s in zone %s", new Object[]{runnable.getFullId(), runnableZoneId});
                if (!runnableZoneId.equals(zoneId)) {
                    continue;
                }
            } else {
                logger.debugV("Considering runnable %s", new Object[]{runnable.getFullId()});
            }
            boolean noPredecessorRunnableIsInFlow = true;
            block1: for (GraphNode graphNode : runnable.getPredecessors()) {
                if (zoneId != null) {
                    for (GraphNode graphNode2 : graphNode.getPredecessors()) {
                        AnyLoc predecessorPredecessorRunnableLoc = AnyLoc.resolveFull(graphNode2.getFullId());
                        Zone predecessorPredecessorRunnableZone = zonesMap.get(predecessorPredecessorRunnableLoc);
                        String predecessorPredecessorRunnableZoneId = predecessorPredecessorRunnableZone != null ? predecessorPredecessorRunnableZone.getId() : Zone.DEFAULT_ZONE.getId();
                        logger.debugV("Predecessor %s of predecessor %s of %s is in zone %s - vs searched zone %s", new Object[]{predecessorPredecessorRunnableLoc, graphNode.getFullId(), runnableLoc, predecessorPredecessorRunnableZoneId, zoneId});
                        if (!predecessorPredecessorRunnableZoneId.equals(zoneId)) continue;
                        noPredecessorRunnableIsInFlow = false;
                        continue block1;
                    }
                    continue;
                }
                if (graphNode.getPredecessors().isEmpty()) continue;
                noPredecessorRunnableIsInFlow = false;
                break;
            }
            logger.debugV("noPredecessorRunnableIsInFlow=%s", new Object[]{noPredecessorRunnableIsInFlow});
            if (!noPredecessorRunnableIsInFlow) continue;
            results.add(runnable);
        }
        logger.infoV("Initial runnables of project=%s zone=%s: %s", new Object[]{projectKey, zoneId, results.stream().map(GraphNode::getFullId).collect(Collectors.joining(","))});
        return results;
    }

    public Set<FlowComputable> getDownstream(GraphNode node) {
        return this.getDownstreamRecursive(Collections.singletonList(node), new HashSet<GraphNode>(), null);
    }

    /*
     * WARNING - void declaration
     */
    public Set<FlowComputable> getDownstreamRecursive(List<? extends GraphNode> nodes, Set<GraphNode> visited, ProjectFlowGraph graph) {
        HashSet<FlowComputable> results = new HashSet<FlowComputable>();
        for (GraphNode graphNode : nodes) {
            if (!visited.add(graphNode)) continue;
            if (graphNode instanceof FlowComputable) {
                void var6_6;
                FlowComputable flowComputable;
                if (graph != null && !graph.getFlowZones().isEmpty()) {
                    FlowComputable flowComputable2 = graph.getComputable(graphNode.getFullId());
                }
                if ((flowComputable = (FlowComputable)var6_6).getSuccessors().isEmpty()) {
                    results.add(flowComputable);
                    continue;
                }
                results.addAll(this.getDownstreamRecursive(flowComputable.getSuccessors(), visited, graph));
                continue;
            }
            if (!(graphNode instanceof FlowRunnable)) continue;
            results.addAll(this.getDownstreamRecursive(graphNode.getSuccessors(), visited, graph));
        }
        return results;
    }

    public List<SerializedRecipe> getSuccessorRecipesAccrossProjectsUnsafe(AnyLoc computable) throws IOException {
        ArrayList<SerializedRecipe> ret = new ArrayList<SerializedRecipe>();
        ProjectsService ps2 = (ProjectsService)SpringUtils.getBean(ProjectsService.class);
        Set<String> projectKeys = ps2.getExpositionTargetProjects(computable.getProjectKey());
        projectKeys.add(computable.getProjectKey());
        RecipesDAO rdao = (RecipesDAO)SpringUtils.getBean(RecipesDAO.class);
        for (String projectKey : projectKeys) {
            for (SerializedRecipe sr : rdao.listUnsafe(projectKey)) {
                for (SerializedRecipe.RecipeInput ri : sr.getFlatInputs()) {
                    try {
                        AnyLoc inputLoc = ri.getLoc(projectKey);
                        if (!inputLoc.equals(computable)) continue;
                        ret.add(sr);
                    }
                    catch (IllegalArgumentException e) {
                        logger.error((Object)"Invalid recipe input ref", (Throwable)e);
                    }
                }
            }
        }
        return ret;
    }

    public List<SerializedRecipe> getSuccessorAndPredecessorRecipesAcrossProjectsUnsafe(AnyLoc computable) throws IOException {
        ArrayList<SerializedRecipe> ret = new ArrayList<SerializedRecipe>();
        ProjectsService ps2 = (ProjectsService)SpringUtils.getBean(ProjectsService.class);
        Set<String> projectKeys = ps2.getExpositionTargetProjects(computable.getProjectKey());
        projectKeys.add(computable.getProjectKey());
        RecipesDAO rdao = (RecipesDAO)SpringUtils.getBean(RecipesDAO.class);
        for (String projectKey : projectKeys) {
            for (SerializedRecipe sr : rdao.listUnsafe(projectKey)) {
                for (SerializedRecipe.RecipeInput ri : sr.getFlatInputs()) {
                    try {
                        AnyLoc inputLoc = ri.getLoc(projectKey);
                        if (!inputLoc.equals(computable)) continue;
                        ret.add(sr);
                    }
                    catch (IllegalArgumentException e) {
                        logger.error((Object)("Invalid recipe input ref for recipe " + sr.getId() + " in project " + projectKey), (Throwable)e);
                    }
                }
                for (SerializedRecipe.RecipeOutput ro : sr.getFlatOutputs()) {
                    try {
                        AnyLoc outputLoc = ro.getLoc(projectKey);
                        if (!outputLoc.equals(computable)) continue;
                        ret.add(sr);
                    }
                    catch (IllegalArgumentException e) {
                        logger.error((Object)("Invalid recipe output ref for recipe " + sr.getId() + " in project " + projectKey), (Throwable)e);
                    }
                }
            }
        }
        return ret;
    }

    public List<LabelingTask> getSuccessorLabelingTasksAcrossProjectsUnsafe(AnyLoc computable) throws IOException {
        ArrayList<LabelingTask> ret = new ArrayList<LabelingTask>();
        ProjectsService ps2 = (ProjectsService)SpringUtils.getBean(ProjectsService.class);
        Set<String> projectKeys = ps2.getExpositionTargetProjects(computable.getProjectKey());
        projectKeys.add(computable.getProjectKey());
        LabelingTasksDAO labelingTasksDAO = (LabelingTasksDAO)SpringUtils.getBean(LabelingTasksDAO.class);
        for (String projectKey : projectKeys) {
            for (LabelingTask task : labelingTasksDAO.listUnsafe(projectKey)) {
                for (LabelingTask.LabelingTaskInput input : task.getFlatInputs()) {
                    AnyLoc inputLoc = input.getLoc(projectKey);
                    if (!inputLoc.equals(computable)) continue;
                    ret.add(task);
                }
            }
        }
        return ret;
    }

    public PartitioningScheme getComputablePartitioningScheme(FlowComputable computable) throws IOException {
        PartitioningScheme scheme = null;
        if (computable instanceof FlowDataset) {
            FlowDataset flowDataset = (FlowDataset)computable;
            scheme = flowDataset.getMandatoryUnsafe(this.datasetsDAO).getPartitioningSchema();
        } else if (computable instanceof FlowManagedFolder) {
            FlowManagedFolder flowManagedFolder = (FlowManagedFolder)computable;
            scheme = flowManagedFolder.getManagedFolder().getPartitioningSchema();
        } else if (computable instanceof FlowSavedModel) {
            FlowSavedModel flowSavedModel = (FlowSavedModel)computable;
            scheme = flowSavedModel.getSavedModel().getPartitioningSchema();
        } else if (computable instanceof FlowModelEvaluationStore) {
            FlowModelEvaluationStore flowModelEvaluationStore = (FlowModelEvaluationStore)computable;
            scheme = flowModelEvaluationStore.getModelEvaluationStore().getPartitioningSchema();
        } else {
            scheme = computable instanceof FlowStreamingEndpoint ? new PartitioningScheme() : new PartitioningScheme();
        }
        return scheme;
    }

    public boolean hasAnyPartitioningInGraph(FlowGraph graph, String projectKeyFilter) throws IOException {
        boolean hasAnyPartitioningAnywhere = false;
        for (GraphNode node : graph.getNodesMap().values()) {
            AnyLoc loc = AnyLoc.resolveFull(node.getFullId());
            if (StringUtils.isNotBlank((String)projectKeyFilter) && !projectKeyFilter.equals(loc.getProjectKey())) continue;
            if (node instanceof FlowComputable) {
                FlowComputable flowComputable = (FlowComputable)node;
                PartitioningScheme scheme = this.getComputablePartitioningScheme(flowComputable);
                hasAnyPartitioningAnywhere |= scheme.isPartitioned();
                continue;
            }
            if (!(node instanceof FlowRecipe)) continue;
            FlowRecipe flowRecipe = (FlowRecipe)node;
            SerializedRecipe recipe = flowRecipe.getModel();
            hasAnyPartitioningAnywhere |= recipe.getFlatInputs().stream().anyMatch(i -> !i.deps.isEmpty());
        }
        return hasAnyPartitioningAnywhere;
    }

    private static /* synthetic */ CacheValue lambda$getProjectGraphUnsafe$1(String x) {
        return new CacheValue();
    }

    private static /* synthetic */ CacheValue lambda$getProjectGraph$0(String x) {
        return new CacheValue();
    }

    private static class CacheValue<G extends FlowGraph> {
        G graph;

        private CacheValue() {
        }
    }
}

