/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow;

import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dao.RecipesDAO;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.RecipeRunnableSubgraph;
import com.dataiku.dip.dataflow.exec.dataquality.ExtractFailedRowsRecipeMeta;
import com.dataiku.dip.dataflow.graph.FlowRecipe;
import com.dataiku.dip.dataflow.pipeline.AbstractPipelineRunnableSubgraph;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.JSON;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;

public class RecipeHashComputer {
    RecipesDAO recipesDAO;
    DatasetsDAO datasetsDAO;

    public RecipeHashComputer(RecipesDAO recipesDAO, DatasetsDAO datasetsDAO) {
        this.recipesDAO = recipesDAO;
        this.datasetsDAO = datasetsDAO;
    }

    public String getRecipeHash(FlowRecipe r) throws IOException {
        SerializedRecipe sr = (SerializedRecipe)this.recipesDAO.getOrNull(r.getProjectKey(), r.getName());
        if (sr == null) {
            return "auto-mirror-hash";
        }
        sr.description = null;
        sr.tags = null;
        sr.doc = null;
        String payload = this.recipesDAO.getPayloadOrNull(r.getProjectKey(), r.getName());
        if (payload == null) {
            payload = "no-payload";
        }
        String data = JSON.json((Object)sr) + "-" + payload;
        if (ExtractFailedRowsRecipeMeta.META.getType().equals(sr.type)) {
            StringBuilder dqRulesData = new StringBuilder();
            for (SerializedRecipe.RecipeInput input : sr.getFlatInputs()) {
                AnyLoc loc = input.getLoc(r.getProjectKey());
                SerializedDataset sd = (SerializedDataset)this.datasetsDAO.getOrNull(loc);
                if (sd == null) continue;
                dqRulesData.append("-").append(JSON.json(sd.getDataQualityRuleSet().getRules()));
            }
            data = data + String.valueOf(dqRulesData);
        }
        return DKUtils.md5Base64((String)data);
    }

    public String getPipelineHash(AbstractPipelineRunnableSubgraph subgraph) throws IOException {
        HashMap<String, String> computedHashes = new HashMap<String, String>();
        for (JobActivity ja : subgraph.getAllIncludedActivitiesWithRoot()) {
            FlowRecipe fr = ((RecipeRunnableSubgraph)ja.getSubgraph()).getRecipe();
            String recipeHash = this.getRecipeHash(fr);
            computedHashes.put(fr.getFullId(), recipeHash);
        }
        ArrayList recipeNames = Lists.newArrayList(computedHashes.keySet());
        Collections.sort(recipeNames);
        Object finalHash = "";
        for (String rn : recipeNames) {
            finalHash = (String)finalHash + rn + ":" + (String)computedHashes.get(rn);
        }
        return finalHash;
    }
}

