/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.pivot;

import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.dataflow.exec.pivot.PivotedModality;
import com.dataiku.dip.datasets.Type;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class PivotElementSchemaGenerator {
    private final Schema sourceSchema;

    public PivotElementSchemaGenerator(Schema sourceSchema) {
        this.sourceSchema = sourceSchema;
    }

    public Schema generate(Schema inputSchema, List<PivotedModality> modalities) {
        Schema outputSchema = new Schema(inputSchema);
        for (PivotedModality modality : modalities) {
            for (PivotedModality.PivotedColumn valueColumn : modality.valueColumns) {
                String value = valueColumn.source;
                String output = valueColumn.pivoted;
                SchemaColumn outputColumn = new SchemaColumn(this.sourceSchema.getColumn(value));
                outputColumn.setName(output);
                outputSchema.addColumn(outputColumn);
            }
            if (!StringUtils.isNotBlank((String)modality.globalCountColumn)) continue;
            outputSchema.addColumn(new SchemaColumn(modality.globalCountColumn, Type.BIGINT));
        }
        return outputSchema;
    }
}

