/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.sync;

import com.dataiku.dip.connections.AzureConnection;
import com.dataiku.dip.connections.ConnectionWithAzureAuthCredentials;
import com.dataiku.dip.connections.ConnectionWithBasicCredential;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.dataflow.exec.sync.AzureBlobToSynapse;
import com.dataiku.dip.dataflow.exec.sync.CloudBlobSupport;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.input.formats.hive.orcfile.ORCFileFormatConfig;
import com.dataiku.dip.input.formats.parquet.ParquetFormatConfig;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.SQLUtils;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.DKULogger;
import com.google.common.base.Joiner;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;

public class AzureBlobToSynapseWithCopy
extends AzureBlobToSynapse.SynapseLoadSQLBuilder {
    public String forcedUniqueId = null;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.recipes.sync.azureblobtosynapse.copy");

    @Override
    boolean canLoadMultipleFiles() {
        return true;
    }

    public AzureBlobToSynapseWithCopy withForcedUuid(String uuid) {
        this.forcedUniqueId = uuid;
        return this;
    }

    @Override
    public AzureBlobToSynapse.SQLCommandList buildSqlSequence(AzureConnection azure, CloudBlobSupport.CopyMode copyMode, SQLDialect dialect, CloudBlobSupport.LocationToLoad azureBlobStorageLocation, SQLUtils.SQLTable table, AzureBlobToSynapse loader) throws DKUSecurityException, IOException {
        return this.buildSqlSequence(azure, copyMode, dialect, Arrays.asList(azureBlobStorageLocation), table, loader);
    }

    @Override
    public AzureBlobToSynapse.SQLCommandList buildSqlSequence(AzureConnection azure, CloudBlobSupport.CopyMode copyMode, SQLDialect dialect, List<CloudBlobSupport.LocationToLoad> azureBlobStorageLocations, SQLUtils.SQLTable table, AzureBlobToSynapse loader) throws DKUSecurityException, IOException {
        Set outputColumnNamesSet;
        boolean skipsSomeInputColumns;
        String uniqueId = this.forcedUniqueId == null ? SecretKeyGenerator.generateSmall() : this.forcedUniqueId;
        Dataset inputDS = loader.getInputDS();
        Dataset outputDS = loader.getOutputDS();
        AzureBlobToSynapse.SQLCommandList sqlSequence = new AzureBlobToSynapse.SQLCommandList();
        boolean hasDatesInParquetOrOrc = false;
        if (copyMode.type == CloudBlobSupport.CopyModeType.PARQUET || copyMode.type == CloudBlobSupport.CopyModeType.ORC) {
            hasDatesInParquetOrOrc = inputDS.getSchema().columns.stream().map(SchemaColumn::getType).anyMatch(t -> t.isTemporal());
        }
        boolean hasUnmappedTypes = inputDS.getSchema().columns.stream().map(SchemaColumn::getType).anyMatch(t -> !t.isPrimitive() || t.isGeo());
        Set inputColumnNamesSet = inputDS.getSchema().columns.stream().map(SchemaColumn::getName).collect(Collectors.toSet());
        boolean bl = skipsSomeInputColumns = !Sets.difference(inputColumnNamesSet, outputColumnNamesSet = outputDS.getSchema().columns.stream().map(SchemaColumn::getName).collect(Collectors.toSet())).isEmpty();
        if (outputDS.getPartitioningSchema().isPartitioned() || hasDatesInParquetOrOrc || hasUnmappedTypes || skipsSomeInputColumns) {
            SQLUtils.SQLTable temporaryTable = new SQLUtils.SQLTable(table.getCatalog(), table.getSchemaNullIfBlank(), String.format("DKU_DSS_TMP_%s", uniqueId));
            String temporaryTableName = dialect.getQuotedTableFullName(temporaryTable);
            ArrayList<CallSite> temporaryTableColumnFields = new ArrayList<CallSite>();
            for (SchemaColumn col : inputDS.getSchema().columns) {
                if (!col.getType().isPrimitive() || col.getType().isGeo()) {
                    col = new SchemaColumn(col.getName(), Type.STRING);
                }
                String sqlDecl = dialect.getSQLType((SchemaColumn)col, (Dataset)inputDS).sqlDecl;
                if (copyMode.type == CloudBlobSupport.CopyModeType.PARQUET) {
                    if (col.getType() == Type.DATEONLY) {
                        sqlDecl = AzureBlobToSynapse.isSynapseDialect(dialect) ? "int" : "date";
                    } else if (col.getType() == Type.DATE) {
                        sqlDecl = "date_day".equalsIgnoreCase(col.originalType) ? "int" : "datetime2(3)";
                    }
                } else if (copyMode.type == CloudBlobSupport.CopyModeType.ORC && col.getType() == Type.DATE) {
                    sqlDecl = "datetime2(3)";
                }
                temporaryTableColumnFields.add((CallSite)((Object)(dialect.quoteIdentifier(col.getName()) + " " + sqlDecl)));
            }
            String temporaryTableColumns = Joiner.on((String)", ").join(temporaryTableColumnFields);
            sqlSequence.add(new AzureBlobToSynapse.SQLCommand(String.format("CREATE TABLE %s ( %s )", temporaryTableName, temporaryTableColumns), null, String.format("DROP TABLE %s", temporaryTableName)));
            sqlSequence.add(this.buildCopySqlCommand(azure, copyMode, dialect, azureBlobStorageLocations, temporaryTable, inputDS.getSchema(), loader));
            sqlSequence.add(loader.buildLoadFromTempTable(dialect, table, temporaryTableName, copyMode));
        } else {
            sqlSequence.add(this.buildCopySqlCommand(azure, copyMode, dialect, azureBlobStorageLocations, table, outputDS.getSchema(), loader));
        }
        return sqlSequence;
    }

    private AzureBlobToSynapse.SQLCommand buildCopySqlCommand(AzureConnection azure, CloudBlobSupport.CopyMode copyMode, SQLDialect dialect, List<CloudBlobSupport.LocationToLoad> azureBlobStorageLocations, SQLUtils.SQLTable table, Schema schema, AzureBlobToSynapse loader) throws DKUSecurityException, IOException {
        String credentialsForLog;
        String credentials;
        if (this.useManagedIdentity) {
            credentialsForLog = credentials = "CREDENTIAL = ( IDENTITY = 'Managed Identity' )";
        } else {
            ConnectionWithAzureAuthCredentials.SerializableAzureAuthCredentials creds = azure.getFullyResolvedCredentials_fsLike(new ConnectionWithBasicCredential.CredentialResolutionContext(loader.getAuthCtx(), loader.getContextProjectKey()), ConnectionWithAzureAuthCredentials.SerializableAzureAuthCredentials.class);
            if (creds.authType == ConnectionWithAzureAuthCredentials.AuthType.KEY) {
                credentials = String.format("CREDENTIAL = ( IDENTITY = 'Storage Account Key', SECRET = '%s' )", creds.key);
                credentialsForLog = "CREDENTIAL = ( IDENTITY = 'Storage Account Key', SECRET = '********' )";
            } else if (creds.authType == ConnectionWithAzureAuthCredentials.AuthType.OAUTH2_APP) {
                String appIdentity = String.format("%s@%s", creds.oauth2AppId, creds.oauth2AuthEndpoint);
                credentials = String.format("CREDENTIAL = ( IDENTITY = '%s', SECRET = '%s' )", appIdentity, creds.oauth2AppSecret);
                credentialsForLog = String.format("CREDENTIAL = ( IDENTITY = '%s', SECRET = '********' )", appIdentity);
            } else {
                throw new IllegalArgumentException("Invalid authType " + String.valueOf((Object)creds.authType));
            }
        }
        ArrayList<String> formatParamChunks = new ArrayList<String>();
        switch (copyMode.type) {
            case CSV: {
                formatParamChunks.add("FILE_TYPE = 'CSV'");
                if (StringUtils.isBlank((String)copyMode.csvCompressionMethod)) {
                    formatParamChunks.add("COMPRESSION = 'NONE'");
                } else {
                    formatParamChunks.add("COMPRESSION = 'Gzip'");
                }
                formatParamChunks.add(String.format("FIELDTERMINATOR = '%c'", Character.valueOf(copyMode.delimiter)));
                if (copyMode.useQuoting && copyMode.quote != '\u0000') {
                    logger.info((Object)"Will use string_delimiter in temporary file format");
                    formatParamChunks.add(String.format("FIELDQUOTE = '%c'", Character.valueOf(copyMode.quote)));
                } else if (copyMode.useQuoting) {
                    logger.info((Object)"Suppressing quoting by setting string delimiter to \\0");
                    formatParamChunks.add("FIELDQUOTE = '0x00'");
                } else {
                    logger.info((Object)"Use string_delimiter in temporary file format has been suppressed");
                }
                if (copyMode.ignoreHeader <= 0) break;
                formatParamChunks.add(String.format("FIRSTROW = %d", copyMode.ignoreHeader + 1));
                break;
            }
            case PARQUET: {
                formatParamChunks.add("FILE_TYPE = 'PARQUET'");
                if (copyMode.parquetCompressionMethod == ParquetFormatConfig.CompressionMethod.GZIP) {
                    formatParamChunks.add("COMPRESSION = 'Gzip'");
                    break;
                }
                if (copyMode.parquetCompressionMethod == ParquetFormatConfig.CompressionMethod.SNAPPY) {
                    formatParamChunks.add("COMPRESSION = 'Snappy'");
                    break;
                }
                if (copyMode.parquetCompressionMethod != ParquetFormatConfig.CompressionMethod.UNCOMPRESSED) break;
                formatParamChunks.add("COMPRESSION = 'NONE'");
                break;
            }
            case ORC: {
                formatParamChunks.add("FILE_TYPE = 'ORC'");
                if (copyMode.orcCompressionMethod == ORCFileFormatConfig.CompressionMethod.ZLIB) {
                    formatParamChunks.add("COMPRESSION = 'DefaultCodec'");
                    break;
                }
                if (copyMode.orcCompressionMethod == ORCFileFormatConfig.CompressionMethod.SNAPPY) {
                    formatParamChunks.add("COMPRESSION = 'Snappy'");
                    break;
                }
                if (copyMode.orcCompressionMethod != ORCFileFormatConfig.CompressionMethod.NONE) break;
                formatParamChunks.add("COMPRESSION = 'NONE'");
            }
        }
        String quotedTableFullName = dialect.getQuotedTableFullName(table);
        ArrayList<String> targetColumnFields = new ArrayList<String>();
        for (Object col : schema.columns) {
            String quotedColumnName = dialect.quoteIdentifier(col.getName());
            targetColumnFields.add(quotedColumnName);
        }
        StringBuilder builder = new StringBuilder();
        for (CloudBlobSupport.LocationToLoad loc : azureBlobStorageLocations) {
            if (!builder.isEmpty()) {
                builder.append(",");
            }
            builder.append(String.format("'https://%s.%s/%s/%s'", loc.storageAccount, loc.location, loc.container, loc.pathInContainer));
        }
        String targetColumns = Joiner.on((String)", ").join(targetColumnFields);
        String sourceLocation = builder.toString();
        String formatParams = Stream.concat(formatParamChunks.stream(), Stream.of(credentials)).collect(Collectors.joining(", "));
        String formatParamsForLog = Stream.concat(formatParamChunks.stream(), Stream.of(credentialsForLog)).collect(Collectors.joining(", "));
        String copyInto = String.format("COPY INTO %s ( %s ) FROM %s WITH (%s)", quotedTableFullName, targetColumns, sourceLocation, formatParams);
        String copyIntoForLog = String.format("COPY INTO %s ( %s ) FROM %s WITH (%s)", quotedTableFullName, targetColumns, sourceLocation, formatParamsForLog);
        return new AzureBlobToSynapse.SQLCommand(copyInto, copyIntoForLog, null);
    }
}

