/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.sync;

import com.dataiku.dip.connections.SQLConnectionProvider;
import com.dataiku.dip.connections.TrinoConnection;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.dataflow.exec.FlowRunnable;
import com.dataiku.dip.dataflow.exec.SISORecipeExecutor;
import com.dataiku.dip.dataflow.exec.sync.AutoFastPathConnector;
import com.dataiku.dip.dataflow.exec.sync.FastPathDatasetTypeStraightener;
import com.dataiku.dip.dataflow.exec.sync.TrinoSupport;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.datasets.fs.AbstractFSLikeDatasetHandler;
import com.dataiku.dip.datasets.fs.BlobLikeDatasetHandler;
import com.dataiku.dip.datasets.sql.AbstractSQLTableDatasetHandler;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.input.DatasetHandlerFactory;
import com.dataiku.dip.output.Output;
import com.dataiku.dip.partitioning.DimensionValue;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.sql.SQLUtils;
import com.dataiku.dip.sql.TrinoSQLDialect;
import com.dataiku.dip.sql.queries.ExpressionUtils;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.warnings.WarningsContext;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;

public abstract class CloudToTrino<T extends BlobLikeDatasetHandler<?>>
extends SISORecipeExecutor
implements AutoFastPathConnector {
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.recipes.sync.cloudtotrino");

    protected abstract String getPartitionRootPath(T var1, Partition var2) throws DKUSecurityException, CodedException, IOException;

    @Override
    public List<FlowRunnable> getRunnables() {
        return Lists.newArrayList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() throws Exception {
        TrinoSupport.CopyMode mode = TrinoSupport.getCopyMode(this.inputDS, true);
        try (AbstractSQLTableDatasetHandler dsh = (AbstractSQLTableDatasetHandler)DatasetHandlerFactory.build(this.authCtx, this.outputDS);
             BlobLikeDatasetHandler blobDShandler = (BlobLikeDatasetHandler)new FastPathDatasetTypeStraightener().getDatasetHandler(this.authCtx, this.inputDS);){
            SQLConnectionProvider.SQLConnectionData connData = dsh.getConnectionData();
            SQLUtils.SQLTable outputTable = dsh.getResolvedTable();
            TrinoSQLDialect dialect = (TrinoSQLDialect)connData.getDialect();
            boolean isAppendMode = this.writeMode == Output.WriteMode.APPEND;
            SQLConnectionProvider.SQLConnectionWrapper connWrapper = dsh.newConnection();
            try {
                SQLUtils.executePreWriteStatements(connData, connWrapper, this.outputDS);
                InfoMessage.InfoMessages messages = new InfoMessage.InfoMessages();
                dialect.dropIfNeededAndCreateTableOrPartition(this.authCtx, connData, connWrapper, this.outputDS, this.outputPartition, this.writeMode, messages);
                if (!messages.isEmpty()) {
                    this.warnContext.addWarning(WarningsContext.WarningType.SQL_CREATE_QUERY_WARNING, messages.report("\n"), logger);
                }
                for (Partition inputPartition : this.inputPartitions) {
                    String inputTableName = blobDShandler.getDataset().getName() + "_" + SecretKeyGenerator.generate((int)8);
                    SQLUtils.SQLTable temporaryInputTable = new SQLUtils.SQLTable(outputTable.getCatalog(), outputTable.getSchemaNullIfBlank(), inputTableName);
                    TrinoConnection trinoConnection = (TrinoConnection)connData.getConnection();
                    TrinoConnection.Params connectionParams = (TrinoConnection.Params)trinoConnection.getParams();
                    if (StringUtils.isNotBlank((String)connectionParams.autoFastPathCatalog)) {
                        temporaryInputTable = new SQLUtils.SQLTable(connectionParams.autoFastPathCatalog, StringUtils.defaultIfBlank((String)connectionParams.autoFastPathSchema, (String)"default"), temporaryInputTable.getTable());
                    } else if (StringUtils.isNotBlank((String)connectionParams.autoFastPathSchema)) {
                        temporaryInputTable = new SQLUtils.SQLTable(temporaryInputTable.getCatalog(), connectionParams.autoFastPathSchema, temporaryInputTable.getTable());
                    }
                    try {
                        this.makeTableFromInput(connData, connWrapper, temporaryInputTable, blobDShandler, inputPartition, mode);
                        this.executeCopy(connData, connWrapper, blobDShandler, temporaryInputTable, inputPartition, dsh, outputTable, this.outputPartition, mode);
                    }
                    finally {
                        try {
                            dialect.dropTable(this.authCtx, connData, connWrapper, temporaryInputTable);
                        }
                        catch (Exception e2) {
                            logger.warn((Object)"Failed to clear temporary table", (Throwable)e2);
                        }
                    }
                }
                SQLUtils.executePostWriteStatements(connData, connWrapper, this.outputDS);
                try {
                    connWrapper.commit();
                }
                catch (Exception e) {
                    logger.warn((Object)("Commit doesn't work on this Trino connection : " + e.getMessage()));
                }
                connWrapper.close();
            }
            catch (Exception e) {
                logger.error((Object)"Trino load failed", (Throwable)e);
                SQLUtils.unsafeRollbackAndClose(connWrapper);
                throw e;
            }
        }
    }

    private void executeCopy(SQLConnectionProvider.SQLConnectionData connData, SQLConnectionProvider.SQLConnectionWrapper connWrapper, T inputDatasetHandler, SQLUtils.SQLTable inputTable, Partition inputPartition, AbstractSQLTableDatasetHandler outputDatasetHandler, SQLUtils.SQLTable outputTable, Partition outputPartition, TrinoSupport.CopyMode mode) throws SQLException, IOException {
        TrinoSQLDialect dialect = (TrinoSQLDialect)connData.getDialect();
        Dataset inputDataset = ((AbstractFSLikeDatasetHandler)inputDatasetHandler).getDataset();
        Dataset outputDataset = outputDatasetHandler.getDataset();
        Schema inputSchema = inputDataset.getSchema();
        Schema outputSchema = outputDataset.getSchema();
        Map outputPartitionValues = outputPartition == null || outputPartition.isNP() ? new HashMap() : outputPartition.getDimensionValues();
        Map inputPartitionValues = inputPartition == null || inputPartition.isNP() ? new HashMap() : inputPartition.getDimensionValues();
        ArrayList<Object> inserted = new ArrayList<Object>();
        for (SchemaColumn outputColumn : outputSchema.getColumns()) {
            String value;
            SchemaColumn inputColumn = inputSchema.getColumn(outputColumn.getName());
            String quotedIdentifier = dialect.quoteIdentifier(outputColumn.getName());
            if (outputPartitionValues.containsKey(outputColumn.getName())) {
                value = ExpressionUtils.getStringForDimensionValue((DimensionValue)outputPartitionValues.get(outputColumn.getName()), outputColumn.getType());
                if (outputColumn.getType() == Type.DATE) {
                    inserted.add(dialect.quoteDate(value) + " AS " + quotedIdentifier);
                    continue;
                }
                if (outputColumn.getType() == Type.DATEONLY) {
                    inserted.add(dialect.quoteDateOnly(value) + " AS " + quotedIdentifier);
                    continue;
                }
                if (outputColumn.getType() == Type.DATETIMENOTZ) {
                    inserted.add(dialect.quoteDatetimeNoTz(value) + " AS " + quotedIdentifier);
                    continue;
                }
                inserted.add(dialect.quoteString(value) + " AS " + quotedIdentifier);
                continue;
            }
            if (inputColumn != null) {
                if (mode.type == TrinoSupport.CopyMode.CopyModeType.CSV || mode.type == TrinoSupport.CopyMode.CopyModeType.TEXTFILE) {
                    if (outputColumn.getType() == Type.DATE) {
                        inserted.add("AT_TIMEZONE(CAST(REPLACE(NULLIF(" + quotedIdentifier + ", ''), 'T', ' ') AS TIMESTAMP WITH TIME ZONE), 'UTC') AS " + quotedIdentifier);
                        continue;
                    }
                    inserted.add("CAST(NULLIF(" + quotedIdentifier + ", '') AS " + dialect.getSQLType((SchemaColumn)outputColumn, (Dataset)outputDataset).sqlDecl + ") AS " + quotedIdentifier);
                    continue;
                }
                if (outputColumn.getType() == Type.DATE) {
                    inserted.add("WITH_TIMEZONE(" + quotedIdentifier + ", 'UTC') AS " + quotedIdentifier);
                    continue;
                }
                inserted.add(quotedIdentifier);
                continue;
            }
            if (inputPartitionValues.containsKey(outputColumn.getName())) {
                value = ExpressionUtils.getStringForDimensionValue((DimensionValue)inputPartition.getDimensionValues().get(outputColumn.getName()), outputColumn.getType());
                if (outputColumn.getType() == Type.DATE) {
                    inserted.add(dialect.quoteDate(value) + " AS " + quotedIdentifier);
                    continue;
                }
                if (outputColumn.getType() == Type.DATEONLY) {
                    inserted.add(dialect.quoteDateOnly(value) + " AS " + quotedIdentifier);
                    continue;
                }
                if (outputColumn.getType() == Type.DATETIMENOTZ) {
                    inserted.add(dialect.quoteDatetimeNoTz(value) + " AS " + quotedIdentifier);
                    continue;
                }
                inserted.add(dialect.quoteString(value) + " AS " + quotedIdentifier);
                continue;
            }
            String partitionId = inputPartition != null ? " (partition id=" + inputPartition.id() + ")" : "";
            String dims = " (partition dims = " + inputPartitionValues.keySet().stream().collect(Collectors.joining(", ")) + ")";
            throw new IOException("Input dataset cannot provide values for column " + outputColumn.getName() + partitionId + dims);
        }
        String insertStatement = String.format("INSERT INTO %s SELECT %s FROM %s", dialect.getQuotedTableFullName(outputTable), inserted.stream().collect(Collectors.joining(", ")), dialect.getQuotedTableFullName(inputTable));
        try (Statement stmt = connWrapper.createStatement();){
            SQLUtils.execute(connWrapper, stmt, insertStatement, insertStatement, false, true);
        }
    }

    private void makeTableFromInput(SQLConnectionProvider.SQLConnectionData connData, SQLConnectionProvider.SQLConnectionWrapper connWrapper, SQLUtils.SQLTable inputTable, T datasetHandler, Partition partition, TrinoSupport.CopyMode mode) throws CodedException, IOException, DKUSecurityException, SQLException {
        Dataset dataset = ((AbstractFSLikeDatasetHandler)datasetHandler).getDataset();
        String inputRootPath = this.getPartitionRootPath(datasetHandler, partition);
        TrinoSQLDialect dialect = (TrinoSQLDialect)connData.getDialect();
        String copyOptions = mode.generateFormatOptions();
        List columnsList = mode.type == TrinoSupport.CopyMode.CopyModeType.CSV || mode.type == TrinoSupport.CopyMode.CopyModeType.TEXTFILE ? dataset.getSchema().getColumns().stream().map(sc -> dialect.quoteIdentifier(sc.getName()) + " varchar").collect(Collectors.toList()) : dataset.getSchema().getColumns().stream().map(sc -> {
            SchemaColumn effectiveSc = (SchemaColumn)JSON.deepCopy((Object)sc);
            if (sc.getType() == Type.DATE) {
                effectiveSc.setType(Type.DATETIMENOTZ);
            }
            return dialect.quoteIdentifier(effectiveSc.getName()) + " " + String.valueOf(dialect.getSQLType(effectiveSc, dataset));
        }).collect(Collectors.toList());
        String createTableStatement = String.format("CREATE TABLE %s (%s) WITH (external_location='%s' %s)", dialect.getQuotedTableFullName(inputTable), columnsList.stream().collect(Collectors.joining(", ")), inputRootPath, StringUtils.isBlank((String)copyOptions) ? "" : ", " + copyOptions);
        try (Statement stmt = connWrapper.createStatement();){
            SQLUtils.execute(connWrapper, stmt, createTableStatement, createTableStatement, false, true);
        }
    }

    @Override
    public void initForAutoFastPath(AuthCtx authCtx, WarningsContext warnContext, Dataset cloudDataset, Partition cloudPartition, Dataset trinoDataset, Output.WriteMode writeMode) throws Exception {
        this.outputDS = trinoDataset;
        this.inputDS = cloudDataset;
        this.contextProjectKey = trinoDataset.getProjectKey();
        this.inputPartitions = Lists.newArrayList((Object[])new Partition[]{cloudPartition});
        this.outputPartition = cloudPartition;
        this.writeMode = writeMode;
        this.authCtx = authCtx;
        this.warnContext = warnContext;
        this.clearOutputPartitionsIfNeeded();
    }
}

