/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.exec.window;

import com.dataiku.dip.containers.exec.ContainerExecSelection;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.exec.window.WindowRecipeCreator;
import com.dataiku.dip.dataflow.exec.window.WindowRecipePayloadParams;
import com.dataiku.dip.dataflow.exec.window.WindowRecipeRunner;
import com.dataiku.dip.dataflow.exec.window.WindowRecipeSchemaComputer;
import com.dataiku.dip.dataflow.exec.window.WindowRecipeStatusComputer;
import com.dataiku.dip.dataflow.pipeline.RecipePipelineHelper;
import com.dataiku.dip.dataflow.pipeline.WindowRecipePipelineHelper;
import com.dataiku.dip.datalineage.DatasetPairLineage;
import com.dataiku.dip.datalineage.RecipeLineage;
import com.dataiku.dip.datasets.SchemaUtils;
import com.dataiku.dip.datasets.sql.BuiltinSQLDatasets;
import com.dataiku.dip.i18n.TranslationService;
import com.dataiku.dip.recipes.AbstractSparkRecipeParams;
import com.dataiku.dip.recipes.BasicRecipeLineageHandler;
import com.dataiku.dip.recipes.MetaWithContainerizablePayload;
import com.dataiku.dip.recipes.NoParams;
import com.dataiku.dip.recipes.ParamsWithContainerizable;
import com.dataiku.dip.recipes.RecipeDesc;
import com.dataiku.dip.recipes.RecipeMeta;
import com.dataiku.dip.recipes.RecipeParams;
import com.dataiku.dip.recipes.RecipeRunner;
import com.dataiku.dip.recipes.RecipeSchemaComputer;
import com.dataiku.dip.recipes.code.hive.HiveRecipeMeta;
import com.dataiku.dip.recipes.common.RecipeCreator;
import com.dataiku.dip.recipes.common.RecipeStatusComputer;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.DataLineageService;
import com.dataiku.dip.spark.InputDatasetsReadParams;
import com.dataiku.dip.spark.SparkOverrideConfig;
import com.dataiku.dip.sql.OracleSQLDialect;
import com.dataiku.dip.sql.queries.ExpressionUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class WindowRecipeMeta
extends RecipeMeta
implements BasicRecipeLineageHandler,
MetaWithContainerizablePayload {
    public static final WindowRecipeMeta META = new WindowRecipeMeta();
    private static final DKULogger logger = DKULogger.getLogger((String)"dip.recipe.window");

    @Override
    public Class<? extends RecipeParams> paramsClass() {
        return NoParams.class;
    }

    @Override
    public String getType() {
        return "window";
    }

    @Override
    public RecipeRunner buildRunner(JobActivity activity) {
        return new WindowRecipeRunner(activity);
    }

    @Override
    public RecipeMeta.OutputSchemaComputability getOutputSchemasComputability() {
        return RecipeMeta.OutputSchemaComputability.RELIABLE_STATIC;
    }

    @Override
    public RecipeSchemaComputer buildSchemaComputer(AuthCtx authCtx, JobActivity activity) {
        return new WindowRecipeSchemaComputer(authCtx, activity);
    }

    @Override
    public RecipeCreator buildCreator(AuthCtx authCtx) {
        return new WindowRecipeCreator(authCtx, this);
    }

    @Override
    public RecipeStatusComputer buildStatusComputer(SerializedRecipe recipe, String payload) {
        return new WindowRecipeStatusComputer(recipe, payload);
    }

    @Override
    public RecipeDesc getRecipeDesc() {
        return this.getRecipeDesc("en");
    }

    @Override
    public RecipeDesc getRecipeDesc(String lang) {
        TranslationService ts = (TranslationService)SpringUtils.getBean(TranslationService.class);
        return RecipeDesc.newSisoDesc(ts.translateNoContext(lang, "RECIPE.WINDOW.NAME", "window", new Object[0]), null).multiEngine(true);
    }

    @Override
    public RecipeMeta.RecipeCategoryFlags getCategoryFlags() {
        return new RecipeMeta.RecipeCategoryFlags().withVisualSQL().withVisualRecipe();
    }

    @Override
    public boolean hasJsonPayload() {
        return true;
    }

    @Override
    public SparkOverrideConfig getSparkConf(SerializedRecipe sr, String payload) {
        WindowRecipePayloadParams params = (WindowRecipePayloadParams)JSON.parse((String)payload, WindowRecipePayloadParams.class);
        return params.engineParams.sparkSQL.sparkConfig;
    }

    @Override
    public String setSparkConf(SerializedRecipe sr, String payload, SparkOverrideConfig config) {
        WindowRecipePayloadParams params = (WindowRecipePayloadParams)JSON.parse((String)payload, WindowRecipePayloadParams.class);
        params.engineParams.sparkSQL.sparkConfig = config;
        return JSON.pretty((Object)params);
    }

    @Override
    public String setEngine(SerializedRecipe sr, String payload, String engine) {
        WindowRecipePayloadParams params = (WindowRecipePayloadParams)JSON.parse((String)payload, WindowRecipePayloadParams.class);
        params.engineType = engine;
        return JSON.pretty((Object)params);
    }

    @Override
    public String setImpalaMode(SerializedRecipe sr, String payload, boolean runInStreamMode) {
        WindowRecipePayloadParams params = (WindowRecipePayloadParams)JSON.parse((String)payload, WindowRecipePayloadParams.class);
        params.engineParams.impala.forceStreamMode = runInStreamMode;
        return JSON.pretty((Object)params);
    }

    @Override
    public HiveRecipeMeta.HiveExecutionEngine getHiveEngine(SerializedRecipe sr, String payload) {
        WindowRecipePayloadParams params = (WindowRecipePayloadParams)JSON.parse((String)payload, WindowRecipePayloadParams.class);
        return params.engineParams.hive.executionEngine;
    }

    @Override
    public String setHiveEngine(SerializedRecipe sr, String payload, HiveRecipeMeta.HiveExecutionEngine executionEngine) {
        WindowRecipePayloadParams params = (WindowRecipePayloadParams)JSON.parse((String)payload, WindowRecipePayloadParams.class);
        params.engineParams.hive.executionEngine = executionEngine;
        return JSON.pretty((Object)params);
    }

    @Override
    public String setSparkEngine(SerializedRecipe sr, String payload, AbstractSparkRecipeParams.SparkExecutionEngine executionEngine) {
        WindowRecipePayloadParams params = (WindowRecipePayloadParams)JSON.parse((String)payload, WindowRecipePayloadParams.class);
        params.engineParams.sparkSQL.executionEngine = executionEngine;
        return JSON.pretty((Object)params);
    }

    @Override
    public InputDatasetsReadParams getInputDatasetsReadParams(SerializedRecipe sr, String payload) {
        return ((WindowRecipePayloadParams)JSON.parse((String)payload, WindowRecipePayloadParams.class)).engineParams.sparkSQL.readParams;
    }

    @Override
    public String setInputDatasetsReadParams(SerializedRecipe sr, String payload, InputDatasetsReadParams inputDatasetsReadParams) {
        WindowRecipePayloadParams params = (WindowRecipePayloadParams)JSON.parse((String)payload, WindowRecipePayloadParams.class);
        params.engineParams.sparkSQL.readParams = inputDatasetsReadParams;
        return JSON.pretty((Object)params);
    }

    @Override
    public RecipePipelineHelper buildPipelineHelper(SerializedRecipe recipe, String payload, RecipePipelineHelper.PipelineType pipelineType, AuthCtx authCtx, JobActivity jobActivity) {
        return new WindowRecipePipelineHelper(authCtx, recipe, payload, pipelineType, jobActivity);
    }

    @Override
    public ContainerExecSelection getContainerExecSelection(SerializedRecipe sr, String payload) {
        WindowRecipePayloadParams params = (WindowRecipePayloadParams)JSON.parse((String)payload, WindowRecipePayloadParams.class);
        return params.getContainerSelection();
    }

    @Override
    public Class<? extends ParamsWithContainerizable> getContainerizableBearingParamsClass() {
        return WindowRecipePayloadParams.class;
    }

    @Override
    public RecipeLineage getRecipeLineage(DataLineageService.SerializedGraphNodes predecessors, DataLineageService.SerializedGraphNodes successors, String payload, AuthCtx authCtx, JobActivity activity, SerializedRecipe serializedRecipe) {
        DatasetPairLineage datasetPairLineage;
        if (predecessors.datasets.isEmpty() || successors.datasets.isEmpty()) {
            return new RecipeLineage();
        }
        Preconditions.checkArgument((predecessors.datasets.size() == 1 ? 1 : 0) != 0, (Object)"Window recipe can have only one input dataset");
        Preconditions.checkArgument((successors.datasets.size() == 1 ? 1 : 0) != 0, (Object)"Window recipe can have only one output dataset");
        SerializedDataset inputDataset = predecessors.datasets.get(0);
        SerializedDataset outputDataset = successors.datasets.get(0);
        WindowRecipePayloadParams payloadParams = (WindowRecipePayloadParams)JSON.parse((String)payload, WindowRecipePayloadParams.class);
        RecipeLineage recipeLineage = this.buildBasicRecipeLineage((BasicRecipeLineageHandler.Params)payloadParams, inputDataset, outputDataset);
        Schema inputSchema = inputDataset.getSchema();
        OracleSQLDialect dialect = inputDataset.type.equals(BuiltinSQLDatasets.ORACLE_META.getType()) ? new OracleSQLDialect(authCtx, Dataset.fromSerialized(inputDataset)) : null;
        SchemaUtils.SafeColumnIdentifierSuffixer safeSuffixer = new SchemaUtils.SafeColumnIdentifierSuffixer(dialect == null ? null : Integer.valueOf(dialect.getIdentifiersMaxLength()), inputSchema);
        List<WindowRecipePayloadParams.WindowValue> resolvedWindowValues = payloadParams.getResolvedWindowValues(inputSchema);
        for (WindowRecipePayloadParams.WindowDesc window : payloadParams.windows) {
            Object prefix = StringUtils.isBlank((String)window.prefix) ? "" : window.prefix + "_";
            for (WindowRecipePayloadParams.WindowValue windowValue : resolvedWindowValues) {
                if (windowValue.column == null) continue;
                SchemaColumn inputSchemaColumn = ExpressionUtils.getSchemaColumn(windowValue.column, inputSchema, payloadParams.computedColumns);
                ArrayList<SchemaColumn> derivedColumns = windowValue.getDerivedColumns(inputSchemaColumn, safeSuffixer, (String)prefix, dialect);
                for (SchemaColumn derivedColumn : derivedColumns) {
                    String outputColumnName = derivedColumn.getName();
                    recipeLineage.addFactorizedColumnRelations(windowValue.column, outputColumnName, inputDataset, outputDataset);
                    this.addPartitioningAndOrderingColumnsRelations(window, recipeLineage, derivedColumn.getName(), inputDataset, outputDataset);
                }
                this.addRankingFunctionsColumnsRelations(payloadParams, recipeLineage, window, (String)prefix, inputDataset, outputDataset);
                String outputColumnName = windowValue.column;
                recipeLineage.addFactorizedColumnRelations(windowValue.column, outputColumnName, inputDataset, outputDataset);
            }
        }
        if (WindowRecipePayloadParams.RetrievedColumnsSelectionMode.EXPLICIT.equals((Object)payloadParams.retrievedColumnsSelectionMode) && (datasetPairLineage = recipeLineage.getDatasetPairLineage(inputDataset.getFullName(), outputDataset.getFullName())) != null) {
            for (WindowRecipePayloadParams.WindowValue windowValue : resolvedWindowValues) {
                if (windowValue.value) continue;
                datasetPairLineage.removeRelationsOnColumn(windowValue.column);
            }
        }
        this.handleColumnNameOverrides(payloadParams, recipeLineage);
        recipeLineage.keepValidRelations();
        return recipeLineage;
    }

    private void addPartitioningAndOrderingColumnsRelations(WindowRecipePayloadParams.WindowDesc window, RecipeLineage recipeLineage, String outputColumnName, SerializedDataset inputDataset, SerializedDataset outputDataset) {
        if (window.enablePartitioning) {
            window.partitioningColumns.forEach(column -> recipeLineage.addFactorizedColumnRelations((String)column, outputColumnName, inputDataset, outputDataset));
        }
        if (window.enableOrdering) {
            window.orders.forEach(order -> recipeLineage.addFactorizedColumnRelations(order.column, outputColumnName, inputDataset, outputDataset));
        }
    }

    private void addRankingFunctionsColumnsRelations(WindowRecipePayloadParams payloadParams, RecipeLineage recipeLineage, WindowRecipePayloadParams.WindowDesc window, String prefix, SerializedDataset inputDataset, SerializedDataset outputDataset) {
        String columnName;
        if (payloadParams.rank) {
            columnName = prefix + "rank";
            this.addPartitioningAndOrderingColumnsRelations(window, recipeLineage, columnName, inputDataset, outputDataset);
        }
        if (payloadParams.denseRank) {
            columnName = prefix + "denserank";
            this.addPartitioningAndOrderingColumnsRelations(window, recipeLineage, columnName, inputDataset, outputDataset);
        }
        if (payloadParams.ntile) {
            columnName = prefix + "ntile" + payloadParams.ntileValues;
            this.addPartitioningAndOrderingColumnsRelations(window, recipeLineage, columnName, inputDataset, outputDataset);
        }
        if (payloadParams.rowNumber) {
            columnName = prefix + "rownumber";
            this.addPartitioningAndOrderingColumnsRelations(window, recipeLineage, columnName, inputDataset, outputDataset);
        }
        if (payloadParams.cumeDist) {
            columnName = prefix + "cumedist";
            this.addPartitioningAndOrderingColumnsRelations(window, recipeLineage, columnName, inputDataset, outputDataset);
        }
    }
}

