/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.kernel.master;

import com.dataiku.common.server.APIError;
import com.dataiku.common.server.SerializedError;
import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.DKUApp;
import com.dataiku.dip.exceptions.ExceptionWithDebuggingHint;
import com.dataiku.dip.exceptions.ProcessDiedException;
import com.dataiku.dip.hadoop.HadoopLoader;
import com.dataiku.dip.kernels.DSSKernelManagerBase;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.rpc.EncryptedRPC;
import com.dataiku.dip.server.SharedSecretUtils;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.InheritableNDC;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.MainUtils;
import com.dataiku.dip.utils.PerfUtils;
import com.dataiku.dip.utils.SmartLogTail;
import com.dataiku.dip.utils.StreamUtils;
import com.dataiku.dss.shadelib.org.apache.commons.io.IOUtils;
import com.dataiku.dss.shadelib.org.apache.http.HttpResponse;
import com.dataiku.dss.shadelib.org.apache.http.NoHttpResponseException;
import com.dataiku.dss.shadelib.org.apache.http.client.HttpClient;
import com.dataiku.dss.shadelib.org.apache.http.client.methods.HttpPost;
import com.dataiku.dss.shadelib.org.apache.http.client.methods.HttpUriRequest;
import com.dataiku.dss.shadelib.org.apache.http.conn.ClientConnectionManager;
import com.dataiku.dss.shadelib.org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import com.dataiku.dss.shadelib.org.apache.http.conn.ssl.NoopHostnameVerifier;
import com.dataiku.dss.shadelib.org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import com.dataiku.dss.shadelib.org.apache.http.impl.client.DefaultHttpClient;
import com.dataiku.dss.shadelib.org.apache.http.impl.client.HttpClients;
import com.dataiku.dss.shadelib.org.apache.http.impl.conn.PoolingClientConnectionManager;
import com.dataiku.dss.shadelib.org.apache.http.params.HttpConnectionParams;
import com.dataiku.dss.shadelib.org.apache.http.params.HttpParams;
import com.dataiku.dss.shadelib.org.apache.http.ssl.SSLContexts;
import com.dataiku.hproxy.model.PingResponse;
import com.google.common.collect.Lists;
import com.google.gson.JsonParseException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class JobExecutionKernelHandle
implements DSSKernelManagerBase.KernelHandle {
    private final String id;
    private final int startTimeoutMs = ApplicationConfigurator.getParams().getIntParam("dku.jek.start.timeout.ms", Integer.valueOf(600000));
    private final int pingTimeoutMs = ApplicationConfigurator.getParams().getIntParam("dku.jek.ping.timeout.ms", Integer.valueOf(30000));
    private volatile int port;
    private volatile int jvmPID;
    private Process process = null;
    private Integer savedReturnCode;
    private final HttpClient client;
    protected DKUtils.SmartLogTailBuilder smartLogTailBuilder = new DKUtils.SmartLogTailBuilder();
    private Exception processExitException;
    private KernelMonitorThread thread;
    private LoggingThread stdoutThread;
    private LoggingThread stderrThread;
    private Thread shutdownHook;
    private String currentJobProjectKey;
    private String currentJobId;
    static Logger logger = Logger.getLogger((String)"dku.jobs.kernel");

    private File getJobFolder() {
        assert (this.currentJobProjectKey != null);
        return ApplicationConfigurator.getFile((String[])new String[]{"jobs", this.currentJobProjectKey, this.currentJobId});
    }

    public int getPid() {
        return DKUtils.getPid((Process)this.process);
    }

    public int getJvmPID() {
        return this.jvmPID;
    }

    public synchronized void log(String line) {
        if (this.currentJobId == null) {
            logger.info((Object)line);
        } else {
            try (FileOutputStream fos = new FileOutputStream(new File(this.getJobFolder(), "output.log"), true);
                 OutputStreamWriter wr = new OutputStreamWriter((OutputStream)fos, StandardCharsets.UTF_8);){
                ((Writer)wr).append(DKUtils.isoFormatPretty((long)System.currentTimeMillis()) + ": " + line);
                ((Writer)wr).append("\n");
            }
            catch (Exception e) {
                logger.warn((Object)"Failed to log", (Throwable)e);
                logger.info((Object)line);
            }
        }
    }

    private File getTempDirectory() {
        return DKUApp.getFile((String[])new String[]{"tmp", "jeks", this.id});
    }

    public JobExecutionKernelHandle(String id) {
        this.id = id;
        if (EncryptedRPC.enabled()) {
            SSLContext sslContext = null;
            try {
                sslContext = SSLContexts.custom().loadTrustMaterial(null, (cert, authType) -> true).build();
            }
            catch (Exception e) {
                throw new RuntimeException("SSL failure", e);
            }
            SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
            this.client = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf).addInterceptorFirst(PerfUtils.MARK_HTTP_REQUEST_INTERCEPTOR).build();
        } else {
            DefaultHttpClient defaultHttpClient = new DefaultHttpClient((ClientConnectionManager)new PoolingClientConnectionManager());
            defaultHttpClient.addRequestInterceptor(PerfUtils.MARK_HTTP_REQUEST_INTERCEPTOR);
            this.client = defaultHttpClient;
        }
        this.shutdownHook = new Thread(new Runnable(){

            @Override
            public void run() {
                if (JobExecutionKernelHandle.this.process != null) {
                    JobExecutionKernelHandle.this.process.destroy();
                }
            }
        });
        Runtime.getRuntime().addShutdownHook(this.shutdownHook);
    }

    private synchronized void tryUnregisterHook() {
        if (this.shutdownHook != null) {
            try {
                Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
            }
            catch (Throwable t) {
                logger.warn((Object)"Failed to remove shutdownHook", t);
            }
            this.shutdownHook = null;
        }
    }

    public void start() throws Exception {
        ProcessBuilder pb = new ProcessBuilder(new String[0]);
        String binary = System.getenv("DKUJEKBIN");
        if (binary == null) {
            throw new Error("environment variable DKUJEKBIN not defined");
        }
        File binaryF = new File(binary);
        pb.command(Lists.newArrayList((Object[])new String[]{binaryF.getAbsolutePath(), this.id}));
        if (HadoopLoader.isKerberosLoginEnabled()) {
            HadoopLoader.addTicketCacheEnvVar(pb.environment());
        }
        SharedSecretUtils.getSharedSecret((boolean)true);
        File processTmp = this.getTempDirectory();
        DKUFileUtils.mkdirs((File)processTmp);
        pb.environment().put("DKU_JAVA_TMP_DIR", processTmp.getAbsolutePath());
        logger.info((Object)("Starting Kernel process for kernel  " + this.id));
        this.process = pb.start();
        logger.info((Object)("Kernel started on pid " + DKUtils.getPid((Process)this.process)));
        this.thread = new KernelMonitorThread();
        this.thread.start();
        try {
            this.waitStarted();
        }
        catch (InterruptedException e) {
            logger.error((Object)"JEK aborted during start", (Throwable)e);
            try {
                this.killWithoutMercy();
            }
            catch (Exception e2) {
                logger.warn((Object)"JEK aborted, but cleanup failed", (Throwable)e2);
            }
            throw e;
        }
    }

    public void killWithoutMercy() throws IOException, InterruptedException {
        logger.warn((Object)("Killing kernel " + this.getId() + " pid=" + DKUtils.getPid((Process)this.process)));
        if (this.process != null) {
            assert (this.thread != null);
            DKUtils.killProcessTree((Process)this.process);
            this.tryUnregisterHook();
            this.thread.join();
            this.thread = null;
        }
    }

    private void waitStarted() throws Exception {
        int loops = 0;
        long start = System.nanoTime();
        while (System.nanoTime() - start < (long)this.startTimeoutMs * 1000000L) {
            ++loops;
            if (this.process == null) {
                logger.error((Object)"Job execution process died before start");
                throw new Exception("Job execution process died before start", this.processExitException);
            }
            if (this.port == 0) {
                if (loops % 50 == 0) {
                    logger.info((Object)"Job execution kernel has not yet registered");
                }
            } else {
                try {
                    this.ping();
                    return;
                }
                catch (Exception e) {
                    logger.info((Object)("Kernel has registered but is not yet ready:" + e.getMessage()));
                }
            }
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedException("Waiting for start of job kernel was interrupted");
            }
            DKUtils.unsafeSleep((long)50L);
        }
        throw new Exception("Timeout reached when starting new kernel: " + this.startTimeoutMs + "ms");
    }

    <T> T executeCommand(String command, Object arg, Class<T> responseClazz, int timeout) throws IOException {
        try {
            HttpPost pm = null;
            pm = EncryptedRPC.enabled() ? new HttpPost("https://localhost:" + this.port + "/kernel/pintercom/" + command) : new HttpPost("http://localhost:" + this.port + "/kernel/pintercom/" + command);
            pm.setHeader("X-DKU-IPythonSharedSecret", SharedSecretUtils.getSharedSecret((boolean)true));
            if (arg != null) {
                pm.setEntity(JSON.toHttpEntity((Object)arg));
            }
            HttpConnectionParams.setConnectionTimeout((HttpParams)pm.getParams(), (int)timeout);
            HttpConnectionParams.setSoTimeout((HttpParams)pm.getParams(), (int)timeout);
            HttpResponse resp = this.client.execute((HttpUriRequest)pm);
            int code = resp.getStatusLine().getStatusCode();
            String ret = new String(IOUtils.toByteArray((InputStream)resp.getEntity().getContent()), "utf8");
            pm.releaseConnection();
            if (code != 200) {
                logger.error((Object)("Received error to command " + command + " httpcode " + code));
                logger.error((Object)("Body " + ret));
                try {
                    SerializedError apiErr = (SerializedError)JSON.parse((String)ret, SerializedError.class);
                    throw new APIError.SerializedErrorException(apiErr);
                }
                catch (JsonParseException jsonParseException) {
                    throw new IOException("Method failed: " + code + "/" + ret);
                }
            }
            return (T)JSON.parse((String)ret, responseClazz);
        }
        catch (NoHttpResponseException e) {
            Integer returnCode = null;
            for (int i = 0; i < 10; ++i) {
                DKUtils.unsafeSleep((long)100L);
                returnCode = this.savedReturnCode;
                if (returnCode != null) break;
            }
            if (returnCode != null) {
                SmartLogTail tail = null;
                if (this.smartLogTailBuilder != null) {
                    tail = this.smartLogTailBuilder.get();
                }
                if (returnCode == 137) {
                    throw new ProcessDiedException("Job process died (killed - maybe out of memory ?)", tail, ExceptionWithDebuggingHint.DebuggingHint.CHECK_JOB_LOG, returnCode.intValue());
                }
                if (returnCode == 0) {
                    throw new ProcessDiedException("Job process died - without error code", tail, ExceptionWithDebuggingHint.DebuggingHint.CHECK_JOB_LOG, returnCode.intValue());
                }
                throw new ProcessDiedException("Job process died (exit code: " + returnCode + ")", tail, ExceptionWithDebuggingHint.DebuggingHint.CHECK_JOB_LOG, returnCode.intValue());
            }
            throw new ProcessDiedException("Job process seems to have died", (Throwable)e);
        }
    }

    public String getId() {
        return this.id;
    }

    public void sentence() {
        throw new UnsupportedOperationException("should not arrive here (yet)");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setJob(String projectKey, String id) {
        JobExecutionKernelHandle jobExecutionKernelHandle = this;
        synchronized (jobExecutionKernelHandle) {
            this.currentJobId = id;
            this.currentJobProjectKey = projectKey;
            try (FileOutputStream fos = new FileOutputStream(new File(this.getJobFolder(), "output.log"), true);
                 OutputStreamWriter wr = new OutputStreamWriter((OutputStream)fos, StandardCharsets.UTF_8);){
                for (String line : MainUtils.getHelloMessages((String)"jek")) {
                    ((Writer)wr).append(line);
                    ((Writer)wr).append("\n");
                }
            }
            catch (Exception e) {
                logger.warn((Object)"Unable to write context info header in log", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        JobExecutionKernelHandle jobExecutionKernelHandle = this;
        synchronized (jobExecutionKernelHandle) {
            this.currentJobId = null;
            this.currentJobProjectKey = null;
        }
    }

    public void ping() throws IOException {
        if (this.process == null) {
            throw new IOException("Process has died");
        }
        this.executeCommand("ping", new PingRequest(), PingResponse.class, this.pingTimeoutMs);
    }

    public boolean isSentenced() {
        throw new IllegalArgumentException("JEK cannot be sentenced (yet)");
    }

    public void checkHealthAtEnd() {
        throw new IllegalArgumentException("JEK has not health check (yet)");
    }

    public void acquire(String jobId, AuthCtx authCtx, String projectKey) {
        this.setJob(projectKey, jobId);
    }

    public void onRegister(int port, int jvmPID) {
        logger.info((Object)("Registered kernel " + this.id + " on port " + port));
        this.port = port;
        this.jvmPID = jvmPID;
    }

    class KernelMonitorThread
    extends Thread {
        KernelMonitorThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Thread.currentThread().setName(JobExecutionKernelHandle.this.id + "-monitor-" + Thread.currentThread().getId());
            try {
                JobExecutionKernelHandle.this.stdoutThread = new LoggingThread(JobExecutionKernelHandle.this.process.getInputStream(), Level.INFO);
                JobExecutionKernelHandle.this.stderrThread = new LoggingThread(JobExecutionKernelHandle.this.process.getErrorStream(), Level.INFO);
                JobExecutionKernelHandle.this.stdoutThread.start();
                JobExecutionKernelHandle.this.stderrThread.start();
                int rv = JobExecutionKernelHandle.this.process.waitFor();
                logger.info((Object)("Process done with code " + rv));
                JobExecutionKernelHandle jobExecutionKernelHandle = JobExecutionKernelHandle.this;
                synchronized (jobExecutionKernelHandle) {
                    JobExecutionKernelHandle.this.process = null;
                    JobExecutionKernelHandle.this.tryUnregisterHook();
                    JobExecutionKernelHandle.this.savedReturnCode = rv;
                }
                if (rv != 0) {
                    JobExecutionKernelHandle.this.processExitException = new IOException("Kernel process return code is " + rv);
                }
                JobExecutionKernelHandle.this.stdoutThread.join();
                JobExecutionKernelHandle.this.stderrThread.join();
                JobExecutionKernelHandle.this.stdoutThread = null;
                JobExecutionKernelHandle.this.stderrThread = null;
                File processTmp = JobExecutionKernelHandle.this.getTempDirectory();
                logger.debug((Object)("Cleaning up JEK temporary folder " + String.valueOf(processTmp)));
                try {
                    DKUFileUtils.forceDelete((File)processTmp);
                }
                catch (IOException e) {
                    logger.warn((Object)("Failed to cleanup JEK temporary folder " + String.valueOf(processTmp)));
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    static class PingRequest {
        PingRequest() {
        }
    }

    class LoggingThread
    extends Thread {
        private InputStream is;
        private Level level;

        public LoggingThread(InputStream is, Level level) {
            this.is = is;
            this.level = level;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Thread.currentThread().setName(JobExecutionKernelHandle.this.id + "-log-" + Thread.currentThread().getId());
            InheritableNDC.inheritNDC();
            try {
                String line;
                BufferedReader br = StreamUtils.readStream((InputStream)this.is);
                while ((line = br.readLine()) != null) {
                    JobExecutionKernelHandle jobExecutionKernelHandle = JobExecutionKernelHandle.this;
                    synchronized (jobExecutionKernelHandle) {
                        if (JobExecutionKernelHandle.this.currentJobId == null) {
                            logger.info((Object)line);
                        } else {
                            try (FileOutputStream fos = new FileOutputStream(new File(JobExecutionKernelHandle.this.getJobFolder(), "output.log"), true);
                                 OutputStreamWriter wr = new OutputStreamWriter((OutputStream)fos, "utf8");){
                                ((Writer)wr).append(line);
                                ((Writer)wr).append("\n");
                            }
                        }
                    }
                    JobExecutionKernelHandle.this.smartLogTailBuilder.appendLine(line);
                }
            }
            catch (IOException e) {
                logger.warn((Object)"Failed to log line ", (Throwable)e);
            }
        }
    }
}

