/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.kernel.slave;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.BuiltinsLoader;
import com.dataiku.dip.DKUApp;
import com.dataiku.dip.cli.CLISetup;
import com.dataiku.dip.cluster.ClusterSelector;
import com.dataiku.dip.cluster.HadoopSettings;
import com.dataiku.dip.dataflow.JobKernelUtils;
import com.dataiku.dip.dataflow.jobrunner.PerJobLoggingAppender;
import com.dataiku.dip.dataflow.kernel.slave.KernelServlet;
import com.dataiku.dip.hadoop.HadoopLoader;
import com.dataiku.dip.io.DockerSimplePythonKernel;
import com.dataiku.dip.io.KubernetesSimplePythonKernel;
import com.dataiku.dip.io.LocalSimplePythonKernel;
import com.dataiku.dip.io.PortRangeParams;
import com.dataiku.dip.logging.MainLoggingConfigurator;
import com.dataiku.dip.plugins.PluginsLoadService;
import com.dataiku.dip.remoterun.RemoteRunNetworkingUtils;
import com.dataiku.dip.rpc.LocalBackendPrivilegedIntercomAPIClient;
import com.dataiku.dip.server.SharedSecretUtils;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.spark.yarnaware.YarnClusterSSHTunnelRegistry;
import com.dataiku.dip.util.DKUExecutors;
import com.dataiku.dip.util.PoiUtils;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.SystemUtils;
import com.dataiku.dss.shadelib.org.eclipse.jetty.server.Server;
import com.dataiku.dss.shadelib.org.eclipse.jetty.server.ServerConnector;
import jakarta.servlet.http.HttpServlet;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.BindException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.function.Supplier;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Appender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;

public class DSSJobKernelMain {
    private static int port = 0;
    private static String host = "127.0.0.1";
    private static final Logger logger = Logger.getLogger((String)"dku.job");

    private static void setupJobLogging() {
        PerJobLoggingAppender appender = new PerJobLoggingAppender(false);
        String pattern = "%-4r [%t] %-5p %c %x - %m%n";
        Enumeration enumeration = Logger.getRootLogger().getAllAppenders();
        while (enumeration.hasMoreElements()) {
            Appender a = (Appender)enumeration.nextElement();
            if (a.getLayout() == null || !(a.getLayout() instanceof PatternLayout)) continue;
            PatternLayout pl = (PatternLayout)a.getLayout();
            pattern = pl.getConversionPattern();
        }
        appender.setLayout((Layout)new PatternLayout(pattern));
        Logger.getRootLogger().addAppender((Appender)appender);
        LocalSimplePythonKernel.loggerNotAdditive.addAppender((Appender)appender);
        DockerSimplePythonKernel.loggerNotAdditive.addAppender((Appender)appender);
        KubernetesSimplePythonKernel.loggerNotAdditive.addAppender((Appender)appender);
    }

    public static void main(String[] args) {
        SystemUtils.runAndExitIfExceptionIsThrown(() -> DSSJobKernelMain.runJekServer(args));
    }

    public static void runJekServer(String[] args) throws Exception {
        System.setProperty("DIP_HOME", System.getenv("DIP_HOME"));
        ApplicationConfigurator.autoconfigure();
        ApplicationConfigurator.setProcessType((MainLoggingConfigurator.ProcessType)MainLoggingConfigurator.ProcessType.JEK);
        MainLoggingConfigurator.configure((MainLoggingConfigurator.ProcessType)MainLoggingConfigurator.ProcessType.JEK);
        ClusterSelector.setContext(MainLoggingConfigurator.ProcessType.JEK);
        System.setProperty("h2.bindAddress", "127.0.0.1");
        String id = args[0];
        logger.info((Object)("Job kernel " + id + " starting, process: " + ManagementFactory.getRuntimeMXBean().getName()));
        DSSJobKernelMain.setupJobLogging();
        int poolSize = DKUApp.getProperty((String)"dku.jek.initThreadPool.size", (int)10);
        try (DKUExecutors.DKUExecutor executorService = new DKUExecutors.DKUExecutor(poolSize, "runJEKStartup-%d", 60000);){
            int delayForTest = DKUApp.getProperty((String)"dku.jek.forTest.builtinsLoader.startupDelayMs", (int)0);
            BuiltinsLoader.load(executorService, delayForTest);
            AnnotationConfigApplicationContext appContext = CLISetup.doJEKSetup();
            executorService.waitFutures();
            logger.info((Object)"Spring beans initialized, refreshing AppContext");
            CLISetup.refreshAppContext(appContext);
            logger.info((Object)"AppContext refreshed, starting server");
            PluginsLoadService pluginsLoadService = (PluginsLoadService)SpringUtils.getBean(PluginsLoadService.class);
            pluginsLoadService.loadPluginsAsync(executorService);
            executorService.submit(MainLoggingConfigurator::configureLimits);
            executorService.submit(() -> {
                try {
                    HadoopSettings hadoopSettings = new ClusterSelector().selectGlobal().getHadoopSettings();
                    HadoopLoader.initializeSecurity(hadoopSettings, true, false);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
            executorService.submit(() -> {
                if (BuiltinsLoader.apachePoiAvailable()) {
                    PoiUtils.initializePoi();
                }
            });
        }
        new Thread("stdin-watcher"){
            {
                this.setDaemon(true);
            }

            @Override
            public void run() {
                try {
                    while (true) {
                        if (System.in.read() != -1) {
                            continue;
                        }
                        logger.warn((Object)"Standard input closed, exiting");
                        System.exit(0);
                    }
                }
                catch (IOException e) {
                    logger.warn((Object)"Error reading standard input, exiting", (Throwable)e);
                    System.exit(1);
                    return;
                }
            }
        }.start();
        Supplier<HttpServlet> servletProducer = () -> {
            KernelServlet ks = new KernelServlet(SharedSecretUtils.getSharedSecret((boolean)false));
            return ks;
        };
        PortRangeParams dssPortRange = ApplicationConfigurator.getPortRangeParams();
        Server server = null;
        if (!dssPortRange.enabled) {
            server = JobKernelUtils.createServerWithServlet(0, servletProducer, "/kernel/*");
            server.start();
        } else {
            assert (dssPortRange.isValid()) : "Port range not defined properly";
            boolean portFound = false;
            Iterator iterator = dssPortRange.getRange().iterator();
            while (iterator.hasNext()) {
                int portCandidate = (Integer)iterator.next();
                server = JobKernelUtils.createServerWithServlet(portCandidate, servletProducer, "/kernel/*");
                try {
                    server.start();
                    portFound = true;
                    break;
                }
                catch (IOException e) {
                    logger.info((Object)String.format("Task can't use port %d", portCandidate), (Throwable)e);
                }
            }
            if (!portFound) {
                throw new BindException(String.format("Task failed to find usable port in range [%d, %d]", dssPortRange.start, dssPortRange.end));
            }
        }
        port = ((ServerConnector)server.getConnectors()[0]).getLocalPort();
        host = RemoteRunNetworkingUtils.getBackendHost();
        RemoteRunNetworkingUtils.setServer(MainLoggingConfigurator.ProcessType.JEK, port);
        YarnClusterSSHTunnelRegistry.setLocalPort(port);
        logger.info((Object)("Kernel JEK started on port " + port + ", registering it"));
        try {
            LocalBackendPrivilegedIntercomAPIClient apiClient = new LocalBackendPrivilegedIntercomAPIClient();
            int ownPid = DKUtils.getOwnPid();
            logger.info((Object)("Kernel's JVM pid is " + ownPid));
            apiClient.postFormToJSON("/dip/api/pintercom/jobs/kernel-register", Void.class, new Object[]{"kernelId", id, "port", port, "jvmPID", ownPid});
            apiClient.close();
            logger.info((Object)"Registration OK, kernel is now ready");
        }
        catch (Exception e) {
            logger.info((Object)"Registration failed, aborting", (Throwable)e);
            System.exit(1);
        }
        JobKernelUtils.preloadStuffWithExpensiveInitsAfterServerIsReady();
        server.join();
    }

    public static int getKernelPort() {
        if (port == 0) {
            throw new RuntimeException("You're not in a JEK, or the JEK has not been correctly initialized");
        }
        return port;
    }

    public static void setPortDEBUGONLY(int _port) {
        port = _port;
    }

    public static String getKernelHost() {
        if (StringUtils.isBlank((String)host)) {
            throw new RuntimeException("You're not in a JEK, or the JEK has not been correctly initialized");
        }
        return host;
    }

    public static void setHostDEBUGONLY(String _host) {
        host = _host;
    }
}

