/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.pdep;

import com.dataiku.dip.dataflow.pdep.AbstractTimeEvaluator;
import com.dataiku.dip.dataflow.pdep.DateUtils;
import com.dataiku.dip.partitioning.Dimension;
import com.dataiku.dip.partitioning.DimensionValue;
import com.dataiku.dip.partitioning.TimeDimension;
import com.dataiku.dip.partitioning.TimeDimensionValue;
import com.dataiku.dip.shaker.types.Date;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.Params;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class TimeRangeEvaluator
extends AbstractTimeEvaluator {
    private java.util.Date flowEpoch;
    private Params params;

    public TimeRangeEvaluator(Set<java.util.Date> blacklist, java.util.Date flowEpoch, Params params) {
        super(blacklist);
        this.params = params;
        this.flowEpoch = flowEpoch;
    }

    private java.util.Date getTargetDate(TimeDimensionValue targetTDV) {
        java.util.Date targetDate = null;
        switch (targetTDV.getDimension().mappedPeriod) {
            case DAY: {
                targetDate = AbstractTimeEvaluator.parseyyyyMMDD(targetTDV);
                break;
            }
            case HOUR: {
                targetDate = AbstractTimeEvaluator.parseyyyyMMDDHH(targetTDV);
                break;
            }
            case MONTH: {
                targetDate = AbstractTimeEvaluator.parseyyyyMM(targetTDV);
                break;
            }
            case YEAR: {
                targetDate = AbstractTimeEvaluator.parseyyyy(targetTDV);
            }
        }
        return targetDate;
    }

    private void checkGranularityConsistent(Granularity granularity, TimeDimension tSrcDim) {
        switch (tSrcDim.mappedPeriod) {
            case DAY: {
                if (granularity != Granularity.HOUR) break;
                throw ErrorContext.iaef((String)"Cannot have a '%s' granularity since input dimension is day-level", (Object)"HOUR", (Object[])new Object[0]);
            }
            case HOUR: {
                break;
            }
            case MONTH: {
                if (granularity == Granularity.HOUR) {
                    throw ErrorContext.iaef((String)"Cannot have a '%s' granularity since input dimension is month-level", (Object)"HOUR", (Object[])new Object[0]);
                }
                if (granularity != Granularity.DAY) break;
                throw ErrorContext.iaef((String)"Cannot have a '%s' granularity since input dimension is month-level", (Object)"DAY", (Object[])new Object[0]);
            }
            case YEAR: {
                if (granularity == Granularity.HOUR) {
                    throw ErrorContext.iaef((String)"Cannot have a '%s' granularity since input dimension is year-level", (Object)"HOUR", (Object[])new Object[0]);
                }
                if (granularity == Granularity.DAY) {
                    throw ErrorContext.iaef((String)"Cannot have a '%s' granularity since input dimension is year-level", (Object)"DAY", (Object[])new Object[0]);
                }
                if (granularity != Granularity.MONTH) break;
                throw ErrorContext.iaef((String)"Cannot have a '%s' granularity since input dimension is year-level", (Object)"MONTH", (Object[])new Object[0]);
            }
        }
    }

    private void alignToBeg(Granularity granularity, Calendar cal) {
        switch (granularity) {
            case YEAR: {
                DateUtils.alignCalendarToBegOfYear(cal);
                break;
            }
            case MONTH: {
                DateUtils.alignCalendarToBegOfMonth(cal);
                break;
            }
            case DAY: {
                DateUtils.alignCalendarToBegOfDay(cal);
                break;
            }
            case HOUR: {
                DateUtils.alignCalendarToBegOfHour(cal);
            }
        }
    }

    @Override
    public List<DimensionValue> getDependent(DimensionValue target, Dimension srcDim) {
        ArrayList<DimensionValue> ov;
        block45: {
            logger.info((Object)("Eval TimeRange target=" + String.valueOf(target)));
            if (this.blacklist != null) {
                logger.info((Object)("Blacklisted : " + StringUtils.join((Collection)this.blacklist, (String)",")));
            }
            Preconditions.checkArgument((boolean)(srcDim instanceof TimeDimension), (Object)"Partitioning dimension is not a time dimension");
            TimeDimension tSrcDim = (TimeDimension)srcDim;
            java.util.Date now = new java.util.Date(System.currentTimeMillis());
            if (this.params.hasParam("nowDate")) {
                now = new java.util.Date(new Date().msSinceEpoch(this.params.getParam("nowDate")));
            }
            java.util.Date targetDateExact = null;
            if (target == null) {
                targetDateExact = now;
            } else {
                TimeDimensionValue targetTDV = (TimeDimensionValue)target;
                targetDateExact = this.getTargetDate(targetTDV);
            }
            Granularity toDateGranularity = null;
            java.util.Date targetDateBegAligned = null;
            if (target == null) {
                if (!this.params.hasParam("toGranularity")) {
                    throw new IllegalStateException("The toGranularity must be specified");
                }
                toDateGranularity = Granularity.valueOf(this.params.getMandParam("toGranularity").toUpperCase());
                Calendar cal = DKUtils.getUTCCalendar();
                cal.setTime(targetDateExact);
                this.alignToBeg(toDateGranularity, cal);
                targetDateBegAligned = cal.getTime();
            } else {
                TimeDimensionValue targetTDV = (TimeDimensionValue)target;
                Granularity granularityOfTargetDim = Granularity.valueOf(targetTDV.getDimension().mappedPeriod.toString());
                int toOffset = this.params.getIntParam("toOffset");
                toDateGranularity = toOffset != 0 ? Granularity.valueOf(this.params.getMandParam("toGranularity").toUpperCase()) : granularityOfTargetDim;
                Calendar cal = DKUtils.getUTCCalendar();
                cal.setTime(targetDateExact);
                this.alignToBeg(granularityOfTargetDim, cal);
                targetDateBegAligned = cal.getTime();
            }
            this.checkGranularityConsistent(toDateGranularity, tSrcDim);
            FromMode fromMode = FromMode.valueOf(this.params.getMandParam("fromMode").toUpperCase());
            java.util.Date fromDate = null;
            switch (fromMode) {
                case FIXED_DATE: {
                    switch (tSrcDim.mappedPeriod) {
                        case DAY: {
                            fromDate = AbstractTimeEvaluator.parseyyyyMMDD(this.params.getMandParam("fromDate"));
                            break;
                        }
                        case HOUR: {
                            fromDate = AbstractTimeEvaluator.parseyyyyMMDDHH(this.params.getMandParam("fromDate"));
                            break;
                        }
                        case MONTH: {
                            fromDate = AbstractTimeEvaluator.parseyyyyMM(this.params.getMandParam("fromDate"));
                            break;
                        }
                        case YEAR: {
                            fromDate = AbstractTimeEvaluator.parseyyyy(this.params.getMandParam("fromDate"));
                        }
                    }
                    break;
                }
                case RELATIVE_OFFSET: {
                    Calendar fromCal = DKUtils.getUTCCalendar();
                    fromCal.setTime(targetDateBegAligned);
                    Granularity fromGranularity = Granularity.valueOf(this.params.getMandParam("fromGranularity").toUpperCase());
                    this.checkGranularityConsistent(fromGranularity, tSrcDim);
                    int offset = this.params.getIntParam("fromOffset");
                    logger.info((Object)("For from, apply offset " + offset + " at " + String.valueOf((Object)fromGranularity)));
                    switch (fromGranularity) {
                        case YEAR: {
                            fromCal.add(1, -offset);
                            DateUtils.alignCalendarToBegOfYear(fromCal);
                            break;
                        }
                        case DAY: {
                            fromCal.add(5, -offset);
                            DateUtils.alignCalendarToBegOfDay(fromCal);
                            break;
                        }
                        case HOUR: {
                            fromCal.add(10, -offset);
                            DateUtils.alignCalendarToBegOfHour(fromCal);
                            break;
                        }
                        case MONTH: {
                            fromCal.add(2, -offset);
                            DateUtils.alignCalendarToBegOfMonth(fromCal);
                        }
                    }
                    fromDate = fromCal.getTime();
                }
            }
            java.util.Date toDate = null;
            boolean targetGranularityIsPartitionGranularity = false;
            Calendar toCal = DKUtils.getUTCCalendar();
            toCal.setTime(targetDateExact);
            int offset = this.params.getIntParam("toOffset");
            if (offset != 0) {
                this.alignToBeg(toDateGranularity, toCal);
            }
            switch (toDateGranularity) {
                case YEAR: {
                    toCal.add(1, -offset);
                    DateUtils.alignCalendarToEndOfYear(toCal);
                    targetGranularityIsPartitionGranularity = tSrcDim.mappedPeriod == TimeDimension.Period.YEAR;
                    break;
                }
                case DAY: {
                    toCal.add(5, -offset);
                    DateUtils.alignCalendarToEndOfDay(toCal);
                    targetGranularityIsPartitionGranularity = tSrcDim.mappedPeriod == TimeDimension.Period.DAY;
                    break;
                }
                case HOUR: {
                    toCal.add(10, -offset);
                    DateUtils.alignCalendarToEndOfHour(toCal);
                    targetGranularityIsPartitionGranularity = tSrcDim.mappedPeriod == TimeDimension.Period.HOUR;
                    break;
                }
                case MONTH: {
                    toCal.add(2, -offset);
                    DateUtils.alignCalendarToEndOfMonth(toCal);
                    targetGranularityIsPartitionGranularity = tSrcDim.mappedPeriod == TimeDimension.Period.MONTH;
                }
            }
            toDate = toCal.getTime();
            ov = new ArrayList<DimensionValue>();
            Calendar curCal = DKUtils.getUTCCalendar();
            curCal.setTime(toDate);
            curCal.add(14, 1);
            assert (curCal.get(14) == 0);
            assert (curCal.get(13) == 0);
            assert (curCal.get(12) == 0);
            assert (fromDate != null);
            logger.info((Object)("Start iteration from " + DKUtils.isoFormatPretty((java.util.Date)fromDate) + " to " + DKUtils.isoFormatPretty((java.util.Date)curCal.getTime())));
            if (curCal.getTime().before(fromDate)) {
                throw ErrorContext.iaef((String)"Cannot have an end date '%s' that is before the start date '%s'", (Object)DKUtils.isoFormatPretty((java.util.Date)curCal.getTime()), (Object[])new Object[]{DKUtils.isoFormatPretty((java.util.Date)fromDate)});
            }
            do {
                switch (tSrcDim.mappedPeriod) {
                    case DAY: {
                        curCal.add(5, -1);
                        break;
                    }
                    case HOUR: {
                        curCal.add(10, -1);
                        break;
                    }
                    case MONTH: {
                        curCal.add(2, -1);
                        break;
                    }
                    case YEAR: {
                        curCal.add(1, -1);
                        break;
                    }
                    default: {
                        throw new Error("Unsupported period: " + String.valueOf(tSrcDim.mappedPeriod));
                    }
                }
                if (curCal.getTime().before(this.flowEpoch)) {
                    logger.info((Object)("flowEpoch " + String.valueOf(this.flowEpoch) + " reached at " + DKUtils.isoFormatPretty((java.util.Date)curCal.getTime())));
                    break block45;
                }
                if (!this.isBlacklisted(curCal.getTime())) {
                    if (!targetGranularityIsPartitionGranularity && curCal.getTime().after(now)) {
                        logger.info((Object)("Ignoring date AFTER now: " + DKUtils.isoFormatPretty((java.util.Date)curCal.getTime())));
                        continue;
                    }
                    ov.add((DimensionValue)TimeRangeEvaluator.getValueFromCalendar(curCal, (TimeDimension)srcDim));
                    continue;
                }
                logger.info((Object)("date is blacklisted : " + DKUtils.isoFormatPretty((java.util.Date)curCal.getTime())));
            } while (!curCal.getTime().equals(fromDate) && !curCal.getTime().before(fromDate));
            logger.info((Object)("Start date " + String.valueOf(fromDate) + " reached at " + DKUtils.isoFormatPretty((java.util.Date)curCal.getTime())));
        }
        return ov;
    }

    public static enum Granularity {
        YEAR,
        MONTH,
        DAY,
        HOUR;

    }

    public static enum FromMode {
        FIXED_DATE,
        RELATIVE_OFFSET;

    }
}

