/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.pipeline;

import com.dataiku.dip.activity.ConnectionTasksService;
import com.dataiku.dip.connections.SQLConnectionProvider;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.JobAuthCtxService;
import com.dataiku.dip.dataflow.RecipeRunnableSubgraph;
import com.dataiku.dip.dataflow.RunnableSubgraph;
import com.dataiku.dip.dataflow.exec.Initializable;
import com.dataiku.dip.dataflow.graph.ComputableWithPartition;
import com.dataiku.dip.dataflow.graph.FlowComputable;
import com.dataiku.dip.dataflow.graph.FlowDataset;
import com.dataiku.dip.dataflow.pipeline.AccessibilityGraph;
import com.dataiku.dip.dataflow.pipeline.RecipePipelineHelper;
import com.dataiku.dip.dataflow.pipeline.RecipePipelineHelperFactory;
import com.dataiku.dip.dataflow.pipeline.SqlPipelineElement;
import com.dataiku.dip.dataflow.pipeline.SqlPipelineRunnableSubgraph;
import com.dataiku.dip.datasets.sql.AbstractSQLDatasetHandler;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.CodedSQLException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.recipes.code.sql.AbstractSQLQueryLikeRecipeRunner;
import com.dataiku.dip.recipes.code.sql.SQLQueryRecipeUtils;
import com.dataiku.dip.recipes.code.sql.SQLQueryToInsertTransformer;
import com.dataiku.dip.recipes.consistency.RecipeCodes;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.sql.BigQuerySQLDialect;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.SQLUtils;
import com.dataiku.dip.sql.queries.SimpleSelectQueryBuilder;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.variables.VariablesContext;
import com.dataiku.dip.variables.VariablesService;
import com.dataiku.dip.warnings.WarningsContext;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class SqlPipelineRunner
extends AbstractSQLQueryLikeRecipeRunner
implements Initializable {
    private static final String UNION_VIEW_SUFFIX = "_U";
    private static final boolean PRE_WRITE_STATEMENTS = true;
    private static final boolean POST_WRITE_STATEMENTS = false;
    @Autowired
    private JobAuthCtxService authCtxService;
    private final SqlPipelineRunnableSubgraph subgraph;
    private AuthCtx authCtx;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.sql.pipeline.runner");

    public SqlPipelineRunner(JobActivity activity) {
        super(((RecipeRunnableSubgraph)((SqlPipelineRunnableSubgraph)activity.getSubgraph()).getRoot().getSubgraph()).getRecipe().getProjectKey());
        this.activity = activity;
        this.subgraph = (SqlPipelineRunnableSubgraph)this.activity.getSubgraph();
        SpringUtils.getInstance().autowire((Object)this);
    }

    @Override
    public void init() throws Exception {
        this.activity.fillSourceTotalSizes(this.datasetsDAO);
        this.activity.setStatusMessage("Initializing");
        this.authCtx = this.authCtxService.getAuthCtx();
        SQLQueryRecipeUtils.SQLConnections sourceConnections = SQLQueryRecipeUtils.getSourceConnections(this.authCtx, (RecipeRunnableSubgraph)this.subgraph.getRoot().getSubgraph(), this.datasetsDAO);
        this.mainConnection = sourceConnections.firstConnection;
    }

    private static String datasetNamePlusPartitionId(ComputableWithPartition computableWithPartition) {
        return ((FlowDataset)computableWithPartition.computable).getFullName() + "_" + computableWithPartition.partition.id();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() throws Exception {
        SQLConnectionProvider.SQLConnectionData connData = SQLConnectionProvider.getConnectionData_NT(this.authCtx, this.recipeProjectKey, this.mainConnection);
        SQLDialect dialect = connData.getDialect();
        List<JobActivity> activitiesInRunOrder = new AccessibilityGraph(this.subgraph.getAllIncludedActivitiesWithRoot()).orderDepthFirst();
        Set<String> pipelineTargetIds = SqlPipelineRunner.getSubgraphTargetIds(this.subgraph);
        ArrayList<PipelineSqlStatement> pipelineSqlStatements = new ArrayList<PipelineSqlStatement>();
        ArrayList<PipelineSqlStatement> pipelineSetupSqlStatements = new ArrayList<PipelineSqlStatement>();
        ArrayList<PipelineSqlStatement> pipelineTeardownSqlStatements = new ArrayList<PipelineSqlStatement>();
        List<SqlPipelineElement> allPipelineElements = this.getAllPipelineElements(activitiesInRunOrder, dialect);
        HashMap<String, String> viewNamesByVirtualizedPartition = new HashMap<String, String>();
        ConnectionTasksService.SQLQueryRun runningSQL = this.activity.runningThings.addSQL(this.mainConnection);
        try (SQLConnectionProvider.SQLConnectionWrapper conn = SQLConnectionProvider.newConnection(this.mainConnection, this.authCtxService.getAuthCtx(), this.recipeProjectKey);){
            for (SqlPipelineElement sqlPipelineElement : allPipelineElements) {
                String targetTableOrViewName;
                RecipeRunnableSubgraph currentSubgraph = sqlPipelineElement.subgraph;
                boolean isDatasetVirtualized = this.isDatasetVirtualized(pipelineTargetIds, sqlPipelineElement, currentSubgraph);
                Partition targetPartition = sqlPipelineElement.targetPartition;
                Dataset targetDataset = sqlPipelineElement.targetFlowDataset.getMandatory(this.datasetsDAO);
                AbstractSQLDatasetHandler.AbstractSQLConfig targetConfig = (AbstractSQLDatasetHandler.AbstractSQLConfig)targetDataset.getParams();
                logger.debugV("Processing target of subgraph %s", new Object[]{currentSubgraph.id()});
                String targetCatalog = targetConfig.catalog;
                String targetSchemaName = targetConfig.schema;
                ArrayList<PipelineSqlStatement> preWritePipelineSqlStatements = new ArrayList<PipelineSqlStatement>();
                ArrayList<PipelineSqlStatement> postWritePipelineSqlStatements = new ArrayList<PipelineSqlStatement>();
                if (isDatasetVirtualized) {
                    String expandedTargetTable = SQLQueryRecipeUtils.substituteAllAndStripComments(this.authCtx, this.recipeProjectKey, currentSubgraph, targetConfig.table, dialect, sqlPipelineElement.sqlQueryIsCommentFree);
                    targetTableOrViewName = SQLUtils.generateSqlViewName(expandedTargetTable, targetPartition, dialect);
                    logger.infoV("Adding view %s for partition %s of dataset %s", new Object[]{targetTableOrViewName, targetPartition.id(), targetDataset.getFullName()});
                    ComputableWithPartition computableWithPartition = new ComputableWithPartition();
                    computableWithPartition.computable = sqlPipelineElement.targetFlowDataset;
                    computableWithPartition.partition = sqlPipelineElement.targetPartition;
                    viewNamesByVirtualizedPartition.put(SqlPipelineRunner.datasetNamePlusPartitionId(computableWithPartition), targetTableOrViewName);
                } else {
                    targetTableOrViewName = targetConfig.table;
                    InfoMessage.InfoMessages messages = new InfoMessage.InfoMessages();
                    this.initializeTargetTable(this.authCtx, connData, dialect, conn, targetPartition, targetDataset, currentSubgraph.getRecipe(), messages);
                    if (!messages.isEmpty()) {
                        this.activity.warnContext.addWarning(WarningsContext.WarningType.SQL_CREATE_QUERY_WARNING, messages.report("\n"), logger);
                    }
                    preWritePipelineSqlStatements.addAll(this.buildWriteStatements(dialect, targetDataset, targetTableOrViewName, true));
                    postWritePipelineSqlStatements.addAll(this.buildWriteStatements(dialect, targetDataset, targetTableOrViewName, false));
                }
                logger.debugV("Processing sources of subgraph %s and computing potential union views", new Object[]{currentSubgraph.id()});
                HashMap<String, PipelineElementSource> pipelineElementSources = new HashMap<String, PipelineElementSource>();
                for (ComputableWithPartition source : currentSubgraph.getAllSources()) {
                    if (!(source.computable instanceof FlowDataset)) continue;
                    String datasetName = ((FlowDataset)source.computable).getFullName();
                    if (!pipelineElementSources.containsKey(datasetName)) {
                        FlowDataset flowDataset = (FlowDataset)source.computable;
                        Dataset dataset = flowDataset.getMandatory(this.datasetsDAO);
                        AbstractSQLDatasetHandler.AbstractSQLConfig sourceConfig = (AbstractSQLDatasetHandler.AbstractSQLConfig)dataset.getParams();
                        SQLUtils.SQLTable expandedSource = SQLQueryRecipeUtils.substituteAll(this.recipeProjectKey, new SQLUtils.SQLTable(sourceConfig.catalog, sourceConfig.schema, sourceConfig.table));
                        PipelineElementSource pipelineElementSource = new PipelineElementSource(datasetName, expandedSource.getCatalog(), expandedSource.getSchemaNullIfBlank(), expandedSource.getTable(), viewNamesByVirtualizedPartition);
                        pipelineElementSources.put(datasetName, pipelineElementSource);
                    }
                    PipelineElementSource pipelineElementSource = (PipelineElementSource)pipelineElementSources.get(datasetName);
                    pipelineElementSource.addPartition(source);
                }
                HashMap<SQLUtils.SQLTable, SQLUtils.SQLTable> tableToViewNameMapping = new HashMap<SQLUtils.SQLTable, SQLUtils.SQLTable>();
                for (PipelineElementSource source : pipelineElementSources.values()) {
                    tableToViewNameMapping.putAll(source.getTableToViewReplacement(dialect));
                    if (!source.needsUnion()) continue;
                    pipelineSqlStatements.add(source.getUnionStatement(this.authCtx, connData, dialect));
                }
                logger.debugV("Adding pipelined and pre/post-write statements for subgraph %s", new Object[]{currentSubgraph.id()});
                pipelineSqlStatements.addAll(preWritePipelineSqlStatements);
                pipelineSqlStatements.add(this.buildPipelineSqlStatement(this.authCtx, connData, dialect, tableToViewNameMapping, sqlPipelineElement, currentSubgraph, isDatasetVirtualized, targetDataset, targetCatalog, targetSchemaName, targetTableOrViewName));
                pipelineSqlStatements.addAll(postWritePipelineSqlStatements);
                for (String sqlQuery : sqlPipelineElement.setupSqlQueries) {
                    pipelineSetupSqlStatements.add(this.buildPipdelineSetupOrTeardownSqlStatement(this.authCtx, connData, dialect, tableToViewNameMapping, sqlQuery, currentSubgraph, targetDataset));
                }
                for (String sqlQuery : sqlPipelineElement.teardownSqlQueries) {
                    pipelineTeardownSqlStatements.add(this.buildPipdelineSetupOrTeardownSqlStatement(this.authCtx, connData, dialect, tableToViewNameMapping, sqlQuery, currentSubgraph, targetDataset));
                }
            }
            if (!pipelineSetupSqlStatements.isEmpty()) {
                logger.info((Object)"Execute setup statements for pipeline");
                this.executePipelineStatements(dialect, pipelineSetupSqlStatements, connData, conn);
            }
            logger.info((Object)"Execute statements for pipeline");
            this.executePipelineStatements(dialect, pipelineSqlStatements, connData, conn);
            if (!pipelineTeardownSqlStatements.isEmpty()) {
                logger.info((Object)"Execute teardown statements for pipeline");
                this.executePipelineStatements(dialect, pipelineTeardownSqlStatements, connData, conn);
            }
        }
        catch (SQLException e) {
            logger.errorV("A query in the SQL pipeline %s failed", new Object[]{this.activity.id()});
            throw e;
        }
        finally {
            runningSQL.doneOn = System.currentTimeMillis();
            SqlPipelineRunner sqlPipelineRunner = this;
            synchronized (sqlPipelineRunner) {
                this.runTerminated = true;
                this.notifyAll();
            }
        }
        this.activity.setAllSourcesCompletelyRead();
        this.activity.fillTargetWrittenSizes(this.datasetsDAO);
        this.activity.setStatusMessage("Done");
        logger.info((Object)("Finished running SQL Pipeline " + this.activity.id()));
    }

    private List<PipelineSqlStatement> buildWriteStatements(SQLDialect dialect, Dataset targetDataset, String targetTableOrViewName, boolean arePreWriteStatements) {
        ArrayList<PipelineSqlStatement> result = new ArrayList<PipelineSqlStatement>();
        List<String> writeStatements = this.getWriteStatements(dialect, targetDataset, arePreWriteStatements);
        String prefix = arePreWriteStatements ? "pre" : "post";
        String targetNameTemplate = "%sWriteStatement_%s";
        for (String writeStatement : writeStatements) {
            result.add(new PipelineSqlStatement.Builder(writeStatement, String.format(targetNameTemplate, prefix, targetTableOrViewName)).build());
        }
        return result;
    }

    private void executePipelineStatements(SQLDialect dialect, List<PipelineSqlStatement> pipelineSqlStatements, SQLConnectionProvider.SQLConnectionData connData, SQLConnectionProvider.SQLConnectionWrapper conn) throws SQLException {
        StringBuilder errorBuilder = new StringBuilder();
        LinkedList<SQLUtils.SQLTable> createdViews = new LinkedList<SQLUtils.SQLTable>();
        try {
            logger.infoV("Starting to execute pipeline SQL statements for pipeline activity %s", new Object[]{this.activity.id()});
            for (PipelineSqlStatement sqlStatement : pipelineSqlStatements) {
                String currentTargetName = sqlStatement.targetName;
                if (sqlStatement.shouldPrintExecutionPlan) {
                    this.safePrintExecutionPlan(sqlStatement.queryForExecutionPlan, connData, dialect, conn, false);
                }
                this.executeStatement(conn, errorBuilder, sqlStatement.sqlQuery, String.format("Building %s in the SQL pipeline failed. ", currentTargetName));
                if (!sqlStatement.isCreatingView) continue;
                createdViews.addFirst(sqlStatement.view);
            }
            this.cleanupViews(dialect, createdViews, conn, errorBuilder);
            if (dialect.supportsCommitAndRollback()) {
                conn.commit();
            }
        }
        catch (SQLException e) {
            this.attemptToRollbackViews(dialect, createdViews, conn, errorBuilder);
            throw new CodedSQLException(RecipeCodes.ERR_RECIPE_GENERIC_ERROR, errorBuilder.toString(), (Throwable)e);
        }
    }

    private void attemptToRollbackViews(SQLDialect dialect, LinkedList<SQLUtils.SQLTable> orderedViews, SQLConnectionProvider.SQLConnectionWrapper conn, StringBuilder errorBuilder) {
        try {
            if (dialect.supportsCommitAndRollback() && dialect.supportsTransactionalDdl()) {
                errorBuilder.append("Rolling back entire pipeline because of a failure executing a SQL statement.");
                conn.rollback();
            } else {
                errorBuilder.append("SQL dialect does not support automatically rolling back view creation, manually dropping any created views. ");
                this.cleanupViews(dialect, orderedViews, conn, errorBuilder);
                logger.info((Object)"Manual dropping of views appears to have been successful");
                if (dialect.supportsCommitAndRollback()) {
                    conn.rollback();
                }
            }
        }
        catch (SQLException ex) {
            String message = "Error when trying to roll back pipeline. Manual cleanup might be necessary. ";
            logger.warn((Object)message, (Throwable)ex);
            errorBuilder.append(message);
        }
    }

    private void cleanupViews(SQLDialect dialect, LinkedList<SQLUtils.SQLTable> orderedViews, SQLConnectionProvider.SQLConnectionWrapper conn, StringBuilder errorBuilder) throws SQLException {
        for (SQLUtils.SQLTable lastView : orderedViews) {
            String dropView = dialect.getDropViewInstruction(lastView.getCatalog(), lastView.getSchemaNullIfBlank(), lastView.getTable());
            this.executeStatement(conn, errorBuilder, dropView, "Error when cleaning up intermediate pipeline views. ");
        }
    }

    private void executeStatement(SQLConnectionProvider.SQLConnectionWrapper conn, StringBuilder errorBuilder, String sqlStatement, String errorMessage) throws SQLException {
        try (Statement statement = conn.createStatement();){
            this.executeCancellableStatement(conn, statement, sqlStatement);
        }
        catch (SQLException e) {
            errorBuilder.append(errorMessage);
            throw e;
        }
    }

    private static boolean shouldUpdateForBigQuery(boolean isTargetVirtualized, SQLDialect dialect) {
        return isTargetVirtualized && dialect instanceof BigQuerySQLDialect;
    }

    private PipelineSqlStatement buildPipelineSqlStatement(AuthCtx authCtx, SQLConnectionProvider.SQLConnectionData connData, SQLDialect dialect, Map<SQLUtils.SQLTable, SQLUtils.SQLTable> tableViewMapping, SqlPipelineElement sqlPipelineElement, RecipeRunnableSubgraph currentSubgraph, boolean isDatasetVirtualized, Dataset targetDataset, String catalog, String schemaName, String targetTableOrViewName) throws IOException, CodedException, DKUSecurityException, SQLException {
        String expandedSqlQuery = SQLQueryRecipeUtils.substituteAllAndStripComments(authCtx, this.recipeProjectKey, currentSubgraph, sqlPipelineElement.sqlQuery, dialect, sqlPipelineElement.sqlQueryIsCommentFree);
        for (Map.Entry<SQLUtils.SQLTable, SQLUtils.SQLTable> entry : tableViewMapping.entrySet()) {
            expandedSqlQuery = expandedSqlQuery.replace(dialect.getQuotedTableFullName(entry.getKey()), dialect.getQuotedTableFullName(entry.getValue()));
        }
        String transformedQuery = SQLQueryToInsertTransformer.transform(connData, expandedSqlQuery, catalog, schemaName, targetTableOrViewName, targetDataset, sqlPipelineElement.sqlQueryMayContainUnionOrSelect, isDatasetVirtualized);
        String finalQuery = SQLQueryRecipeUtils.substituteAllAndStripComments(authCtx, this.recipeProjectKey, currentSubgraph, transformedQuery, dialect, sqlPipelineElement.sqlQueryIsCommentFree);
        if (SqlPipelineRunner.shouldUpdateForBigQuery(isDatasetVirtualized, dialect)) {
            String replacedQuery = ((BigQuerySQLDialect)dialect).performRegexReplacementForCreatingAView(authCtx, finalQuery, this.getAllSchemaNames(currentSubgraph, schemaName), (SQLConnectionProvider.BigQuerySQLConnectionData)connData);
            if (replacedQuery.equals(finalQuery)) {
                logger.warnV("Attempting to add project id to table and view names in query to build %s resulted in a query that is exactly the same as the original. If the project id is not already present in the query, the SQL pipeline may not work as intended.", new Object[]{targetDataset.getFullName()});
            }
            finalQuery = replacedQuery;
        }
        PipelineSqlStatement.Builder builder = new PipelineSqlStatement.Builder(finalQuery, targetDataset.getName()).shouldPrintExecutionPlan(!isDatasetVirtualized && sqlPipelineElement.needExecutionPlan).queryForExecutionPlan(expandedSqlQuery);
        if (isDatasetVirtualized) {
            builder = builder.withView(SQLQueryRecipeUtils.substituteAll(this.recipeProjectKey, new SQLUtils.SQLTable(catalog, schemaName, targetTableOrViewName)));
        }
        return builder.build();
    }

    private PipelineSqlStatement buildPipdelineSetupOrTeardownSqlStatement(AuthCtx authCtx, SQLConnectionProvider.SQLConnectionData connData, SQLDialect dialect, Map<SQLUtils.SQLTable, SQLUtils.SQLTable> tableViewMapping, String sqlQuery, RecipeRunnableSubgraph currentSubgraph, Dataset targetDataset) throws IOException, CodedException, DKUSecurityException {
        String expandedSqlQuery = SQLQueryRecipeUtils.substituteAllAndStripComments(authCtx, this.recipeProjectKey, currentSubgraph, sqlQuery, dialect, false);
        for (Map.Entry<SQLUtils.SQLTable, SQLUtils.SQLTable> entry : tableViewMapping.entrySet()) {
            expandedSqlQuery = expandedSqlQuery.replace(dialect.getQuotedTableFullName(entry.getKey()), dialect.getQuotedTableFullName(entry.getValue()));
        }
        String finalQuery = SQLQueryRecipeUtils.substituteAllAndStripComments(authCtx, this.recipeProjectKey, currentSubgraph, expandedSqlQuery, dialect, false);
        PipelineSqlStatement.Builder builder = new PipelineSqlStatement.Builder(finalQuery, targetDataset.getName()).shouldPrintExecutionPlan(false);
        return builder.build();
    }

    private List<String> getAllSchemaNames(RecipeRunnableSubgraph subgraph, String targetSchemaName) {
        Set<String> schemaNames = new HashSet<String>();
        if (StringUtils.isNotBlank((String)targetSchemaName)) {
            schemaNames.add(targetSchemaName);
        }
        for (FlowDataset sourceFlowDataset : subgraph.getSourceDatasets()) {
            try {
                Dataset sourceDataset = sourceFlowDataset.getMandatory(this.datasetsDAO);
                AbstractSQLDatasetHandler.AbstractSQLConfig targetConfig = (AbstractSQLDatasetHandler.AbstractSQLConfig)sourceDataset.getParams();
                if (!StringUtils.isNotBlank((String)targetConfig.schema)) continue;
                schemaNames.add(targetConfig.schema);
            }
            catch (IOException e) {
                logger.warnV((Throwable)e, "Unable to get schema name of source dataset %s", new Object[]{sourceFlowDataset.getFullName()});
            }
        }
        if (!schemaNames.isEmpty()) {
            VariablesService variablesService = (VariablesService)SpringUtils.getBean(VariablesService.class);
            VariablesContext variablesContext = variablesService.getForProject(this.recipeProjectKey);
            schemaNames = schemaNames.stream().map(arg_0 -> ((VariablesContext)variablesContext).expand(arg_0)).collect(Collectors.toSet());
        }
        return ImmutableList.copyOf(schemaNames);
    }

    private boolean isDatasetVirtualized(Set<String> pipelineTargetIds, SqlPipelineElement sqlPipelineElement, RecipeRunnableSubgraph currentSubgraph) {
        if (!Collections.disjoint(pipelineTargetIds, SqlPipelineRunner.getSubgraphTargetIds(currentSubgraph))) {
            logger.infoV("Activity %s is a target of the pipeline, so the results will be inserted", new Object[]{sqlPipelineElement.jobActivityId});
            return false;
        }
        logger.infoV("Activity %s is not a target of the pipeline, so the query will be transformed into a view", new Object[]{sqlPipelineElement.jobActivityId});
        return true;
    }

    private List<SqlPipelineElement> getAllPipelineElements(List<JobActivity> activitiesInRunOrder, SQLDialect dialect) throws Exception {
        RecipePipelineHelperFactory pipelineHelperFactory = new RecipePipelineHelperFactory(RecipePipelineHelper.PipelineType.SQL);
        ArrayList<SqlPipelineElement> allPipelineElements = new ArrayList<SqlPipelineElement>();
        for (JobActivity next : activitiesInRunOrder) {
            allPipelineElements.addAll(pipelineHelperFactory.build(next, this.authCtx).generateSqlQueries(next, dialect));
        }
        return allPipelineElements;
    }

    private static Set<String> getSubgraphTargetIds(RunnableSubgraph subgraph) {
        HashSet<String> targetIds = new HashSet<String>();
        for (FlowComputable flowComputable : subgraph.getTargets()) {
            targetIds.add(flowComputable.getFullId());
        }
        return targetIds;
    }

    private static class PipelineElementSource {
        private static final Joiner UNION_ALL_JOINER = Joiner.on((String)" UNION ALL ");
        private final String datasetName;
        private final String catalog;
        private final String schema;
        private final String expandedTableName;
        private final Map<String, String> viewNamesByVirtualizedPartition;
        private final List<SQLUtils.SQLTable> virtualPartitionViews = new ArrayList<SQLUtils.SQLTable>();
        boolean dependsOnNonVirtualizedTable;
        String viewUnionName;

        private PipelineElementSource(String datasetName, String catalog, String schema, String expandedTableName, Map<String, String> viewNamesByVirtualizedPartition) {
            this.datasetName = datasetName;
            this.catalog = catalog;
            this.schema = schema;
            this.expandedTableName = expandedTableName;
            this.viewNamesByVirtualizedPartition = viewNamesByVirtualizedPartition;
        }

        private void addPartition(ComputableWithPartition partition) {
            String computablePlusPartitionId = SqlPipelineRunner.datasetNamePlusPartitionId(partition);
            if (this.viewNamesByVirtualizedPartition.containsKey(computablePlusPartitionId)) {
                this.virtualPartitionViews.add(new SQLUtils.SQLTable(this.catalog, this.schema, this.viewNamesByVirtualizedPartition.get(computablePlusPartitionId)));
            } else {
                this.dependsOnNonVirtualizedTable = true;
            }
        }

        private boolean needsUnion() {
            return this.virtualPartitionViews.size() > 1 || this.virtualPartitionViews.size() == 1 && this.dependsOnNonVirtualizedTable;
        }

        private Map<SQLUtils.SQLTable, SQLUtils.SQLTable> getTableToViewReplacement(SQLDialect dialect) {
            SQLUtils.SQLTable sourceTable = new SQLUtils.SQLTable(this.catalog, this.schema, this.expandedTableName);
            if (this.needsUnion()) {
                this.viewUnionName = SQLUtils.generateSqlViewName(this.expandedTableName + SqlPipelineRunner.UNION_VIEW_SUFFIX, dialect);
                logger.debugV("Adding a view that UNIONs ALL the partitions of source dataset %s: %s", new Object[]{this.datasetName, this.viewUnionName});
                return ImmutableMap.of((Object)sourceTable, (Object)new SQLUtils.SQLTable(this.catalog, this.schema, this.viewUnionName));
            }
            if (!this.virtualPartitionViews.isEmpty()) {
                logger.debugV("Not adding a UNION ALL view since there is only one virtualized partition needed from %s", new Object[]{this.datasetName});
                return ImmutableMap.of((Object)sourceTable, (Object)this.virtualPartitionViews.get(0));
            }
            logger.debugV("Source dataset %s has no virtualized partitions to read from", new Object[]{this.datasetName});
            return ImmutableMap.of();
        }

        private PipelineSqlStatement getUnionStatement(AuthCtx authCtx, SQLConnectionProvider.SQLConnectionData connData, SQLDialect dialect) throws DKUSecurityException, IOException, SQLException {
            if (!this.needsUnion() || StringUtils.isBlank((String)this.viewUnionName)) {
                throw new IllegalStateException(String.format("No union needed for this source dataset %s", this.datasetName));
            }
            ArrayList<SQLUtils.SQLTable> unionElements = new ArrayList<SQLUtils.SQLTable>(this.virtualPartitionViews);
            if (this.dependsOnNonVirtualizedTable) {
                logger.debugV("Target depends on non-virtualized source table %s, adding it to the view union", new Object[]{this.expandedTableName});
                unionElements.add(new SQLUtils.SQLTable(this.catalog, this.schema, this.expandedTableName));
            }
            ArrayList<String> selectStatementsToUnion = new ArrayList<String>();
            for (SQLUtils.SQLTable element : unionElements) {
                selectStatementsToUnion.add(SimpleSelectQueryBuilder.selectAll().from(element).toSQL(dialect));
            }
            Object unionStatement = dialect.getCreateViewInstruction(this.catalog, this.schema, this.viewUnionName) + UNION_ALL_JOINER.join(selectStatementsToUnion);
            if (SqlPipelineRunner.shouldUpdateForBigQuery(true, dialect)) {
                unionStatement = ((BigQuerySQLDialect)dialect).performRegexReplacementForCreatingAView(authCtx, (String)unionStatement, this.schema, (SQLConnectionProvider.BigQuerySQLConnectionData)connData);
            }
            return new PipelineSqlStatement.Builder((String)unionStatement, this.viewUnionName).withView(new SQLUtils.SQLTable(this.catalog, this.schema, this.viewUnionName)).build();
        }
    }

    private static class PipelineSqlStatement {
        private final String sqlQuery;
        private final String targetName;
        private final boolean shouldPrintExecutionPlan;
        private final String queryForExecutionPlan;
        private final boolean isCreatingView;
        private final SQLUtils.SQLTable view;

        private PipelineSqlStatement(Builder builder) {
            this.sqlQuery = builder.sqlQuery;
            this.targetName = builder.targetName;
            this.shouldPrintExecutionPlan = builder.shouldPrintExecutionPlan;
            this.queryForExecutionPlan = builder.queryForExecutionPlan;
            this.isCreatingView = builder.isCreatingView;
            this.view = builder.view;
        }

        static class Builder {
            private String sqlQuery;
            private final String targetName;
            private boolean shouldPrintExecutionPlan = false;
            private String queryForExecutionPlan;
            private boolean isCreatingView = false;
            private SQLUtils.SQLTable view;

            Builder(String sqlQuery, String targetName) {
                this.sqlQuery = sqlQuery;
                this.targetName = targetName;
            }

            Builder shouldPrintExecutionPlan(boolean value) {
                this.shouldPrintExecutionPlan = value;
                return this;
            }

            Builder queryForExecutionPlan(String value) {
                this.queryForExecutionPlan = value;
                return this;
            }

            Builder withView(SQLUtils.SQLTable value) {
                this.isCreatingView = true;
                this.view = value;
                return this;
            }

            PipelineSqlStatement build() {
                return new PipelineSqlStatement(this);
            }
        }
    }
}

