/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataflow.streaming;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.ObjectCompleteMetadata;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.coremodel.VersionTag;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dao.StreamingEndpointsDAO;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.graph.FlowComputable;
import com.dataiku.dip.dataflow.kernel.slave.KernelSession;
import com.dataiku.dip.dataflow.streaming.DatasetWriteRequest;
import com.dataiku.dip.dataflow.streaming.DatasetWriteSession;
import com.dataiku.dip.dataflow.streaming.slave.CAKernelSession;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.DatasetInspector;
import com.dataiku.dip.datasets.ManagedDatasetsHelper;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.input.DatasetHandlerFactory;
import com.dataiku.dip.rpc.TicketBasedIntercomAPIClient;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.IPermissionsService;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.tickets.APITicketService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.notifications.backend.DatasetChangedEvent;
import com.dataiku.dip.server.services.PubSubService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.streaming.endpoints.model.StreamingEndpoint;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.transactions.ifaces.TransactionRef;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.util.DatasetLocUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.warnings.WarningsContext;
import com.dataiku.dss.shadelib.org.apache.commons.io.IOUtils;
import com.dataiku.dss.shadelib.org.apache.http.NameValuePair;
import com.dataiku.dss.shadelib.org.apache.http.client.utils.URLEncodedUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DatasetWritingService {
    private static final DKULogger logger = DKULogger.getLogger(DatasetWritingService.class);
    private final Map<String, DatasetWriteSession> activeSessions = Collections.synchronizedMap(new HashMap());
    @Autowired
    private TransactionService transactionService;
    private TransactionRef transaction;
    @Autowired
    private DatasetsDAO datasetsDAO;
    @Autowired
    private StreamingEndpointsDAO streamingEndpointsDAO;
    private KernelSession jekKernelSession;
    private CAKernelSession caKernelSession;
    private PubSubService pubSub;
    private Context context;

    private void checkDatasetPrivilege(AuthCtx authCtx, String fullDatasetName, Privileges.DatasetLevelPrivilegeType privilege) throws Exception {
        switch (this.context) {
            case BACKEND: {
                IPermissionsService permissionsService = (IPermissionsService)SpringUtils.getBean(IPermissionsService.class);
                permissionsService.checkDatasetPrivileges(authCtx, DatasetLocUtils.resolveFull(fullDatasetName), privilege);
                break;
            }
            case JEK: 
            case CAK: {
                APITicketService ticketService = (APITicketService)SpringUtils.getBean(APITicketService.class);
                try (APITicketService.TicketUsage tu = ticketService.getAndUseSingleTicket();
                     TicketBasedIntercomAPIClient apiClient = TicketBasedIntercomAPIClient.forLocalHost(tu.getTicket().getSecret());){
                    apiClient.postFormToJSON("/dip/api/tintercom/permissions/check-dataset-privilege", Void.class, new Object[]{"datasetFullName", fullDatasetName, "privilege", privilege.toString()});
                    break;
                }
            }
        }
    }

    public static void writeJSON(HttpServletResponse resp, Object obj) throws IOException {
        resp.setStatus(200);
        resp.setContentType("application/json; charset=UTF-8");
        resp.getWriter().write(JSON.pretty((Object)obj));
    }

    private static void sendError(HttpServletResponse resp, Throwable e) throws IOException {
        StreamingError err = new StreamingError();
        err.message = e.getMessage();
        DatasetWritingService.writeJSON(resp, err);
        resp.setStatus(500);
    }

    private static Map<String, String> parseQueryString(HttpServletRequest req) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (NameValuePair nvp : URLEncodedUtils.parse((String)req.getQueryString(), (Charset)StandardCharsets.UTF_8)) {
            map.put(nvp.getName(), nvp.getValue());
        }
        return map;
    }

    public void configureForJEK(KernelSession kernelSession, TransactionRef transaction) {
        this.context = Context.JEK;
        this.jekKernelSession = kernelSession;
        this.transaction = transaction;
    }

    public void configureForCAK(CAKernelSession kernelSession, TransactionRef transaction) {
        this.context = Context.CAK;
        this.caKernelSession = kernelSession;
        this.transaction = transaction;
    }

    public void configureForBackend(PubSubService pubSub) {
        this.context = Context.BACKEND;
        this.pubSub = pubSub;
    }

    private WarningsContext getWarningContext(DatasetWriteRequest request) {
        switch (this.context) {
            case JEK: {
                if (StringUtils.isBlank((String)request.activityId)) {
                    throw new RuntimeException("Missing activity ID");
                }
                JobActivity ja = (JobActivity)Preconditions.checkNotNull((Object)this.jekKernelSession.getActivityById(request.activityId));
                return (WarningsContext)Preconditions.checkNotNull((Object)ja.warnContext);
            }
            case CAK: {
                return new WarningsContext();
            }
            case BACKEND: {
                return new WarningsContext();
            }
        }
        throw new Error("unreachable");
    }

    public DatasetWriteSession getSessionMandatory(String id) {
        DatasetWriteSession ss = this.activeSessions.get(id);
        if (ss == null) {
            throw new RuntimeException("Session " + id + " doesn't exist");
        }
        return ss;
    }

    private void initSessionImpl(AuthCtx authCtx, HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws IOException {
        try {
            String streamingRequestRaw = (String)Preconditions.checkNotNull((Object)servletRequest.getParameter("request"));
            DatasetWriteRequest streamingRequest = (DatasetWriteRequest)JSON.parse((String)streamingRequestRaw, DatasetWriteRequest.class);
            switch (streamingRequest.targetType) {
                case DATASET: {
                    this.checkDatasetPrivilege(authCtx, streamingRequest.fullDatasetName, Privileges.DatasetLevelPrivilegeType.WRITE_DATA);
                    break;
                }
            }
            int currentSimilarSessions = this.countSimilarSessions(streamingRequest);
            if (currentSimilarSessions > 0) {
                logger.warn((Object)("There are already " + currentSimilarSessions + " writing sessions with similar characteristics, maybe specify a splitId"));
            }
            DatasetWriteSession session = new DatasetWriteSession(authCtx, streamingRequest, this.jekKernelSession, this.caKernelSession);
            session.attemptSetLogContext();
            session.setWarningsContext(this.getWarningContext(streamingRequest));
            this.activeSessions.put(session.getSessionId(), session);
            if (streamingRequest.method == DatasetWriteRequest.Method.FILE) {
                new WriteFromFileThread(session).start();
            }
            logger.info((Object)("Init write session: " + session.getSessionId() + " (current count=" + this.activeSessions.size() + ")"));
            DatasetWritingService.writeJSON(servletResponse, new SessionId(session.getSessionId(), session.getHeartbeatFrequency()));
        }
        catch (Throwable e) {
            logger.error((Object)("Init session error: " + e.getMessage()), e);
            DatasetWritingService.sendError(servletResponse, e);
        }
    }

    private int countSimilarSessions(DatasetWriteRequest streamingRequest) {
        int countSimilar = 0;
        if (streamingRequest.method == DatasetWriteRequest.Method.STREAM_CONTINUOUS && streamingRequest.targetType == FlowComputable.FCType.DATASET) {
            for (DatasetWriteSession session : Lists.newArrayList(this.activeSessions.values())) {
                if (session.getState() == DatasetWriteSession.State.ERROR || session.getState() == DatasetWriteSession.State.SUCCESS || !StringUtils.equals((String)streamingRequest.fullDatasetName, (String)session.getWriteRequest().fullDatasetName) || !StringUtils.equals((String)streamingRequest.partitionSpec, (String)session.getWriteRequest().partitionSpec) || !StringUtils.equals((String)streamingRequest.sourceId, (String)session.getWriteRequest().sourceId) || streamingRequest.splitId != session.getWriteRequest().splitId) continue;
                ++countSimilar;
            }
        }
        return countSimilar;
    }

    public void initSession(AuthCtx authCtx, HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws IOException {
        try (Transaction t = this.transactionService.retrieveOrBeginRead();){
            this.initSessionImpl(authCtx, servletRequest, servletResponse);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitSession(AuthCtx authCtx, HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws IOException {
        WriteSessionResult wsr = new WriteSessionResult();
        try {
            Map<String, String> params = DatasetWritingService.parseQueryString(servletRequest);
            String sessionId = (String)Preconditions.checkNotNull((Object)params.get("id"));
            DatasetWriteSession session = this.getSessionMandatory(sessionId);
            long heartbeatFrequency = (long)session.getHeartbeatFrequency() * 1000L;
            ServletInputStream reqInputStream = servletRequest.getInputStream();
            Thread heartbeatThread = new Thread("Heartbeat-Consumer-" + sessionId, (InputStream)reqInputStream, session){
                final /* synthetic */ InputStream val$reqInputStream;
                final /* synthetic */ DatasetWriteSession val$session;
                {
                    this.val$reqInputStream = inputStream;
                    this.val$session = datasetWriteSession;
                    super(name);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try (BufferedReader reader = new BufferedReader(new InputStreamReader(this.val$reqInputStream));){
                        String line = "start";
                        while (line != null && !this.val$session.isFinished()) {
                            DatasetWriteSession datasetWriteSession = this.val$session;
                            synchronized (datasetWriteSession) {
                                this.val$session.notify();
                            }
                            line = reader.readLine();
                        }
                    }
                    catch (InterruptedIOException e) {
                        logger.info((Object)"Heartbeat stopped");
                    }
                    catch (IOException e) {
                        logger.warn((Object)"Heartbeating ended with error", (Throwable)e);
                        this.val$session.setErrorIfNoneYet(e);
                    }
                    logger.info((Object)"Stopped checking heartbeat");
                }
            };
            heartbeatThread.setDaemon(true);
            heartbeatThread.start();
            long last = System.currentTimeMillis();
            while (!session.isFinished()) {
                try {
                    DatasetWriteSession datasetWriteSession = session;
                    synchronized (datasetWriteSession) {
                        session.wait(3L * heartbeatFrequency);
                    }
                }
                catch (InterruptedException e) {
                    logger.warn((Object)"Heartbeating interrupted");
                    break;
                }
                long cur = System.currentTimeMillis();
                if (cur - last >= 2L * heartbeatFrequency) {
                    logger.error((Object)"Wait write session missed a beat");
                    session.setErrorIfNoneYet(new Exception("Missed a heartbeat"));
                    break;
                }
                last = cur;
            }
            try {
                reqInputStream.close();
                heartbeatThread.interrupt();
            }
            catch (Exception e) {
                logger.warn((Object)"Unable to force-close the heartbeat thread", (Throwable)e);
            }
            this.activeSessions.remove(sessionId);
            session.attemptSetLogContext();
            DatasetWriteSession.State state = session.getState();
            if (state == DatasetWriteSession.State.ERROR) {
                Throwable t;
                if (session.getWriteRequest().method == DatasetWriteRequest.Method.STREAM_CONTINUOUS) {
                    try {
                        session.closeContinuous(true);
                    }
                    catch (Exception e) {
                        logger.warn((Object)("Failed to cleanup session " + session.getSessionId()), (Throwable)e);
                    }
                }
                if ((t = session.getError()) == null) {
                    t = new RuntimeException("Unknown error");
                }
                throw t;
            }
            wsr.ok = true;
            wsr.writtenRows = session.getWrittenRows();
            wsr.message = "OK";
            logger.info((Object)("Finished write session: " + sessionId + " (current count=" + this.activeSessions.size() + ")"));
            DatasetWritingService.writeJSON(servletResponse, wsr);
        }
        catch (Throwable e) {
            logger.error((Object)("Wait session error: " + e.getMessage()), e);
            wsr.ok = false;
            wsr.message = e.getClass().getSimpleName() + ": " + e.getMessage();
            wsr.writtenRows = -1L;
            DatasetWritingService.writeJSON(servletResponse, wsr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pushDataAtOnce(AuthCtx authCtx, HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws IOException {
        DatasetWriteRequest writeRequest;
        DatasetWriteSession session;
        try {
            Map<String, String> params = DatasetWritingService.parseQueryString(servletRequest);
            String sessionId = (String)Preconditions.checkNotNull((Object)params.get("id"));
            session = this.getSessionMandatory(sessionId);
            writeRequest = session.getWriteRequest();
            if (writeRequest.method != DatasetWriteRequest.Method.STREAM) {
                throw new RuntimeException("Session " + sessionId + " is not using STREAM transfer method");
            }
        }
        catch (Throwable e) {
            DatasetWritingService.sendError(servletResponse, e);
            logger.error((Object)("Push data error: " + e.getMessage()), e);
            return;
        }
        session.attemptSetLogContext();
        ServletInputStream servletInputStream = servletRequest.getInputStream();
        try {
            session.writeAtOnceFromCSVStream(writeRequest.dataSchema, (InputStream)servletInputStream);
            logger.info((Object)("Pushed data to write session " + session.getSessionId() + " : " + session.getWrittenRows() + " rows"));
            this.notifyDatasetChanged(session);
        }
        catch (Throwable t) {
            DatasetWriteSession datasetWriteSession = session;
            synchronized (datasetWriteSession) {
                session.setError(t);
                session.enterState(DatasetWriteSession.State.ERROR);
            }
            IOUtils.closeQuietly((InputStream)servletInputStream);
            IOUtils.closeQuietly((Writer)servletResponse.getWriter());
            logger.error((Object)("Push data error during streaming:" + t.getMessage()), t);
        }
    }

    private DatasetWriteSession getContinuousSession(AuthCtx authCtx, HttpServletRequest servletRequest) throws Exception {
        try {
            Map<String, String> params = DatasetWritingService.parseQueryString(servletRequest);
            String sessionId = (String)Preconditions.checkNotNull((Object)params.get("id"));
            DatasetWriteSession session = this.getSessionMandatory(sessionId);
            DatasetWriteRequest writeRequest = session.getWriteRequest();
            if (writeRequest.method != DatasetWriteRequest.Method.STREAM_CONTINUOUS) {
                throw new RuntimeException("Session " + sessionId + " is not using STREAM transfer method");
            }
            return session;
        }
        catch (Exception e) {
            logger.error((Object)("Push data error: " + e.getMessage()), (Throwable)e);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pushDataContinuous(AuthCtx authCtx, HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws Exception {
        DatasetWriteSession session = this.getContinuousSession(authCtx, servletRequest);
        session.attemptSetLogContext();
        ServletInputStream servletInputStream = servletRequest.getInputStream();
        try {
            session.appendContinuousChunkFromCSVStream((InputStream)servletInputStream);
            logger.info((Object)("Pushed data to write session " + session.getSessionId() + " : " + session.getWrittenRows() + " rows"));
            this.notifyDatasetChanged(session);
        }
        catch (Throwable t) {
            DatasetWriteSession datasetWriteSession = session;
            synchronized (datasetWriteSession) {
                session.setError(t);
                session.enterState(DatasetWriteSession.State.ERROR);
            }
            IOUtils.closeQuietly((InputStream)servletInputStream);
            IOUtils.closeQuietly((Writer)servletResponse.getWriter());
            logger.error((Object)("Push data error during streaming:" + t.getMessage()), t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkpointContinuous(AuthCtx authCtx, HttpServletRequest servletRequest) throws Exception {
        DatasetWriteSession session = this.getContinuousSession(authCtx, servletRequest);
        if (session.getWriteRequest().targetType == FlowComputable.FCType.STREAMING_ENDPOINT) {
            throw new IOException("Cannot checkpoint on streaming outputs");
        }
        Map<String, String> params = DatasetWritingService.parseQueryString(servletRequest);
        String newState = params.get("newState");
        session.attemptSetLogContext();
        try {
            session.checkpointContinuous(newState);
        }
        catch (Throwable t2) {
            IOException t2;
            int similarSessionsCount = this.countSimilarSessions(session.getWriteRequest());
            if (t2 instanceof IOException && similarSessionsCount > 1) {
                t2 = new IOException("Error while checkpointing (" + similarSessionsCount + " similar write sessions, maybe splitId needs to be specified)", t2);
            }
            DatasetWriteSession datasetWriteSession = session;
            synchronized (datasetWriteSession) {
                session.setError(t2);
                session.enterState(DatasetWriteSession.State.ERROR);
            }
            throw new RuntimeException(t2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getContinuousState(AuthCtx authCtx, HttpServletRequest servletRequest) throws Exception {
        DatasetWriteSession session = this.getContinuousSession(authCtx, servletRequest);
        if (session.getWriteRequest().targetType == FlowComputable.FCType.STREAMING_ENDPOINT) {
            throw new IOException("Cannot checkpoint on streaming outputs");
        }
        Map<String, String> params = DatasetWritingService.parseQueryString(servletRequest);
        session.attemptSetLogContext();
        try {
            return session.getContinuousState();
        }
        catch (Throwable t) {
            DatasetWriteSession datasetWriteSession = session;
            synchronized (datasetWriteSession) {
                session.setError(t);
                session.enterState(DatasetWriteSession.State.ERROR);
            }
            throw new RuntimeException(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeContinuous(AuthCtx authCtx, HttpServletRequest servletRequest) throws Exception {
        DatasetWriteSession session = this.getContinuousSession(authCtx, servletRequest);
        try {
            session.closeContinuous("true".equalsIgnoreCase(servletRequest.getParameter("failed")));
        }
        catch (Throwable t) {
            logger.warn((Object)"Close call failed", t);
            DatasetWriteSession datasetWriteSession = session;
            synchronized (datasetWriteSession) {
                session.setError(t);
                session.enterState(DatasetWriteSession.State.ERROR);
            }
            throw new RuntimeException(t);
        }
    }

    private void notifyDatasetChanged(DatasetWriteSession session) {
        if (this.pubSub != null) {
            DatasetWriteRequest wr = session.getWriteRequest();
            DatasetLocUtils.DatasetLoc loc = DatasetLocUtils.resolveFull(wr.fullDatasetName);
            String partitionOrNP = StringUtils.isBlank((String)wr.partitionSpec) ? "NP" : wr.partitionSpec;
            this.pubSub.publish(new DatasetChangedEvent(loc, Lists.newArrayList((Object[])new String[]{partitionOrNP})));
        }
    }

    public boolean writeDatasetSchema(AuthCtx authCtx, DatasetLocUtils.DatasetLoc ds, Schema newSchema, boolean dropAndRecreate, String origin) throws IOException, DKUSecurityException {
        logger.info((Object)("Setting schema of " + ds.getFullName()));
        SerializedDataset sd = (SerializedDataset)this.datasetsDAO.getMandatory(ds);
        for (SchemaColumn col : newSchema.getColumns()) {
            if (Type.exists((String)col.getTypeString())) continue;
            throw ErrorContext.iaef((String)"Invalid type '%s' for column '%s'", (Object)col.getTypeString(), (Object[])new Object[]{col.getName()});
        }
        Schema currentSchema = sd.getSchema();
        if (dropAndRecreate) {
            Dataset datasetBefore = Dataset.fromSerialized(sd);
            logger.info((Object)("Dropping previous data for " + datasetBefore.getFullName()));
            try (DatasetHandler dh = DatasetHandlerFactory.build(authCtx, datasetBefore);){
                dh.clearAllDataAndStructure();
            }
            catch (Exception e) {
                logger.warn((Object)"Failed to drop previous data", (Throwable)e);
            }
        }
        Dataset dataset = Dataset.fromSerialized(sd);
        if (newSchema != null && dataset.getTypeSystemVersion() == SerializedDataset.TypeSystemVersion.V1) {
            newSchema.rewindTypesToV1FromOrigin(origin);
        }
        ManagedDatasetsHelper.fixupSchema(authCtx, dataset, newSchema, currentSchema);
        if (!JSON.json((Object)currentSchema).equals(JSON.json((Object)newSchema))) {
            logger.info((Object)"Schema was modified");
            sd.setSchema(newSchema);
            sd.versionTag = VersionTag.increment(sd.versionTag, authCtx.getIdentifier());
            this.datasetsDAO.save(sd);
            return true;
        }
        logger.info((Object)"Schema was not modified");
        return false;
    }

    public void writeDatasetMetadata(AuthCtx authCtx, DatasetLocUtils.DatasetLoc ds, ObjectCompleteMetadata ocm) throws IOException {
        SerializedDataset sd = (SerializedDataset)this.datasetsDAO.getMandatory(ds);
        DatasetInspector.setMetadata(sd, ocm);
        sd.versionTag = VersionTag.increment(sd.versionTag, authCtx.getIdentifier());
        logger.info((Object)"Prepared");
        this.datasetsDAO.save(sd);
        logger.info((Object)"Saved");
    }

    public boolean writeStreamingEndpointSchema(AuthCtx authCtx, AnyLoc ds, Schema newSchema) throws IOException, DKUSecurityException {
        logger.info((Object)("Setting schema of " + ds.getFullName()));
        logger.info((Object)("New schema is " + JSON.json((Object)newSchema)));
        StreamingEndpoint se = (StreamingEndpoint)this.streamingEndpointsDAO.getMandatory(ds);
        logger.info((Object)("Saved SE is " + JSON.json((Object)se)));
        for (SchemaColumn col : newSchema.getColumns()) {
            if (Type.exists((String)col.getTypeString())) continue;
            throw ErrorContext.iaef((String)"Invalid type '%s' for column '%s'", (Object)col.getTypeString(), (Object[])new Object[]{col.getName()});
        }
        Schema currentSchema = se.schema;
        logger.info((Object)("Current shcema is " + JSON.json((Object)currentSchema)));
        if (currentSchema == null || !JSON.json((Object)currentSchema).equals(JSON.json((Object)newSchema))) {
            logger.info((Object)"Schema was modified");
            se.schema = newSchema;
            se.versionTag = VersionTag.increment(se.versionTag, authCtx.getIdentifier());
            this.streamingEndpointsDAO.save(se);
            return true;
        }
        logger.info((Object)"Schema was not modified");
        return false;
    }

    public static enum Context {
        BACKEND,
        JEK,
        CAK;

    }

    static class StreamingError {
        String message;

        StreamingError() {
        }
    }

    private class WriteFromFileThread
    extends Thread {
        private final DatasetWriteSession session;
        private final DatasetWriteRequest request;

        public WriteFromFileThread(DatasetWriteSession session) {
            this.session = session;
            this.request = session.getWriteRequest();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.session.writeAtOnceFromCSVFile(this.request.dataSchema, new File(this.request.dataFilePath));
                DatasetWritingService.this.notifyDatasetChanged(this.session);
            }
            catch (Throwable t) {
                DatasetWriteSession datasetWriteSession = this.session;
                synchronized (datasetWriteSession) {
                    this.session.setError(t);
                    this.session.enterState(DatasetWriteSession.State.ERROR);
                }
            }
        }
    }

    public static class SessionId {
        public String id;
        public int heartbeatFrequency;

        SessionId(String id, int heartbeatFrequency) {
            this.id = id;
            this.heartbeatFrequency = heartbeatFrequency;
        }
    }

    public static class WriteSessionResult {
        public long writtenRows;
        public boolean ok;
        public String message;
    }
}

