/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datalayer.window;

import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.dataflow.exec.window.WindowRecipePayloadParams;
import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.sort.RowAndSortMark;
import com.dataiku.dip.datalayer.sort.SortedRowsIterator;
import com.dataiku.dip.datalayer.streamimpl.StreamColumnFactory;
import com.dataiku.dip.datalayer.streamimpl.StreamRow;
import com.dataiku.dip.datalayer.window.WindowPartitionSlider;
import com.dataiku.dip.datalayer.window.WindowSlider;
import com.dataiku.dip.datalayer.window.Windower;
import com.dataiku.dip.expressions.Expression;
import com.dataiku.dip.utils.NotImplementedException;
import java.io.IOException;

public class RangeEndWindowSlider
extends WindowPartitionSlider {
    private final Expression expression;
    private final Column columnX;
    private final Column columnY;
    private final Row expressionRow;
    private final Column rangeColumn;
    private final SchemaColumn rangeSchemaColumn;
    private long columnXIndex = -1L;
    private long columnYIndex = -1L;
    private RowAndSortMark previous;

    public RangeEndWindowSlider(SortedRowsIterator it, boolean descending, double delta, WindowRecipePayloadParams.DateDiffUnit rangeUnit, SchemaColumn rangeSchemaColumn, Column rangeColumn) {
        super(it);
        String expressionStr;
        this.rangeSchemaColumn = rangeSchemaColumn;
        this.rangeColumn = rangeColumn;
        Schema schema = new Schema();
        schema.addColumn(new SchemaColumn("x", rangeSchemaColumn.getType()));
        schema.addColumn(new SchemaColumn("y", rangeSchemaColumn.getType()));
        StreamColumnFactory cf = new StreamColumnFactory();
        this.expressionRow = new StreamRow();
        this.columnX = cf.column("x");
        this.columnY = cf.column("y");
        if (rangeSchemaColumn.getType().isNumeric()) {
            expressionStr = descending ? "if(isNull(y) && isNull(x), 0 <= " + delta + ", if(isNull(x),0 <= 1, if(isNull(y), 1 <= 0, x <= y + " + delta + ")))" : "if(isNull(y) && isNull(x), 0 <= " + delta + ", if(isNull(y),0 <= 1, if(isNull(x), 1 <= 0, y <= x + " + delta + ")))";
        } else if (rangeSchemaColumn.getType().isTemporal()) {
            WindowRecipePayloadParams.DateDiffUnit dateDiffUnit = rangeUnit = rangeUnit == null ? WindowRecipePayloadParams.DateDiffUnit.DAY : rangeUnit;
            expressionStr = descending ? "if(isNull(y) && isNull(x), 0 <= " + delta + ", if(isNull(x),0 <= 1, if(isNull(y), 1 <= 0, diff(x, y, '" + rangeUnit.toString() + "') <= " + delta + ")))" : "if(isNull(y) && isNull(x), 0 <= " + delta + ", if(isNull(y),0 <= 1, if(isNull(x), 1 <= 0, diff(y, x, '" + rangeUnit.toString() + "') <= " + delta + ")))";
        } else {
            throw new NotImplementedException("Cannot range window on " + String.valueOf(rangeSchemaColumn.getType()));
        }
        this.expression = new Expression(expressionStr, schema);
        this.expression.setColumnFactory((ColumnFactory)cf);
    }

    private void slideOne() {
        this.previous = this.current;
        this.current = this.it.hasNext() ? this.it.next() : null;
    }

    private void fillExpressionRow(Row row, Column to) {
        if (row != null) {
            if (this.rangeSchemaColumn.getType().isNumeric()) {
                double v = row.getAsDoubleOrNaN(this.rangeColumn);
                if (Double.isNaN(v)) {
                    this.expressionRow.put(to, null);
                } else {
                    this.expressionRow.put(to, v);
                }
            } else {
                this.expressionRow.put(to, row.get(this.rangeColumn));
            }
        } else {
            this.expressionRow.put(to, null);
        }
    }

    private boolean evaluateExpression(RowAndSortMark to, RowAndSortMark cur) {
        if (to == null && this.columnXIndex >= 0L) {
            this.columnXIndex = -1L;
            this.fillExpressionRow(null, this.columnX);
        } else if (to != null && this.columnXIndex != to.mark.index) {
            this.columnXIndex = to.mark.index;
            this.fillExpressionRow(to.row.row, this.columnX);
        }
        if (cur == null && this.columnYIndex >= 0L) {
            this.columnYIndex = -1L;
            this.fillExpressionRow(null, this.columnY);
        } else if (cur != null && this.columnYIndex != cur.mark.index) {
            this.columnYIndex = cur.mark.index;
            this.fillExpressionRow(cur.row.row, this.columnY);
        }
        return this.expression.isTrueish(this.expressionRow);
    }

    @Override
    public void position(RowAndSortMark at, Windower.WindowPartition partition, RowAndSortMark windowStart) throws IOException {
        super.position(at, partition, windowStart);
        this.previous = null;
    }

    @Override
    public RowAndSortMark current() {
        return this.atEnd ? null : this.previous;
    }

    @Override
    public void slide(RowAndSortMark to, WindowSlider.SlideCallback callBefore, WindowSlider.SlideCallback callAfter) {
        while (!this.atEnd && this.current != null && this.current.mark.index <= this.partition.last.mark.index && this.evaluateExpression(to, this.current)) {
            if (callBefore != null && this.previous != null) {
                callBefore.handle(this.previous);
            }
            this.slideOne();
            if (callAfter == null || this.previous == null) continue;
            callAfter.handle(this.previous);
        }
    }
}

