/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.dataquality.dqmetrics;

import com.dataiku.dip.dataquality.dqmetrics.ValuesInRangeSQLLikeComputer;
import com.dataiku.dip.dataquality.dqmetrics.ValuesInRangeStreamComputer;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.metrics.Metric;
import com.dataiku.dip.metrics.MetricComputer;
import com.dataiku.dip.metrics.MetricMetadata;
import com.dataiku.dip.metrics.probes.TemporaryMetric;
import java.util.List;

public class ValuesInRangeMetric
extends TemporaryMetric {
    public static final String TYPE = "ValuesInRangeMetric";
    public String ruleId;
    public String column;
    public double minimum;
    public double maximum;
    public boolean minimumEnabled;
    public boolean maximumEnabled;
    public double softMinimum;
    public double softMaximum;
    public boolean softMinimumEnabled;
    public boolean softMaximumEnabled;

    private ValuesInRangeMetric() {
        super("temporary_metrics_probe", Type.ARRAY);
    }

    public ValuesInRangeMetric(String ruleId, String column, double minimum, double maximum, boolean minimumEnabled, boolean maximumEnabled, double softMinimum, double softMaximum, boolean softMinimumEnabled, boolean softMaximumEnabled) {
        this();
        this.ruleId = ruleId;
        this.column = column;
        this.minimum = minimum;
        this.maximum = maximum;
        this.minimumEnabled = minimumEnabled;
        this.maximumEnabled = maximumEnabled;
        this.softMinimum = softMinimum;
        this.softMaximum = softMaximum;
        this.softMinimumEnabled = softMinimumEnabled;
        this.softMaximumEnabled = softMaximumEnabled;
        this.id = this.serialize();
    }

    @Override
    public MetricMetadata getMeta() {
        MetricMetadata meta = new MetricMetadata().withName("Find values outside range");
        meta.withFullName(meta.getName() + " for " + this.column);
        return meta;
    }

    @Override
    public String getColumn() {
        return this.column;
    }

    @Override
    public List<MetricComputer> getComputers() {
        return List.of(new ValuesInRangeStreamComputer(), new ValuesInRangeSQLLikeComputer.ValuesInRangeSQLComputer(), new ValuesInRangeSQLLikeComputer.ValuesInRangeImpalaComputer(), new ValuesInRangeSQLLikeComputer.ValuesInRangeHiveComputer(), new ValuesInRangeSQLLikeComputer.ValuesInRangeSparkComputer());
    }

    @Override
    public String serialize() {
        return Metric.buildMetricIdFromParts("temporary_metrics_probe", TYPE, this.column, this.ruleId);
    }
}

