/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets.fs.plugin;

import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.io.AbstractImpersonatedSecretProtectedPythonKernel;
import com.dataiku.dip.io.SingleCommandKernelLink;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.process.IsolableProcess;
import com.dataiku.dip.security.tickets.APITicketService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.utils.DKULogger;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;

public class CustomFSProviderReadPythonKernel
extends AbstractImpersonatedSecretProtectedPythonKernel<SingleCommandKernelLink> {
    private final APITicketService.Ticket ticket;
    private static DKULogger logger = DKULogger.getLogger((String)"dip.fsprovider.read.kernel");

    public CustomFSProviderReadPythonKernel(SingleCommandKernelLink link, AuthCtx authCtx, File workDir, String pluginResourceFolderPath, String pluginPythonLibFolderPath, String projectKey, String envName, APITicketService.Ticket ticket) {
        super(link, GeneralSettingsDAO.CGrouppableProcessType.CUSTOM_PYTHON_DATA_ACCESS_COMPONENT, authCtx, workDir, pluginResourceFolderPath, false, CustomFSProviderReadPythonKernel.makePythonLibs("python-lib", pluginPythonLibFolderPath), projectKey, envName);
        this.ticket = ticket;
        SpringUtils.getInstance().autowire((Object)this);
    }

    @Override
    protected IsolableProcess createAndStartProcess(ProcessBuilder pb, GeneralSettingsDAO.CGrouppableProcessType cgrouppableProcessType) throws DKUSecurityException, IOException, InterruptedException {
        pb.environment().put("DKU_API_TICKET", this.ticket.getSecret());
        return super.createAndStartProcess(pb, cgrouppableProcessType);
    }

    public void killWithoutMercy() throws IOException, InterruptedException {
        try {
            APITicketService apiTicketService = (APITicketService)SpringUtils.getBean(APITicketService.class);
            apiTicketService.expireTicket(this.ticket);
        }
        catch (Exception e) {
            logger.warn((Object)"Unable to expire ticket", (Throwable)e);
        }
        super.killWithoutMercy();
    }

    @Override
    protected String getPythonModule() {
        return "dataiku.fsprovider.read_server";
    }

    public static class StartServerResponse {
        public String reason;
    }

    public static class StartServerRequest {
        public String code;
        public JsonObject config;
        public JsonObject pluginConfig;
        public String root;
        public String path;
        public long limit;

        public StartServerRequest(String code, JsonObject config, JsonObject pluginConfig, String root, String path, long limit) {
            this.code = code;
            this.config = config;
            this.pluginConfig = pluginConfig;
            this.root = root;
            this.path = path;
            this.limit = limit;
        }
    }
}

