/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets.sql;

import com.dataiku.dip.connections.ConnectionsDAO;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.HiveableDatasetHandler;
import com.dataiku.dip.datasets.sql.PartitionedSQLTableDatasetHandler;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.sql.SQLUtils;
import com.dataiku.dip.utils.ErrorContext;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;

public class PartitionedHiveTableDatasetHandler
extends PartitionedSQLTableDatasetHandler
implements HiveableDatasetHandler {
    public PartitionedHiveTableDatasetHandler(AuthCtx authCtx, Dataset dataset, DatasetHandler.DatasetMeta<?, ?> meta) {
        super(authCtx, dataset, meta);
    }

    @Override
    public String getDSSConnectionForHive() {
        return this.resolvedAbstractConfig.connection;
    }

    @Override
    public SQLUtils.SQLTable getResolvedHiveTableRef(boolean databaseIsMandatory) {
        String database = null;
        if (StringUtils.isNotBlank((String)this.resolvedAbstractConfig.schema)) {
            database = this.resolvedAbstractConfig.schema;
        } else {
            ConnectionsDAO.VirtualConnectionId virtualConnection = ConnectionsDAO.parseVirtualConnection(this.resolvedAbstractConfig.connection);
            String string = database = virtualConnection != null ? virtualConnection.db : null;
        }
        if (databaseIsMandatory && StringUtils.isBlank((String)database)) {
            throw ErrorContext.iae((String)("Could not determine Hive database for dataset " + this.dataset.getFullName() + ", please check config"));
        }
        String table = this.resolvedAbstractConfig.table;
        String schema = database == null ? null : database.toLowerCase(Locale.ENGLISH);
        String table1 = table == null ? null : table.toLowerCase(Locale.ENGLISH);
        return new SQLUtils.SQLTable(null, schema, table1, true);
    }

    @Override
    public SQLUtils.SQLTable getUnresolvedHiveTableRef() {
        ConnectionsDAO.VirtualConnectionId virtualConnection;
        String database = null;
        database = StringUtils.isNotBlank((String)this.rawAbstractConfig.schema) ? this.rawAbstractConfig.schema : ((virtualConnection = ConnectionsDAO.parseVirtualConnection(this.rawAbstractConfig.connection)) != null ? virtualConnection.db : null);
        String table = this.rawAbstractConfig.table;
        return new SQLUtils.SQLTable(null, database, table, true);
    }
}

