/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets.sql;

import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.connections.OracleConnection;
import com.dataiku.dip.connections.SQLConnectionProvider;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.datasets.sql.SQLCodes;
import com.dataiku.dip.exceptions.CodedSQLException;
import com.dataiku.dip.exceptions.DataStoreIOException;
import com.dataiku.dip.hive.HiveCodes;
import com.dataiku.dip.sql.HiveSQLDialect;
import com.dataiku.dip.sql.ImpalaSQLDialect;
import com.dataiku.dip.sql.OracleSQLDialect;
import com.dataiku.dip.sql.PostgreSQLDialect;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.VerticaSQLDialect;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.JSON;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.sql.SQLException;
import org.apache.log4j.Logger;

public class SQLExceptionsParser {
    public static DataStoreIOException newDatastoreIOException(String message, SQLConnectionProvider.SQLConnectionData connData, SQLException e, boolean parseTableNotFound) {
        SQLExceptionDetails sd = SQLExceptionsParser.parse(connData, e, parseTableNotFound);
        Logger.getLogger((String)"dku").info((Object)("SQL D:" + JSON.json((Object)sd.code)));
        return new DataStoreIOException(message, (Throwable)e).withCode(sd.code);
    }

    public static CodedSQLException newCodedSQLException(String message, SQLConnectionProvider.SQLConnectionData connData, SQLException e, boolean parseTableNotFound) {
        SQLExceptionDetails sd = SQLExceptionsParser.parse(connData, e, parseTableNotFound);
        Logger.getLogger((String)"dku").info((Object)("SQL D:" + JSON.json((Object)sd.code)));
        return new CodedSQLException(sd.code, message, (Throwable)e);
    }

    public static SQLException tryCodeSQLException(String message, SQLConnectionProvider.SQLConnectionData connData, SQLException e, boolean parseTableNotFound) {
        if (e instanceof CodedSQLException) {
            return new CodedSQLException(((CodedSQLException)e).getCode(), message, (Throwable)e);
        }
        SQLExceptionDetails sd = SQLExceptionsParser.parse(connData, e, parseTableNotFound);
        Logger.getLogger((String)"dku").info((Object)("SQL D:" + JSON.json((Object)sd.code)));
        if (sd.code != null) {
            return new CodedSQLException(sd.code, message, (Throwable)e);
        }
        return e;
    }

    public static SQLExceptionDetails parse(SQLConnectionProvider.SQLConnectionData connData, SQLException e, boolean parseTableNotFound) {
        SQLDialect dialect = connData.getDialect();
        AbstractSQLConnection connection = dialect instanceof OracleSQLDialect ? connData.getConnection() : null;
        return SQLExceptionsParser.parse(dialect, connection, e, parseTableNotFound);
    }

    public static SQLExceptionDetails parse(SQLDialect dialect, DSSConnection connection, SQLException e, boolean parseTableNotFound) {
        SQLExceptionDetails ret = new SQLExceptionDetails();
        ret.originalException = e;
        if (dialect instanceof ImpalaSQLDialect && e.getMessage().contains("Memory limit exceeded")) {
            ret.code = SQLCodes.ERR_SQL_IMPALA_MEMORYLIMIT;
        }
        if (dialect instanceof VerticaSQLDialect) {
            if (ExceptionUtils.hasCauseWithMessage((Throwable)e, (String)"[VJDBC](5065) ERROR: Too many ROS")) {
                ret.code = SQLCodes.ERR_SQL_VERTICA_TOOMANYROS;
            }
            if (ExceptionUtils.hasCauseWithMessage((Throwable)e, (String)"[VJDBC](4060) FATAL: New session rejected due to limit")) {
                ret.code = SQLCodes.ERR_SQL_VERTICA_TOOMANYSESSIONS;
            }
        }
        if (dialect instanceof OracleSQLDialect && ExceptionUtils.hasCauseWithMessage((Throwable)e, (String)"ORA-01017:") && connection instanceof OracleConnection && ((OracleConnection)connection).mayNeedAdditionalProperties()) {
            ret.code = SQLCodes.ERR_SQL_ORACLE_KERBEROS_SETUP_MAY_BE_INCOMPLETE;
        }
        if (dialect instanceof PostgreSQLDialect && ExceptionUtils.hasCauseWithMessage((Throwable)e, (String)"FATAL: sorry, too many clients already")) {
            ret.code = SQLCodes.ERR_SQL_POSTGRESQL_TOOMANYSESSIONS;
        }
        if (parseTableNotFound && dialect instanceof PostgreSQLDialect && ExceptionUtils.hasCauseWithMessageRe((Throwable)e, (String)"ERROR: relation \\\"[^\\\"]*\\\" does not exist")) {
            ret.code = SQLCodes.ERR_SQL_TABLE_NOT_FOUND;
        }
        if (dialect instanceof HiveSQLDialect) {
            if (ExceptionUtils.hasCauseWithMessage((Throwable)e, (String)"can not be used in column name in create table statement")) {
                ret.code = HiveCodes.ERR_HIVE_BAD_COLUMN_NAME;
            } else if (ExceptionUtils.hasCauseWithMessage((Throwable)e, (String)"Number of column name and column type differs")) {
                ret.code = HiveCodes.ERR_HIVE_BAD_COLUMN_NAME;
            }
        }
        if (ExceptionUtils.hasCauseOfClass((Throwable)e, ConnectException.class) && (ExceptionUtils.hasCauseWithMessage((Throwable)e, (String)"connection refused") || ExceptionUtils.hasCauseWithMessage((Throwable)e, (String)"operation timed out"))) {
            ret.code = SQLCodes.ERR_SQL_DB_UNREACHABLE;
        } else if (ExceptionUtils.hasCauseOfClass((Throwable)e, SocketTimeoutException.class) || ExceptionUtils.hasCauseOfClass((Throwable)e, UnknownHostException.class)) {
            ret.code = SQLCodes.ERR_SQL_DB_UNREACHABLE;
        }
        return ret;
    }

    public static class SQLExceptionDetails {
        public SQLException originalException;
        public InfoMessage.MessageCode code;
    }
}

