/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.docgen.flow.placeholders.recipe;

import com.dataiku.dip.dataflow.exec.fuzzyjoin.FuzzyJoinRecipePayloadParams;
import com.dataiku.dip.dataflow.exec.geojoin.GeoJoinRecipePayloadParams;
import com.dataiku.dip.dataflow.exec.join.JoinRecipePayloadParams;
import com.dataiku.dip.dataflow.exec.joinlike.MatchingConditionBase;
import com.dataiku.dip.docgen.flow.FlowDocumentContext;
import com.dataiku.dip.docgen.flow.FlowPlaceholder;
import com.dataiku.dip.docgen.resolver.PlaceholderExpectedException;
import com.dataiku.dip.docgen.resolver.PlaceholderOutput;

public abstract class BaseConditionPlaceholder
implements FlowPlaceholder.TextPlaceholder<MatchingConditionBase> {
    @Override
    public Class<MatchingConditionBase> getInputType() {
        return MatchingConditionBase.class;
    }

    public static class Description
    extends BaseConditionPlaceholder {
        @Override
        public PlaceholderOutput.Text resolve(FlowDocumentContext context, MatchingConditionBase condition) throws PlaceholderExpectedException {
            if (condition instanceof JoinRecipePayloadParams.MatchingCondition) {
                return this.describeJoin((JoinRecipePayloadParams.MatchingCondition)condition);
            }
            if (condition instanceof FuzzyJoinRecipePayloadParams.MatchingCondition) {
                return this.describeFuzzyJoin((FuzzyJoinRecipePayloadParams.MatchingCondition)condition);
            }
            if (condition instanceof GeoJoinRecipePayloadParams.MatchingCondition) {
                return this.describeGeoJoin((GeoJoinRecipePayloadParams.MatchingCondition)condition);
            }
            throw new PlaceholderExpectedException("Unknown matching condition");
        }

        private PlaceholderOutput.Text describeJoin(JoinRecipePayloadParams.MatchingCondition condition) throws PlaceholderExpectedException {
            return new PlaceholderOutput.Text(condition.type.getDisplayName());
        }

        private PlaceholderOutput.Text describeFuzzyJoin(FuzzyJoinRecipePayloadParams.MatchingCondition condition) throws PlaceholderExpectedException {
            StringBuilder sb = new StringBuilder();
            sb.append(condition.fuzzyMatchDesc.distanceType.getDisplayName());
            if (condition.fuzzyMatchDesc.isRelative()) {
                sb.append(String.format(" (%.0f%%)", condition.fuzzyMatchDesc.threshold * 100.0));
            } else if (condition.fuzzyMatchDesc.distanceType != FuzzyJoinRecipePayloadParams.DistanceType.EXACT) {
                sb.append(String.format(" (%.2f)", condition.fuzzyMatchDesc.threshold));
            }
            return new PlaceholderOutput.Text(sb.toString());
        }

        private PlaceholderOutput.Text describeGeoJoin(GeoJoinRecipePayloadParams.MatchingCondition condition) throws PlaceholderExpectedException {
            String ret = condition.type.getDisplayWithDistanceFormat();
            if (condition.type == GeoJoinRecipePayloadParams.MatchingType.DWITHIN || condition.type == GeoJoinRecipePayloadParams.MatchingType.BEYOND) {
                ret = String.format(ret, condition.threshold, condition.unit.getDisplayName());
            }
            return new PlaceholderOutput.Text(ret);
        }
    }

    public static class Right
    extends BaseConditionPlaceholder {
        @Override
        public PlaceholderOutput.Text resolve(FlowDocumentContext context, MatchingConditionBase condition) throws PlaceholderExpectedException {
            return new PlaceholderOutput.Text(condition.column2.name);
        }
    }

    public static class Left
    extends BaseConditionPlaceholder {
        @Override
        public PlaceholderOutput.Text resolve(FlowDocumentContext context, MatchingConditionBase condition) throws PlaceholderExpectedException {
            return new PlaceholderOutput.Text(condition.column1.name);
        }
    }
}

