/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.docgen.flow.placeholders.recipe;

import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dataflow.exec.fuzzyjoin.FuzzyJoinRecipeMeta;
import com.dataiku.dip.dataflow.exec.fuzzyjoin.FuzzyJoinRecipePayloadParams;
import com.dataiku.dip.dataflow.exec.geojoin.GeoJoinRecipeMeta;
import com.dataiku.dip.dataflow.exec.geojoin.GeoJoinRecipePayloadParams;
import com.dataiku.dip.dataflow.exec.join.JoinRecipeMeta;
import com.dataiku.dip.dataflow.exec.join.JoinRecipePayloadParams;
import com.dataiku.dip.dataflow.exec.joinlike.JoinDescBase;
import com.dataiku.dip.dataflow.exec.joinlike.JoinInputDescBase;
import com.dataiku.dip.dataflow.exec.joinlike.JoinLikeRecipePayloadParams;
import com.dataiku.dip.docgen.flow.FlowDocumentContext;
import com.dataiku.dip.docgen.flow.FlowPlaceholder;
import com.dataiku.dip.docgen.flow.placeholders.recipe.JoinDescWithNames;
import com.dataiku.dip.docgen.resolver.BadTemplatePlaceholderException;
import com.dataiku.dip.docgen.resolver.IterableDescription;
import com.dataiku.dip.docgen.resolver.PlaceholderExpectedException;
import com.dataiku.dip.utils.JSON;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

public class RecipeBaseJoinIterable
implements FlowPlaceholder.IterablePlaceholder<SerializedRecipe, JoinDescWithNames> {
    @Override
    public Collection<JoinDescWithNames> resolve(FlowDocumentContext context, SerializedRecipe recipe) throws PlaceholderExpectedException {
        JoinLikeRecipePayloadParams payload;
        if (JoinRecipeMeta.META.getType().equals(recipe.type)) {
            payload = (JoinLikeRecipePayloadParams)JSON.parse((String)context.getCachedPayload(recipe), JoinRecipePayloadParams.class);
        } else if (FuzzyJoinRecipeMeta.META.getType().equals(recipe.type)) {
            payload = (JoinLikeRecipePayloadParams)JSON.parse((String)context.getCachedPayload(recipe), FuzzyJoinRecipePayloadParams.class);
        } else if (GeoJoinRecipeMeta.META.getType().equals(recipe.type)) {
            payload = (JoinLikeRecipePayloadParams)JSON.parse((String)context.getCachedPayload(recipe), GeoJoinRecipePayloadParams.class);
        } else {
            throw new BadTemplatePlaceholderException("Placeholder not available for recipe " + recipe.name + ". " + recipe.type + " doesn't have joins.");
        }
        return payload.joins.stream().map(j -> {
            List<SerializedRecipe.RecipeInput> inputs = recipe.getInputsForRole("main");
            int leftIndex = ((JoinInputDescBase)payload.virtualInputs.get((int)j.table1)).index;
            int rightIndex = ((JoinInputDescBase)payload.virtualInputs.get((int)j.table2)).index;
            return new JoinDescWithNames((JoinDescBase<?>)j, inputs.get((int)leftIndex).ref, inputs.get((int)rightIndex).ref);
        }).collect(Collectors.toList());
    }

    @Override
    public IterableDescription<SerializedRecipe, JoinDescWithNames> getDescription() {
        return IterableDescription.iterablePlaceholder(SerializedRecipe.class, JoinDescWithNames.class, "$join");
    }
}

