/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.docgen.flow.placeholders.recipe;

import com.dataiku.dip.code.CodeEnvModel;
import com.dataiku.dip.code.CodeEnvSelection;
import com.dataiku.dip.code.CodeEnvSelector;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.docgen.flow.FlowDocumentContext;
import com.dataiku.dip.docgen.flow.FlowPlaceholder;
import com.dataiku.dip.docgen.helpers.PlaceholderOutputFactory;
import com.dataiku.dip.docgen.resolver.BadTemplatePlaceholderException;
import com.dataiku.dip.docgen.resolver.PlaceholderExpectedException;
import com.dataiku.dip.docgen.resolver.PlaceholderOutput;
import com.dataiku.dip.recipes.MetaWithSelectableCodeEnv;
import com.dataiku.dip.recipes.ParamsWithSelectableCodeEnv;
import com.dataiku.dip.recipes.RecipeMeta;
import com.dataiku.dip.recipes.RecipeRegistry;
import java.io.IOException;

public class RecipeCodeEnvPlaceholder
implements FlowPlaceholder.TextPlaceholder<SerializedRecipe> {
    @Override
    public Class<SerializedRecipe> getInputType() {
        return SerializedRecipe.class;
    }

    @Override
    public PlaceholderOutput.Text resolve(FlowDocumentContext context, SerializedRecipe recipe) throws PlaceholderExpectedException {
        if (recipe.params instanceof ParamsWithSelectableCodeEnv) {
            CodeEnvSelection codeEnvSelection = ((ParamsWithSelectableCodeEnv)((Object)recipe.params)).getCodeEnvSelection();
            switch (codeEnvSelection.envMode) {
                case USE_BUILTIN_MODE: {
                    return new PlaceholderOutput.Text("DSS builtin env");
                }
                case INHERIT: {
                    String codeEnv;
                    try {
                        RecipeMeta recipeMeta = RecipeRegistry.getMeta(recipe);
                        if (!(recipeMeta instanceof MetaWithSelectableCodeEnv)) break;
                        CodeEnvModel.EnvLang lang = ((MetaWithSelectableCodeEnv)((Object)recipeMeta)).getEnvLang();
                        codeEnv = new CodeEnvSelector().getProjectDefault(lang, context.serializedProject.settings.codeEnvs);
                        codeEnv = codeEnv == null ? "DSS builtin env" : codeEnv;
                    }
                    catch (IOException e) {
                        throw new PlaceholderExpectedException("Couldn't retrieve project default code env");
                    }
                    return new PlaceholderOutput.Text("Inherited from project default (" + codeEnv + ")");
                }
                case EXPLICIT_ENV: {
                    return new PlaceholderOutput.Text("Explicit selection: " + codeEnvSelection.envName);
                }
            }
        }
        throw new BadTemplatePlaceholderException("Placeholder not available for recipe " + recipe.getDisplayName() + ". Recipe type " + recipe.type + " do not have code env.");
    }

    public static class HasCodeEnv
    implements FlowPlaceholder.TextPlaceholder<SerializedRecipe> {
        @Override
        public Class<SerializedRecipe> getInputType() {
            return SerializedRecipe.class;
        }

        @Override
        public PlaceholderOutput.Text resolve(FlowDocumentContext context, SerializedRecipe recipe) throws PlaceholderExpectedException {
            return PlaceholderOutputFactory.makeBoolean(recipe.params instanceof ParamsWithSelectableCodeEnv);
        }
    }
}

