/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.docgen.flow.placeholders.recipe;

import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dataflow.exec.sort.SortRecipeMeta;
import com.dataiku.dip.dataflow.exec.sort.SortRecipePayloadParams;
import com.dataiku.dip.dataflow.exec.topn.TopNRecipeMeta;
import com.dataiku.dip.dataflow.exec.topn.TopNRecipePayloadParams;
import com.dataiku.dip.docgen.flow.FlowDocumentContext;
import com.dataiku.dip.docgen.flow.FlowPlaceholder;
import com.dataiku.dip.docgen.resolver.BadTemplatePlaceholderException;
import com.dataiku.dip.docgen.resolver.IterableDescription;
import com.dataiku.dip.docgen.resolver.PlaceholderExpectedException;
import com.dataiku.dip.docgen.resolver.PlaceholderOutput;
import com.dataiku.dip.utils.JSON;
import java.util.Collection;
import java.util.stream.Collectors;

public abstract class SortingColumnPlaceholder
implements FlowPlaceholder.TextPlaceholder<Order> {
    @Override
    public Class<Order> getInputType() {
        return Order.class;
    }

    public static class Order {
        String column;
        boolean desc;

        public Order(SortRecipePayloadParams.Order order) {
            this.column = order.column;
            this.desc = order.desc;
        }

        public Order(TopNRecipePayloadParams.Order order) {
            this.column = order.column;
            this.desc = order.desc;
        }
    }

    public static class Direction
    extends SortingColumnPlaceholder {
        @Override
        public PlaceholderOutput.Text resolve(FlowDocumentContext context, Order order) throws PlaceholderExpectedException {
            return new PlaceholderOutput.Text(order.desc ? "Descending" : "Ascending");
        }
    }

    public static class Name
    extends SortingColumnPlaceholder {
        @Override
        public PlaceholderOutput.Text resolve(FlowDocumentContext context, Order order) throws PlaceholderExpectedException {
            return new PlaceholderOutput.Text(order.column);
        }
    }

    public static class SortingColumnsIterable
    implements FlowPlaceholder.IterablePlaceholder<SerializedRecipe, Order> {
        @Override
        public IterableDescription<SerializedRecipe, Order> getDescription() {
            return IterableDescription.iterablePlaceholder(SerializedRecipe.class, Order.class, "$sorted_column");
        }

        @Override
        public Collection<Order> resolve(FlowDocumentContext context, SerializedRecipe recipe) throws PlaceholderExpectedException {
            if (recipe.type.equals(SortRecipeMeta.META.getType())) {
                return ((SortRecipePayloadParams)JSON.parse((String)context.getCachedPayload((SerializedRecipe)recipe), SortRecipePayloadParams.class)).orders.stream().map(Order::new).collect(Collectors.toList());
            }
            if (recipe.type.equals(TopNRecipeMeta.META.getType())) {
                return ((TopNRecipePayloadParams)JSON.parse((String)context.getCachedPayload((SerializedRecipe)recipe), TopNRecipePayloadParams.class)).orders.stream().map(Order::new).collect(Collectors.toList());
            }
            throw new BadTemplatePlaceholderException("Placeholder not available for recipe " + recipe.getDisplayName() + " (" + recipe.type + "). Expected " + TopNRecipeMeta.META.getType() + " or " + SortRecipeMeta.META.getType() + " recipe");
        }
    }
}

