/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.eda.worksheets.cards;

import com.dataiku.dip.eda.compute.computations.common.MultiComputation;
import com.dataiku.dip.eda.compute.computations.univariate.FitDistribution;
import com.dataiku.dip.eda.compute.computations.univariate.Shapiro;
import com.dataiku.dip.eda.compute.computations.univariate.TestDistribution;
import com.dataiku.dip.eda.compute.distributions.Normal;
import com.dataiku.dip.eda.worksheets.cards.CardResult;
import com.dataiku.dip.eda.worksheets.cards.UnivariateCard;
import com.dataiku.dip.eda.worksheets.cards.common.AbstractCompiledCard;
import com.dataiku.dip.eda.worksheets.cards.common.CardWithConfidenceLevel;
import com.dataiku.dip.eda.worksheets.cards.common.CompiledCard;
import com.dataiku.dip.eda.worksheets.cards.common.RecipeCompatibleCard;
import com.dataiku.dip.eda.worksheets.cards.fragments.BoxPlotFragment;
import com.dataiku.dip.eda.worksheets.cards.fragments.NumericalHistogramFragment;
import com.dataiku.dip.eda.worksheets.models.Variable;
import java.util.List;

public class ShapiroNormalityTestCard
extends UnivariateCard
implements CardWithConfidenceLevel,
RecipeCompatibleCard {
    public static final String TYPE = "shapiro";
    public double confidenceLevel;

    @Override
    public void setConfidenceLevel(double confidenceLevel) {
        this.confidenceLevel = confidenceLevel;
    }

    public ShapiroNormalityTestCard(Variable column) {
        this.column = column;
    }

    private ShapiroNormalityTestCard() {
    }

    @Override
    protected CompiledCard compileNoSplitNoFilter() {
        return new AbstractCompiledCard<MultiComputation, MultiComputation.MultiComputationResult>(){

            @Override
            public MultiComputation getComputationPlan() {
                return new MultiComputation(new Shapiro(ShapiroNormalityTestCard.this.column.name), BoxPlotFragment.getComputationPlan(ShapiroNormalityTestCard.this.column.name), new FitDistribution(ShapiroNormalityTestCard.this.column.name, new Normal(), true), NumericalHistogramFragment.getPlan(ShapiroNormalityTestCard.this.column));
            }

            @Override
            public CardResult buildFromFullyAvailableResult(MultiComputation.MultiComputationResult result) {
                Shapiro.ShapiroResult shapiro = result.get(0).as(Shapiro.ShapiroResult.class);
                BoxPlotFragment boxPlot = BoxPlotFragment.build(result.get(1));
                FitDistribution.FitDistributionResult fitDistributionResult = result.get(2).as(FitDistribution.FitDistributionResult.class);
                NumericalHistogramFragment histogram = NumericalHistogramFragment.buildResult(result.get(3));
                return new ShapiroNormalityTestCardResult(result.collectWarnings(), shapiro.pvalue, shapiro.statistic, boxPlot, fitDistributionResult.test.plot.pdf, histogram);
            }
        };
    }

    public static class ShapiroNormalityTestCardResult
    extends CardResult {
        public NumericalHistogramFragment histogram;
        public TestDistribution.ProbabilityDensityFunction normalPdf;
        public double statistic;
        public double pvalue;
        public BoxPlotFragment boxPlot;

        public ShapiroNormalityTestCardResult(List<String> warnings, double pvalue, double statistic, BoxPlotFragment boxPlot, TestDistribution.ProbabilityDensityFunction pdf, NumericalHistogramFragment histogram) {
            this.warnings = warnings;
            this.pvalue = pvalue;
            this.statistic = statistic;
            this.boxPlot = boxPlot;
            this.normalPdf = pdf;
            this.histogram = histogram;
        }

        private ShapiroNormalityTestCardResult() {
        }
    }
}

