/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.eda.worksheets.queries;

import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.eda.compute.computations.ComputationResult;
import com.dataiku.dip.eda.compute.computations.common.DummyComputation;
import com.dataiku.dip.eda.compute.computations.common.GroupedComputation;
import com.dataiku.dip.eda.compute.engine.ComputationRunner;
import com.dataiku.dip.eda.compute.grouping.AnumGrouping;
import com.dataiku.dip.eda.worksheets.queries.InteractiveQuery;
import com.google.common.collect.Lists;
import java.util.List;

public class ListMostFrequentValues
extends InteractiveQuery {
    public static final String TYPE = "list_most_frequent_values";
    public int maxValues;
    public String column;

    @Override
    public ListMostFrequentValuesResult run(Schema schema, ComputationRunner runner) throws Exception {
        ComputationResult result = runner.compute(new GroupedComputation(new DummyComputation(), new AnumGrouping(this.column, this.maxValues, false)));
        if (result.isFailed()) {
            throw new RuntimeException("Could not fetch values of \"" + this.column + "\": " + result.asFailed().message);
        }
        ListMostFrequentValuesResult queryResult = new ListMostFrequentValuesResult();
        queryResult.values = Lists.newArrayList((Object[])result.asGrouped().groups.asAnum().values);
        return queryResult;
    }

    public static class ListMostFrequentValuesResult
    extends InteractiveQuery.InteractiveQueryResult {
        List<String> values;
    }
}

