/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.export.output;

import com.dataiku.dip.CodedRuntimeException;
import com.dataiku.dip.coremodel.FormatParams;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.RowInputStream;
import com.dataiku.dip.export.ExportCodes;
import com.dataiku.dip.export.ExportParams;
import com.dataiku.dip.export.ExportService;
import com.dataiku.dip.export.output.ExportOutput;
import com.dataiku.dip.formats.FormatFactory;
import com.dataiku.dip.output.OutputFormatter;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dss.shadelib.org.apache.commons.io.output.ProxyOutputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.log4j.Logger;

public class ExportToStream
implements ExportOutput {
    private OutputFormatter formatter;
    private boolean calledFooter = false;
    private MonitoredOutputStream monitoredStream;
    private final OutputStream outputStream;
    private final ExportParams exportParams;
    private OutputStream writerStream;
    private long writtenRecords = 0L;
    private final long maxExportSizeMB;
    private ColumnFactory cf;
    private ExportOutput.ExportContext exportContext;
    private static final Logger logger = Logger.getLogger(ExportToStream.class);

    public ExportToStream(OutputStream outputStream, ExportParams exportParams, long maxExportSizeMB) {
        this.exportParams = exportParams;
        this.outputStream = outputStream;
        this.maxExportSizeMB = maxExportSizeMB;
    }

    @Override
    public long getWrittenBytes() {
        if (this.monitoredStream != null) {
            return this.monitoredStream.getWrittenBytes();
        }
        return -1L;
    }

    @Override
    public void close() {
        if (this.formatter != null && !this.calledFooter) {
            try {
                this.formatter.cancel(this.writerStream);
            }
            catch (Exception e) {
                logger.error((Object)"Unable to close formatter", (Throwable)e);
            }
        }
        if (this.writerStream != null) {
            try {
                this.writerStream.close();
            }
            catch (IOException e) {
                logger.error((Object)"Unable to close stream", (Throwable)e);
            }
        }
    }

    @Override
    public void initialize(ExportService.LocalExportJob job, Schema schema, ColumnFactory cf) throws Exception {
        this.cf = cf;
        this.monitoredStream = new MonitoredOutputStream(this.outputStream, this.maxExportSizeMB);
        BufferedOutputStream bufferedStream = new BufferedOutputStream((OutputStream)((Object)this.monitoredStream), 1000000);
        this.writerStream = this.exportParams.format != null && this.exportParams.format.params != null && this.exportParams.format.params.has("compress") && "gz".equals(this.exportParams.format.params.get("compress").getAsString()) ? new GZIPOutputStream(bufferedStream) : bufferedStream;
        FormatParams fp = (FormatParams)JSON.parse((String)this.exportParams.format.params.toString(), FormatFactory.getMeta(this.exportParams.format.type).paramsClass());
        this.formatter = FormatFactory.buildFormatter(this.exportParams.user, this.exportParams.contextProjectKey, this.exportParams.format.type, fp);
        this.formatter.setOutputSchema(schema);
        if (this.exportContext != null) {
            this.formatter.setColoring(this.exportContext.tableColoring);
            this.formatter.setMemTable((Object)this.exportContext.table);
            this.formatter.setWarningsContext(this.exportContext.warningsContext);
        }
        this.formatter.header(cf, this.writerStream);
    }

    @Override
    public void setExportContext(ExportOutput.ExportContext exportContext) {
        this.exportContext = exportContext;
    }

    @Override
    public void stream(RowInputStream stream) throws Exception {
        Row row = stream.next();
        while (row != null) {
            try {
                this.formatter.format(row, this.cf, this.writerStream);
                ++this.writtenRecords;
                if (this.writtenRecords % 5000L == 0L) {
                    this.writerStream.flush();
                    this.outputStream.flush();
                }
            }
            catch (IOException e) {
                throw new Exception("Stream closed unexpectedly", e);
            }
            row = stream.next();
        }
        this.formatter.footer(this.cf, this.writerStream);
        this.calledFooter = true;
        this.writerStream.flush();
    }

    @Override
    public void checkFeasability(ExportService.LocalExportJob job) throws Exception {
    }

    public static class MonitoredOutputStream
    extends ProxyOutputStream {
        private long writtenBytes;
        private final long maxSizeBytes;

        public MonitoredOutputStream(OutputStream os, long maxSizeMB) {
            super(os);
            this.maxSizeBytes = maxSizeMB * 1024L * 1024L;
            if (this.maxSizeBytes > 0L) {
                logger.info((Object)("Export will be limited to " + this.maxSizeBytes + " bytes"));
            }
        }

        protected void afterWrite(int n) {
            this.writtenBytes += (long)n;
            this.checkSize();
        }

        private void checkSize() {
            if (this.writtenBytes > this.maxSizeBytes && this.maxSizeBytes > 0L) {
                String message = String.format("Export size (%d bytes) is larger than the max allowed size (%d bytes)", this.getWrittenBytes(), this.maxSizeBytes);
                throw new CodedRuntimeException((InfoMessage.MessageCode)ExportCodes.ERR_EXPORT_OUTPUT_TOO_LARGE, message);
            }
        }

        public long getWrittenBytes() {
            return this.writtenBytes;
        }
    }
}

