/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.externalinfras.azureml.http;

import com.dataiku.common.server.APIError;
import com.dataiku.common.server.SerializedError;
import com.dataiku.dip.DKUApp;
import com.dataiku.dip.ProxySettings;
import com.dataiku.dip.externalinfras.azureml.AzureMLUtils;
import com.dataiku.dip.externalinfras.azureml.datamodel.AzureMLEnvironment;
import com.dataiku.dip.externalinfras.azureml.datamodel.AzureMLModel;
import com.dataiku.dip.externalinfras.azureml.datamodel.AzureMLOnlineDeployment;
import com.dataiku.dip.externalinfras.azureml.datamodel.AzureMLOnlineEndpoint;
import com.dataiku.dip.externalinfras.azureml.datamodel.AzureMLResource;
import com.dataiku.dip.externalinfras.azureml.datamodel.AzureMLResourceIdentifier;
import com.dataiku.dip.externalinfras.azureml.datamodel.AzureMLVersionedResource;
import com.dataiku.dip.externalinfras.azureml.datamodel.AzureMLVersionedResourceIdentifier;
import com.dataiku.dip.externalinfras.azureml.http.AzureMLEnvironmentAPIRestDTO;
import com.dataiku.dip.externalinfras.azureml.http.AzureMLModelAPIRestDTO;
import com.dataiku.dip.externalinfras.azureml.http.AzureMLOnlineDeploymentAPIRestDTO;
import com.dataiku.dip.externalinfras.azureml.http.AzureMLOnlineEndpointAPIRestDTO;
import com.dataiku.dip.externalinfras.azureml.http.AzureMLResourceAPIRestDTO;
import com.dataiku.dip.util.ProxyUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.PerfUtils;
import com.dataiku.dss.shadelib.org.apache.commons.io.IOUtils;
import com.dataiku.dss.shadelib.org.apache.http.HttpEntity;
import com.dataiku.dss.shadelib.org.apache.http.HttpResponse;
import com.dataiku.dss.shadelib.org.apache.http.client.config.RequestConfig;
import com.dataiku.dss.shadelib.org.apache.http.client.methods.CloseableHttpResponse;
import com.dataiku.dss.shadelib.org.apache.http.client.methods.HttpDelete;
import com.dataiku.dss.shadelib.org.apache.http.client.methods.HttpGet;
import com.dataiku.dss.shadelib.org.apache.http.client.methods.HttpPost;
import com.dataiku.dss.shadelib.org.apache.http.client.methods.HttpPut;
import com.dataiku.dss.shadelib.org.apache.http.client.methods.HttpRequestBase;
import com.dataiku.dss.shadelib.org.apache.http.client.methods.HttpUriRequest;
import com.dataiku.dss.shadelib.org.apache.http.client.utils.URIBuilder;
import com.dataiku.dss.shadelib.org.apache.http.conn.HttpClientConnectionManager;
import com.dataiku.dss.shadelib.org.apache.http.impl.client.CloseableHttpClient;
import com.dataiku.dss.shadelib.org.apache.http.impl.client.HttpClientBuilder;
import com.dataiku.dss.shadelib.org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import com.dataiku.dss.shadelib.org.apache.http.message.BasicNameValuePair;
import com.dataiku.dss.shadelib.org.apache.http.util.EntityUtils;
import com.dataiku.dss.shadelibazure.com.azure.core.credential.AccessToken;
import com.dataiku.dss.shadelibazure.com.azure.core.credential.TokenCredential;
import com.dataiku.dss.shadelibazure.com.azure.core.credential.TokenRequestContext;
import com.google.common.primitives.Ints;
import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.ObjectUtils;

public class AzureMLHttpClient
implements AutoCloseable {
    final CloseableHttpClient httpClient;
    public final TokenCredential credential;
    private final PoolingHttpClientConnectionManager cm;
    private static final String AZURE_RESOURCE_MANAGEMENT_BASE_URI = "https://management.azure.com";
    private static final String AZURE_API_VERSION_PARAM_KEY = "api-version";
    private static final String AZURE_SUBSCRIPTIONS_URI = "https://management.azure.com/subscriptions";
    private static final String AZURE_SUBSCRIPTIONS_API_VERSION = "2022-12-01";
    private static final String AZURE_OPEN_AI_DEPLOYMENTS_URI = "https://management.azure.com/subscriptions/%s/resourceGroups/%s/providers/Microsoft.CognitiveServices/accounts/%s/deployments";
    private static final String AZURE_OPEN_AI_DEPLOYMENTS_API_VERSION = "2023-10-01-preview";
    private static final String AZURE_ML_BASE_URI = "https://management.azure.com/subscriptions/%s/resourceGroups/%s/providers/Microsoft.MachineLearningServices/workspaces/%s";
    private static final String AZURE_ML_ONLINE_ENDPOINTS_URI = "/onlineEndpoints";
    private static final String AZURE_ML_ONLINE_ENDPOINT_SINGLE_URI = "/onlineEndpoints/%s";
    private static final String AZURE_ML_ONLINE_DEPLOYMENTS_URI = "/onlineEndpoints/%s/deployments";
    private static final String AZURE_ML_ONLINE_DEPLOYMENT_SINGLE_URI = "/onlineEndpoints/%s/deployments/%s";
    private static final String AZURE_ML_ONLINE_ENDPOINT_LIST_KEYS_URI = "/onlineEndpoints/%s/listKeys";
    private static final String AZURE_ML_ONLINE_ENDPOINT_TOKEN_URI = "/onlineEndpoints/%s/token";
    private static final String AZURE_ML_MODELS_URI = "/models";
    private static final String AZURE_ML_MODEL_SINGLE_VERSION_URI = "/models/%s/versions/%s";
    private static final String AZURE_ML_ENVIRONMENTS_URI = "/environments";
    private static final String AZURE_ML_ENVIRONMENTS_SINGLE_VERSION_URI = "/environments/%s/versions/%s";
    private static final String AZURE_ML_API_VERSION = "2023-10-01";
    private static final String AZURE_ML_BASE_INFERENCE_URL_KEY = "dku.deployer.deployment.azureml.client.baseInferenceUrl";
    private static final String DEFAULT_AZURE_ML_BASE_INFERENCE_URL = "https://%s.%s.inference.ml.azure.com/";
    private static final String AZUREML_TOKEN_REQUEST_SCOPE = "https://management.azure.com/.default";
    public static final String AZUREML_MAX_TOKEN_REQUEST_WAIT_SECONDS = "dku.deployer.deployment.azureml.max_token_wait_second";
    public static final long AZUREML_MAX_TOKEN_REQUEST_WAIT_SECONDS_DEFAULT = 15L;
    private static final String API_DOC = "swagger.json";
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.externalinfras.azureml.utils");

    public AzureMLHttpClient(ProxySettings proxySettings, TokenCredential credential, int connectTimeout, int socketTimeout) {
        this.credential = credential;
        HttpClientBuilder builder = HttpClientBuilder.create();
        builder.addInterceptorFirst(PerfUtils.MARK_HTTP_REQUEST_INTERCEPTOR);
        ProxyUtils.applyProxySettings((ProxySettings)proxySettings, (HttpClientBuilder)builder);
        this.cm = new PoolingHttpClientConnectionManager();
        this.cm.setMaxTotal(10);
        this.cm.setDefaultMaxPerRoute(10);
        RequestConfig rc = RequestConfig.custom().setConnectTimeout(connectTimeout).setConnectionRequestTimeout(10000).setSocketTimeout(socketTimeout).build();
        builder.setDefaultRequestConfig(rc);
        builder.setConnectionManager((HttpClientConnectionManager)this.cm);
        this.httpClient = builder.build();
    }

    private String composeURI(String subscription, String resourceGroup, String workspace, String actionEndpoint, String ... actionEndpointUriParams) {
        String formattedActionEndpoint = String.format(actionEndpoint, Arrays.copyOf(actionEndpointUriParams, actionEndpointUriParams.length, Object[].class));
        return String.format(AZURE_ML_BASE_URI, subscription, resourceGroup, workspace) + formattedActionEndpoint;
    }

    private URI composeResourceURI(String subscription, String resourceGroup, String workspace, String actionEndpoint, Map<String, String> extraParams, String ... actionEndpointUriParams) {
        try {
            String uri = this.composeURI(subscription, resourceGroup, workspace, actionEndpoint, actionEndpointUriParams);
            List params = extraParams.entrySet().stream().map(entry -> new BasicNameValuePair((String)entry.getKey(), (String)entry.getValue())).collect(Collectors.toList());
            return new URIBuilder(new URI(uri)).addParameter(AZURE_API_VERSION_PARAM_KEY, AZURE_ML_API_VERSION).addParameters(params).build();
        }
        catch (URISyntaxException uriSyntaxException) {
            String message = String.format("Error generating URI for action endpoint %s", actionEndpoint);
            logger.error((Object)message, (Throwable)uriSyntaxException);
            throw ErrorContext.iae((String)message, (Exception)uriSyntaxException);
        }
    }

    private <T> T handleJSONResp(String requestURI, HttpResponse resp, TypeToken<T> typeToken, boolean handleNotFound) throws IOException {
        int code = resp.getStatusLine().getStatusCode();
        HttpEntity entity = resp.getEntity();
        String ret = "";
        if (entity != null) {
            ret = IOUtils.toString((InputStream)resp.getEntity().getContent(), (Charset)StandardCharsets.UTF_8);
        }
        if (code >= 200 && code < 300) {
            try {
                return (T)JSON.parse((String)ret, typeToken);
            }
            catch (Exception e) {
                logger.error((Object)("Error while parsing the response '" + ret + "' when querying " + requestURI), (Throwable)e);
                throw e;
            }
        }
        if (handleNotFound && code == 404) {
            logger.warn((Object)("Received Not Found response message when querying " + requestURI + " httpcode " + code));
            return null;
        }
        logger.error((Object)("Received error when querying " + requestURI + " httpcode " + code));
        logger.error((Object)("Body " + ret));
        throw new IOException(String.format("Method '%s' failed with code '%s' and content %s", requestURI, code, ret));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T execRequest_NT(HttpRequestBase requestBase, TypeToken<T> typeToken, boolean handleNotFound) throws IOException {
        CloseableHttpResponse resp = null;
        try {
            requestBase.setHeader("Authorization", String.format("Bearer %s", this.getTokenFromCredential()));
            resp = this.httpClient.execute((HttpUriRequest)requestBase);
            T t = this.handleJSONResp(requestBase.getURI().toString(), (HttpResponse)resp, typeToken, handleNotFound);
            return t;
        }
        finally {
            if (Objects.nonNull(resp)) {
                EntityUtils.consume((HttpEntity)resp.getEntity());
            }
            requestBase.releaseConnection();
        }
    }

    private String getTokenFromCredential() {
        TokenRequestContext tokenRequestContext = new TokenRequestContext();
        tokenRequestContext.addScopes(new String[]{AZUREML_TOKEN_REQUEST_SCOPE});
        long maxDuration = DKUApp.getParams().getLongParam(AZUREML_MAX_TOKEN_REQUEST_WAIT_SECONDS, 15L);
        return ((AccessToken)this.credential.getToken(tokenRequestContext).timeout(Duration.ofSeconds(maxDuration)).retry(5L).block(Duration.ofSeconds(maxDuration))).getToken();
    }

    private <T extends AzureMLResourceAPIRestDTO<?>, R extends AzureMLResource> Optional<R> execSingleResourceGetRequest_NT(URI uri, String resourceType, AzureMLResourceIdentifier resourceId, AzureMLDtoPojoMapper<R, T> resourceMapper) throws IOException {
        AzureMLResourceAPIRestDTO retrievedResource = (AzureMLResourceAPIRestDTO)this.execRequest_NT((HttpRequestBase)new HttpGet(uri), resourceMapper.getDtoType(), true);
        Object mappedResource = null;
        if (Objects.nonNull(retrievedResource)) {
            logger.traceV("AzureML %s '%s' successfully retrieved.", new Object[]{resourceType, resourceId.name});
            this.fillResourceWithMissingFields(retrievedResource, resourceId.workspace, resourceId.resourceGroup, resourceId.subscription);
            mappedResource = resourceMapper.map(retrievedResource);
        } else {
            logger.traceV("AzureML %s '%s' does not exist.", new Object[]{resourceType, resourceId.name});
        }
        return Optional.ofNullable(mappedResource);
    }

    private <T extends AzureMLResourceAPIRestDTO<?>, R extends AzureMLResource> R execSingleResourcePutRequest_NT(URI uri, String resourceType, @Nonnull R resource, @Nonnull AzureMLDtoPojoMapper<R, T> dtoPojoMapper, @Nonnull AzureMLPojoDtoMapper<R, T> pojoDtoMapper) throws IOException {
        HttpPut put = new HttpPut(uri);
        put.setEntity(JSON.toHttpEntity(pojoDtoMapper.map(resource)));
        AzureMLResourceAPIRestDTO modifiedResource = (AzureMLResourceAPIRestDTO)this.execRequest_NT((HttpRequestBase)put, dtoPojoMapper.getDtoType(), false);
        R mappedResource = null;
        if (Objects.nonNull(modifiedResource)) {
            logger.debugV("AzureML %s '%s' successfully modified.", new Object[]{resourceType, resource.name});
            this.fillResourceWithMissingFields(modifiedResource, resource.workspace, resource.resourceGroup, resource.subscription);
            mappedResource = dtoPojoMapper.map(modifiedResource);
        }
        return mappedResource;
    }

    private void execSingleResourceDeleteRequest_NT(URI uri, String resourceType, AzureMLResourceIdentifier resourceId) throws IOException {
        this.execRequest_NT((HttpRequestBase)new HttpDelete(uri), new TypeToken<Void>(){}, true);
        logger.debugV("AzureML %s '%s' successfully deleted.", new Object[]{resourceType, resourceId.name});
    }

    private void fillResourceWithMissingFields(AzureMLResourceAPIRestDTO<?> resource, String workspace, String resourceGroup, String subscription) {
        resource.resourceGroup = resourceGroup;
        resource.workspace = workspace;
        resource.subscription = subscription;
    }

    private <POJO extends AzureMLResource, DTO extends AzureMLResourceAPIRestDTO<?>> Optional<POJO> retrieve_NT(String resourceType, AzureMLResourceIdentifier resourceId, AzureMLDtoPojoMapper<POJO, DTO> mapper, String actionURI, String ... actionEndpointUriParams) throws IOException {
        try {
            AzureMLUtils.checkRate("Retrieve AzureML " + resourceType);
            logger.debugV("Retrieving AzureML %s with name '%s'.", new Object[]{resourceType, resourceId.name});
            URI retrieveResourceURI = this.composeResourceURI(resourceId.subscription, resourceId.resourceGroup, resourceId.workspace, actionURI, Collections.emptyMap(), actionEndpointUriParams);
            return this.execSingleResourceGetRequest_NT(retrieveResourceURI, resourceType, resourceId, mapper);
        }
        catch (Exception e) {
            logger.errorV((Throwable)e, "Error while retrieving AzureML Model with name '%s'.", new Object[]{resourceId.name});
            throw e;
        }
    }

    private <POJO extends AzureMLVersionedResource, DTO extends AzureMLResourceAPIRestDTO<?>> void archive_NT(String resourceType, AzureMLVersionedResourceIdentifier id, RetrieveVersionedResourcePointer<POJO> fp, @Nonnull AzureMLDtoPojoMapper<POJO, DTO> dtoPojoMapper, @Nonnull AzureMLPojoDtoMapper<POJO, DTO> pojoDtoMapper, String actionURI) throws IOException {
        Optional<POJO> resource = fp.retrieve(id);
        if (resource.isPresent()) {
            AzureMLUtils.checkRate("Archive AzureML " + resourceType);
            logger.debugV("Archiving AzureML %s with name '%s'.", new Object[]{resourceType, id.name});
            AzureMLVersionedResource resourceToArchive = (AzureMLVersionedResource)resource.get();
            resourceToArchive.isArchived = true;
            URI archiveResourceURI = this.composeResourceURI(id.subscription, id.resourceGroup, id.workspace, actionURI, Collections.emptyMap(), id.name, id.version);
            this.execSingleResourcePutRequest_NT(archiveResourceURI, resourceType, resourceToArchive, dtoPojoMapper, pojoDtoMapper);
        } else {
            logger.debugV("AzureML %s with name '%s' does not exist.", new Object[]{resourceType, id.name});
        }
    }

    private void delete_NT(String resourceType, AzureMLResourceIdentifier resourceId, String actionURI, String ... actionEndpointUriParams) throws IOException {
        try {
            AzureMLUtils.checkRate("Delete AzureML " + resourceType);
            logger.debugV("Deleting AzureML %s with name '%s'.", new Object[]{resourceType, resourceId.name});
            URI deleteResourceURI = this.composeResourceURI(resourceId.subscription, resourceId.resourceGroup, resourceId.workspace, actionURI, Collections.emptyMap(), actionEndpointUriParams);
            this.execSingleResourceDeleteRequest_NT(deleteResourceURI, resourceType, resourceId);
        }
        catch (Exception e) {
            logger.errorV((Throwable)e, "Error while deleting AzureML %s with name '%s'.", new Object[]{resourceType, resourceId.name});
            throw e;
        }
    }

    public Optional<AzureMLModel> retrieveModel_NT(AzureMLVersionedResourceIdentifier modelId) throws IOException {
        return this.retrieve_NT("Model", modelId, new AzureMLModelMapper(), AZURE_ML_MODEL_SINGLE_VERSION_URI, modelId.name, modelId.version);
    }

    public void archiveModel_NT(AzureMLVersionedResourceIdentifier modelId) throws IOException {
        AzureMLModelMapper modelMapper = new AzureMLModelMapper();
        this.archive_NT("Model", modelId, this::retrieveModel_NT, modelMapper, modelMapper, AZURE_ML_MODEL_SINGLE_VERSION_URI);
    }

    public Optional<AzureMLEnvironment> retrieveEnvironment_NT(AzureMLVersionedResourceIdentifier environmentId) throws IOException {
        return this.retrieve_NT("Environment", environmentId, new AzureMLEnvironmentMapper(), AZURE_ML_ENVIRONMENTS_SINGLE_VERSION_URI, environmentId.name, environmentId.version);
    }

    public void archiveEnvironment_NT(AzureMLVersionedResourceIdentifier environmentId) throws IOException {
        AzureMLEnvironmentMapper environmentMapper = new AzureMLEnvironmentMapper();
        this.archive_NT("Environment", environmentId, this::retrieveEnvironment_NT, environmentMapper, environmentMapper, AZURE_ML_ENVIRONMENTS_SINGLE_VERSION_URI);
    }

    public Optional<AzureMLOnlineEndpoint> retrieveOnlineEndpoint_NT(AzureMLResourceIdentifier onlineEndpointId) throws IOException {
        return this.retrieve_NT("Online Endpoint", onlineEndpointId, new AzureMLOnlineEndpointMapper(), AZURE_ML_ONLINE_ENDPOINT_SINGLE_URI, onlineEndpointId.name);
    }

    public void deleteOnlineEndpoint_NT(AzureMLResourceIdentifier onlineEndpointId) throws IOException {
        this.delete_NT("Online Endpoint", onlineEndpointId, AZURE_ML_ONLINE_ENDPOINT_SINGLE_URI, onlineEndpointId.name);
    }

    public Optional<AzureMLOnlineDeployment> retrieveOnlineDeployment_NT(AzureMLResourceIdentifier onlineDeploymentId) throws IOException {
        return this.retrieve_NT("Online Deployment", onlineDeploymentId, new AzureMLOnlineDeploymentMapper(), AZURE_ML_ONLINE_DEPLOYMENT_SINGLE_URI, onlineDeploymentId.parentResourceName, onlineDeploymentId.name);
    }

    public void deleteOnlineDeployment_NT(AzureMLResourceIdentifier onlineDeploymentId) throws IOException {
        this.delete_NT("Online Deployment", onlineDeploymentId, AZURE_ML_ONLINE_DEPLOYMENT_SINGLE_URI, onlineDeploymentId.parentResourceName, onlineDeploymentId.name);
    }

    public List<AzureMLOnlineEndpoint> listOnlineEndpoints_NT(String workspace, String resourceGroup, String subscription) throws IOException {
        try {
            AzureMLUtils.checkRate("List AzureML Online Endpoints");
            logger.debugV("Retrieving the list of AzureML Online Endpoints for subscription '%s', resource group '%s' and workspace '%s'.", new Object[]{subscription, resourceGroup, workspace});
            URI listEndpointsURI = this.composeResourceURI(subscription, resourceGroup, workspace, AZURE_ML_ONLINE_ENDPOINTS_URI, Collections.emptyMap(), new String[0]);
            AzureListResponse<AzureMLOnlineEndpointAPIRestDTO> azureMLOnlineEndpointListResult = this.execRequest_NT((HttpRequestBase)new HttpGet(listEndpointsURI), new TypeToken<AzureListResponse<AzureMLOnlineEndpointAPIRestDTO>>(){}, false);
            ArrayList<AzureMLOnlineEndpoint> azureMLOnlineEndpoints = new ArrayList<AzureMLOnlineEndpoint>();
            AzureMLOnlineEndpointMapper onlineEndpointMapper = new AzureMLOnlineEndpointMapper();
            azureMLOnlineEndpointListResult.value.forEach(resource -> {
                this.fillResourceWithMissingFields((AzureMLResourceAPIRestDTO<?>)resource, workspace, resourceGroup, subscription);
                azureMLOnlineEndpoints.add(onlineEndpointMapper.map((AzureMLOnlineEndpointAPIRestDTO)resource));
            });
            logger.debugV("AzureML list of Online Endpoints for subscription '%s', resource group '%s' and workspace ''%s'' successfully retrieved.", new Object[]{subscription, resourceGroup, workspace});
            return azureMLOnlineEndpoints;
        }
        catch (Exception e) {
            logger.errorV((Throwable)e, "Error while retrieving list of AzureML Online Endpoints.", new Object[0]);
            throw e;
        }
    }

    public AzureMLEndpointKeys retrieveKeyAuthBasedOnlineEndpointCredentials_NT(AzureMLResourceIdentifier onlineEndpointId) throws IOException {
        try {
            AzureMLUtils.checkRate("Retrieve AzureML Online Endpoint Keys");
            logger.debugV("Retrieving keys for AzureML Online Endpoint '%s'.", new Object[]{onlineEndpointId.name});
            URI retrieveKeysURI = this.composeResourceURI(onlineEndpointId.subscription, onlineEndpointId.resourceGroup, onlineEndpointId.workspace, AZURE_ML_ONLINE_ENDPOINT_LIST_KEYS_URI, Collections.emptyMap(), onlineEndpointId.name);
            AzureMLEndpointKeys keys = this.execRequest_NT((HttpRequestBase)new HttpPost(retrieveKeysURI), new TypeToken<AzureMLEndpointKeys>(){}, false);
            logger.debugV("AzureML Keys for Online Endpoint '%s' successfully retrieved.", new Object[]{onlineEndpointId.name});
            return keys;
        }
        catch (Exception e) {
            logger.errorV((Throwable)e, "Error while retrieving keys for AzureML Online Endpoint with name '%s'.", new Object[]{onlineEndpointId.name});
            throw e;
        }
    }

    public AzureMLEndpointAccessToken retrieveAMLTokenBasedOnlineEndpointCredentials_NT(AzureMLResourceIdentifier onlineEndpointId) throws IOException {
        try {
            AzureMLUtils.checkRate("Retrieve AzureML Online Endpoint Token");
            logger.debugV("Retrieving token for AzureML Online Endpoint '%s'.", new Object[]{onlineEndpointId.name});
            URI retrieveTokenURI = this.composeResourceURI(onlineEndpointId.subscription, onlineEndpointId.resourceGroup, onlineEndpointId.workspace, AZURE_ML_ONLINE_ENDPOINT_TOKEN_URI, Collections.emptyMap(), onlineEndpointId.name);
            AzureMLEndpointAccessToken token = this.execRequest_NT((HttpRequestBase)new HttpPost(retrieveTokenURI), new TypeToken<AzureMLEndpointAccessToken>(){}, false);
            logger.debugV("AzureML Token for Online Endpoint '%s' successfully retrieved.", new Object[]{onlineEndpointId.name});
            return token;
        }
        catch (Exception e) {
            logger.errorV((Throwable)e, "Error while retrieving token for AzureML Online Endpoint with name '%s'.", new Object[]{onlineEndpointId.name});
            throw e;
        }
    }

    public String retrieveOnlineEndpointCredentials_NT(AzureMLResourceIdentifier onlineEndpointId) throws IOException {
        try {
            AzureMLEndpointKeys azureMLEndpointKeys = this.retrieveKeyAuthBasedOnlineEndpointCredentials_NT(onlineEndpointId);
            return azureMLEndpointKeys.primaryKey;
        }
        catch (Exception e) {
            logger.warnV((Throwable)e, "Unable to retrieve keys credentials for Online Endpoint '%s'", new Object[]{onlineEndpointId.name});
            try {
                AzureMLEndpointAccessToken azureMLEndpointAccessToken = this.retrieveAMLTokenBasedOnlineEndpointCredentials_NT(onlineEndpointId);
                return azureMLEndpointAccessToken.accessToken;
            }
            catch (Exception e2) {
                logger.errorV((Throwable)e2, "Unable to retrieve token credentials for Online Endpoint '%s'", new Object[]{onlineEndpointId.name});
                throw e2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getAPIDoc_NT(AzureMLResourceIdentifier onlineEndpointId, String location) throws IOException {
        String ret;
        int code;
        String onlineEndpointCredentials = this.retrieveOnlineEndpointCredentials_NT(onlineEndpointId);
        AzureMLUtils.checkRate("Retrieve AzureML Online Endpoint Swagger Doc");
        logger.debugV("Retrieving Swagger docs for AzureML Online Endpoint '%s'.", new Object[]{onlineEndpointId.name});
        String baseInferenceUrl = DKUApp.getParams().getParam(AZURE_ML_BASE_INFERENCE_URL_KEY, DEFAULT_AZURE_ML_BASE_INFERENCE_URL);
        HttpGet getDoc = new HttpGet(String.format(baseInferenceUrl, onlineEndpointId.name, location) + API_DOC);
        getDoc.setHeader("Authorization", String.format("Bearer %s", onlineEndpointCredentials));
        CloseableHttpResponse resp = this.httpClient.execute((HttpUriRequest)getDoc);
        try {
            code = resp.getStatusLine().getStatusCode();
            ret = new String(IOUtils.toByteArray((InputStream)resp.getEntity().getContent()), StandardCharsets.UTF_8);
        }
        finally {
            EntityUtils.consume((HttpEntity)resp.getEntity());
            getDoc.releaseConnection();
        }
        if (code != 200) {
            logger.error((Object)("Received error when querying " + getDoc.getURI().toString() + " httpcode " + code));
            logger.error((Object)("Body " + ret));
            try {
                SerializedError apiErr = (SerializedError)JSON.parse((String)ret, SerializedError.class);
                throw new APIError.SerializedErrorException(apiErr);
            }
            catch (JsonParseException jsonParseException) {
                throw new IOException("Method failed: " + code + "/" + ret);
            }
        }
        logger.debugV("AzureML Swagger docs for Online Endpoint '%s' successfully retrieved.", new Object[]{onlineEndpointId.name});
        return ret;
    }

    private URI buildSubscriptionsURI() {
        try {
            return new URIBuilder(new URI(AZURE_SUBSCRIPTIONS_URI)).addParameter(AZURE_API_VERSION_PARAM_KEY, AZURE_SUBSCRIPTIONS_API_VERSION).build();
        }
        catch (URISyntaxException uriSyntaxException) {
            String message = String.format("Error generating URI for action endpoint %s", AZURE_SUBSCRIPTIONS_URI);
            logger.error((Object)message, (Throwable)uriSyntaxException);
            throw ErrorContext.iae((String)message, (Exception)uriSyntaxException);
        }
    }

    public List<AzureSubscription> retrieveSubscriptions_NT() throws IOException {
        try {
            AzureMLUtils.checkRate("Retrieve Azure Subscriptions");
            logger.debugV("Retrieving Azure subscriptions.", new Object[0]);
            URI retrieveSubscriptionsURI = this.buildSubscriptionsURI();
            AzureListResponse<AzureSubscription> subscriptions = this.execRequest_NT((HttpRequestBase)new HttpGet(retrieveSubscriptionsURI), new TypeToken<AzureListResponse<AzureSubscription>>(){}, false);
            logger.debugV("Azure subscriptions successfully retrieved.", new Object[0]);
            return subscriptions.value;
        }
        catch (Exception e) {
            logger.errorV((Throwable)e, "Error while retrieving Azure subscriptions.", new Object[0]);
            throw e;
        }
    }

    private URI buildDeploymentsURI(String subscriptionId, String resourceGroup, String resourceName, Optional<String> deploymentName) {
        try {
            Object uri = String.format(AZURE_OPEN_AI_DEPLOYMENTS_URI, subscriptionId, resourceGroup, resourceName);
            if (deploymentName.isPresent()) {
                uri = (String)uri + "/" + deploymentName.get();
            }
            return new URIBuilder(new URI((String)uri)).addParameter(AZURE_API_VERSION_PARAM_KEY, AZURE_OPEN_AI_DEPLOYMENTS_API_VERSION).build();
        }
        catch (URISyntaxException uriSyntaxException) {
            String message = String.format("Error generating URI for action endpoint %s", AZURE_OPEN_AI_DEPLOYMENTS_URI);
            logger.error((Object)message, (Throwable)uriSyntaxException);
            throw ErrorContext.iae((String)message, (Exception)uriSyntaxException);
        }
    }

    public List<AzureDeployment> listDeployments_NT(String subscriptionId, String resourceGroup, String resourceName) throws AzureManagementAPIException {
        URI listDeploymentsURI = this.buildDeploymentsURI(subscriptionId, resourceGroup, resourceName, Optional.empty());
        try {
            AzureListResponse<AzureDeployment> deployments = this.execRequest_NT((HttpRequestBase)new HttpGet(listDeploymentsURI), new TypeToken<AzureListResponse<AzureDeployment>>(){}, false);
            return deployments.value;
        }
        catch (IOException e) {
            throw new AzureManagementAPIException(e.getMessage());
        }
    }

    public Optional<AzureDeployment> getDeployment_NT(String subscriptionId, String resourceGroup, String resourceName, String deploymentName) throws AzureManagementAPIException {
        URI getDeploymentURI = this.buildDeploymentsURI(subscriptionId, resourceGroup, resourceName, Optional.of(deploymentName));
        try {
            AzureDeployment deployment = this.execRequest_NT((HttpRequestBase)new HttpGet(getDeploymentURI), new TypeToken<AzureDeployment>(){}, true);
            return Optional.ofNullable(deployment);
        }
        catch (IOException e) {
            throw new AzureManagementAPIException(e.getMessage());
        }
    }

    public AzureDeployment createDeployment_NT(String subscriptionId, String resourceGroup, String resourceName, String deploymentName, String remoteModelId) throws AzureManagementAPIException {
        URI createDeploymentURI = this.buildDeploymentsURI(subscriptionId, resourceGroup, resourceName, Optional.of(deploymentName));
        HttpPut httpPut = new HttpPut(createDeploymentURI);
        httpPut.setEntity(JSON.toHttpEntity((Object)new AzureDeploymentCreationResource(remoteModelId)));
        try {
            AzureDeployment deployment = this.execRequest_NT((HttpRequestBase)httpPut, new TypeToken<AzureDeployment>(){}, false);
            return deployment;
        }
        catch (IOException e) {
            throw new AzureManagementAPIException(e.getMessage());
        }
    }

    public void deleteDeployment_NT(String subscriptionId, String resourceGroup, String resourceName, String deploymentName) throws AzureManagementAPIException {
        URI deleteDeploymentURI = this.buildDeploymentsURI(subscriptionId, resourceGroup, resourceName, Optional.of(deploymentName));
        try {
            this.execRequest_NT((HttpRequestBase)new HttpDelete(deleteDeploymentURI), new TypeToken<Void>(){}, true);
        }
        catch (IOException e) {
            throw new AzureManagementAPIException(e.getMessage());
        }
    }

    @Override
    public void close() {
        try {
            logger.infoV("Closing AzureML HttpClient and connection pool manager.", new Object[0]);
            this.httpClient.close();
            this.cm.close();
        }
        catch (Exception e) {
            logger.error((Object)("Unable to close AzureML HttpClient: " + ExceptionUtils.getMessageWithCauses((Throwable)e)));
        }
    }

    public static interface AzureMLDtoPojoMapper<T extends AzureMLResource, D extends AzureMLResourceAPIRestDTO<?>> {
        public TypeToken<D> getDtoType();

        public T map(D var1);
    }

    public static interface AzureMLPojoDtoMapper<T extends AzureMLResource, D extends AzureMLResourceAPIRestDTO<?>> {
        public D map(T var1);
    }

    private static interface RetrieveVersionedResourcePointer<POJO extends AzureMLVersionedResource> {
        public Optional<POJO> retrieve(AzureMLVersionedResourceIdentifier var1) throws IOException;
    }

    public static class AzureMLModelMapper
    implements AzureMLDtoPojoMapper<AzureMLModel, AzureMLModelAPIRestDTO>,
    AzureMLPojoDtoMapper<AzureMLModel, AzureMLModelAPIRestDTO> {
        @Override
        public TypeToken<AzureMLModelAPIRestDTO> getDtoType() {
            return new TypeToken<AzureMLModelAPIRestDTO>(){};
        }

        @Override
        public AzureMLModel map(AzureMLModelAPIRestDTO dto) {
            AzureMLModel model = new AzureMLModel(dto.getResourceIdentifier());
            model.id = dto.id;
            model.systemData = dto.systemData;
            model.type = dto.type;
            if (dto.properties != null) {
                model.tags = ((AzureMLModelAPIRestDTO.AzureMLModelProperties)dto.properties).tags;
                model.provisioningState = ((AzureMLModelAPIRestDTO.AzureMLModelProperties)dto.properties).provisioningState;
                model.path = ((AzureMLModelAPIRestDTO.AzureMLModelProperties)dto.properties).modelUri;
                model.description = ((AzureMLModelAPIRestDTO.AzureMLModelProperties)dto.properties).description;
                model.isArchived = ((AzureMLModelAPIRestDTO.AzureMLModelProperties)dto.properties).isArchived;
            }
            return model;
        }

        @Override
        public AzureMLModelAPIRestDTO map(AzureMLModel model) {
            AzureMLModelAPIRestDTO dto = new AzureMLModelAPIRestDTO(model.getResourceIdentifier());
            dto.id = model.id;
            dto.type = model.type;
            AzureMLModelAPIRestDTO.AzureMLModelProperties modelProperties = new AzureMLModelAPIRestDTO.AzureMLModelProperties();
            modelProperties.tags = model.tags;
            modelProperties.provisioningState = model.provisioningState;
            modelProperties.modelUri = model.path;
            modelProperties.description = model.description;
            modelProperties.isArchived = model.isArchived;
            dto.properties = modelProperties;
            return dto;
        }
    }

    public static class AzureMLEnvironmentMapper
    implements AzureMLDtoPojoMapper<AzureMLEnvironment, AzureMLEnvironmentAPIRestDTO>,
    AzureMLPojoDtoMapper<AzureMLEnvironment, AzureMLEnvironmentAPIRestDTO> {
        @Override
        public TypeToken<AzureMLEnvironmentAPIRestDTO> getDtoType() {
            return new TypeToken<AzureMLEnvironmentAPIRestDTO>(){};
        }

        @Override
        public AzureMLEnvironment map(AzureMLEnvironmentAPIRestDTO dto) {
            AzureMLEnvironment environment = new AzureMLEnvironment(dto.getResourceIdentifier());
            environment.id = dto.id;
            environment.type = dto.type;
            environment.systemData = dto.systemData;
            if (dto.properties != null) {
                environment.tags = (Map)ObjectUtils.defaultIfNull((Object)((AzureMLEnvironmentAPIRestDTO.AzureMLEnvironmentProperties)dto.properties).tags, new HashMap());
                environment.description = ((AzureMLEnvironmentAPIRestDTO.AzureMLEnvironmentProperties)dto.properties).description;
                environment.image = ((AzureMLEnvironmentAPIRestDTO.AzureMLEnvironmentProperties)dto.properties).image;
                environment.provisioningState = ((AzureMLEnvironmentAPIRestDTO.AzureMLEnvironmentProperties)dto.properties).provisioningState;
                environment.isArchived = ((AzureMLEnvironmentAPIRestDTO.AzureMLEnvironmentProperties)dto.properties).isArchived;
            }
            return environment;
        }

        @Override
        public AzureMLEnvironmentAPIRestDTO map(AzureMLEnvironment environment) {
            AzureMLEnvironmentAPIRestDTO dto = new AzureMLEnvironmentAPIRestDTO(environment.getResourceIdentifier());
            dto.id = environment.id;
            dto.type = environment.type;
            AzureMLEnvironmentAPIRestDTO.AzureMLEnvironmentProperties environmentProperties = new AzureMLEnvironmentAPIRestDTO.AzureMLEnvironmentProperties();
            environmentProperties.tags = environment.tags;
            environmentProperties.description = environment.description;
            environmentProperties.image = environment.image;
            environmentProperties.isArchived = environment.isArchived;
            dto.properties = environmentProperties;
            return dto;
        }
    }

    public static class AzureMLOnlineEndpointMapper
    implements AzureMLDtoPojoMapper<AzureMLOnlineEndpoint, AzureMLOnlineEndpointAPIRestDTO> {
        @Override
        public TypeToken<AzureMLOnlineEndpointAPIRestDTO> getDtoType() {
            return new TypeToken<AzureMLOnlineEndpointAPIRestDTO>(){};
        }

        @Override
        public AzureMLOnlineEndpoint map(AzureMLOnlineEndpointAPIRestDTO dto) {
            AzureMLOnlineEndpoint onlineEndpoint = new AzureMLOnlineEndpoint(dto.getResourceIdentifier());
            onlineEndpoint.id = dto.id;
            onlineEndpoint.type = dto.type;
            onlineEndpoint.systemData = dto.systemData;
            onlineEndpoint.kind = dto.kind;
            onlineEndpoint.location = dto.location;
            onlineEndpoint.tags = (Map)ObjectUtils.defaultIfNull(dto.tags, new HashMap());
            if (dto.properties != null) {
                onlineEndpoint.authMode = ((AzureMLOnlineEndpointAPIRestDTO.AzureMLOnlineEndpointProperties)dto.properties).authMode;
                onlineEndpoint.publicNetworkAccess = ((AzureMLOnlineEndpointAPIRestDTO.AzureMLOnlineEndpointProperties)dto.properties).publicNetworkAccess;
                onlineEndpoint.description = ((AzureMLOnlineEndpointAPIRestDTO.AzureMLOnlineEndpointProperties)dto.properties).description;
                onlineEndpoint.provisioningState = ((AzureMLOnlineEndpointAPIRestDTO.AzureMLOnlineEndpointProperties)dto.properties).provisioningState;
                onlineEndpoint.traffic = (Map)ObjectUtils.defaultIfNull(((AzureMLOnlineEndpointAPIRestDTO.AzureMLOnlineEndpointProperties)dto.properties).traffic, new HashMap());
                onlineEndpoint.openapiURI = ((AzureMLOnlineEndpointAPIRestDTO.AzureMLOnlineEndpointProperties)dto.properties).swaggerUri;
                onlineEndpoint.scoringURI = ((AzureMLOnlineEndpointAPIRestDTO.AzureMLOnlineEndpointProperties)dto.properties).scoringUri;
            }
            return onlineEndpoint;
        }
    }

    public static class AzureMLOnlineDeploymentMapper
    implements AzureMLDtoPojoMapper<AzureMLOnlineDeployment, AzureMLOnlineDeploymentAPIRestDTO> {
        @Override
        public TypeToken<AzureMLOnlineDeploymentAPIRestDTO> getDtoType() {
            return new TypeToken<AzureMLOnlineDeploymentAPIRestDTO>(){};
        }

        private AzureMLOnlineDeployment.ProbeSettings mapProbe(@Nonnull AzureMLOnlineDeploymentAPIRestDTO.ProbeSettings probeDTO) {
            AzureMLOnlineDeployment.ProbeSettings probe = new AzureMLOnlineDeployment.ProbeSettings();
            probe.initialDelay = Ints.checkedCast((long)Duration.parse(probeDTO.initialDelay).getSeconds());
            probe.period = Ints.checkedCast((long)Duration.parse(probeDTO.period).getSeconds());
            probe.timeout = Ints.checkedCast((long)Duration.parse(probeDTO.timeout).getSeconds());
            probe.successThreshold = probeDTO.successThreshold;
            probe.failureThreshold = probeDTO.failureThreshold;
            return probe;
        }

        @Override
        public AzureMLOnlineDeployment map(AzureMLOnlineDeploymentAPIRestDTO dto) {
            AzureMLOnlineDeployment onlineDeployment = new AzureMLOnlineDeployment(dto.getResourceIdentifier());
            onlineDeployment.id = dto.id;
            onlineDeployment.type = dto.type;
            onlineDeployment.systemData = dto.systemData;
            onlineDeployment.tags = (Map)ObjectUtils.defaultIfNull(dto.tags, new HashMap());
            int n = onlineDeployment.instanceCount = dto.sku != null ? dto.sku.capacity : 0;
            if (dto.properties != null) {
                onlineDeployment.modelURI = ((AzureMLOnlineDeploymentAPIRestDTO.AzureMLOnlineDeploymentProperties)dto.properties).model;
                onlineDeployment.environment = ((AzureMLOnlineDeploymentAPIRestDTO.AzureMLOnlineDeploymentProperties)dto.properties).environmentId;
                onlineDeployment.instanceType = ((AzureMLOnlineDeploymentAPIRestDTO.AzureMLOnlineDeploymentProperties)dto.properties).instanceType;
                onlineDeployment.appInsightsEnabled = ((AzureMLOnlineDeploymentAPIRestDTO.AzureMLOnlineDeploymentProperties)dto.properties).appInsightsEnabled;
                onlineDeployment.egressPublicNetworkAccess = ((AzureMLOnlineDeploymentAPIRestDTO.AzureMLOnlineDeploymentProperties)dto.properties).egressPublicNetworkAccess;
                onlineDeployment.environmentVariables = ((AzureMLOnlineDeploymentAPIRestDTO.AzureMLOnlineDeploymentProperties)dto.properties).environmentVariables;
                onlineDeployment.provisioningState = ((AzureMLOnlineDeploymentAPIRestDTO.AzureMLOnlineDeploymentProperties)dto.properties).provisioningState;
                onlineDeployment.livenessProbe = ((AzureMLOnlineDeploymentAPIRestDTO.AzureMLOnlineDeploymentProperties)dto.properties).livenessProbe != null ? this.mapProbe(((AzureMLOnlineDeploymentAPIRestDTO.AzureMLOnlineDeploymentProperties)dto.properties).livenessProbe) : null;
                onlineDeployment.readinessProbe = ((AzureMLOnlineDeploymentAPIRestDTO.AzureMLOnlineDeploymentProperties)dto.properties).readinessProbe != null ? this.mapProbe(((AzureMLOnlineDeploymentAPIRestDTO.AzureMLOnlineDeploymentProperties)dto.properties).readinessProbe) : null;
                onlineDeployment.description = ((AzureMLOnlineDeploymentAPIRestDTO.AzureMLOnlineDeploymentProperties)dto.properties).description;
            }
            return onlineDeployment;
        }
    }

    private static class AzureListResponse<T> {
        public List<T> value;

        private AzureListResponse() {
        }
    }

    private static class AzureMLEndpointKeys {
        public String primaryKey;
        public String secondaryKey;
    }

    private static class AzureMLEndpointAccessToken {
        public String accessToken;
        public String tokenType;
    }

    public class AzureManagementAPIException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public AzureManagementAPIException(String message) {
            super(message);
        }
    }

    public static class AzureDeployment {
        public String id;
        public String type;
        public String name;
        public String etag;
        public Sku sku;
        public Properties properties;

        public static class Properties {
            public Model model;
            public Capabilities capabilities;
            public String provisioningState;
            public List<RateLimit> rateLimits;

            public static class RateLimit {
                public String key;
                public int renewalPeriod;
                public int count;
            }

            public static class Capabilities {
                public String maxContextToken;
                public String maxOutputToken;
                public String chatCompletion;
                public String completion;
            }

            public static class Model {
                public String format;
                public String name;
                public String version;
            }
        }

        public static class Sku {
            public String name;
            public int capacity;
        }
    }

    private static class AzureDeploymentCreationResource {
        private AzureDeployment.Sku sku = new AzureDeployment.Sku();
        private AzureDeployment.Properties properties;

        AzureDeploymentCreationResource(String modelName) {
            this.sku.capacity = 1;
            this.sku.name = "standard";
            this.properties = new AzureDeployment.Properties();
            this.properties.model = new AzureDeployment.Properties.Model();
            this.properties.model.format = "OpenAI";
            this.properties.model.name = modelName;
            this.properties.model.version = "1";
        }
    }

    public static class AzureSubscription {
        public String id;
        public String tenantId;

        public String getSubscriptionId() {
            return this.id.replace("/subscriptions/", "");
        }
    }
}

