/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.externalinfras.vertexai;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.DKUApp;
import com.dataiku.dip.ProxySettings;
import com.dataiku.dip.apideployer.DeployerCodes;
import com.dataiku.dip.apideployer.datamodel.actual.DeploymentHealth;
import com.dataiku.dip.connections.ConnectionWithBasicCredential;
import com.dataiku.dip.connections.ConnectionWithGoogleAuthCredentials;
import com.dataiku.dip.connections.GoogleCredentialsBuilder;
import com.dataiku.dip.connections.VertexAIModelDeploymentConnection;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.exceptions.DSSInternalErrorException;
import com.dataiku.dip.externalinfras.ExternalInfraEndpoint;
import com.dataiku.dip.externalinfras.ExternalInfraRegionDTO;
import com.dataiku.dip.externalinfras.ExternalInfrasUtils;
import com.dataiku.dip.externalinfras.vertexai.datamodel.GCPProject;
import com.dataiku.dip.externalinfras.vertexai.datamodel.VertexAICreateEndpointRequest;
import com.dataiku.dip.externalinfras.vertexai.datamodel.VertexAICreateModelRequest;
import com.dataiku.dip.externalinfras.vertexai.datamodel.VertexAIDeployedModelConfig;
import com.dataiku.dip.externalinfras.vertexai.datamodel.VertexAIEndpoint;
import com.dataiku.dip.externalinfras.vertexai.datamodel.VertexAIModel;
import com.dataiku.dip.externalinfras.vertexai.datamodel.VertexAIModelConfig;
import com.dataiku.dip.externalinfras.vertexai.datamodel.VertexAIModelInternalConfig;
import com.dataiku.dip.futures.FuturePayload;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.futures.FutureThread;
import com.dataiku.dip.savedmodels.proxymodelversions.ProxyModelVersionConfiguration;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.security.auth.UserAuthenticationException;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.util.ProxyUtils;
import com.dataiku.dip.util.RateLimiterRegistry;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.Pair;
import com.dataiku.dip.utils.Params;
import com.dataiku.dss.shadelib.com.google.common.util.concurrent.RateLimiter;
import com.dataiku.dss.shadelibgcp.com.google.api.client.http.HttpTransport;
import com.dataiku.dss.shadelibgcp.com.google.api.gax.core.CredentialsProvider;
import com.dataiku.dss.shadelibgcp.com.google.api.gax.core.FixedCredentialsProvider;
import com.dataiku.dss.shadelibgcp.com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.dataiku.dss.shadelibgcp.com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.dataiku.dss.shadelibgcp.com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.dataiku.dss.shadelibgcp.com.google.api.gax.retrying.RetrySettings;
import com.dataiku.dss.shadelibgcp.com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.dataiku.dss.shadelibgcp.com.google.api.gax.rpc.TransportChannelProvider;
import com.dataiku.dss.shadelibgcp.com.google.auth.Credentials;
import com.dataiku.dss.shadelibgcp.com.google.auth.oauth2.AccessToken;
import com.dataiku.dss.shadelibgcp.com.google.auth.oauth2.GoogleCredentials;
import com.dataiku.dss.shadelibgcp.com.google.cloud.MetadataConfig;
import com.dataiku.dss.shadelibgcp.com.google.cloud.aiplatform.v1.AcceleratorType;
import com.dataiku.dss.shadelibgcp.com.google.cloud.aiplatform.v1.CreateEndpointRequest;
import com.dataiku.dss.shadelibgcp.com.google.cloud.aiplatform.v1.DedicatedResources;
import com.dataiku.dss.shadelibgcp.com.google.cloud.aiplatform.v1.DeployModelRequest;
import com.dataiku.dss.shadelibgcp.com.google.cloud.aiplatform.v1.DeployModelResponse;
import com.dataiku.dss.shadelibgcp.com.google.cloud.aiplatform.v1.DeployedModel;
import com.dataiku.dss.shadelibgcp.com.google.cloud.aiplatform.v1.Endpoint;
import com.dataiku.dss.shadelibgcp.com.google.cloud.aiplatform.v1.EndpointName;
import com.dataiku.dss.shadelibgcp.com.google.cloud.aiplatform.v1.EndpointServiceClient;
import com.dataiku.dss.shadelibgcp.com.google.cloud.aiplatform.v1.EndpointServiceSettings;
import com.dataiku.dss.shadelibgcp.com.google.cloud.aiplatform.v1.EnvVar;
import com.dataiku.dss.shadelibgcp.com.google.cloud.aiplatform.v1.ListEndpointsRequest;
import com.dataiku.dss.shadelibgcp.com.google.cloud.aiplatform.v1.ListModelsRequest;
import com.dataiku.dss.shadelibgcp.com.google.cloud.aiplatform.v1.LocationName;
import com.dataiku.dss.shadelibgcp.com.google.cloud.aiplatform.v1.MachineSpec;
import com.dataiku.dss.shadelibgcp.com.google.cloud.aiplatform.v1.Model;
import com.dataiku.dss.shadelibgcp.com.google.cloud.aiplatform.v1.ModelContainerSpec;
import com.dataiku.dss.shadelibgcp.com.google.cloud.aiplatform.v1.ModelName;
import com.dataiku.dss.shadelibgcp.com.google.cloud.aiplatform.v1.ModelServiceClient;
import com.dataiku.dss.shadelibgcp.com.google.cloud.aiplatform.v1.ModelServiceSettings;
import com.dataiku.dss.shadelibgcp.com.google.cloud.aiplatform.v1.Port;
import com.dataiku.dss.shadelibgcp.com.google.cloud.aiplatform.v1.PredictRequest;
import com.dataiku.dss.shadelibgcp.com.google.cloud.aiplatform.v1.PredictResponse;
import com.dataiku.dss.shadelibgcp.com.google.cloud.aiplatform.v1.PredictionServiceClient;
import com.dataiku.dss.shadelibgcp.com.google.cloud.aiplatform.v1.PredictionServiceSettings;
import com.dataiku.dss.shadelibgcp.com.google.cloud.aiplatform.v1.UpdateEndpointRequest;
import com.dataiku.dss.shadelibgcp.com.google.cloud.aiplatform.v1.UpdateModelRequest;
import com.dataiku.dss.shadelibgcp.com.google.cloud.aiplatform.v1.UploadModelRequest;
import com.dataiku.dss.shadelibgcp.com.google.cloud.aiplatform.v1.UploadModelResponse;
import com.dataiku.dss.shadelibgcp.com.google.cloud.compute.v1.MachineType;
import com.dataiku.dss.shadelibgcp.com.google.cloud.compute.v1.MachineTypesClient;
import com.dataiku.dss.shadelibgcp.com.google.cloud.compute.v1.MachineTypesSettings;
import com.dataiku.dss.shadelibgcp.com.google.cloud.compute.v1.Region;
import com.dataiku.dss.shadelibgcp.com.google.cloud.compute.v1.RegionsClient;
import com.dataiku.dss.shadelibgcp.com.google.cloud.compute.v1.RegionsSettings;
import com.dataiku.dss.shadelibgcp.com.google.cloud.resourcemanager.v3.Project;
import com.dataiku.dss.shadelibgcp.com.google.cloud.resourcemanager.v3.ProjectName;
import com.dataiku.dss.shadelibgcp.com.google.cloud.resourcemanager.v3.ProjectsClient;
import com.dataiku.dss.shadelibgcp.com.google.cloud.resourcemanager.v3.ProjectsSettings;
import com.dataiku.dss.shadelibgcp.com.google.protobuf.FieldMask;
import com.dataiku.dss.shadelibgcp.com.google.protobuf.InvalidProtocolBufferException;
import com.dataiku.dss.shadelibgcp.com.google.protobuf.ListValue;
import com.dataiku.dss.shadelibgcp.com.google.protobuf.Message;
import com.dataiku.dss.shadelibgcp.com.google.protobuf.ProtocolStringList;
import com.dataiku.dss.shadelibgcp.com.google.protobuf.util.JsonFormat;
import com.dataiku.dss.shadelibgcp.org.threeten.bp.Duration;
import com.google.gson.JsonArray;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public class VertexAIUtils {
    private static final String VERTEX_AI_RATE_LIMITER_NAME = "vertexAIUtils";
    private static final String VERTEX_AI_ENDPOINT_FORMAT_CONFIG_KEY = "dku.deployer.deployment.vertex_ai.utils.endpointFormat";
    private static final String DEFAULT_VERTEX_AI_ENDPOINT_FORMAT = "%s-aiplatform.googleapis.com:443";
    private static final double DEFAULT_VERTEX_AI_RATE_LIMIT = 5.0;
    private static final int TIMEOUT_SECONDS = 3600;
    public static final String AUTH_API_SCOPE_URL = "https://www.googleapis.com/auth/cloud-platform";
    @Nonnull
    private final String location;
    @Nonnull
    private final String project;
    @Nonnull
    private final CredentialsProvider credentialsProvider;
    @Nonnull
    private final ProxySettings proxySettings;
    @Nonnull
    private final String aiPlatformEndpoint;
    private final RetrySettings defaultOperationRetrySettings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build();
    private static List<ExternalInfraRegionDTO> vertexAIRegions;
    private static final DKULogger logger;

    public static VertexAIUtils from(String gcpRegion, String gcpProjectId, GoogleCredentials credentials, @Nullable VertexAIModelDeploymentConnection connection) {
        return new VertexAIUtils(gcpRegion, gcpProjectId, credentials, connection);
    }

    public static GoogleCredentials getGoogleCredentials_NT(@Nonnull AuthCtx authCtx, @Nullable VertexAIModelDeploymentConnection connection) throws DKUSecurityException, IOException, URISyntaxException {
        GoogleCredentials credentials;
        TransactionContext.assertNoAttachedTransaction();
        logger.info((Object)"Trying to get Google cloud credentials");
        if (Objects.nonNull(connection)) {
            logger.infoV("Retrieving credentials from connection %s", new Object[]{connection.name});
            ConnectionWithBasicCredential.CredentialResolutionContext ctx = new ConnectionWithBasicCredential.CredentialResolutionContext(authCtx, null);
            ConnectionWithGoogleAuthCredentials.SerializableGoogleAuthCredentials creds = connection.getFullyResolvedCredentials_fsLike(ctx, ConnectionWithGoogleAuthCredentials.SerializableGoogleAuthCredentials.class);
            credentials = creds.toGoogleCredentials(ctx, connection);
            if (credentials.createScopedRequired()) {
                credentials = credentials.createScoped(new String[]{AUTH_API_SCOPE_URL});
            }
        } else {
            logger.info((Object)"No connection specified, retrieving the Application Default Credentials from the environment");
            ProxySettings proxySettings = ApplicationConfigurator.getProxySettings();
            credentials = new GoogleCredentialsBuilder().buildNewGoogleCredentials((HttpTransport)ProxyUtils.getNetHttpTransport((ProxySettings)proxySettings), null, null, true);
        }
        if (credentials != null) {
            logger.infoV("Got credentials of type %s", new Object[]{credentials.getClass().getSimpleName()});
        } else {
            logger.warn((Object)"No Google credentials were found. The following actions on GCP will probably fail. Check your infrastructure settings");
        }
        return credentials;
    }

    public static FixedCredentialsProvider createFixedCredentialsProvider(GoogleCredentials credentials) {
        return FixedCredentialsProvider.create((Credentials)credentials);
    }

    public static void prepareEnvForPush_NT(File contextDir, GoogleCredentials credentials, Map<String, String> additionalEnv) throws IOException, UserAuthenticationException {
        TransactionContext.assertNoAttachedTransaction();
        if (credentials != null) {
            AccessToken accessToken;
            File gCloudSDKConfigDirectory = new File(contextDir, ".gcloud");
            logger.infoV("Creating a temporary gcloud configuration directory %s and setting the CLOUDSDK_CONFIG environment variable accordingly. This will be used by the deployment scripts", new Object[]{gCloudSDKConfigDirectory.getAbsolutePath()});
            DKUFileUtils.mkdirs((File)gCloudSDKConfigDirectory);
            additionalEnv.put("CLOUDSDK_CONFIG", gCloudSDKConfigDirectory.getAbsolutePath());
            if (credentials.getAccessToken() == null) {
                logger.debug((Object)"No access token available in the retrieved Google credentials, will try to refresh it");
                accessToken = credentials.refreshAccessToken();
                if (accessToken == null) {
                    logger.error((Object)"Failed to refresh the access token from the retrieved Google credentials");
                    throw new UserAuthenticationException("Failed to obtain an access token to authenticate on GCP");
                }
            } else {
                accessToken = credentials.getAccessToken();
            }
            logger.info((Object)"Got an access token for GCP from the Google credentials. It will be available in deployment scripts though the environment variable CLOUDSDK_AUTH_ACCESS_TOKEN");
            additionalEnv.put("CLOUDSDK_AUTH_ACCESS_TOKEN", accessToken.getTokenValue());
        }
    }

    public static String extractEndpointId(@Nonnull String fullName) {
        EndpointName name = EndpointName.parse((String)fullName);
        return name.getEndpoint();
    }

    public static String extractModelId(@Nonnull String fullName) {
        ModelName name = ModelName.parse((String)fullName);
        return name.getModel();
    }

    private VertexAIUtils(@Nonnull String location, @Nonnull String project, GoogleCredentials credentials, @Nullable VertexAIModelDeploymentConnection connection) {
        ErrorContext.checkNotEmpty((String)location, (String)"GCP region");
        ErrorContext.checkNotEmpty((String)project, (String)"GCP project");
        this.location = location;
        this.project = project;
        this.credentialsProvider = VertexAIUtils.createFixedCredentialsProvider(credentials);
        this.proxySettings = ExternalInfrasUtils.getProxy(connection);
        Params p = DKUApp.getParams();
        String endpointFormat = p.getParam(VERTEX_AI_ENDPOINT_FORMAT_CONFIG_KEY, DEFAULT_VERTEX_AI_ENDPOINT_FORMAT);
        this.aiPlatformEndpoint = String.format(endpointFormat, location);
    }

    public static boolean areEndpointFullNamesEqual(@Nonnull String name1, @Nonnull String name2, boolean ignoreProject) {
        EndpointName endpointName1 = EndpointName.parse((String)name1);
        EndpointName endpointName2 = EndpointName.parse((String)name2);
        if (endpointName1 == null || endpointName2 == null) {
            return endpointName1 == endpointName2;
        }
        if (!ignoreProject && !Objects.equals(endpointName1.getProject(), endpointName2.getProject())) {
            return false;
        }
        if (!Objects.equals(endpointName1.getLocation(), endpointName2.getLocation())) {
            return false;
        }
        return Objects.equals(endpointName1.getEndpoint(), endpointName2.getEndpoint());
    }

    public static boolean areModelFullNamesEqual(@Nonnull String name1, @Nonnull String name2, boolean ignoreProject) {
        ModelName modelName1 = ModelName.parse((String)name1);
        ModelName modelName2 = ModelName.parse((String)name2);
        if (modelName1 == null || modelName2 == null) {
            return modelName1 == modelName2;
        }
        if (!ignoreProject && !Objects.equals(modelName1.getProject(), modelName2.getProject())) {
            return false;
        }
        if (!Objects.equals(modelName1.getLocation(), modelName2.getLocation())) {
            return false;
        }
        return Objects.equals(modelName1.getModel(), modelName2.getModel());
    }

    @Nullable
    public static String getDefaultConfiguredRegion_NT() {
        TransactionContext.assertNoAttachedTransaction();
        String zone = MetadataConfig.getZone();
        if (zone == null) {
            return null;
        }
        return VertexAIUtils.getRegionOfZone(zone);
    }

    @Nullable
    public static String getDefaultConfiguredProject_NT() {
        TransactionContext.assertNoAttachedTransaction();
        return MetadataConfig.getProjectId();
    }

    public static Optional<DeployedModel> getDeployedModel(@Nullable String deployedModelId, @Nullable Endpoint endpoint) {
        if (StringUtils.isBlank((String)deployedModelId) || endpoint == null) {
            return Optional.empty();
        }
        return endpoint.getDeployedModelsList().stream().filter(deployedModel -> deployedModel.getId().equals(deployedModelId)).findFirst();
    }

    public Optional<Endpoint> getEndpoint_NT(@Nullable String endpointId) throws IOException {
        TransactionContext.assertNoAttachedTransaction();
        if (StringUtils.isBlank((String)endpointId)) {
            return Optional.empty();
        }
        try (EndpointServiceClient serviceClient = this.getEndpointServiceClient();){
            Optional<Endpoint> optional = this.getEndpoint_NT(endpointId, serviceClient);
            return optional;
        }
    }

    public Optional<Model> getModel_NT(@Nullable String modelId) throws IOException {
        if (StringUtils.isBlank((String)modelId)) {
            return Optional.empty();
        }
        try (ModelServiceClient serviceClient = this.getModelServiceClient();){
            Optional<Model> optional = this.getModel_NT(modelId, serviceClient);
            return optional;
        }
    }

    public Model createModel_NT(@Nonnull VertexAICreateModelRequest requestedModel) throws IOException, ExecutionException, InterruptedException {
        TransactionContext.assertNoAttachedTransaction();
        try (ModelServiceClient modelServiceClient = this.getModelServiceClient();){
            VertexAIUtils.checkRate("Create Vertex AI model");
            UploadModelRequest request = this.getUploadModelRequest(requestedModel);
            UploadModelResponse response = (UploadModelResponse)modelServiceClient.uploadModelAsync(request).get();
            VertexAIUtils.checkRate("Fetch Vertex AI model just created");
            Model model = modelServiceClient.getModel(response.getModel());
            return model;
        }
    }

    public Model updateModelLabels_NT(@Nonnull VertexAIModel storedModel) throws IOException {
        TransactionContext.assertNoAttachedTransaction();
        try (ModelServiceClient modelServiceClient = this.getModelServiceClient();){
            String modelName = storedModel.getFullName();
            Map<String, String> tags = storedModel.config.tags;
            Iterable<Model> versions = this.listModelVersions_NT(modelName, modelServiceClient);
            for (Model version : versions) {
                this.updateModelLabels_NT(version.getName(), tags, modelServiceClient);
            }
            Model model = this.updateModelLabels_NT(modelName, tags, modelServiceClient);
            return model;
        }
    }

    public Endpoint createEndpoint_NT(@Nonnull VertexAICreateEndpointRequest requestedEndpoint) throws IOException, ExecutionException, InterruptedException {
        TransactionContext.assertNoAttachedTransaction();
        try (EndpointServiceClient endpointServiceClient = this.getEndpointServiceClient();){
            VertexAIUtils.checkRate("Create Vertex AI endpoint");
            CreateEndpointRequest createEndpointRequest = this.getCreateEndpointRequest(requestedEndpoint);
            Endpoint endpoint = (Endpoint)endpointServiceClient.createEndpointAsync(createEndpointRequest).get();
            Endpoint endpoint2 = this.correctEndpoint(requestedEndpoint.endpointId, endpoint, endpointServiceClient);
            return endpoint2;
        }
    }

    public void deleteModel_NT(@Nonnull String modelId) throws IOException, ExecutionException, InterruptedException {
        try (ModelServiceClient serviceClient = this.getModelServiceClient();){
            Optional<Model> modelOptional = this.getModel_NT(modelId, serviceClient);
            if (modelOptional.isPresent()) {
                VertexAIUtils.checkRate("Delete Vertex AI model");
                logger.info((Object)("Deleting Vertex AI model with id " + modelId));
                Model model = modelOptional.get();
                serviceClient.deleteModelAsync(model.getName()).get();
                logger.infoV("Vertex AI model with id %s deleted.", new Object[]{modelId});
            } else {
                logger.infoV("Vertex AI model with id %s does not exist.", new Object[]{modelId});
            }
        }
    }

    public void undeployModelsThenDeleteEndpoint_NT(@Nonnull String endpointId) throws IOException, ExecutionException, InterruptedException {
        try (EndpointServiceClient serviceClient = this.getEndpointServiceClient();){
            Optional<Endpoint> endpointOptional = this.getEndpoint_NT(endpointId, serviceClient);
            if (endpointOptional.isPresent()) {
                logger.info((Object)("Deleting Vertex AI endpoint with id " + endpointId));
                Endpoint endpoint = endpointOptional.get();
                this.deleteDeployedModels_NT(endpoint, serviceClient);
                this.deleteEndpointWithoutDeployedModels_NT(serviceClient, endpoint.getName());
                logger.infoV("Vertex AI endpoint with id %s deleted.", new Object[]{endpointId});
            } else {
                logger.infoV("Vertex AI endpoint with id %s does not exist.", new Object[]{endpointId});
            }
        }
    }

    public void undeployModels_NT(@Nonnull String endpointId) throws IOException, ExecutionException, InterruptedException {
        try (EndpointServiceClient serviceClient = this.getEndpointServiceClient();){
            Optional<Endpoint> endpointOptional = this.getEndpoint_NT(endpointId, serviceClient);
            if (endpointOptional.isPresent()) {
                logger.info((Object)("Undeploying models deployed on Vertex AI endpoint " + endpointId));
                this.deleteDeployedModels_NT(endpointOptional.get(), serviceClient);
                logger.infoV("Vertex AI endpoint with id %s has no longer deployed models.", new Object[]{endpointId});
            } else {
                logger.infoV("Vertex AI endpoint with id %s does not exist.", new Object[]{endpointId});
            }
        }
    }

    public Endpoint updateEndpoint_NT(VertexAIEndpoint storedEndpoint) throws IOException {
        TransactionContext.assertNoAttachedTransaction();
        try (EndpointServiceClient serviceClient = this.getEndpointServiceClient();){
            VertexAIUtils.checkRate("Update Vertex AI endpoint");
            UpdateEndpointRequest request = VertexAIUtils.getUpdateEndpointRequest(storedEndpoint);
            Endpoint endpoint = serviceClient.updateEndpoint(request);
            return endpoint;
        }
    }

    public DeployedModel replaceDeployedModels_NT(Model model, Endpoint endpoint, VertexAIDeployedModelConfig config) throws IOException, ExecutionException, InterruptedException {
        TransactionContext.assertNoAttachedTransaction();
        try (EndpointServiceClient serviceClient = this.getEndpointServiceClient();){
            this.deleteDeployedModels_NT(endpoint, serviceClient);
            DeployModelResponse response = this.deployModelToEndpoint_NT(model.getName(), endpoint.getName(), config, serviceClient);
            DeployedModel deployedModel = response.getDeployedModel();
            return deployedModel;
        }
    }

    public PredictResponse predict_NT(String endpointId, JsonArray query) throws IOException {
        TransactionContext.assertNoAttachedTransaction();
        try (PredictionServiceClient serviceClient = this.getPredictionServiceClient();){
            EndpointName endpointName = this.computeEndpointName(endpointId);
            PredictRequest request = this.getPredictRequest(endpointName, query);
            PredictResponse predictResponse = serviceClient.predict(request);
            return predictResponse;
        }
    }

    public Set<String> getMachineTypes_NT() throws IOException {
        Region region = this.getRegion_NT();
        ProtocolStringList zoneNames = region.getZonesList();
        return this.getMachineTypes_NT((List<String>)zoneNames);
    }

    public static List<AcceleratorType> getAcceleratorTypes() {
        return Arrays.stream(AcceleratorType.values()).filter(e -> !e.equals((Object)AcceleratorType.UNRECOGNIZED)).collect(Collectors.toList());
    }

    public static String getRegionOfZone(@Nonnull String zone) {
        Pattern regionPattern = Pattern.compile("^(.+\\d)-\\w+$");
        Matcher regionMatcher = regionPattern.matcher(zone);
        if (regionMatcher.matches()) {
            return regionMatcher.group(1);
        }
        throw new IllegalArgumentException("Unable to find region for zone " + zone);
    }

    private Region getRegion_NT() throws IOException {
        TransactionContext.assertNoAttachedTransaction();
        try (RegionsClient regionsClient = this.getRegionsClient();){
            VertexAIUtils.checkRate("Get Vertex AI region");
            Region region = regionsClient.get(this.project, this.location);
            return region;
        }
    }

    @Nonnull
    private Set<String> getMachineTypes_NT(List<String> zoneNames) throws IOException {
        TransactionContext.assertNoAttachedTransaction();
        HashSet<String> machineTypes = new HashSet<String>();
        try (MachineTypesClient machineTypesClient = this.getMachineTypesClient();){
            for (String zoneName : zoneNames) {
                VertexAIUtils.checkRate("Get Vertex AI machine types");
                String[] zoneElements = zoneName.split("/");
                if (zoneElements.length <= 0) continue;
                String zone = zoneElements[zoneElements.length - 1];
                Iterable types = machineTypesClient.list(this.project, zone).iterateAll();
                for (MachineType machineType : types) {
                    machineTypes.add(machineType.getName());
                }
            }
        }
        return machineTypes;
    }

    private EndpointName computeEndpointName(@Nonnull String endpointId) {
        return VertexAIUtils.computeEndpointName(this.project, this.location, endpointId);
    }

    public static EndpointName computeEndpointName(@Nonnull String gcpProjectId, @Nonnull String gcpRegion, @Nonnull String endpointId) {
        return EndpointName.of((String)gcpProjectId, (String)gcpRegion, (String)endpointId);
    }

    public static ModelName computeModelName(@Nonnull String gcpProjectId, @Nonnull String gcpRegion, @Nonnull String modelId) {
        return ModelName.of((String)gcpProjectId, (String)gcpRegion, (String)modelId);
    }

    private LocationName computeLocationName() {
        return LocationName.of((String)this.project, (String)this.location);
    }

    private void deleteEndpointWithoutDeployedModels_NT(EndpointServiceClient serviceClient, String endpointName) throws InterruptedException, ExecutionException {
        TransactionContext.assertNoAttachedTransaction();
        VertexAIUtils.checkRate("Delete Vertex AI endpoint");
        serviceClient.deleteEndpointAsync(endpointName).get();
    }

    private DeployModelResponse deployModelToEndpoint_NT(String modelName, String endpointName, VertexAIDeployedModelConfig config, EndpointServiceClient endpointServiceClient) throws InterruptedException, ExecutionException {
        TransactionContext.assertNoAttachedTransaction();
        VertexAIUtils.checkRate("Deploy Vertex AI model on endpoint");
        DeployModelRequest deployModelRequest = this.getDeployModelRequest(modelName, endpointName, config);
        return (DeployModelResponse)endpointServiceClient.deployModelAsync(deployModelRequest).get();
    }

    private Endpoint correctEndpoint(@Nonnull String expectedEndpointId, @Nonnull Endpoint initialEndpoint, @Nonnull EndpointServiceClient serviceClient) {
        String initialEndpointId = VertexAIUtils.extractEndpointId(initialEndpoint.getName());
        if (expectedEndpointId.equals(initialEndpointId)) {
            return initialEndpoint;
        }
        VertexAIUtils.checkRate("Fetch corrected Vertex AI endpoint");
        logger.infoV("Request sent to create a new Vertex AI endpoint with id %s. The new Vertex AI endpoint has been created successfully with id %s. Since there is a bug in Vertex AI where those two ids are not the same, we re-fetch the endpoint.", new Object[]{expectedEndpointId, initialEndpointId});
        Endpoint correctedEndpoint = serviceClient.getEndpoint(initialEndpoint.getName());
        String correctedEndpointId = VertexAIUtils.extractEndpointId(correctedEndpoint.getName());
        if (!expectedEndpointId.equals(correctedEndpointId)) {
            String errorMessage = String.format("The endpoint id returned by Vertex AI '%s' is not the one asked by DSS '%s'. This should never happen, contact Dataiku support.", correctedEndpointId, expectedEndpointId);
            logger.error((Object)errorMessage);
            throw new DSSInternalErrorException(errorMessage);
        }
        logger.infoV("Vertex endpoint id successfully corrected to %s.", new Object[]{expectedEndpointId});
        return correctedEndpoint;
    }

    public Iterable<Endpoint> listEndpoints_NT(@Nullable String endpointId) throws IOException {
        try (EndpointServiceClient endpointServiceClient = this.getEndpointServiceClient();){
            Iterable<Endpoint> iterable = this.listEndpoints_NT(endpointId, endpointServiceClient);
            return iterable;
        }
    }

    private Iterable<Endpoint> listEndpoints_NT(@Nullable String endpointId, EndpointServiceClient serviceClient) {
        TransactionContext.assertNoAttachedTransaction();
        ListEndpointsRequest.Builder requestBuilder = ListEndpointsRequest.newBuilder().setParent(this.computeLocationName().toString());
        if (StringUtils.isNotBlank((String)endpointId)) {
            requestBuilder.setFilter("endpoint=" + endpointId);
        }
        VertexAIUtils.checkRate("List endpoints");
        return serviceClient.listEndpoints(requestBuilder.build()).iterateAll();
    }

    private Optional<Endpoint> getEndpoint_NT(@Nonnull String endpointId, EndpointServiceClient serviceClient) {
        Iterator<Endpoint> iterator = this.listEndpoints_NT(endpointId, serviceClient).iterator();
        if (iterator.hasNext()) {
            return Optional.of(iterator.next());
        }
        return Optional.empty();
    }

    private Iterable<Model> listModelVersions_NT(@Nonnull String modelName, ModelServiceClient modelServiceClient) {
        TransactionContext.assertNoAttachedTransaction();
        VertexAIUtils.checkRate("List Vertex AI model versions");
        return modelServiceClient.listModelVersions(modelName).iterateAll();
    }

    private Model updateModelLabels_NT(@Nonnull String modelName, Map<String, String> tags, ModelServiceClient modelServiceClient) {
        TransactionContext.assertNoAttachedTransaction();
        VertexAIUtils.checkRate("Update Vertex AI model or version");
        UpdateModelRequest request = this.getUpdateModelLabelsRequest(modelName, tags);
        return modelServiceClient.updateModel(request);
    }

    private Optional<Model> getModel_NT(@Nonnull String modelId, ModelServiceClient serviceClient) {
        TransactionContext.assertNoAttachedTransaction();
        VertexAIUtils.checkRate("Search Vertex AI model");
        ListModelsRequest request = ListModelsRequest.newBuilder().setParent(this.computeLocationName().toString()).setFilter("model=" + modelId).build();
        ModelServiceClient.ListModelsPagedResponse response = serviceClient.listModels(request);
        Iterator iterator = response.iterateAll().iterator();
        if (iterator.hasNext()) {
            return Optional.of((Model)iterator.next());
        }
        return Optional.empty();
    }

    private void deleteDeployedModels_NT(Endpoint endpoint, EndpointServiceClient serviceClient) throws InterruptedException, ExecutionException {
        TransactionContext.assertNoAttachedTransaction();
        Map<String, Integer> trafficSplit = endpoint.getTrafficSplitMap();
        for (DeployedModel deployedModel : endpoint.getDeployedModelsList()) {
            VertexAIUtils.checkRate("Delete Vertex AI deployed model associated to endpoint");
            trafficSplit = this.redispatchTrafficSplit(trafficSplit, deployedModel.getId());
            serviceClient.undeployModelAsync(endpoint.getName(), deployedModel.getId(), trafficSplit).get();
        }
    }

    private Map<String, Integer> redispatchTrafficSplit(Map<String, Integer> trafficSplit, String deletedEndpointId) {
        HashMap<String, Integer> newTrafficSplit = new HashMap<String, Integer>(trafficSplit);
        Integer deletedTraffic = newTrafficSplit.remove(deletedEndpointId);
        if (deletedTraffic == null || newTrafficSplit.size() == 0) {
            return newTrafficSplit;
        }
        String receivingEndpointId = new ArrayList<String>(newTrafficSplit.keySet()).get(0);
        Integer receivingEndpointTraffic = newTrafficSplit.get(receivingEndpointId);
        newTrafficSplit.put(receivingEndpointId, receivingEndpointTraffic + deletedTraffic);
        return newTrafficSplit;
    }

    private static void checkRate(String action) {
        double waited = VertexAIUtils.getVertexAIRateLimiter().acquire();
        if (waited > 0.0) {
            logger.infoV("Waited %.3f seconds for %s (rate-limited by %s)", new Object[]{waited, action, VERTEX_AI_RATE_LIMITER_NAME});
        }
    }

    private static RateLimiter getVertexAIRateLimiter() {
        return RateLimiterRegistry.forName(VERTEX_AI_RATE_LIMITER_NAME, 5.0);
    }

    private EndpointServiceClient getEndpointServiceClient() throws IOException {
        EndpointServiceSettings.Builder settingsBuilder = EndpointServiceSettings.newBuilder();
        settingsBuilder.deployModelOperationSettings().setPollingAlgorithm((TimedRetryAlgorithm)this.createExtendedTimeoutAlgorithm());
        InstantiatingGrpcChannelProvider.Builder channelProviderBuilder = EndpointServiceSettings.defaultGrpcTransportProviderBuilder();
        ProxyUtils.applyProxySettings((ProxySettings)this.proxySettings, (InstantiatingGrpcChannelProvider.Builder)channelProviderBuilder);
        EndpointServiceSettings settings = ((EndpointServiceSettings.Builder)((EndpointServiceSettings.Builder)((EndpointServiceSettings.Builder)settingsBuilder.setCredentialsProvider(this.credentialsProvider)).setEndpoint(this.aiPlatformEndpoint)).setTransportChannelProvider((TransportChannelProvider)channelProviderBuilder.build())).build();
        return EndpointServiceClient.create((EndpointServiceSettings)settings);
    }

    private ModelServiceClient getModelServiceClient() throws IOException {
        ModelServiceSettings.Builder settingsBuilder = ModelServiceSettings.newBuilder();
        settingsBuilder.uploadModelOperationSettings().setPollingAlgorithm((TimedRetryAlgorithm)this.createExtendedTimeoutAlgorithm());
        InstantiatingGrpcChannelProvider.Builder channelProviderBuilder = ModelServiceSettings.defaultGrpcTransportProviderBuilder();
        ProxyUtils.applyProxySettings((ProxySettings)this.proxySettings, (InstantiatingGrpcChannelProvider.Builder)channelProviderBuilder);
        ModelServiceSettings settings = ((ModelServiceSettings.Builder)((ModelServiceSettings.Builder)((ModelServiceSettings.Builder)settingsBuilder.setCredentialsProvider(this.credentialsProvider)).setEndpoint(this.aiPlatformEndpoint)).setTransportChannelProvider((TransportChannelProvider)channelProviderBuilder.build())).build();
        return ModelServiceClient.create((ModelServiceSettings)settings);
    }

    private PredictionServiceClient getPredictionServiceClient() throws IOException {
        InstantiatingGrpcChannelProvider.Builder channelProviderBuilder = PredictionServiceSettings.defaultGrpcTransportProviderBuilder();
        ProxyUtils.applyProxySettings((ProxySettings)this.proxySettings, (InstantiatingGrpcChannelProvider.Builder)channelProviderBuilder);
        PredictionServiceSettings settings = ((PredictionServiceSettings.Builder)((PredictionServiceSettings.Builder)((PredictionServiceSettings.Builder)PredictionServiceSettings.newBuilder().setCredentialsProvider(this.credentialsProvider)).setEndpoint(this.aiPlatformEndpoint)).setTransportChannelProvider((TransportChannelProvider)channelProviderBuilder.build())).build();
        return PredictionServiceClient.create((PredictionServiceSettings)settings);
    }

    private RegionsClient getRegionsClient() throws IOException {
        InstantiatingHttpJsonChannelProvider.Builder channelProviderBuilder = RegionsSettings.defaultHttpJsonTransportProviderBuilder();
        ProxyUtils.applyProxySettings((ProxySettings)this.proxySettings, (InstantiatingHttpJsonChannelProvider.Builder)channelProviderBuilder);
        RegionsSettings settings = ((RegionsSettings.Builder)((RegionsSettings.Builder)RegionsSettings.newBuilder().setCredentialsProvider(this.credentialsProvider)).setTransportChannelProvider((TransportChannelProvider)channelProviderBuilder.build())).build();
        return RegionsClient.create((RegionsSettings)settings);
    }

    private MachineTypesClient getMachineTypesClient() throws IOException {
        InstantiatingHttpJsonChannelProvider.Builder channelProviderBuilder = MachineTypesSettings.defaultHttpJsonTransportProviderBuilder();
        ProxyUtils.applyProxySettings((ProxySettings)this.proxySettings, (InstantiatingHttpJsonChannelProvider.Builder)channelProviderBuilder);
        MachineTypesSettings settings = ((MachineTypesSettings.Builder)((MachineTypesSettings.Builder)MachineTypesSettings.newBuilder().setCredentialsProvider(this.credentialsProvider)).setTransportChannelProvider((TransportChannelProvider)channelProviderBuilder.build())).build();
        return MachineTypesClient.create((MachineTypesSettings)settings);
    }

    private CreateEndpointRequest getCreateEndpointRequest(@Nonnull VertexAICreateEndpointRequest requestedEndpoint) {
        Endpoint.Builder endpointBuilder = Endpoint.newBuilder().setDisplayName(requestedEndpoint.endpointId).putAllLabels(requestedEndpoint.config.tags);
        String networkFullName = requestedEndpoint.config.networkFullName;
        if (StringUtils.isNotBlank((String)networkFullName)) {
            endpointBuilder.setNetwork(networkFullName);
        }
        return CreateEndpointRequest.newBuilder().setParent(this.computeLocationName().toString()).setEndpoint(endpointBuilder.build()).setEndpointId(requestedEndpoint.endpointId).build();
    }

    private static UpdateEndpointRequest getUpdateEndpointRequest(VertexAIEndpoint storedEndpoint) {
        Endpoint endpoint = Endpoint.newBuilder().setName(storedEndpoint.getFullName()).putAllLabels(storedEndpoint.config.tags).build();
        FieldMask updateMask = FieldMask.newBuilder().addPaths("labels").build();
        return UpdateEndpointRequest.newBuilder().setUpdateMask(updateMask).setEndpoint(endpoint).build();
    }

    private UpdateModelRequest getUpdateModelLabelsRequest(@Nonnull String modelName, Map<String, String> tags) {
        Model model = Model.newBuilder().setName(modelName).putAllLabels(tags).build();
        FieldMask updateMask = FieldMask.newBuilder().addPaths("labels").build();
        return UpdateModelRequest.newBuilder().setUpdateMask(updateMask).setModel(model).build();
    }

    private PredictRequest getPredictRequest(EndpointName endpointName, JsonArray query) throws InvalidProtocolBufferException {
        String queryString = JSON.json((Object)query);
        ListValue.Builder listValue = ListValue.newBuilder();
        JsonFormat.parser().merge(queryString, (Message.Builder)listValue);
        List instanceList = listValue.getValuesList();
        return PredictRequest.newBuilder().setEndpoint(endpointName.toString()).addAllInstances((Iterable)instanceList).build();
    }

    private DeployModelRequest getDeployModelRequest(String modelName, String endpointName, VertexAIDeployedModelConfig config) {
        MachineSpec machineSpec = MachineSpec.newBuilder().setMachineType(config.machineConfig.machineType).setAcceleratorType(config.machineConfig.getAcceleratorType()).setAcceleratorCount(config.machineConfig.acceleratorCount).build();
        DedicatedResources dedicatedResources = DedicatedResources.newBuilder().setMachineSpec(machineSpec).setMinReplicaCount(config.machineConfig.minReplicaCount.intValue()).setMaxReplicaCount(config.machineConfig.maxReplicaCount.intValue()).build();
        DeployedModel deployedModel = DeployedModel.newBuilder().setDedicatedResources(dedicatedResources).setModel(modelName).build();
        return DeployModelRequest.newBuilder().setEndpoint(endpointName).setDeployedModel(deployedModel).build();
    }

    private UploadModelRequest getUploadModelRequest(@Nonnull VertexAICreateModelRequest requestedModel) {
        VertexAIModelConfig config = requestedModel.config;
        VertexAIModelInternalConfig internalConfig = requestedModel.internalConfig;
        List envVars = config.environmentVariables.stream().map(s -> EnvVar.newBuilder().setName(s.key).setValue(s.value).build()).collect(Collectors.toList());
        if (StringUtils.isBlank((String)config.imageUri)) {
            throw new DSSInternalErrorException("Container image URI should not be null. Please report this issue to Dataiku's support.");
        }
        ModelContainerSpec containerSpec = ModelContainerSpec.newBuilder().setImageUri(config.imageUri).addPorts(Port.newBuilder().setContainerPort(internalConfig.port).build()).setHealthRoute(internalConfig.healthRoute).setPredictRoute(internalConfig.predictRoute).addAllEnv(envVars).build();
        Model model = Model.newBuilder().setDisplayName(requestedModel.modelDisplayName).setContainerSpec(containerSpec).putAllLabels(config.tags).build();
        return UploadModelRequest.newBuilder().setParent(this.computeLocationName().toString()).setModel(model).build();
    }

    @Nullable
    public ProxyModelVersionConfiguration.ConsolidatedEndpointInfo getConsolidatedEndpointInfo_NT(String endpointId) throws IOException {
        Optional<Endpoint> endpointOpt = this.getEndpoint_NT(endpointId);
        if (endpointOpt.isEmpty()) {
            logger.infoV("Endpoint %s not found in project %s, location %s", new Object[]{endpointId, this.project, this.location});
            return null;
        }
        Endpoint endpoint = endpointOpt.get();
        DSSVertexAIConsolidatedEndpointInfo ret = new DSSVertexAIConsolidatedEndpointInfo(endpoint);
        for (DeployedModel dm2 : endpoint.getDeployedModelsList()) {
            ret.models.add(new DSSVertexAIModelInfo(dm2));
        }
        return ret;
    }

    private OperationTimedPollAlgorithm createExtendedTimeoutAlgorithm() {
        RetrySettings extendedTimeoutOperationRetrySettings = this.defaultOperationRetrySettings.toBuilder().setTotalTimeout(Duration.ofSeconds((long)3600L)).build();
        return OperationTimedPollAlgorithm.create((RetrySettings)extendedTimeoutOperationRetrySettings);
    }

    public List<ExternalInfraEndpoint> retrieveEndpoints_NT() throws IOException {
        try (EndpointServiceClient esc = this.getEndpointServiceClient();){
            ArrayList<ExternalInfraEndpoint> result = new ArrayList<ExternalInfraEndpoint>();
            for (Endpoint endpoint : this.listEndpoints_NT(null, esc)) {
                String fullName = endpoint.getName();
                String id = VertexAIUtils.extractEndpointId(fullName);
                String resourceLink = this.getEndpointResourceLink(this.project, this.location, id);
                Pair<DeploymentHealth, InfoMessage.InfoMessages> healthPair = VertexAIUtils.getExternalEndpointHealth(endpoint);
                result.add(new ExternalInfraEndpoint(id, endpoint.getDisplayName(), fullName, (DeploymentHealth)((Object)healthPair.first), (InfoMessage.InfoMessages)healthPair.second, resourceLink));
            }
            result.sort(Comparator.comparing(o -> o.name.toLowerCase()));
            ArrayList<ExternalInfraEndpoint> arrayList = result;
            return arrayList;
        }
    }

    private static Pair<DeploymentHealth, InfoMessage.InfoMessages> getExternalEndpointHealth(@Nonnull Endpoint endpoint) {
        DeploymentHealth health;
        InfoMessage.InfoMessages infoMessages = new InfoMessage.InfoMessages();
        String fullName = endpoint.getName();
        int totalTraffic = endpoint.getTrafficSplitMap().values().stream().mapToInt(Integer::intValue).sum();
        if (endpoint.getDeployedModelsList().isEmpty()) {
            infoMessages.withErrorV((InfoMessage.MessageCode)DeployerCodes.ERR_API_DEPLOYER_ENDPOINT_HAS_NO_MODEL_DEPLOYED, "Endpoint %s has no model deployed", new Object[]{fullName});
            health = DeploymentHealth.UNHEALTHY;
        } else if (totalTraffic == 0) {
            infoMessages.withErrorV((InfoMessage.MessageCode)DeployerCodes.ERR_API_DEPLOYER_ENDPOINT_HAS_NO_TRAFFIC, "Endpoint %s has no traffic available", new Object[]{fullName});
            health = DeploymentHealth.UNHEALTHY;
        } else {
            health = DeploymentHealth.HEALTHY;
        }
        return new Pair((Object)health, (Object)infoMessages);
    }

    public static GCPProject getProject_NT(@Nonnull String projectId, @Nonnull AuthCtx authCtx, @Nullable VertexAIModelDeploymentConnection connection) throws IOException {
        TransactionContext.assertNoAttachedTransaction();
        String defaultProjectId = VertexAIUtils.getDefaultConfiguredProject_NT();
        ProxySettings proxySettings = ExternalInfrasUtils.getProxy(connection);
        ProjectsSettings projectsSettings = VertexAIUtils.getProjectsSettings(authCtx, connection, proxySettings);
        try (ProjectsClient projectsClient = ProjectsClient.create((ProjectsSettings)projectsSettings);){
            VertexAIUtils.checkRate("Get project");
            Project project = projectsClient.getProject(ProjectName.of((String)projectId));
            String dssDisplayName = VertexAIUtils.getDSSDisplayName(project);
            GCPProject gCPProject = new GCPProject(dssDisplayName, projectId, project.getName(), projectId.equals(defaultProjectId));
            return gCPProject;
        }
    }

    public static List<GCPProject> retrieveProjects_NT(AuthCtx authCtx, @Nullable VertexAIModelDeploymentConnection connection) throws IOException {
        TransactionContext.assertNoAttachedTransaction();
        String defaultProjectId = VertexAIUtils.getDefaultConfiguredProject_NT();
        ProxySettings proxySettings = ExternalInfrasUtils.getProxy(connection);
        ProjectsSettings projectsSettings = VertexAIUtils.getProjectsSettings(authCtx, connection, proxySettings);
        ArrayList<GCPProject> projects = new ArrayList<GCPProject>();
        try (ProjectsClient projectsClient = ProjectsClient.create((ProjectsSettings)projectsSettings);){
            VertexAIUtils.checkRate("Search projects");
            for (Project project : projectsClient.searchProjects("").iterateAll()) {
                String projectId = project.getProjectId();
                String dssDisplayName = VertexAIUtils.getDSSDisplayName(project);
                projects.add(new GCPProject(dssDisplayName, projectId, project.getName(), projectId.equals(defaultProjectId)));
            }
        }
        projects.sort(Comparator.comparing(o -> o.displayName.toLowerCase()));
        return projects;
    }

    public static String getDSSDisplayName(Project project) {
        Object displayName = project.getDisplayName();
        String projectId = project.getProjectId();
        if (((String)displayName).isEmpty()) {
            displayName = projectId;
        }
        if (!((String)displayName).equals(projectId)) {
            displayName = (String)displayName + " (" + projectId + ")";
        }
        return displayName;
    }

    public static List<ExternalInfraRegionDTO> getVertexAIRegions_NT() {
        if (null == vertexAIRegions) {
            String[] locations;
            String gcpLocations = "Montr\u00e9al,northamerica-northeast1;Toronto,northamerica-northeast2;S\u00e3o Paulo,southamerica-east1;Iowa,us-central1;South Carolina,us-east1;N. Virginia,us-east4;Dallas,us-south1;Oregon,us-west1;Los Angeles,us-west2;Salt Lake City,us-west3;Las Vegas,us-west4;Warsaw,europe-central2;Belgium,europe-west1;London,europe-west2;Frankfurt,europe-west3;Netherlands,europe-west4;Zurich,europe-west6;Paris,europe-west9;Taiwan,asia-east1;Hong Kong,asia-east2;Tokyo,asia-northeast1;Mumbai,asia-south1;Singapore,asia-southeast1;Jakarta,asia-southeast2;Seoul,asia-northeast3;Sydney,australia-southeast1;Tel Aviv,me-west1";
            vertexAIRegions = new ArrayList<ExternalInfraRegionDTO>();
            String defaultLocation = VertexAIUtils.getDefaultConfiguredRegion_NT();
            for (String location : locations = gcpLocations.split(";")) {
                String[] elem = location.split(",");
                vertexAIRegions.add(new ExternalInfraRegionDTO(elem[1], elem[0], elem[0].equals(defaultLocation)));
            }
            vertexAIRegions.sort(Comparator.comparing(o -> o.name));
        }
        return vertexAIRegions;
    }

    public static FutureResponse<List<GCPProject>> startListProjects_NT(DSSAuthCtx user, String connectionName) throws Exception {
        FutureService futureService = (FutureService)((Object)SpringUtils.getBean(FutureService.class));
        VertexAIModelDeploymentConnection connection = (VertexAIModelDeploymentConnection)ExternalInfrasUtils.getAndCheckConnection(user, connectionName);
        ProjectListingFutureThread plft = new ProjectListingFutureThread(user, connection);
        return futureService.runFuture(plft, 0L, new TypeToken<FutureResponse<List<GCPProject>>>(){});
    }

    public static FutureResponse<GCPProject> startGetProject_NT(DSSAuthCtx user, String projectId, String connectionName) throws Exception {
        FutureService futureService = (FutureService)((Object)SpringUtils.getBean(FutureService.class));
        VertexAIModelDeploymentConnection connection = (VertexAIModelDeploymentConnection)ExternalInfrasUtils.getAndCheckConnection(user, connectionName);
        ProjectGettingFutureThread pgft = new ProjectGettingFutureThread(user, projectId, connection);
        return futureService.runFuture(pgft, 0L, new TypeToken<FutureResponse<GCPProject>>(){});
    }

    public static FutureResponse<List<ExternalInfraEndpoint>> startListEndpoints_NT(DSSAuthCtx user, String project, String region, String connectionName) throws Exception {
        FutureService futureService = (FutureService)((Object)SpringUtils.getBean(FutureService.class));
        EndpointListingFutureThread plft = new EndpointListingFutureThread(user, project, region, connectionName);
        return futureService.runFuture(plft, 0L, new TypeToken<FutureResponse<List<ExternalInfraEndpoint>>>(){});
    }

    private static ProjectsSettings getProjectsSettings(@Nonnull AuthCtx authCtx, @Nullable VertexAIModelDeploymentConnection connection, @Nonnull ProxySettings proxySettings) throws IOException {
        GoogleCredentials credentials;
        try {
            credentials = VertexAIUtils.getGoogleCredentials_NT(authCtx, connection);
        }
        catch (DKUSecurityException | IOException | URISyntaxException e) {
            throw new RuntimeException(e);
        }
        FixedCredentialsProvider credProvider = VertexAIUtils.createFixedCredentialsProvider(credentials);
        InstantiatingGrpcChannelProvider.Builder channelProviderBuilder = ProjectsSettings.defaultGrpcTransportProviderBuilder();
        ProxyUtils.applyProxySettings((ProxySettings)proxySettings, (InstantiatingGrpcChannelProvider.Builder)channelProviderBuilder);
        return ((ProjectsSettings.Builder)((ProjectsSettings.Builder)ProjectsSettings.newBuilder().setCredentialsProvider((CredentialsProvider)credProvider)).setTransportChannelProvider((TransportChannelProvider)channelProviderBuilder.build())).build();
    }

    private String getEndpointResourceLink(String project, String location, String endpointId) {
        return String.format("https://console.cloud.google.com/vertex-ai/locations/%s/endpoints/%s?project=%s", location, endpointId, project);
    }

    static {
        logger = DKULogger.getLogger((String)"dku.externalinfras.vertex_ai.utils");
    }

    public static class DSSVertexAIConsolidatedEndpointInfo
    extends ProxyModelVersionConfiguration.ConsolidatedEndpointInfo {
        public String name;
        public String displayName;
        public String description;
        public Map<String, Integer> trafficSplit;
        public List<DSSVertexAIModelInfo> models = new ArrayList<DSSVertexAIModelInfo>();

        public DSSVertexAIConsolidatedEndpointInfo() {
        }

        public DSSVertexAIConsolidatedEndpointInfo(Endpoint endpoint) {
            this.name = endpoint.getName();
            this.description = endpoint.getDescription();
            this.displayName = endpoint.getDisplayName();
            this.trafficSplit = endpoint.getTrafficSplitMap();
        }

        @Override
        public InfoMessage.InfoMessages computeDifferences(@Nonnull ProxyModelVersionConfiguration.ConsolidatedEndpointInfo other) {
            InfoMessage.InfoMessages ret = new InfoMessage.InfoMessages();
            if (this.getClass() != other.getClass()) {
                ret.addMessage(new InfoMessage(InfoMessage.Severity.ERROR, "Wrong type", "Type mismatch between configuration and remote endpoint"));
                return ret;
            }
            DSSVertexAIConsolidatedEndpointInfo vertexAIOther = (DSSVertexAIConsolidatedEndpointInfo)other;
            if (!StringUtils.equals((String)this.name, (String)vertexAIOther.name)) {
                ret.addMessage(new InfoMessage(InfoMessage.Severity.ERROR, "Name differs", String.format("Name at version creation: %s. Current name: %s.", this.name, vertexAIOther.name)));
            }
            if (!StringUtils.equals((String)this.displayName, (String)vertexAIOther.displayName)) {
                ret.addMessage(new InfoMessage(InfoMessage.Severity.WARNING, "Display name differs", String.format("Display name at version creation: %s. Current display name: %s.", this.displayName, vertexAIOther.displayName)));
            }
            if (vertexAIOther.models.isEmpty()) {
                ret.addMessage(new InfoMessage(InfoMessage.Severity.ERROR, "Model differs", "There is no model currently deployed on endpoint"));
                return ret;
            }
            if (!Objects.equals(this.models.stream().sorted(Comparator.comparing(m -> m.modelId)).collect(Collectors.toList()), vertexAIOther.models.stream().sorted(Comparator.comparing(m -> m.modelId)).collect(Collectors.toList()))) {
                ret.addMessage(new InfoMessage(InfoMessage.Severity.ERROR, "Model differs", "Model(s) at version creation time differ from some currently deployed on endpoint"));
            }
            if (!Objects.equals(this.trafficSplit, vertexAIOther.trafficSplit)) {
                String msg = String.format("Traffic split at version creation: %s.%nCurrent traffic split: %s.", this.trafficSplit.entrySet().stream().map(s -> (String)s.getKey() + " -> " + String.valueOf(s.getValue())).collect(Collectors.joining(", ")), vertexAIOther.trafficSplit.entrySet().stream().map(s -> (String)s.getKey() + " -> " + String.valueOf(s.getValue())).collect(Collectors.joining(", ")));
                ret.addMessage(new InfoMessage(InfoMessage.Severity.WARNING, "Traffic split differs", msg));
            }
            if (ret.messages.isEmpty()) {
                ret.addMessage(new InfoMessage(InfoMessage.Severity.INFO, "Information matches", "The endpoint has the same configuration as when this DSS saved model version was created"));
            }
            return ret;
        }
    }

    public static class DSSVertexAIModelInfo {
        public String id;
        public String resourceName;
        public String displayName;
        public String versionId;
        public String modelId;
        public String modelVersionId;

        public DSSVertexAIModelInfo() {
        }

        public DSSVertexAIModelInfo(DeployedModel dm2) {
            this.id = dm2.getId();
            this.resourceName = dm2.getModel();
            this.displayName = dm2.getDisplayName();
            this.versionId = dm2.getModelVersionId();
            this.modelId = dm2.getModel();
            this.modelVersionId = dm2.getModelVersionId();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DSSVertexAIModelInfo that = (DSSVertexAIModelInfo)o;
            return this.id.equals(that.id) && this.resourceName.equals(that.resourceName) && this.displayName.equals(that.displayName) && this.versionId.equals(that.versionId) && this.modelId.equals(that.modelId) && this.modelVersionId.equals(that.modelVersionId);
        }

        public int hashCode() {
            return Objects.hash(this.id, this.resourceName, this.displayName, this.versionId, this.modelId, this.modelVersionId);
        }
    }

    public static class ProjectListingFutureThread
    extends FutureThread<List<GCPProject>> {
        private List<GCPProject> result;
        private final FuturePayload futurePayload = this.buildFuturePayload();
        @Nullable
        private final VertexAIModelDeploymentConnection connection;

        public ProjectListingFutureThread(DSSAuthCtx user, @Nullable VertexAIModelDeploymentConnection connection) {
            super(user);
            this.connection = connection;
        }

        public FuturePayload buildFuturePayload() {
            String id;
            FuturePayload fp = new FuturePayload();
            fp.action = id = "list_projects";
            fp.targets.add(new FuturePayload.FuturePayloadTarget(null, id, id, "BUNDLE"));
            fp.displayName = "Listing projects...";
            return fp;
        }

        public FuturePayload getPayload() {
            return this.futurePayload;
        }

        public double getDangerosity() {
            return 0.0;
        }

        public List<GCPProject> getResult() {
            return this.result;
        }

        public void execute() throws IOException {
            this.result = VertexAIUtils.retrieveProjects_NT(this.owner, this.connection);
        }
    }

    public static class ProjectGettingFutureThread
    extends FutureThread<GCPProject> {
        private final String projectId;
        private GCPProject result;
        private final FuturePayload futurePayload;
        @Nullable
        private final VertexAIModelDeploymentConnection connection;

        public ProjectGettingFutureThread(DSSAuthCtx user, String projectId, @Nullable VertexAIModelDeploymentConnection connection) {
            super(user);
            this.projectId = projectId;
            this.futurePayload = this.buildFuturePayload();
            this.connection = connection;
        }

        public FuturePayload buildFuturePayload() {
            String id;
            FuturePayload fp = new FuturePayload();
            fp.action = id = "get_project";
            fp.targets.add(new FuturePayload.FuturePayloadTarget(null, id, id, "BUNDLE"));
            fp.displayName = "Getting project...";
            return fp;
        }

        public FuturePayload getPayload() {
            return this.futurePayload;
        }

        public double getDangerosity() {
            return 0.0;
        }

        public GCPProject getResult() {
            return this.result;
        }

        public void execute() throws Exception {
            this.result = VertexAIUtils.getProject_NT(this.projectId, this.owner, this.connection);
        }
    }

    public static class EndpointListingFutureThread
    extends FutureThread<List<ExternalInfraEndpoint>> {
        private List<ExternalInfraEndpoint> result;
        private final String project;
        private final String region;
        private final String connectionName;
        private final FuturePayload futurePayload;

        public EndpointListingFutureThread(DSSAuthCtx user, String project, String region, String connectionName) {
            super(user);
            this.project = project;
            this.region = region;
            this.connectionName = connectionName;
            this.futurePayload = this.buildFuturePayload();
        }

        public FuturePayload buildFuturePayload() {
            FuturePayload fp = new FuturePayload();
            fp.action = "list_endpoints";
            fp.targets.add(new FuturePayload.FuturePayloadTarget(null, fp.action, fp.action, "BUNDLE"));
            fp.displayName = "List endpoints";
            return fp;
        }

        public FuturePayload getPayload() {
            return this.futurePayload;
        }

        public double getDangerosity() {
            return 0.0;
        }

        public List<ExternalInfraEndpoint> getResult() {
            return this.result;
        }

        public void execute() throws Exception {
            VertexAIModelDeploymentConnection connection = (VertexAIModelDeploymentConnection)ExternalInfrasUtils.getAndCheckConnection(this.owner, this.connectionName);
            GoogleCredentials credentials = VertexAIUtils.getGoogleCredentials_NT(this.owner, connection);
            this.result = VertexAIUtils.from(this.region, this.project, credentials, connection).retrieveEndpoints_NT();
        }
    }
}

