/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.formats.excel.model.range;

import com.dataiku.dip.formats.excel.model.range.ExcelRange;
import com.dataiku.dip.formats.excel.model.range.ExcelUtils;
import com.dataiku.dss.shadelibpoi.org.apache.poi.ss.util.CellRangeAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class SheetBasedExcelRange {
    private Map<String, List<CellRangeAddress>> perSheet;
    private List<CellRangeAddress> allSheets;

    private SheetBasedExcelRange(Map<String, List<CellRangeAddress>> perSheet, List<CellRangeAddress> allSheets) {
        this.perSheet = perSheet;
        this.allSheets = allSheets;
    }

    public static SheetBasedExcelRange from(String s) {
        String[] ranges = s.split(",");
        HashMap<String, List<CellRangeAddress>> perSheet = new HashMap<String, List<CellRangeAddress>>();
        ArrayList<CellRangeAddress> allSheets = new ArrayList<CellRangeAddress>();
        for (String rawRange : ranges) {
            ExcelUtils.valueOfRange(rawRange);
            if (rawRange.split("!").length > 1) {
                String sheetName = rawRange.split("!")[0].trim();
                List sheetRanges = perSheet.computeIfAbsent(sheetName, k -> new ArrayList());
                sheetRanges.add(ExcelUtils.valueOfRange(rawRange.split("!")[1]));
                continue;
            }
            allSheets.add(ExcelUtils.valueOfRange(rawRange));
        }
        return new SheetBasedExcelRange(perSheet, allSheets);
    }

    public ExcelRange getRange(String sheetName) {
        if (this.perSheet.isEmpty()) {
            return ExcelRange.from(this.allSheets);
        }
        return ExcelRange.from(Stream.concat(((List)this.perSheet.getOrDefault(sheetName, new ArrayList())).stream(), this.allSheets.stream()).collect(Collectors.toList()));
    }
}

