/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.input.formats.parquet;

import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.input.formats.parquet.ConverterFactory;
import com.dataiku.dip.input.formats.parquet.ParentValueContainer;
import org.apache.log4j.Logger;
import org.apache.parquet.io.api.Converter;
import org.apache.parquet.io.api.GroupConverter;
import org.apache.parquet.schema.Type;
import org.json.JSONException;
import org.json.JSONObject;

class MapConverter
extends GroupConverter {
    private static Logger logger = Logger.getLogger(MapConverter.class);
    private final ParentValueContainer parent;
    private final Converter kvTupleConverter;
    private final Converter keyConverter;
    private final Converter valueConverter;
    private Object currentKey;
    private Object currentValue;
    private JSONObject jsonObject;

    public MapConverter(ConverterFactory cf, Type parquetType, SchemaColumn keys, SchemaColumn values, ParentValueContainer parent) {
        this.parent = parent;
        Type keyType = parquetType.asGroupType().getType(0).asGroupType().getType(0);
        Type valueType = parquetType.asGroupType().getType(0).asGroupType().getType(1);
        this.keyConverter = cf.createConverter(keyType, keys, new ParentValueContainer(){

            @Override
            void add(Object value) {
                MapConverter.this.currentKey = value;
            }
        });
        this.valueConverter = cf.createConverter(valueType, values, new ParentValueContainer(){

            @Override
            void add(Object value) {
                MapConverter.this.currentValue = value;
            }
        });
        this.kvTupleConverter = new GroupConverter(){

            public Converter getConverter(int i) {
                return i == 0 ? MapConverter.this.keyConverter : MapConverter.this.valueConverter;
            }

            public void start() {
                MapConverter.this.currentKey = null;
                MapConverter.this.currentValue = null;
            }

            public void end() {
                try {
                    if (MapConverter.this.currentKey == null) {
                        throw new RuntimeException("Unsupported NULL key in Parquet map");
                    }
                    MapConverter.this.jsonObject.put(MapConverter.this.currentKey.toString(), MapConverter.this.currentValue == null ? JSONObject.NULL : MapConverter.this.currentValue);
                }
                catch (JSONException e) {
                    throw new RuntimeException("Cannot handle key/value tuple", e);
                }
            }
        };
    }

    public Converter getConverter(int i) {
        return this.kvTupleConverter;
    }

    public void start() {
        this.jsonObject = new JSONObject();
    }

    public void end() {
        if (this.jsonObject != null) {
            this.parent.add(this.jsonObject);
        }
        this.jsonObject = null;
    }
}

