/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.io;

import com.dataiku.dip.cluster.ClusterSelector;
import com.dataiku.dip.code.ProjectLibPathHelper;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.exceptions.UnauthorizedException;
import com.dataiku.dip.rpc.LocalPrivilegedIntercomAPIClient;
import com.dataiku.dip.rpc.TicketBasedIntercomAPIClient;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.IPermissionsService;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.tickets.APITicketService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.intercom.t.PermissionsIntercomController;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.git.DSSGitModel;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class KernelUtils {
    private static DKULogger logger = DKULogger.getLogger((String)"dku.kernels");

    public static ProjectLibPathHelper.ProjectLibsPaths handlePythonAndRPath(AuthCtx authCtx, String projectKey, boolean addProjectLibs, Map<String, String> pythonlibs, File workDir, boolean impersonated, ProcessBuilder pb) throws IOException, DKUSecurityException {
        String pythonPath;
        String additionalChunk;
        String pythonlibName;
        ProjectLibPathHelper.ProjectLibsPaths outputPaths = new ProjectLibPathHelper.ProjectLibsPaths();
        outputPaths.projectKey = projectKey;
        HashMap cleanPythonLibs = Maps.newHashMap();
        if (pythonlibs != null) {
            for (Map.Entry<String, String> entry : pythonlibs.entrySet()) {
                pythonlibName = entry.getKey();
                additionalChunk = entry.getValue();
                if (!StringUtils.isNotBlank((String)additionalChunk)) continue;
                cleanPythonLibs.put(pythonlibName, additionalChunk);
            }
        }
        if (!cleanPythonLibs.isEmpty()) {
            if (impersonated) {
                for (Map.Entry<String, String> entry : cleanPythonLibs.entrySet()) {
                    pythonlibName = entry.getKey();
                    additionalChunk = entry.getValue();
                    File src = new File(additionalChunk);
                    if (!src.isDirectory()) continue;
                    File dst = new File(workDir, pythonlibName);
                    logger.debugV("Impersonation enabled, copying additional PythonPath chunk %s to %s", new Object[]{src, dst});
                    DKUFileUtils.copyDirectory((File)src, (File)dst, EnumSet.of(DKUFileUtils.CopyDirectoryFlags.NoPreserveFileDate), (FileFilter[])new FileFilter[0]);
                    outputPaths.pythonPath.add(dst.getAbsolutePath());
                }
            } else {
                outputPaths.pythonPath.addAll(cleanPythonLibs.values());
            }
        }
        if (addProjectLibs) {
            DSSGitModel.ExternalLibraries externalLibraries;
            ProjectLibPathHelper.preparePathsFromProjectCopyIfNeeded(projectKey, workDir, outputPaths);
            try (Transaction transaction = ((TransactionService)SpringUtils.getBean(TransactionService.class)).retrieveOrBeginRead();){
                RelFile externalLibrariesFile = new RelFile(new String[]{"projects", projectKey, "lib", "external-libraries.json"});
                externalLibraries = (DSSGitModel.ExternalLibraries)transaction.readObjectDefault(externalLibrariesFile, DSSGitModel.ExternalLibraries.class);
            }
            if (!externalLibraries.getNonNullLibrariesFromProjects().isEmpty()) {
                KernelUtils.handleForeignPythonAndRPath(authCtx, workDir, outputPaths, externalLibraries);
            }
        }
        if (StringUtils.isNotBlank((String)(pythonPath = System.getenv("PYTHONPATH")))) {
            outputPaths.pythonPath.add(0, pythonPath);
        }
        if (pb != null) {
            pb.environment().put("PYTHONPATH", StringUtils.join(outputPaths.pythonPath, (String)File.pathSeparator));
            pb.environment().put("DKU_SOURCE_LIB_R_PATH", StringUtils.join(outputPaths.rsrcPath, (String)File.pathSeparator));
        }
        return outputPaths;
    }

    private static void handleForeignPythonAndRPath(AuthCtx authCtx, File workDir, ProjectLibPathHelper.ProjectLibsPaths outputPaths, DSSGitModel.ExternalLibraries externalLibraries) throws DKUSecurityException, IOException {
        for (String foreignProjectKey : externalLibraries.getNonNullLibrariesFromProjects()) {
            if (!KernelUtils.hasReadConfProjectPrivilege_autoTxn(authCtx, foreignProjectKey)) {
                throw new UnauthorizedException("Cannot import libraries from project '" + foreignProjectKey + "'", "project-authorization-failure");
            }
            ProjectLibPathHelper.preparePathsFromProjectCopyIfNeeded(foreignProjectKey, workDir, outputPaths);
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive exception aggregation
     */
    private static boolean hasReadConfProjectPrivilege_autoTxn(AuthCtx authCtx, String projectKey) throws IOException, DKUSecurityException {
        switch (1.$SwitchMap$com$dataiku$dip$logging$MainLoggingConfigurator$ProcessType[ClusterSelector.getContext().ordinal()]) {
            case 1: 
            case 2: {
                permissionsService = (IPermissionsService)SpringUtils.getBean(IPermissionsService.class);
                if (TransactionContext.hasAttachedTransaction()) {
                    return permissionsService.hasProjectPrivilege(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
                }
                transactionService = (TransactionService)SpringUtils.getBean(TransactionService.class);
                t = transactionService.beginRead();
                try {
                    var5_15 = permissionsService.hasProjectPrivilege(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
                    return var5_15;
                }
                finally {
                    if (t != null) {
                        t.close();
                    }
                }
            }
            case 3: {
                return false;
            }
            case 4: 
            case 5: {
                ticketService = (APITicketService)SpringUtils.getBean(APITicketService.class);
                try {
                    tu = ticketService.getAndUseSingleTicket();
                    try {
                        apiClient = TicketBasedIntercomAPIClient.forLocalHost(tu.getTicket().getSecret());
                        try {
                            var5_17 = ((PermissionsIntercomController.PermissionCheckResult)apiClient.postFormToJSON((String)"/dip/api/tintercom/permissions/has-project-privilege", PermissionsIntercomController.PermissionCheckResult.class, (Object[])new Object[]{"projectKey", projectKey, "privilege", Privileges.ProjectLevelPrivilegeType.READ_CONF.toString()})).ok;
                            if (apiClient == null) ** GOTO lbl38
                        }
                        catch (Throwable var5_18) {
                            if (apiClient != null) {
                                try {
                                    apiClient.close();
                                }
                                catch (Throwable var6_22) {
                                    var5_18.addSuppressed(var6_22);
                                }
                            }
                            throw var5_18;
                        }
                        apiClient.close();
lbl38:
                        // 2 sources

                        return var5_17;
                    }
                    finally {
                        if (tu != null) {
                            tu.close();
                        }
                    }
                }
                catch (DKUSecurityException | IOException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new DKUSecurityException("Could not close ticket usage for permission check call", (Throwable)e);
                }
            }
            case 6: 
            case 7: {
                backendPort = Integer.parseInt(System.getenv("DKU_BACKEND_PORT"));
                apiClient = new LocalPrivilegedIntercomAPIClient(backendPort);
                try {
                    var4_13 = ((PermissionsIntercomController.PermissionCheckResult)apiClient.postFormToJSON((String)"/dip/api/intercom/permissions/has-project-privilege", PermissionsIntercomController.PermissionCheckResult.class, (Object[])new Object[]{"authCtx", JSON.json((Object)authCtx), "projectKey", projectKey, "privilege", Privileges.ProjectLevelPrivilegeType.READ_CONF.toString()})).ok;
                    return var4_13;
                }
                finally {
                    apiClient.close();
                }
            }
        }
        throw new Error("DSS Process type not set, cannot check project permission");
    }
}

